    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Xml.Serialization;
namespace NinjaTrader.Indicator
{
    [Description("Creates Limit Entry plot in NinjaScript Strategies")]
    public class bftatBFTiTargetPlot : NinjaTrader.Indicator.Indicator
    {
        private int id = 1;

        protected override void Initialize()
        {
            base.Add(new NinjaTrader.Gui.Chart.Plot(new Pen(Color.Green, 3f), PlotStyle.Hash, "TargetPlot"));
            base.CalculateOnBarClose = true;
            base.Overlay = true;
            base.PriceTypeSupported = false;
        }

        protected override void OnBarUpdate()
        {
        }

        public override string ToString()
        {
            return string.Empty;
        }

        [Description("")]
        [Category("Parameters")]
        public int Id
        {
            get
            {
                return this.id;
            }
            set
            {
                this.id = Math.Max(0, value);
            }
        }

        [XmlIgnore, Browsable(false)]
        public DataSeries Plot
        {
            get
            {
                return base.Values[0];
            }
        }
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bftatBFTiTargetPlot[] cachebftatBFTiTargetPlot = null;

        private static bftatBFTiTargetPlot checkbftatBFTiTargetPlot = new bftatBFTiTargetPlot();

        /// <summary>
        /// Creates Limit Entry plot in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTargetPlot bftatBFTiTargetPlot(int id)
        {
            return bftatBFTiTargetPlot(Input, id);
        }

        /// <summary>
        /// Creates Limit Entry plot in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public bftatBFTiTargetPlot bftatBFTiTargetPlot(Data.IDataSeries input, int id)
        {
            if (cachebftatBFTiTargetPlot != null)
                for (int idx = 0; idx < cachebftatBFTiTargetPlot.Length; idx++)
                    if (cachebftatBFTiTargetPlot[idx].Id == id && cachebftatBFTiTargetPlot[idx].EqualsInput(input))
                        return cachebftatBFTiTargetPlot[idx];

            lock (checkbftatBFTiTargetPlot)
            {
                checkbftatBFTiTargetPlot.Id = id;
                id = checkbftatBFTiTargetPlot.Id;

                if (cachebftatBFTiTargetPlot != null)
                    for (int idx = 0; idx < cachebftatBFTiTargetPlot.Length; idx++)
                        if (cachebftatBFTiTargetPlot[idx].Id == id && cachebftatBFTiTargetPlot[idx].EqualsInput(input))
                            return cachebftatBFTiTargetPlot[idx];

                bftatBFTiTargetPlot indicator = new bftatBFTiTargetPlot();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Id = id;
                Indicators.Add(indicator);
                indicator.SetUp();

                bftatBFTiTargetPlot[] tmp = new bftatBFTiTargetPlot[cachebftatBFTiTargetPlot == null ? 1 : cachebftatBFTiTargetPlot.Length + 1];
                if (cachebftatBFTiTargetPlot != null)
                    cachebftatBFTiTargetPlot.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebftatBFTiTargetPlot = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Creates Limit Entry plot in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTargetPlot bftatBFTiTargetPlot(int id)
        {
            return _indicator.bftatBFTiTargetPlot(Input, id);
        }

        /// <summary>
        /// Creates Limit Entry plot in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTargetPlot bftatBFTiTargetPlot(Data.IDataSeries input, int id)
        {
            return _indicator.bftatBFTiTargetPlot(input, id);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Creates Limit Entry plot in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bftatBFTiTargetPlot bftatBFTiTargetPlot(int id)
        {
            return _indicator.bftatBFTiTargetPlot(Input, id);
        }

        /// <summary>
        /// Creates Limit Entry plot in NinjaScript Strategies
        /// </summary>
        /// <returns></returns>
        public Indicator.bftatBFTiTargetPlot bftatBFTiTargetPlot(Data.IDataSeries input, int id)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bftatBFTiTargetPlot(input, id);
        }
    }
}
#endregion
