    using NinjaTrader.Cbi;
    using NinjaTrader.Data;
    using NinjaTrader.Gui.Design;
    using NinjaTrader.Indicator;
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Drawing.Drawing2D;
    using System.Globalization;
    using System.Text;
    using System.Windows.Forms;
    using System.Xml.Serialization;
namespace NinjaTrader.Strategy
{
    [Description("bftatBigfootV5bDev | www.bigfootautomatedtrading.com")]
    public class bftatBigfootV5bDev : NinjaTrader.Strategy.Strategy
    {
        private bool activateDailyTargets = true;
        private bool Backtest_OpMode;
        private int BestEC_LE_PB_Prd;
        private int BestEC_LE_TR_Prd;
        private int BestEC_ProfTrgt_Ticks;
        private int BestEC_SE_PB_Prd;
        private int BestEC_SE_TR_Prd;
        private int BestEC_StopLoss_Ticks;
        private int BestEC_SystemNbr;
        private int BestEC_TradeSignal;
        private double BestEC_Value;
        private double BestStrategyEC;
        private double BestStrategyNbr;
        private MAX BIP0_HHigh;
        private MIN BIP0_LLow;
        private int BreakEvenStopStatus;
        private bool BTN_BuyMkt_On;
        private bool BTN_ClosePos_On;
        private bool BTN_ClosePosClickedThisBar;
        private bool BTN_CT_On = true;
        private bool BTN_Long_On = true;
        private bool BTN_Long_OnState;
        private bool BTN_SellMkt_On;
        private bool BTN_Short_On = true;
        private bool BTN_Short_OnState;
        private bool BTN_Strategy_On = true;
        private bool BuyMktButtonClicked;
        private bool CancelExits_On;
        private int cBreakEvenBufferTicks = 1;
        private int CHB_CurrStatus;
        private int CHB_PrevStatus;
        private bool CheckLoadTime = true;
        private double ClosedPosPnl;
        private double commission = 4.95;
        private string ConfirmCancelThenExitLabel = string.Empty;
        private int cTrailStopBufferTicks = 1;
        private double CumulativeClosedPosPnl;
        private double CumulativeOpenPosPnl;
        private int currBar;
        private int CurrTradeCount;
        private int CurrTradeNbr;
        private double DailyClosedPosPnl;
        private double DailyEquity_ClosedOpenCommishPnl;
        private double DailyEquity_EquityHigh;
        private double DailyEquity_EquityLow;
        private double DailyEquity_TrailStopValue;
        private double dailyLossTarget = 500.0;
        private double DailyOpenPosPnl;
        private double dailyProfitTarget = 500.0;
        private bool displayProfitLoss = true;
        private int DVR_Dn_BegSignalBarsNum;
        private int DVR_Dn_EndSignalBarsNum;
        private int DVR_Dn_TGTR_Count;
        private int DVR_Up_BegSignalBarsNum;
        private int DVR_Up_EndSignalBarsNum;
        private int DVR_Up_TGTR_Count;
        private string EntryOrderSuffix = string.Empty;
        private bool EntryOrderTypeIsStopOrder;
        private bool EntryOrderTypeIsWorkingOrder;
        private bool EquityOkayToTrade;
        private double EquityTrailStop_PriorTradesCumProfit;
        private int EquityTrailStop_Status;
        private double EquityTrailStop_Trail_Amt;
        private double EquityTrailStop_Trig_Amt;
        private System.Drawing.Color fillColor = System.Drawing.Color.DarkGoldenrod;
        private int filterTG4A_SignalDir;
        private bool FirstRealtime = true;
        private bool FirstRealtimeUpdate = true;
        private int fontsize = 10;
        private int gEntry1_Qty;
        private int gEntry2_Qty;
        private int gEntry3_Qty;
        private int gEntry4_Qty;
        private int gLE_ExpireBarsNum;
        private double gLE_Limit_Price;
        private double gLE_OrderType;
        private double gLE_StopLmt_LimitPrice;
        private double gLE_StopLmt_StopPrice;
        private double gLE_StopMkt_StopPrice;
        private int gProfTrgt1_Ticks;
        private int gProfTrgt2_Ticks;
        private int gProfTrgt3_Ticks;
        private int gProfTrgt4_Ticks;
        private int gSE_ExpireBarsNum;
        private double gSE_Limit_Price;
        private double gSE_OrderType;
        private double gSE_StopLmt_LimitPrice;
        private double gSE_StopLmt_StopPrice;
        private double gSE_StopMkt_StopPrice;
        private int gStopLoss_Ticks;
        private bool HaltStopLossModProcess;
        private bool HaltStrategy_On;
        private bool initButtonEvents;
        private int LastBIP1BarsNum = 1;
        private DateTime LastEntry_DateTime = DateTime.MinValue;
        private string LastEventText = string.Empty;
        private DateTime LastExit_DateTime = DateTime.MinValue;
        private double lastHigh = double.MaxValue;
        private double lastLow = double.MinValue;
        private double lastPriceChange;
        private int lastTradedUpdate;
        private double LE_BestProfLossTicks;
        private bool LE_ConfirmCancelThenPlaceReverseOrder;
        private int LE_EntriesPerDirCount;
        private int LE_EntryBarsNum;
        private int LE_EntryCount;
        private int LE_EntrySetup_BarsNum;
        private bool LE_EntrySetup_EOB_Trigger;
        private double LE_EntrySetup_OrderPrice;
        private int LE_EntrySetup_Status;
        private int LE_TG2A_CT_Count;
        private int LE_TG2A_TR_Count;
        private IOrder LE1_EntryOrder;
        private IOrder LE2_EntryOrder;
        private IOrder LE3_EntryOrder;
        private IOrder LE4_EntryOrder;
        private int Lot1_PosQty;
        private int Lot2_PosQty;
        private int Lot3_PosQty;
        private int Lot4_PosQty;
        private bool LX_ConfirmCancelThenExit;
        private bool LX_ExitPositionNextReverse;
        private double LX_PrevStopPrice;
        private IOrder LX_ReverseOrder;
        private bool LX_Setup;
        private bool LX_StopLossOrder_Modify = true;
        private double LX_StopLossPrice;
        private double LX_StopPrice;
        private IOrder LX1_DynExitOrder;
        private double LX1_LastStopPrice;
        private string LX1_OCO_GUID = string.Empty;
        private IOrder LX1_ProfTrgtOrder;
        private bool LX1_ProfTrgtOrderCancelled;
        private IOrder LX1_StopLossOrder;
        private bool LX1_StopLossOrder_Modify = true;
        private double LX1_StopLossOrder_Price;
        private bool LX1_StopLossOrderCancelled;
        private IOrder LX2_DynExitOrder;
        private double LX2_LastStopPrice;
        private string LX2_OCO_GUID = string.Empty;
        private IOrder LX2_ProfTrgtOrder;
        private bool LX2_ProfTrgtOrderCancelled;
        private IOrder LX2_StopLossOrder;
        private bool LX2_StopLossOrder_Modify = true;
        private double LX2_StopLossOrder_Price;
        private bool LX2_StopLossOrderCancelled;
        private IOrder LX3_DynExitOrder;
        private double LX3_LastStopPrice;
        private string LX3_OCO_GUID = string.Empty;
        private IOrder LX3_ProfTrgtOrder;
        private bool LX3_ProfTrgtOrderCancelled;
        private IOrder LX3_StopLossOrder;
        private bool LX3_StopLossOrder_Modify = true;
        private double LX3_StopLossOrder_Price;
        private bool LX3_StopLossOrderCancelled;
        private IOrder LX4_DynExitOrder;
        private double LX4_LastStopPrice;
        private string LX4_OCO_GUID = string.Empty;
        private IOrder LX4_ProfTrgtOrder;
        private bool LX4_ProfTrgtOrderCancelled;
        private IOrder LX4_StopLossOrder;
        private bool LX4_StopLossOrder_Modify = true;
        private double LX4_StopLossOrder_Price;
        private bool LX4_StopLossOrderCancelled;
        private bftatBFTiDiverScout mDiverScout;
        private EMA mEntryEMA;
        private bftatBFTiTG2A mEntryTG2A_CT;
        private bftatBFTiTG2A mEntryTG2A_TR;
        private bftatBFTiTG2A mExitTG2A;
        private int MSSEquityCurvePanelUI;
        private double mTG4A_Value1 = 1.0;
        private double mTG4A_Value2;
        private bftatBFTiSCBV1a mySCB;
        private bool OneEntryPerBarOkayToTrade = true;
        private double OpenPosCommission;
        private int OR_Beg_BarsNum;
        private double OR_HHigh;
        private bool OR_HighExceeded;
        private double OR_LLow;
        private bool OR_LowExceeded;
        private int OR_Status;
        private DataSeries ORHigh_Series;
        private DataSeries ORLow_Series;
        private System.Drawing.Color pAlert_DnBackColor = System.Drawing.Color.Pink;
        private System.Drawing.Color pAlert_UpBackColor = System.Drawing.Color.PaleGreen;
        private int pEntriesPerDirection = 4;
        private int pEntry_PriceTrigType = 1;
        private int pEntry_Reverse_On;
        private DayOfWeek pEOW_Exit_DayOfWeek = DayOfWeek.Friday;
        private int pMaxExceptionsAllowed = 3;
        private int pOrderBIP;
        private string ppAlert_Buy_Wav = "BFTAT_Buy.wav";
        private bool ppAlert_On;
        private string ppAlert_Sell_Wav = "BFTAT_Sell.wav";
        private bool ppAuditMode_On = true;
        private bool ppAuditRpt_On;
        private int pPB_LE_Smooth = 3;
        private int pPB_LE_Trigger = 60;
        private int pPB_SE_Smooth = 3;
        private int pPB_SE_Trigger = 40;
        private int ppBetweenTradeSeconds = 120;
        private int ppBreakEven_On;
        private int ppBreakEven_PlusTicks = 5;
        private int ppBreakEven_TrigTicks = 20;
        private bool ppBtn_Buttons_On = true;
        private int ppBtn_ButtonsXPixels = 10;
        private int ppBtn_ButtonsYPixels = 0x2d;
        private bool ppBtn_BuyMkt_On = true;
        private bool ppBtn_ClosePos_On = true;
        private bool ppBtn_CT_On = true;
        private bool ppBtn_Long_On = true;
        private bool ppBtn_SellMkt_On = true;
        private bool ppBtn_Short_On = true;
        private bool ppBtn_Strategy_On = true;
        private int ppDailyMaxGain_Amt = 800;
        private bool ppDailyMaxGain_On = true;
        private int ppDailyMaxLoss_Amt = 400;
        private bool ppDailyMaxLoss_On = true;
        private int ppDiverScout_Bars = 6;
        private int ppDiverScout_MCFilter_On;
        private int ppDiverScout_Period = 14;
        private int ppDiverScout_ScanWidth = 30;
        private int ppDiverScout_Smooth = 5;
        private int ppEMA_Entry_Period = 200;
        private int ppEntry_Limit_Bars = 3;
        private bftatBigfootV5bDev_Limit_Offset_Type ppEntry_Limit_Offset_Type;
        private int ppEntry_Limit_Ticks = 1;
        private bool ppEntry_Longs_On = true;
        private bftatBigfootV5bDev_OrderType ppEntry_Order_Type;
        private bool ppEntry_Shorts_On = true;
        private int ppEntry1_Qty = 1;
        private int ppEntry2_Qty;
        private int ppEntry3_Qty;
        private int ppEntry4_Qty;
        private DayOfWeek ppEOW_Exit_DOW = DayOfWeek.Friday;
        private TimeSpan ppEOW_Exit_Time = new TimeSpan(15, 45, 0);
        private bool ppEquityCurve_On = true;
        private bool ppEquityTrail_On;
        private int ppEquityTrail_Trail_Amt;
        private int ppEquityTrail_Trail_Pct = 0x20;
        private int ppEquityTrail_Trig_Amt = 800;
        private int ppEquityTrail_Trig_Pct;
        private bftatBigfootV5bDev_OpMode ppOperatingMode = bftatBigfootV5bDev_OpMode.Realtime;
        private int ppProfTrgt1_LE_Ticks = 10;
        private int ppProfTrgt1_SE_Ticks = 10;
        private int ppProfTrgt2_LE_Ticks;
        private int ppProfTrgt2_SE_Ticks;
        private int ppProfTrgt3_LE_Ticks;
        private int ppProfTrgt3_SE_Ticks;
        private int ppProfTrgt4_LE_Ticks;
        private int ppProfTrgt4_SE_Ticks;
        private int pProfTrgt_Ticks = 10;
        private int ppStopLoss_Ticks = 15;
        private string ppStrategyName = "bftatBigfootV5bDev";
        private int ppT2_CounterTrend_On;
        private int ppT2_CT_Entry_Factor = 15;
        private int ppT2_CT_Entry_Period = 0x23;
        private int ppT2_Exit_Factor = 10;
        private int ppT2_Exit_Hook_On;
        private int ppT2_Exit_Period = 10;
        private int ppT2_Exit_Recross_On;
        private int ppT2_MidlineCross_On = 1;
        private int ppT2_MidlineOffset = 10;
        private int ppT2_TR_Entry_Factor = 5;
        private int ppT2_TR_Entry_Period = 5;
        private int ppT2_Trend_On = 1;
        private int ppT2_ValueCross_On = 1;
        private int ppT4_Filter_BarSize = 4;
        private int ppT4_Filter_Factor = 8;
        private int ppT4_Filter_On;
        private int ppT4_Filter_Period = 8;
        private PeriodType ppT4_Filter_PeriodType = PeriodType.Custom0; //?
        private TimeSpan ppTime1_Beg = new TimeSpan(8, 30, 0);
        private TimeSpan ppTime1_End = new TimeSpan(10, 20, 0);
        private TimeSpan ppTime1_Exit = new TimeSpan(10, 0x19, 0);
        private bool ppTime1_Filter_On = true;
        private TimeSpan ppTime2_Beg = new TimeSpan(10, 0x1f, 0);
        private TimeSpan ppTime2_End = new TimeSpan(15, 0, 0);
        private TimeSpan ppTime2_Exit = new TimeSpan(15, 15, 0);
        private bool ppTime2_Filter_On = true;
        private TimeSpan ppTime3_Beg = new TimeSpan(15, 30, 0);
        private TimeSpan ppTime3_End = new TimeSpan(0x10, 0, 0);
        private TimeSpan ppTime3_Exit = new TimeSpan(0x10, 10, 0);
        private bool ppTime3_Filter_On;
        private bool ppTraceOrders_On;
        private int ppTrailStop_On;
        private int ppTrailStop_TrailTicks = 40;
        private int ppTrailStop_TrigTicks = 20;
        private double Prev_LongBestProfLossTicks;
        private double Prev_ShortBestProfLossTicks;
        private int prevBar = 1;
        private int PrevBarTrendDir;
        private double previousHigh = double.MinValue;
        private double previousLow = double.MaxValue;
        private MarketPosition PrevMarketPosition = MarketPosition.Flat;
        private int PrevTradeCount;
        private int PrevTradeNbr;
        private IntSeries PriceDirSeries;
        private double priorTradesCumProfit;
        private bool ProcessExits = true;
        private int pSS_LE_PB_Prd = 0x10;
        private int pSS_LE_PB_Smooth_Prd = 3;
        private int pSS_LE_TR_Prd = 0x10;
        private int pSS_SE_PB_Prd = 0x10;
        private int pSS_SE_PB_Smooth_Prd = 3;
        private int pSS_SE_TR_Prd = 0x10;
        private int pStopLoss_StopLmtOn;
        private int pStopLoss_StopLmtTicks;
        private double realizedProfitLossCommission;
        private bool Realtime_OpMode;
        private double SE_BestProfLossTicks;
        private bool SE_ConfirmCancelThenPlaceReverseOrder;
        private int SE_EntriesPerDirCount;
        private int SE_EntryBarsNum;
        private int SE_EntryCount;
        private int SE_EntrySetup_BarsNum;
        private bool SE_EntrySetup_EOB_Trigger;
        private double SE_EntrySetup_OrderPrice;
        private int SE_EntrySetup_Status;
        private int SE_TG2A_CT_Count;
        private int SE_TG2A_TR_Count;
        private IOrder SE1_EntryOrder;
        private IOrder SE2_EntryOrder;
        private IOrder SE3_EntryOrder;
        private IOrder SE4_EntryOrder;
        private bool SellMktButtonClicked;
        private DateTime stratBegDT = DateTime.MinValue;
        private DateTime stratEndDT = DateTime.MinValue;
        private bool SX_ConfirmCancelThenExit;
        private bool SX_ExitPositionNextReverse;
        private double SX_PrevStopPrice;
        private IOrder SX_ReverseOrder;
        private bool SX_Setup;
        private bool SX_StopLossOrder_Modify = true;
        private double SX_StopLossPrice;
        private double SX_StopPrice;
        private IOrder SX1_DynExitOrder;
        private double SX1_LastStopPrice;
        private string SX1_OCO_GUID = string.Empty;
        private IOrder SX1_ProfTrgtOrder;
        private bool SX1_ProfTrgtOrderCancelled;
        private IOrder SX1_StopLossOrder;
        private bool SX1_StopLossOrder_Modify = true;
        private double SX1_StopLossOrder_Price;
        private bool SX1_StopLossOrderCancelled;
        private IOrder SX2_DynExitOrder;
        private double SX2_LastStopPrice;
        private string SX2_OCO_GUID = string.Empty;
        private IOrder SX2_ProfTrgtOrder;
        private bool SX2_ProfTrgtOrderCancelled;
        private IOrder SX2_StopLossOrder;
        private bool SX2_StopLossOrder_Modify = true;
        private double SX2_StopLossOrder_Price;
        private bool SX2_StopLossOrderCancelled;
        private IOrder SX3_DynExitOrder;
        private double SX3_LastStopPrice;
        private string SX3_OCO_GUID = string.Empty;
        private IOrder SX3_ProfTrgtOrder;
        private bool SX3_ProfTrgtOrderCancelled;
        private IOrder SX3_StopLossOrder;
        private bool SX3_StopLossOrder_Modify = true;
        private double SX3_StopLossOrder_Price;
        private bool SX3_StopLossOrderCancelled;
        private IOrder SX4_DynExitOrder;
        private double SX4_LastStopPrice;
        private string SX4_OCO_GUID = string.Empty;
        private IOrder SX4_ProfTrgtOrder;
        private bool SX4_ProfTrgtOrderCancelled;
        private IOrder SX4_StopLossOrder;
        private bool SX4_StopLossOrder_Modify = true;
        private double SX4_StopLossOrder_Price;
        private bool SX4_StopLossOrderCancelled;
        private SolidBrush textBrush = new SolidBrush(System.Drawing.Color.Black);
        private Font textFont = new Font("Arial", 10f, FontStyle.Bold);
        private bool TimeExitOkayToTrade = true;
        private int TotalIterations;
        private double TotalPosMaxPnl;
        private int TryCatchExceptionCounter;
        private TextPosition txtPosition = TextPosition.BottomLeft;
        private bool useLhHl;
//---
public enum bftatBigfootV5bDev_Limit_Offset_Type
{
    BidAsk,
    FixedTick
}
public enum bftatBigfootV5bDev_OrderType
{
    Limit,
    Market
}
public enum bftatBigfootV5bDev_OpMode
{
    Backtest,
    Realtime
}
public enum bftatBigfootV5bDev_EntrySetup_Level
{
    Level_1,
    Level_2,
    Level_3
}
public enum bftatBigfootV5bDev_EntrySetup_Type
{
    EndOfBar,
    IntraBar
}
//---
        private void btnBFTBuyMkt_Click(object sender)
        {
            this.BTN_BuyMkt_On = true;
            if ((this.BTN_BuyMkt_On && this.BTN_Long_On) && ((this.LE_EntriesPerDirCount < this.pEntriesPerDirection) && (base.Position.MarketPosition == MarketPosition.Flat)))
            {
                this.PlaceEntryOrder(1, bftatBigfootV5bDev_OrderType.Market, 0.0, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                this.LE_EntryBarsNum = base.CurrentBar;
                this.LastEventText = "Btn: BuyMkt";
            }
        }

        private void btnBFTBuyMkt_Event(object sender, EventArgs e)
        {
            if (this.pBtn_BuyMkt_On)
            {
                base.TriggerCustomEvent(new StrategyBase.CustomEvent(this.btnBFTBuyMkt_Click), 1, string.Empty);
            }
        }

        private void btnBFTClosePos_Click(object sender)
        {
            this.BTN_ClosePos_On = true;
            if (this.BTN_ClosePos_On)
            {
                if (base.Position.MarketPosition == MarketPosition.Long)
                {
                    if ((((this.LX1_ProfTrgtOrder == null) && (this.LX2_ProfTrgtOrder == null)) && ((this.LX3_ProfTrgtOrder == null) && (this.LX4_ProfTrgtOrder == null))) && (((this.LX1_StopLossOrder == null) && (this.LX2_StopLossOrder == null)) && ((this.LX3_StopLossOrder == null) && (this.LX4_StopLossOrder == null))))
                    {
                        base.CancelAllOrders(true, false);
                        this.LX1_DynExitOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", "LX_Btn");
                    }
                    else
                    {
                        base.CancelAllOrders(true, true);
                        this.ConfirmCancelThenExitLabel = "LX_Btn";
                        this.LX_ConfirmCancelThenExit = true;
                    }
                    this.LastEventText = "Btn: CloseLong";
                }
                else if (base.Position.MarketPosition == MarketPosition.Short)
                {
                    if ((((this.SX1_ProfTrgtOrder == null) && (this.SX2_ProfTrgtOrder == null)) && ((this.SX3_ProfTrgtOrder == null) && (this.SX4_ProfTrgtOrder == null))) && (((this.SX1_StopLossOrder == null) && (this.SX2_StopLossOrder == null)) && ((this.SX3_StopLossOrder == null) && (this.SX4_StopLossOrder == null))))
                    {
                        base.CancelAllOrders(true, false);
                        this.SX1_DynExitOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", "SX_Btn");
                    }
                    else
                    {
                        base.CancelAllOrders(true, true);
                        this.ConfirmCancelThenExitLabel = "SX_Btn";
                        this.SX_ConfirmCancelThenExit = true;
                    }
                    this.LastEventText = "Btn: CloseShort";
                }
                else
                {
                    base.CancelAllOrders(true, true);
                    this.LastEventText = "Btn: CancelAll";
                }
                this.BTN_ClosePos_On = false;
            }
        }

        private void btnBFTClosePos_Event(object sender, EventArgs e)
        {
            if (this.pBtn_ClosePos_On)
            {
                base.TriggerCustomEvent(new StrategyBase.CustomEvent(this.btnBFTClosePos_Click), 1, string.Empty);
            }
        }

        private void btnBFTCTOn_Click(object sender)
        {
            this.BTN_CT_On = !this.BTN_CT_On;
            if (this.BTN_CT_On)
            {
                this.mySCB.btnBFTCTOn.BackColor = System.Drawing.Color.PaleGreen;
                this.LastEventText = "Btn: CTOn";
            }
            else
            {
                this.mySCB.btnBFTCTOn.BackColor = System.Drawing.Color.LightGray;
                this.LastEventText = "Btn CTOff";
            }
        }

        private void btnBFTCTOn_Event(object sender, EventArgs e)
        {
            if (this.pBtn_CT_On)
            {
                base.TriggerCustomEvent(new StrategyBase.CustomEvent(this.btnBFTCTOn_Click), 1, string.Empty);
            }
        }

        private void btnBFTLongOn_Click(object sender)
        {
            this.BTN_Long_On = !this.BTN_Long_On;
            if (this.BTN_Long_On)
            {
                this.mySCB.btnBFTLongOn.BackColor = System.Drawing.Color.PaleGreen;
                this.LastEventText = "Btn LongOn";
            }
            else
            {
                this.mySCB.btnBFTLongOn.BackColor = System.Drawing.Color.LightGray;
                this.LastEventText = "Btn: LongOff";
            }
        }

        private void btnBFTLongOn_Event(object sender, EventArgs e)
        {
            if (this.pBtn_Long_On)
            {
                base.TriggerCustomEvent(new StrategyBase.CustomEvent(this.btnBFTLongOn_Click), 1, string.Empty);
            }
        }

        private void btnBFTSellMkt_Click(object sender)
        {
            this.BTN_SellMkt_On = true;
            if ((this.BTN_SellMkt_On && this.BTN_Short_On) && ((this.SE_EntriesPerDirCount < this.pEntriesPerDirection) && (base.Position.MarketPosition == MarketPosition.Flat)))
            {
                this.PlaceEntryOrder(-1, bftatBigfootV5bDev_OrderType.Market, 0.0, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                this.LE_EntryBarsNum = base.CurrentBar;
                this.LastEventText = "Btn: SellMkt";
            }
        }

        private void btnBFTSellMkt_Event(object sender, EventArgs e)
        {
            if (this.pBtn_SellMkt_On)
            {
                base.TriggerCustomEvent(new StrategyBase.CustomEvent(this.btnBFTSellMkt_Click), 1, string.Empty);
            }
        }

        private void btnBFTShortOn_Click(object sender)
        {
            this.BTN_Short_On = !this.BTN_Short_On;
            if (this.BTN_Short_On)
            {
                this.mySCB.btnBFTShortOn.BackColor = System.Drawing.Color.PaleGreen;
                this.LastEventText = "Btn: ShortOn";
            }
            else
            {
                this.mySCB.btnBFTShortOn.BackColor = System.Drawing.Color.LightGray;
                this.LastEventText = "Btn ShortOff";
            }
        }

        private void btnBFTShortOn_Event(object sender, EventArgs e)
        {
            if (this.pBtn_Short_On)
            {
                base.TriggerCustomEvent(new StrategyBase.CustomEvent(this.btnBFTShortOn_Click), 1, string.Empty);
            }
        }

        private void btnBFTStrategyOn_Click(object sender)
        {
            this.BTN_Strategy_On = !this.BTN_Strategy_On;
            if (this.BTN_Strategy_On)
            {
                this.mySCB.btnBFTStrategyOn.BackColor = System.Drawing.Color.PaleGreen;
                this.LastEventText = "Btn StrategyOn";
            }
            else
            {
                this.mySCB.btnBFTStrategyOn.BackColor = System.Drawing.Color.LightGray;
                this.LastEventText = "Btn StrategyOff";
            }
        }

        private void btnBFTStrategyOn_Event(object sender, EventArgs e)
        {
            if (this.pBtn_Strategy_On)
            {
                base.TriggerCustomEvent(new StrategyBase.CustomEvent(this.btnBFTStrategyOn_Click), 1, string.Empty);
            }
        }

        private static string GetHigh()
        {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i <= 9; i++)
            {
                builder.Append((char) (i + 0x30));
            }
            return builder.ToString();
        }

        protected override void Initialize()
        {
            this.stratBegDT = DateTime.Now;            
            base.Add(PeriodType.Tick, 1);
            this.pOrderBIP = 1;
            if (this.pT4_Filter_On == 1)
            {
                base.Add(this.pT4_Filter_PeriodType, this.pT4_Filter_BarSize);
            }
            if (this.pBtn_Buttons_On && (this.pOperatingMode == bftatBigfootV5bDev_OpMode.Realtime))
            {
                base.Add(base.bftatBFTiSCBV1a(this.pBtn_ButtonsXPixels, this.pBtn_ButtonsYPixels));
            }
            base.Add(base.bftatBFTiEntryPlot(1));
            base.bftatBFTiEntryPlot(1).Plots[0].Pen.Color = System.Drawing.Color.Goldenrod;
            base.bftatBFTiEntryPlot(1).Plots[0].Pen.Width = 2f;
            base.bftatBFTiEntryPlot(1).PanelUI = 1;
            base.Add(base.bftatBFTiTargetPlot(1));
            base.bftatBFTiTargetPlot(1).Plots[0].Pen.Color = System.Drawing.Color.Green;
            base.bftatBFTiTargetPlot(1).Plots[0].Pen.Width = 2f;
            base.bftatBFTiTargetPlot(1).PanelUI = 1;
            base.Add(base.bftatBFTiTargetPlot(2));
            base.bftatBFTiTargetPlot(2).Plots[0].Pen.Color = System.Drawing.Color.Green;
            base.bftatBFTiTargetPlot(2).Plots[0].Pen.Width = 2f;
            base.bftatBFTiTargetPlot(2).PanelUI = 1;
            base.Add(base.bftatBFTiTargetPlot(3));
            base.bftatBFTiTargetPlot(3).Plots[0].Pen.Color = System.Drawing.Color.Green;
            base.bftatBFTiTargetPlot(3).Plots[0].Pen.Width = 2f;
            base.bftatBFTiTargetPlot(3).PanelUI = 1;
            base.Add(base.bftatBFTiTargetPlot(4));
            base.bftatBFTiTargetPlot(4).Plots[0].Pen.Color = System.Drawing.Color.Green;
            base.bftatBFTiTargetPlot(4).Plots[0].Pen.Width = 2f;
            base.bftatBFTiTargetPlot(4).PanelUI = 1;
            base.Add(base.bftatBFTiStopPlot(1));
            base.bftatBFTiStopPlot(1).Plots[0].Pen.Color = System.Drawing.Color.Red;
            base.bftatBFTiStopPlot(1).Plots[0].Pen.Width = 2f;
            base.bftatBFTiStopPlot(1).PanelUI = 1;
            if (this.pAuditMode_On)
            {
                base.Add(base.EMA(this.pEMA_Entry_Period));
                base.EMA(this.pEMA_Entry_Period).Plots[0].Pen.Width = 2f;
                base.EMA(this.pEMA_Entry_Period).Plots[0].Pen.Color = System.Drawing.Color.LimeGreen;
                base.EMA(this.pEMA_Entry_Period).Plots[0].Pen.DashStyle = DashStyle.Dash;
                base.Add(base.bftatBFTiDiverScout(this.pDiverScout_Period, this.pDiverScout_ScanWidth, this.pDiverScout_Smooth));
                base.bftatBFTiDiverScout(this.pDiverScout_Period, this.pDiverScout_ScanWidth, this.pDiverScout_Smooth).Name = "DiverScout";
                string str = string.Empty;
                str = string.Concat(new object[] { "-", this.pT2_MidlineOffset, "-", this.pT2_TR_Entry_Period, "-", this.pT2_TR_Entry_Factor, " " });
                base.Add(base.bftatBFTiTG2ADisplay(this.pT2_MidlineOffset, this.pT2_TR_Entry_Period, this.pT2_TR_Entry_Factor));
                base.bftatBFTiTG2ADisplay(this.pT2_MidlineOffset, this.pT2_TR_Entry_Period, this.pT2_TR_Entry_Factor).Name = "TR TG2A" + str;
                str = string.Concat(new object[] { "-", this.pT2_MidlineOffset, "-", this.pT2_CT_Entry_Period, "-", this.pT2_CT_Entry_Factor, " " });
                base.Add(base.bftatBFTiTG2ADisplay(this.pT2_MidlineOffset, this.pT2_CT_Entry_Period, this.pT2_CT_Entry_Factor));
                base.bftatBFTiTG2ADisplay(this.pT2_MidlineOffset, this.pT2_CT_Entry_Period, this.pT2_CT_Entry_Factor).Name = "CT TG2A" + str;
                str = string.Concat(new object[] { "-", this.pT2_MidlineOffset, "-", this.pT2_Exit_Period, "-", this.pT2_Exit_Factor, " " });
                base.Add(base.bftatBFTiTG2ADisplay(this.pT2_MidlineOffset, this.pT2_Exit_Period, this.pT2_Exit_Factor));
                base.bftatBFTiTG2ADisplay(this.pT2_MidlineOffset, this.pT2_Exit_Period, this.pT2_Exit_Factor).Name = "EX TG2A" + str;
                if (this.pT4_Filter_On == 1)
                {
                    base.Add(base.bftatBFTiTG4ADisplay(1));
                    base.bftatBFTiTG4ADisplay(1).Name = "FL TG4A";
                    base.bftatBFTiTG4ADisplay(1).Plots[0].Pen.Width = 8f;
                }
            }
            if (this.pEquityCurve_On)
            {
                base.Add(base.bftatBFTiECMonitor(0));
                base.bftatBFTiECMonitor(0).Plots[0].Pen.Color = System.Drawing.Color.Green;
                base.bftatBFTiECMonitor(0).Plots[0].Pen.Width = 2f;
            }
            this.ORHigh_Series = new DataSeries(this);
            this.ORLow_Series = new DataSeries(this);
            this.PriceDirSeries = new IntSeries(this);
            this.CalculateOnBarClose = true;
            base.Unmanaged = true;
            base.IgnoreOverFill = true;
            base.ExitOnClose = false;
            base.TimeInForce = TimeInForce.Day;
        }

        protected override void OnBarUpdate()
        {
                try
                {
                    if (base.CurrentBar >= 5)
                    {
                        bool flag14;
                        if (this.pBtn_Buttons_On && this.Realtime_OpMode)
                        {
                            try
                            {
                                if (((((base.ChartControl != null) && !this.initButtonEvents) && ((this.mySCB.btnBFTStrategyOn != null) && (this.mySCB.btnBFTLongOn != null))) && (((this.mySCB.btnBFTShortOn != null) && (this.mySCB.btnBFTCTOn != null)) && ((this.mySCB.btnBFTBuyMkt != null) && (this.mySCB.btnBFTSellMkt != null)))) && (this.mySCB.btnBFTClosePos != null))
                                {
                                    this.mySCB.btnBFTStrategyOn.Click += new EventHandler(this.btnBFTStrategyOn_Event);
                                    this.mySCB.btnBFTLongOn.Click += new EventHandler(this.btnBFTLongOn_Event);
                                    this.mySCB.btnBFTShortOn.Click += new EventHandler(this.btnBFTShortOn_Event);
                                    this.mySCB.btnBFTCTOn.Click += new EventHandler(this.btnBFTCTOn_Event);
                                    this.mySCB.btnBFTBuyMkt.Click += new EventHandler(this.btnBFTBuyMkt_Event);
                                    this.mySCB.btnBFTSellMkt.Click += new EventHandler(this.btnBFTSellMkt_Event);
                                    this.mySCB.btnBFTClosePos.Click += new EventHandler(this.btnBFTClosePos_Event);
                                    this.initButtonEvents = true;
                                    if (this.pBtn_Strategy_On)
                                    {
                                        this.mySCB.btnBFTStrategyOn.BackColor = System.Drawing.Color.PaleGreen;
                                        this.mySCB.btnBFTStrategyOn.ForeColor = System.Drawing.Color.Black;
                                        this.BTN_Strategy_On = true;
                                    }
                                    else
                                    {
                                        this.mySCB.btnBFTStrategyOn.BackColor = System.Drawing.Color.LightGray;
                                        this.mySCB.btnBFTStrategyOn.ForeColor = System.Drawing.Color.Black;
                                        this.BTN_Strategy_On = false;
                                    }
                                    if (this.pBtn_Long_On)
                                    {
                                        this.mySCB.btnBFTLongOn.BackColor = System.Drawing.Color.PaleGreen;
                                        this.mySCB.btnBFTLongOn.ForeColor = System.Drawing.Color.Black;
                                        this.BTN_Long_On = true;
                                    }
                                    else
                                    {
                                        this.mySCB.btnBFTLongOn.BackColor = System.Drawing.Color.LightGray;
                                        this.mySCB.btnBFTLongOn.ForeColor = System.Drawing.Color.Black;
                                        this.BTN_Long_On = false;
                                    }
                                    if (this.pBtn_Short_On)
                                    {
                                        this.mySCB.btnBFTShortOn.BackColor = System.Drawing.Color.PaleGreen;
                                        this.mySCB.btnBFTShortOn.ForeColor = System.Drawing.Color.Black;
                                        this.BTN_Short_On = true;
                                    }
                                    else
                                    {
                                        this.mySCB.btnBFTShortOn.BackColor = System.Drawing.Color.LightGray;
                                        this.mySCB.btnBFTShortOn.ForeColor = System.Drawing.Color.Black;
                                        this.BTN_Short_On = false;
                                    }
                                    if (this.pBtn_CT_On)
                                    {
                                        if (this.pT2_CounterTrend_On == 1)
                                        {
                                            this.mySCB.btnBFTCTOn.BackColor = System.Drawing.Color.PaleGreen;
                                            this.mySCB.btnBFTCTOn.ForeColor = System.Drawing.Color.Black;
                                            this.BTN_CT_On = true;
                                        }
                                        else if (this.pT2_CounterTrend_On == 0)
                                        {
                                            this.mySCB.btnBFTCTOn.BackColor = System.Drawing.Color.LightGray;
                                            this.mySCB.btnBFTCTOn.ForeColor = System.Drawing.Color.Black;
                                            this.BTN_CT_On = false;
                                        }
                                    }
                                    else
                                    {
                                        this.mySCB.btnBFTCTOn.BackColor = System.Drawing.Color.LightGray;
                                        this.mySCB.btnBFTCTOn.ForeColor = System.Drawing.Color.Black;
                                        this.BTN_CT_On = false;
                                    }
                                    if (this.pBtn_BuyMkt_On)
                                    {
                                        this.mySCB.btnBFTBuyMkt.BackColor = System.Drawing.Color.Green;
                                        this.mySCB.btnBFTBuyMkt.ForeColor = System.Drawing.Color.White;
                                        this.BTN_BuyMkt_On = true;
                                    }
                                    else
                                    {
                                        this.mySCB.btnBFTBuyMkt.BackColor = System.Drawing.Color.DarkGray;
                                        this.mySCB.btnBFTBuyMkt.ForeColor = System.Drawing.Color.White;
                                        this.BTN_BuyMkt_On = false;
                                    }
                                    if (this.pBtn_SellMkt_On)
                                    {
                                        this.mySCB.btnBFTSellMkt.BackColor = System.Drawing.Color.Red;
                                        this.mySCB.btnBFTSellMkt.ForeColor = System.Drawing.Color.White;
                                        this.BTN_SellMkt_On = true;
                                    }
                                    else
                                    {
                                        this.mySCB.btnBFTSellMkt.BackColor = System.Drawing.Color.DarkGray;
                                        this.mySCB.btnBFTSellMkt.ForeColor = System.Drawing.Color.White;
                                        this.BTN_SellMkt_On = false;
                                    }
                                    if (this.pBtn_ClosePos_On)
                                    {
                                        this.mySCB.btnBFTClosePos.BackColor = System.Drawing.Color.Orange;
                                        this.mySCB.btnBFTClosePos.ForeColor = System.Drawing.Color.White;
                                        this.BTN_ClosePos_On = true;
                                    }
                                    else
                                    {
                                        this.mySCB.btnBFTClosePos.BackColor = System.Drawing.Color.DarkGray;
                                        this.mySCB.btnBFTClosePos.ForeColor = System.Drawing.Color.White;
                                        this.BTN_ClosePos_On = false;
                                    }
                                    base.ChartControl.ChartPanel.Invalidate();
                                }
                            }
                            catch (Exception exception)
                            {
                                base.Print("wdcStrategyFrameDemo3b Error 1: " + exception.Message);
                            }
                            if (!base.Historical && !this.FirstRealtime)
                            {
                            }
                        }
                        DateTime time = base.Time[0];
                        TimeSpan timeOfDay = time.TimeOfDay;
                        time = base.Time[1];
                        TimeSpan span2 = time.TimeOfDay;
                        if (base.Bars.FirstBarOfSession)
                        {
                            this.EquityOkayToTrade = true;
                            this.TimeExitOkayToTrade = true;
                            this.EquityTrailStop_Status = 0;
                            this.DailyEquity_TrailStopValue = 0.0;
                            this.DailyEquity_EquityHigh = 0.0;
                            this.DailyEquity_EquityLow = 0.0;
                            this.BestEC_Value = 0.0;
                            this.OR_LowExceeded = false;
                            this.OR_HighExceeded = false;
                            this.TotalPosMaxPnl = 0.0;
                            if (this.Backtest_OpMode)
                            {
                                this.priorTradesCumProfit = base.Performance.AllTrades.TradesPerformance.Currency.CumProfit;
                            }
                            else
                            {
                                this.priorTradesCumProfit = base.Performance.RealtimeTrades.TradesPerformance.Currency.CumProfit;
                            }
                        }
                        if (this.Realtime_OpMode)
                        {
                            this.ClosedPosPnl = base.Performance.RealtimeTrades.TradesPerformance.Currency.CumProfit - this.priorTradesCumProfit;
                            this.CurrTradeCount = base.Performance.RealtimeTrades.Count;
                        }
                        else
                        {
                            this.ClosedPosPnl = base.Performance.AllTrades.TradesPerformance.Currency.CumProfit - this.priorTradesCumProfit;
                            this.CurrTradeCount = base.Performance.AllTrades.Count;
                        }
                        double profitLoss = 0.0;
                        if (base.Position.MarketPosition != MarketPosition.Flat)
                        {
                            if (!Commission.ApplyCommissionToProfitLoss)
                            {
                                this.OpenPosCommission = 0.0;
                            }
                            profitLoss = base.Position.GetProfitLoss(base.Close[0], PerformanceUnit.Currency);
                        }
                        else
                        {
                            profitLoss = 0.0;
                            this.OpenPosCommission = 0.0;
                        }
                        this.DailyEquity_ClosedOpenCommishPnl = (this.ClosedPosPnl + profitLoss) - this.OpenPosCommission;
                        if ((this.CurrTradeCount != this.PrevTradeCount) && (base.Position.MarketPosition != this.PrevMarketPosition))
                        {
                            if (this.ClosedPosPnl > 0.0)
                            {
                                this.DailyEquity_EquityHigh = this.ClosedPosPnl;
                            }
                            else
                            {
                                this.DailyEquity_EquityLow = this.ClosedPosPnl;
                            }
                        }
                        if (this.DailyEquity_ClosedOpenCommishPnl > this.DailyEquity_EquityHigh)
                        {
                            this.DailyEquity_EquityHigh = this.DailyEquity_ClosedOpenCommishPnl;
                        }
                        if (this.DailyEquity_ClosedOpenCommishPnl < this.DailyEquity_EquityLow)
                        {
                            this.DailyEquity_EquityLow = this.DailyEquity_ClosedOpenCommishPnl;
                        }
                        this.PrevTradeCount = this.CurrTradeCount;
                        this.PrevMarketPosition = base.Position.MarketPosition;
                        bool flag = false;
                        bool flag2 = false;
                        if (this.TimeExitOkayToTrade)
                        {
                            bool flag3 = this.pTime1_Filter_On && (((this.pTime1_End.CompareTo(this.pTime1_Exit) < 0) && (span2.CompareTo(this.pTime1_Exit) < 0)) && (timeOfDay.CompareTo(this.pTime1_Exit) >= 0));
                            bool flag4 = this.pTime2_Filter_On && (((this.pTime2_End.CompareTo(this.pTime2_Exit) < 0) && (span2.CompareTo(this.pTime2_Exit) < 0)) && (timeOfDay.CompareTo(this.pTime2_Exit) >= 0));
                            bool flag5 = this.pTime3_Filter_On && (((this.pTime3_End.CompareTo(this.pTime3_Exit) < 0) && (span2.CompareTo(this.pTime3_Exit) < 0)) && (timeOfDay.CompareTo(this.pTime3_Exit) >= 0));
                            if ((flag3 || flag4) || flag5)
                            {
                                if (base.Position.MarketPosition == MarketPosition.Long)
                                {
                                    flag = true;
                                    this.ConfirmCancelThenExitLabel = "LX_ExitTime";
                                    this.TimeExitOkayToTrade = false;
                                }
                                else if (base.Position.MarketPosition == MarketPosition.Short)
                                {
                                    flag2 = true;
                                    this.ConfirmCancelThenExitLabel = "SX_ExitTime";
                                    this.TimeExitOkayToTrade = false;
                                }
                            }
                            bool flag6 = (this.pEOW_Exit_DOW > DayOfWeek.Sunday) && ((time = base.Time[0]).DayOfWeek == this.pEOW_Exit_DOW);
                            bool flag7 = ((this.pEOW_Exit_Time.CompareTo(this.pTime1_Exit) < 0) && (span2.CompareTo(this.pEOW_Exit_Time) < 0)) && (timeOfDay.CompareTo(this.pEOW_Exit_Time) >= 0);
                            if (flag6 && flag7)
                            {
                                if (base.Position.MarketPosition == MarketPosition.Long)
                                {
                                    flag = true;
                                    this.ConfirmCancelThenExitLabel = "LX_EOWTime";
                                    this.TimeExitOkayToTrade = false;
                                }
                                else if (base.Position.MarketPosition == MarketPosition.Short)
                                {
                                    flag2 = true;
                                    this.ConfirmCancelThenExitLabel = "SX_EOWTime";
                                    this.TimeExitOkayToTrade = false;
                                }
                            }
                        }
                        else
                        {
                            bool flag8 = (this.pTime1_Filter_On && (span2.CompareTo(this.pTime1_Beg) < 0)) && (timeOfDay.CompareTo(this.pTime1_Beg) >= 0);
                            bool flag9 = (this.pTime2_Filter_On && (span2.CompareTo(this.pTime2_Beg) < 0)) && (timeOfDay.CompareTo(this.pTime2_Beg) >= 0);
                            bool flag10 = (this.pTime3_Filter_On && (span2.CompareTo(this.pTime3_Beg) < 0)) && (timeOfDay.CompareTo(this.pTime3_Beg) >= 0);
                            if ((flag8 || flag9) || flag10)
                            {
                                this.TimeExitOkayToTrade = true;
                            }
                        }
                        if (this.EquityOkayToTrade)
                        {
                            if ((this.pDailyMaxGain_On && (this.pDailyMaxGain_Amt > 0)) && (this.DailyEquity_ClosedOpenCommishPnl >= this.pDailyMaxGain_Amt))
                            {
                                base.DrawVerticalLine("DailyGainVertLine" + base.CurrentBar.ToString(), 0, System.Drawing.Color.Green, DashStyle.Dash, 2);
                                this.EquityOkayToTrade = false;
                                if (base.Position.MarketPosition == MarketPosition.Long)
                                {
                                    flag = true;
                                    this.ConfirmCancelThenExitLabel = "LX_MaxDlyGain";
                                }
                                else if (base.Position.MarketPosition == MarketPosition.Short)
                                {
                                    flag2 = true;
                                    this.ConfirmCancelThenExitLabel = "SX_MaxDlyGain";
                                }
                            }
                            if ((this.pDailyMaxLoss_On && (this.pDailyMaxLoss_Amt > 0)) && (this.DailyEquity_ClosedOpenCommishPnl <= -this.pDailyMaxLoss_Amt))
                            {
                                base.DrawVerticalLine("DailyLossVertLine" + base.CurrentBar.ToString(), 0, System.Drawing.Color.Red, DashStyle.Dash, 2);
                                this.EquityOkayToTrade = false;
                                if (base.Position.MarketPosition == MarketPosition.Long)
                                {
                                    flag = true;
                                    this.ConfirmCancelThenExitLabel = "LX_MaxDlyLoss";
                                }
                                else if (base.Position.MarketPosition == MarketPosition.Short)
                                {
                                    flag2 = true;
                                    this.ConfirmCancelThenExitLabel = "SX_MaxDlyLoss";
                                }
                            }
                            if (this.pEquityTrail_On)
                            {
                                if (this.EquityTrailStop_Status == 0)
                                {
                                    if (this.DailyEquity_ClosedOpenCommishPnl > this.pEquityTrail_Trig_Amt)
                                    {
                                        this.EquityTrailStop_Status = 1;
                                        this.TotalPosMaxPnl = this.DailyEquity_ClosedOpenCommishPnl;
                                    }
                                }
                                else if (this.EquityTrailStop_Status == 1)
                                {
                                    if (this.DailyEquity_ClosedOpenCommishPnl > this.TotalPosMaxPnl)
                                    {
                                        this.TotalPosMaxPnl = this.DailyEquity_ClosedOpenCommishPnl;
                                    }
                                    if (this.pEquityTrail_Trail_Pct > 0)
                                    {
                                        this.DailyEquity_TrailStopValue = this.TotalPosMaxPnl * (1.0 - (this.pEquityTrail_Trail_Pct * 0.01));
                                    }
                                    else if (this.pEquityTrail_Trail_Amt > 0)
                                    {
                                        this.DailyEquity_TrailStopValue = this.TotalPosMaxPnl - this.pEquityTrail_Trail_Amt;
                                    }
                                    else
                                    {
                                        this.DailyEquity_TrailStopValue = this.TotalPosMaxPnl;
                                    }
                                    if (this.DailyEquity_ClosedOpenCommishPnl <= this.DailyEquity_TrailStopValue)
                                    {
                                        if (base.Position.MarketPosition == MarketPosition.Long)
                                        {
                                            flag = true;
                                            this.ConfirmCancelThenExitLabel = "LX_EqTrail";
                                            this.EquityOkayToTrade = false;
                                            base.DrawVerticalLine("LX_EqTrail" + base.CurrentBar.ToString(), 0, System.Drawing.Color.Green, DashStyle.Dot, 2);
                                        }
                                        else if (base.Position.MarketPosition == MarketPosition.Short)
                                        {
                                            flag2 = true;
                                            this.ConfirmCancelThenExitLabel = "SX_EqTrail";
                                            this.EquityOkayToTrade = false;
                                            base.DrawVerticalLine("SX_EqTrail" + base.CurrentBar.ToString(), 0, System.Drawing.Color.Green, DashStyle.Dot, 2);
                                        }
                                    }
                                }
                            }
                        }
                        if ((this.Backtest_OpMode && (base.BarsInProgress == 0)) && (base.CurrentBar == (base.Bars.Count - 1)))
                        {
                            if (base.Position.MarketPosition == MarketPosition.Long)
                            {
                                flag = true;
                                this.ConfirmCancelThenExitLabel = "LX_LastTrade";
                            }
                            else if (base.Position.MarketPosition == MarketPosition.Short)
                            {
                                flag2 = true;
                                this.ConfirmCancelThenExitLabel = "SX_LastTrade";
                            }
                        }
                        bool flag11 = this.pTime1_Filter_On && (((((this.pTime1_Beg.CompareTo(this.pTime1_End) >= 0) || (timeOfDay.CompareTo(this.pTime1_Beg) <= 0)) || (timeOfDay.CompareTo(this.pTime1_End) > 0)) && ((this.pTime1_Beg.CompareTo(this.pTime1_End) <= 0) || ((timeOfDay.CompareTo(this.pTime1_Beg) <= 0) && (timeOfDay.CompareTo(this.pTime1_End) > 0)))) ? (this.pTime1_Beg == this.pTime1_End) : true);
                        bool flag12 = this.pTime2_Filter_On && (((((this.pTime2_Beg.CompareTo(this.pTime2_End) >= 0) || (timeOfDay.CompareTo(this.pTime2_Beg) <= 0)) || (timeOfDay.CompareTo(this.pTime2_End) > 0)) && ((this.pTime1_Beg.CompareTo(this.pTime2_End) <= 0) || ((timeOfDay.CompareTo(this.pTime2_Beg) <= 0) && (timeOfDay.CompareTo(this.pTime2_End) > 0)))) ? (this.pTime2_Beg == this.pTime2_End) : true);
                        bool flag13 = this.pTime3_Filter_On && (((((this.pTime3_Beg.CompareTo(this.pTime3_End) >= 0) || (timeOfDay.CompareTo(this.pTime3_Beg) <= 0)) || (timeOfDay.CompareTo(this.pTime3_End) > 0)) && ((this.pTime1_Beg.CompareTo(this.pTime3_End) <= 0) || ((timeOfDay.CompareTo(this.pTime3_Beg) <= 0) && (timeOfDay.CompareTo(this.pTime3_End) > 0)))) ? (this.pTime3_Beg == this.pTime3_End) : true);
                        if (!(flag14 = (flag11 || flag12) || flag13))
                        {
                            base.BackColor = System.Drawing.Color.FromArgb(40, System.Drawing.Color.Yellow);
                        }
                        bool flag15 = false;
                        bool flag16 = false;
                        if (base.BarsInProgress == 0)
                        {
                            if ((base.CurrentBar - this.LE_EntryBarsNum) >= this.pEntry_Limit_Bars)
                            {
                                if (this.LE1_EntryOrder != null)
                                {
                                    base.CancelOrder(this.LE1_EntryOrder);
                                }
                                if (this.LE2_EntryOrder != null)
                                {
                                    base.CancelOrder(this.LE2_EntryOrder);
                                }
                                if (this.LE3_EntryOrder != null)
                                {
                                    base.CancelOrder(this.LE3_EntryOrder);
                                }
                                if (this.LE4_EntryOrder != null)
                                {
                                    base.CancelOrder(this.LE4_EntryOrder);
                                }
                            }
                            if ((base.CurrentBar - this.SE_EntryBarsNum) >= this.pEntry_Limit_Bars)
                            {
                                if (this.SE1_EntryOrder != null)
                                {
                                    base.CancelOrder(this.SE1_EntryOrder);
                                }
                                if (this.SE2_EntryOrder != null)
                                {
                                    base.CancelOrder(this.SE2_EntryOrder);
                                }
                                if (this.SE3_EntryOrder != null)
                                {
                                    base.CancelOrder(this.SE3_EntryOrder);
                                }
                                if (this.SE4_EntryOrder != null)
                                {
                                    base.CancelOrder(this.SE4_EntryOrder);
                                }
                            }
                            if (this.pDiverScout_MCFilter_On == 1)
                            {
                                if (this.mDiverScout.SignalDir[0] == 1.0)
                                {
                                    this.DVR_Up_BegSignalBarsNum = base.CurrentBar;
                                    this.DVR_Up_EndSignalBarsNum = base.CurrentBar + this.pDiverScout_Bars;
                                    this.DVR_Up_TGTR_Count = 0;
                                }
                                else if (this.mDiverScout.SignalDir[0] == -1.0)
                                {
                                    this.DVR_Dn_BegSignalBarsNum = base.CurrentBar;
                                    this.DVR_Dn_EndSignalBarsNum = base.CurrentBar + this.pDiverScout_Bars;
                                    this.DVR_Dn_TGTR_Count = 0;
                                }
                                if ((base.CurrentBar >= this.DVR_Up_BegSignalBarsNum) && (base.CurrentBar <= this.DVR_Up_EndSignalBarsNum))
                                {
                                    base.BackColor = System.Drawing.Color.FromArgb(50, System.Drawing.Color.Green);
                                }
                                if ((base.CurrentBar >= this.DVR_Dn_BegSignalBarsNum) && (base.CurrentBar <= this.DVR_Dn_EndSignalBarsNum))
                                {
                                    base.BackColor = System.Drawing.Color.FromArgb(50, System.Drawing.Color.Red);
                                }
                            }
                            double num1 = base.Close[0];
                            double num13 = base.Open[0];
                            if (base.CrossAbove((IDataSeries) this.mEntryTG2A_TR.Value1, (IDataSeries) this.mEntryTG2A_TR.Value2, 1))
                            {
                                this.LE_TG2A_TR_Count = 0;
                            }
                            else if (base.CrossBelow((IDataSeries) this.mEntryTG2A_TR.Value1, (IDataSeries) this.mEntryTG2A_TR.Value2, 1))
                            {
                                this.SE_TG2A_TR_Count = 0;
                            }
                            if (base.CrossAbove((IDataSeries) this.mEntryTG2A_CT.Value1, (IDataSeries) this.mEntryTG2A_CT.Value2, 1))
                            {
                                this.LE_TG2A_CT_Count = 0;
                            }
                            else if (base.CrossBelow((IDataSeries) this.mEntryTG2A_CT.Value1, (IDataSeries) this.mEntryTG2A_CT.Value2, 1))
                            {
                                this.SE_TG2A_CT_Count = 0;
                            }
                            this.EntryOrderSuffix = string.Empty;
                            if (this.pT2_Trend_On == 1)
                            {
                                if (this.pT2_MidlineCross_On == 1)
                                {
                                    bool flag17 = this.LE_TG2A_TR_Count == 0;
                                    bool flag18 = base.Close[0] > this.mEntryEMA[0];
                                    bool flag19 = this.mEntryTG2A_TR.Value1[0] > this.mEntryTG2A_TR.Value2[0];
                                    bool flag20 = base.CrossAbove((IDataSeries) this.mEntryTG2A_TR.Value1, (double) 50.0, 1);
                                    bool flag21 = (this.pDiverScout_MCFilter_On == 0) || ((this.pDiverScout_MCFilter_On == 1) && ((base.CurrentBar - this.DVR_Up_BegSignalBarsNum) <= this.pDiverScout_Bars));
                                    bool flag22 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir > 0));
                                    if (((flag17 && flag18) && (flag19 && flag20)) && (flag21 && flag22))
                                    {
                                        flag15 = true;
                                        this.EntryOrderSuffix = "_TRMC";
                                        this.LE_TG2A_TR_Count++;
                                    }
                                    bool flag23 = this.SE_TG2A_TR_Count == 0;
                                    bool flag24 = base.Close[0] < this.mEntryEMA[0];
                                    bool flag25 = this.mEntryTG2A_TR.Value1[0] < this.mEntryTG2A_TR.Value2[0];
                                    bool flag26 = base.CrossBelow((IDataSeries) this.mEntryTG2A_TR.Value1, (double) 50.0, 1);
                                    bool flag27 = (this.pDiverScout_MCFilter_On == 0) || ((this.pDiverScout_MCFilter_On == 1) && ((base.CurrentBar - this.DVR_Dn_BegSignalBarsNum) <= this.pDiverScout_Bars));
                                    bool flag28 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir < 0));
                                    if (((flag23 && flag24) && (flag25 && flag26)) && (flag27 && flag28))
                                    {
                                        flag16 = true;
                                        this.EntryOrderSuffix = "_TRMC";
                                        this.SE_TG2A_TR_Count++;
                                    }
                                }
                                if (this.pT2_ValueCross_On == 1)
                                {
                                    bool flag29 = this.LE_TG2A_TR_Count == 0;
                                    bool flag30 = base.Close[0] > this.mEntryEMA[0];
                                    bool flag31 = base.CrossAbove((IDataSeries) this.mEntryTG2A_TR.Value1, (IDataSeries) this.mEntryTG2A_TR.Value2, 1);
                                    bool flag32 = this.mEntryTG2A_TR.Value1[0] > 50.0;
                                    bool flag33 = this.mEntryTG2A_TR.Value1[0] < (50 + this.pT2_MidlineOffset);
                                    bool flag34 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir > 0));
                                    if (((flag29 && flag30) && (flag31 && flag32)) && (flag33 && flag34))
                                    {
                                        flag15 = true;
                                        this.EntryOrderSuffix = "_TRVC";
                                        this.LE_TG2A_TR_Count++;
                                    }
                                    bool flag35 = this.SE_TG2A_TR_Count == 0;
                                    bool flag36 = base.Close[0] < this.mEntryEMA[0];
                                    bool flag37 = base.CrossBelow((IDataSeries) this.mEntryTG2A_TR.Value1, (IDataSeries) this.mEntryTG2A_TR.Value2, 1);
                                    bool flag38 = this.mEntryTG2A_TR.Value1[0] < 50.0;
                                    bool flag39 = this.mEntryTG2A_TR.Value1[0] > (50 - this.pT2_MidlineOffset);
                                    bool flag40 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir < 0));
                                    if (((flag35 && flag36) && (flag37 && flag38)) && (flag39 && flag40))
                                    {
                                        flag16 = true;
                                        this.EntryOrderSuffix = "_TRVC";
                                        this.SE_TG2A_TR_Count++;
                                    }
                                }
                            }
                            if ((this.Backtest_OpMode && (this.pT2_CounterTrend_On == 1)) || (this.Realtime_OpMode && this.BTN_CT_On))
                            {
                                if (this.pT2_MidlineCross_On == 1)
                                {
                                    bool flag41 = this.LE_TG2A_CT_Count == 0;
                                    bool flag42 = base.Close[0] < this.mEntryEMA[0];
                                    bool flag43 = this.mEntryTG2A_CT.Value1[0] > this.mEntryTG2A_CT.Value2[0];
                                    bool flag44 = base.CrossAbove((IDataSeries) this.mEntryTG2A_CT.Value1, (double) 50.0, 1);
                                    bool flag45 = (this.pDiverScout_MCFilter_On == 0) || ((this.pDiverScout_MCFilter_On == 1) && ((base.CurrentBar - this.DVR_Up_BegSignalBarsNum) <= this.pDiverScout_Bars));
                                    bool flag46 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir > 0));
                                    if (((flag41 && flag42) && (flag43 && flag44)) && (flag45 && flag46))
                                    {
                                        flag15 = true;
                                        this.EntryOrderSuffix = "_CTMC";
                                        this.LE_TG2A_CT_Count++;
                                    }
                                    bool flag47 = this.SE_TG2A_CT_Count == 0;
                                    bool flag48 = base.Close[0] > this.mEntryEMA[0];
                                    bool flag49 = this.mEntryTG2A_CT.Value1[0] < this.mEntryTG2A_CT.Value2[0];
                                    bool flag50 = base.CrossBelow((IDataSeries) this.mEntryTG2A_CT.Value1, (double) 50.0, 1);
                                    bool flag51 = (this.pDiverScout_MCFilter_On == 0) || ((this.pDiverScout_MCFilter_On == 1) && ((base.CurrentBar - this.DVR_Dn_BegSignalBarsNum) <= this.pDiverScout_Bars));
                                    bool flag52 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir < 0));
                                    if (((flag47 && flag48) && (flag49 && flag50)) && (flag51 && flag52))
                                    {
                                        flag16 = true;
                                        this.EntryOrderSuffix = "_CTMC";
                                        this.SE_TG2A_CT_Count++;
                                    }
                                }
                                if (this.pT2_ValueCross_On == 1)
                                {
                                    bool flag53 = this.LE_TG2A_CT_Count == 0;
                                    bool flag54 = base.Close[0] < this.mEntryEMA[0];
                                    bool flag55 = base.CrossAbove((IDataSeries) this.mEntryTG2A_CT.Value1, (IDataSeries) this.mEntryTG2A_CT.Value2, 1);
                                    bool flag56 = this.mEntryTG2A_CT.Value1[0] > 50.0;
                                    bool flag57 = this.mEntryTG2A_CT.Value1[0] < (50 + this.pT2_MidlineOffset);
                                    bool flag58 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir > 0));
                                    if (((flag53 && flag54) && (flag55 && flag56)) && (flag57 && flag58))
                                    {
                                        flag15 = true;
                                        this.EntryOrderSuffix = "_CTVC";
                                        this.LE_TG2A_CT_Count++;
                                    }
                                    bool flag59 = this.SE_TG2A_CT_Count == 0;
                                    bool flag60 = base.Close[0] > this.mEntryEMA[0];
                                    bool flag61 = base.CrossBelow((IDataSeries) this.mEntryTG2A_CT.Value1, (IDataSeries) this.mEntryTG2A_CT.Value2, 1);
                                    bool flag62 = this.mEntryTG2A_CT.Value1[0] < 50.0;
                                    bool flag63 = this.mEntryTG2A_CT.Value1[0] > (50 - this.pT2_MidlineOffset);
                                    bool flag64 = (this.pT4_Filter_On == 0) || ((this.pT4_Filter_On == 1) && (this.filterTG4A_SignalDir < 0));
                                    if (((flag59 && flag60) && (flag61 && flag62)) && (flag63 && flag64))
                                    {
                                        flag16 = true;
                                        this.EntryOrderSuffix = "_CTVC";
                                        this.SE_TG2A_CT_Count++;
                                    }
                                }
                            }
                            if (flag15 && flag16)
                            {
                                base.BackColorAll = System.Drawing.Color.FromArgb(30, System.Drawing.Color.Orange);
                            }
                            else if (flag15)
                            {
                                base.BackColorAll = System.Drawing.Color.FromArgb(30, System.Drawing.Color.Green);
                            }
                            else if (flag16)
                            {
                                base.BackColorAll = System.Drawing.Color.FromArgb(30, System.Drawing.Color.Red);
                            }
                            if ((this.pT2_Exit_Hook_On == 1) && (this.mExitTG2A.Value1[0] < this.mExitTG2A.Value1[1]))
                            {
                                flag = true;
                                this.ConfirmCancelThenExitLabel = "LX_HK";
                            }
                            if ((this.pT2_Exit_Hook_On == 1) && (this.mExitTG2A.Value1[0] > this.mExitTG2A.Value1[1]))
                            {
                                flag2 = true;
                                this.ConfirmCancelThenExitLabel = "SX_HK";
                            }
                            if ((this.pT2_Exit_Recross_On == 1) && base.CrossBelow((IDataSeries) this.mExitTG2A.Value1, (IDataSeries) this.mExitTG2A.Value2, 1))
                            {
                                flag = true;
                                this.ConfirmCancelThenExitLabel = "LX_RC";
                            }
                            if ((this.pT2_Exit_Recross_On == 1) && base.CrossAbove((IDataSeries) this.mExitTG2A.Value1, (IDataSeries) this.mExitTG2A.Value2, 1))
                            {
                                flag2 = true;
                                this.ConfirmCancelThenExitLabel = "SX_RC";
                            }
                            if (!this.pAuditMode_On && (this.EntryOrderSuffix != string.Empty))
                            {
                                this.EntryOrderSuffix = string.Empty;
                            }
                            if (this.EquityOkayToTrade && ((this.Realtime_OpMode && !base.Historical) || (this.Backtest_OpMode && base.Historical)))
                            {
                                bool flag65 = (flag15 && flag14) && ((!this.Backtest_OpMode || !this.pEntry_Longs_On) ? ((this.Realtime_OpMode && this.BTN_Strategy_On) && this.BTN_Long_On) : true);
                                bool flag66 = (flag16 && flag14) && ((!this.Backtest_OpMode || !this.pEntry_Shorts_On) ? ((this.Realtime_OpMode && this.BTN_Strategy_On) && this.BTN_Short_On) : true);
                                this.ProcessExits = false;
                                if (flag65)
                                {
                                    this.OneEntryPerBarOkayToTrade = false;
                                    this.LE_EntryCount++;
                                    if (this.pAlert_On && (this.pAlert_Buy_Wav.Length > 0))
                                    {
                                        double num3 = base.Close[0];
                                        string message = base.Bars.Instrument.FullName.ToString() + ", " + base.Bars.Period.ToString() + ", TKO Long Signal at " + num3.ToString();
                                        base.Alert("LE_Vol_Alert", Priority.Low, message, this.pAlert_Buy_Wav, 10, this.pAlert_UpBackColor, System.Drawing.Color.Black);
                                    }
                                    if (base.Position.MarketPosition == MarketPosition.Flat)
                                    {
                                        if (this.pEntry_Order_Type == bftatBigfootV5bDev_OrderType.Limit)
                                        {
                                            if (this.pEntry_Limit_Offset_Type == bftatBigfootV5bDev_Limit_Offset_Type.BidAsk)
                                            {
                                                this.LE_EntrySetup_OrderPrice = base.Bars.Instrument.MasterInstrument.Round2TickSize(base.GetCurrentAsk() - (this.pEntry_Limit_Ticks * base.TickSize));
                                            }
                                            else if (this.pEntry_Limit_Offset_Type == bftatBigfootV5bDev_Limit_Offset_Type.FixedTick)
                                            {
                                                this.LE_EntrySetup_OrderPrice = base.Bars.Instrument.MasterInstrument.Round2TickSize(base.Close[0] - (this.pEntry_Limit_Ticks * base.TickSize));
                                            }
                                            else
                                            {
                                                this.LE_EntrySetup_OrderPrice = base.Close[0];
                                            }
                                            this.PlaceEntryOrder(1, bftatBigfootV5bDev_OrderType.Limit, this.LE_EntrySetup_OrderPrice, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                        }
                                        else
                                        {
                                            this.PlaceEntryOrder(1, bftatBigfootV5bDev_OrderType.Market, 0.0, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                        }
                                        this.LE_EntryBarsNum = base.CurrentBar;
                                    }
                                    else if ((base.Position.MarketPosition == MarketPosition.Short) && (this.pEntry_Reverse_On == 1))
                                    {
                                        if ((((this.SX1_ProfTrgtOrder == null) && (this.SX2_ProfTrgtOrder == null)) && ((this.SX3_ProfTrgtOrder == null) && (this.SX4_ProfTrgtOrder == null))) && (((this.SX1_StopLossOrder == null) && (this.SX2_StopLossOrder == null)) && ((this.SX3_StopLossOrder == null) && (this.SX4_StopLossOrder == null))))
                                        {
                                            if ((this.pEntry_Order_Type == bftatBigfootV5bDev_OrderType.Limit) && (this.LE_EntrySetup_OrderPrice > 0.0))
                                            {
                                                this.PlaceEntryOrder(1, bftatBigfootV5bDev_OrderType.Limit, this.LE_EntrySetup_OrderPrice, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                            }
                                            else
                                            {
                                                this.PlaceEntryOrder(1, bftatBigfootV5bDev_OrderType.Market, 0.0, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                            }
                                            this.LE_EntryBarsNum = base.CurrentBar;
                                        }
                                        else
                                        {
                                            base.CancelAllOrders(true, true);
                                            this.LE_ConfirmCancelThenPlaceReverseOrder = true;
                                        }
                                    }
                                }
                                else if (flag66)
                                {
                                    this.OneEntryPerBarOkayToTrade = false;
                                    this.SE_EntryCount++;
                                    if (this.pAlert_On && (this.pAlert_Sell_Wav.Length > 0))
                                    {
                                        double num4 = base.Close[0];
                                        string str2 = base.Bars.Instrument.FullName.ToString() + ", " + base.Bars.Period.ToString() + ", TKO Short Signal at " + num4.ToString();
                                        base.Alert("SE_Vol_Alert", Priority.Low, str2, this.pAlert_Sell_Wav, 10, this.pAlert_DnBackColor, System.Drawing.Color.Black);
                                    }
                                    if (base.Position.MarketPosition == MarketPosition.Flat)
                                    {
                                        if (this.pEntry_Order_Type == bftatBigfootV5bDev_OrderType.Limit)
                                        {
                                            if (this.pEntry_Limit_Offset_Type == bftatBigfootV5bDev_Limit_Offset_Type.BidAsk)
                                            {
                                                this.SE_EntrySetup_OrderPrice = base.Bars.Instrument.MasterInstrument.Round2TickSize(base.GetCurrentBid() + (this.pEntry_Limit_Ticks * base.TickSize));
                                            }
                                            else if (this.pEntry_Limit_Offset_Type == bftatBigfootV5bDev_Limit_Offset_Type.FixedTick)
                                            {
                                                this.SE_EntrySetup_OrderPrice = base.Bars.Instrument.MasterInstrument.Round2TickSize(base.Close[0] + (this.pEntry_Limit_Ticks * base.TickSize));
                                            }
                                            else
                                            {
                                                this.SE_EntrySetup_OrderPrice = base.Close[0];
                                            }
                                            this.PlaceEntryOrder(-1, bftatBigfootV5bDev_OrderType.Limit, this.SE_EntrySetup_OrderPrice, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                        }
                                        else
                                        {
                                            this.PlaceEntryOrder(-1, bftatBigfootV5bDev_OrderType.Market, 0.0, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                        }
                                        this.SE_EntryBarsNum = base.CurrentBar;
                                    }
                                    else if ((base.Position.MarketPosition == MarketPosition.Long) && (this.pEntry_Reverse_On == 1))
                                    {
                                        if ((((this.LX1_ProfTrgtOrder == null) && (this.LX2_ProfTrgtOrder == null)) && ((this.LX3_ProfTrgtOrder == null) && (this.LX4_ProfTrgtOrder == null))) && (((this.LX1_StopLossOrder == null) && (this.LX2_StopLossOrder == null)) && ((this.LX3_StopLossOrder == null) && (this.LX4_StopLossOrder == null))))
                                        {
                                            if ((this.pEntry_Order_Type == bftatBigfootV5bDev_OrderType.Limit) && (this.SE_EntrySetup_OrderPrice > 0.0))
                                            {
                                                this.PlaceEntryOrder(-1, bftatBigfootV5bDev_OrderType.Limit, this.SE_EntrySetup_OrderPrice, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                            }
                                            else
                                            {
                                                this.PlaceEntryOrder(-1, bftatBigfootV5bDev_OrderType.Market, 0.0, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                                            }
                                            this.SE_EntryBarsNum = base.CurrentBar;
                                        }
                                        else
                                        {
                                            base.CancelAllOrders(true, true);
                                            this.SE_ConfirmCancelThenPlaceReverseOrder = true;
                                        }
                                    }
                                }
                            }
                            if ((base.Position.MarketPosition == MarketPosition.Flat) && (this.pEntry_Order_Type == bftatBigfootV5bDev_OrderType.Limit))
                            {
                                if (this.LE1_EntryOrder != null)
                                {
                                    base.bftatBFTiEntryPlot(1).Value.Set(this.LE1_EntryOrder.LimitPrice);
                                }
                                if (this.SE1_EntryOrder != null)
                                {
                                    base.bftatBFTiEntryPlot(1).Value.Set(this.SE1_EntryOrder.LimitPrice);
                                }
                            }
                            if (base.Position.MarketPosition == MarketPosition.Long)
                            {
                                if (this.LX4_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(4).Value.Set(this.LX4_ProfTrgtOrder.LimitPrice);
                                }
                                if (this.LX3_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(3).Value.Set(this.LX3_ProfTrgtOrder.LimitPrice);
                                }
                                if (this.LX2_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(2).Value.Set(this.LX2_ProfTrgtOrder.LimitPrice);
                                }
                                if (this.LX1_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(1).Value.Set(this.LX1_ProfTrgtOrder.LimitPrice);
                                }
                                bool flag67 = false;
                                if (this.LX4_StopLossOrder != null)
                                {
                                    this.LX_StopLossPrice = this.LX4_StopLossOrder.StopPrice;
                                    flag67 = true;
                                }
                                if (this.LX3_StopLossOrder != null)
                                {
                                    this.LX_StopLossPrice = this.LX3_StopLossOrder.StopPrice;
                                    flag67 = true;
                                }
                                if (this.LX2_StopLossOrder != null)
                                {
                                    this.LX_StopLossPrice = this.LX2_StopLossOrder.StopPrice;
                                    flag67 = true;
                                }
                                if (this.LX1_StopLossOrder != null)
                                {
                                    this.LX_StopLossPrice = this.LX1_StopLossOrder.StopPrice;
                                    flag67 = true;
                                }
                                if (flag67)
                                {
                                    base.bftatBFTiStopPlot(1).Value.Set(this.LX_StopLossPrice);
                                }
                            }
                            else if (base.Position.MarketPosition == MarketPosition.Short)
                            {
                                if (this.SX4_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(4).Value.Set(this.SX4_ProfTrgtOrder.LimitPrice);
                                }
                                if (this.SX3_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(3).Value.Set(this.SX3_ProfTrgtOrder.LimitPrice);
                                }
                                if (this.SX2_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(2).Value.Set(this.SX2_ProfTrgtOrder.LimitPrice);
                                }
                                if (this.SX1_ProfTrgtOrder != null)
                                {
                                    base.bftatBFTiTargetPlot(1).Value.Set(this.SX1_ProfTrgtOrder.LimitPrice);
                                }
                                bool flag68 = false;
                                if (this.SX4_StopLossOrder != null)
                                {
                                    this.SX_StopLossPrice = this.SX4_StopLossOrder.StopPrice;
                                    flag68 = true;
                                }
                                if (this.SX3_StopLossOrder != null)
                                {
                                    this.SX_StopLossPrice = this.SX3_StopLossOrder.StopPrice;
                                    flag68 = true;
                                }
                                if (this.SX2_StopLossOrder != null)
                                {
                                    this.SX_StopLossPrice = this.SX2_StopLossOrder.StopPrice;
                                    flag68 = true;
                                }
                                if (this.SX1_StopLossOrder != null)
                                {
                                    this.SX_StopLossPrice = this.SX1_StopLossOrder.StopPrice;
                                    flag68 = true;
                                }
                                if (flag68)
                                {
                                    base.bftatBFTiStopPlot(1).Value.Set(this.SX_StopLossPrice);
                                }
                            }
                            if (this.pAuditMode_On && (this.pT4_Filter_On == 1))
                            {
                                base.bftatBFTiTG4ADisplay(1).Value.Set(1.0);
                                if (this.filterTG4A_SignalDir == 2)
                                {
                                    base.bftatBFTiTG4ADisplay(1).PlotColors[0][0] = System.Drawing.Color.Green;
                                }
                                else if (this.filterTG4A_SignalDir == 1)
                                {
                                    base.bftatBFTiTG4ADisplay(1).PlotColors[0][0] = System.Drawing.Color.Lime;
                                }
                                else if (this.filterTG4A_SignalDir == -1)
                                {
                                    base.bftatBFTiTG4ADisplay(1).PlotColors[0][0] = System.Drawing.Color.Pink;
                                }
                                else if (this.filterTG4A_SignalDir == -2)
                                {
                                    base.bftatBFTiTG4ADisplay(1).PlotColors[0][0] = System.Drawing.Color.Red;
                                }
                                else
                                {
                                    base.bftatBFTiTG4ADisplay(1).PlotColors[0][0] = System.Drawing.Color.LightGray;
                                }
                            }
                            if (this.pEquityCurve_On)
                            {
                                base.bftatBFTiECMonitor(0).Value.Set(this.DailyEquity_ClosedOpenCommishPnl);
                                if (this.DailyEquity_ClosedOpenCommishPnl >= 0.0)
                                {
                                    base.bftatBFTiECMonitor(0).PlotColors[0][0] = System.Drawing.Color.Green;
                                }
                                else
                                {
                                    base.bftatBFTiECMonitor(0).PlotColors[0][0] = System.Drawing.Color.Red;
                                }
                                base.bftatBFTiECMonitor(0).Values[1].Set(this.DailyEquity_EquityHigh);
                                base.bftatBFTiECMonitor(0).Values[2].Set(this.DailyEquity_EquityLow);
                                if (this.pEquityTrail_On)
                                {
                                    if (this.pEquityTrail_Trig_Amt <= 0)
                                    {
                                        base.bftatBFTiECMonitor(0).Values[3].Reset();
                                    }
                                    else
                                    {
                                        base.bftatBFTiECMonitor(0).Values[3].Set((double) this.pEquityTrail_Trig_Amt);
                                    }
                                    if (this.DailyEquity_TrailStopValue <= 0.0)
                                    {
                                        base.bftatBFTiECMonitor(0).Values[4].Reset();
                                    }
                                    else
                                    {
                                        base.bftatBFTiECMonitor(0).Values[4].Set(this.DailyEquity_TrailStopValue);
                                    }
                                }
                            }
                            if (!base.Historical && this.FirstRealtimeUpdate)
                            {
                                this.FirstRealtimeUpdate = false;
                                base.DrawVerticalLine("VertLine" + base.CurrentBar.ToString(), 0, System.Drawing.Color.DarkGoldenrod, DashStyle.Dash, 2);
                                string text = "OpMode: " + this.pOperatingMode.ToString();
                                base.DrawTextFixed("TextMessage", text, TextPosition.TopLeft);
                            }
                            if (this.CheckLoadTime && this.LastBarOnChart)
                            {
                                this.stratEndDT = DateTime.Now;
                                TimeSpan span4 = this.stratEndDT.Subtract(this.stratBegDT);
                                base.Log(base.Name + " Seconds To Load: " + span4.TotalSeconds.ToString("F2") + " Bars To Process: " + base.CurrentBar.ToString(), NinjaTrader.Cbi.LogLevel.Information);
                                this.CheckLoadTime = false;
                            }
                        }
                        else if (base.BarsInProgress == this.pOrderBIP)
                        {
                            if (this.activateDailyTargets)
                            {
                                this.realizedProfitLossCommission = Math.Round((double) ((base.Performance.AllTrades.TradesPerformance.GrossLoss + base.Performance.AllTrades.TradesPerformance.GrossProfit) - (base.Performance.AllTrades.TradesPerformance.TradesCount * this.commission)));
                                if (((this.lastTradedUpdate != base.Position.Quantity) || (this.lastPriceChange != base.Close[0])) && this.displayProfitLoss)
                                {
                                    if (this.displayProfitLoss)
                                    {
                                        object[] objArray = new object[] { "======================== \r\nOpen P & L       = $ ", base.Position.GetProfitLoss(base.Close[0], PerformanceUnit.Currency).ToString("0.00"), " \r\nOpen Contracts  = ", base.Position.Quantity, " \r\n------------------------------------------ \r\nRealized P & L  = $ ", ((base.Performance.AllTrades.TradesPerformance.GrossLoss + base.Performance.AllTrades.TradesPerformance.GrossProfit) - (base.Performance.AllTrades.TradesPerformance.TradesCount * this.commission)).ToString("0.00"), " \r\nWinning Trades  = ", base.Performance.AllTrades.WinningTrades.Count, " \r\nLosing   Trades  = ", base.Performance.AllTrades.LosingTrades.TradesCount, " \r\n------------------------------------------ \r\nGrossProfit  = $  ", base.Performance.AllTrades.TradesPerformance.GrossProfit.ToString("0.00"), " \r\nGrossLoss   = $ ", base.Performance.AllTrades.TradesPerformance.GrossLoss.ToString("0.00"), " \r\n========================" };
                                        base.DrawTextFixed("TradePL", string.Concat(objArray), this.txtPosition, this.textBrush.Color, this.textFont, this.textBrush.Color, this.fillColor, this.fontsize);
                                    }
                                    this.lastTradedUpdate = base.Position.Quantity;
                                    this.lastPriceChange = base.Close[0];
                                }
                            }
                            if (base.Position.MarketPosition != MarketPosition.Flat)
                            {
                                if (base.Position.MarketPosition == MarketPosition.Long)
                                {
                                    double num6 = Math.Round((double) (base.Position.GetProfitLoss(base.Close[0], PerformanceUnit.Points) / base.TickSize));
                                    if (num6 > this.LE_BestProfLossTicks)
                                    {
                                        this.LE_BestProfLossTicks = num6;
                                    }
                                }
                                else if (base.Position.MarketPosition == MarketPosition.Short)
                                {
                                    double num7 = Math.Round((double) (base.Position.GetProfitLoss(base.Close[0], PerformanceUnit.Points) / base.TickSize));
                                    if (num7 > this.SE_BestProfLossTicks)
                                    {
                                        this.SE_BestProfLossTicks = num7;
                                    }
                                }
                                this.LX_StopLossOrder_Modify = false;
                                this.LX1_StopLossOrder_Modify = false;
                                this.LX2_StopLossOrder_Modify = false;
                                this.LX3_StopLossOrder_Modify = false;
                                this.LX4_StopLossOrder_Modify = false;
                                this.SX_StopLossOrder_Modify = false;
                                this.SX1_StopLossOrder_Modify = false;
                                this.SX2_StopLossOrder_Modify = false;
                                this.SX3_StopLossOrder_Modify = false;
                                this.SX4_StopLossOrder_Modify = false;
                                if ((this.pBreakEven_On == 1) && (this.BreakEvenStopStatus == 1))
                                {
                                    if (base.Position.MarketPosition == MarketPosition.Long)
                                    {
                                        if (this.LE_BestProfLossTicks >= this.pBreakEven_TrigTicks)
                                        {
                                            this.BreakEvenStopStatus = 0;
                                            double num8 = Math.Max(this.LX_PrevStopPrice, Math.Min((double) (base.GetCurrentBid() - (this.cBreakEvenBufferTicks * base.TickSize)), (double) (base.Position.AvgPrice + (this.pBreakEven_PlusTicks * base.TickSize))));
                                            if (num8 > this.LX_PrevStopPrice)
                                            {
                                                this.LX_StopLossOrder_Modify = true;
                                                this.LX1_StopLossOrder_Modify = true;
                                                this.LX1_StopLossOrder_Price = num8;
                                                this.LX2_StopLossOrder_Modify = true;
                                                this.LX2_StopLossOrder_Price = num8;
                                                this.LX3_StopLossOrder_Modify = true;
                                                this.LX3_StopLossOrder_Price = num8;
                                                this.LX4_StopLossOrder_Modify = true;
                                                this.LX4_StopLossOrder_Price = num8;
                                                this.LX_PrevStopPrice = num8;
                                            }
                                        }
                                    }
                                    else if ((base.Position.MarketPosition == MarketPosition.Short) && (this.SE_BestProfLossTicks >= this.pBreakEven_TrigTicks))
                                    {
                                        this.BreakEvenStopStatus = 0;
                                        double num9 = Math.Min(this.SX_PrevStopPrice, Math.Max((double) (base.GetCurrentAsk() + (this.cBreakEvenBufferTicks * base.TickSize)), (double) (base.Position.AvgPrice - (this.pBreakEven_PlusTicks * base.TickSize))));
                                        if (num9 < this.SX_PrevStopPrice)
                                        {
                                            this.SX_StopLossOrder_Modify = true;
                                            this.SX1_StopLossOrder_Modify = true;
                                            this.SX1_StopLossOrder_Price = num9;
                                            this.SX2_StopLossOrder_Modify = true;
                                            this.SX2_StopLossOrder_Price = num9;
                                            this.SX3_StopLossOrder_Modify = true;
                                            this.SX3_StopLossOrder_Price = num9;
                                            this.SX4_StopLossOrder_Modify = true;
                                            this.SX4_StopLossOrder_Price = num9;
                                            this.SX_PrevStopPrice = num9;
                                        }
                                    }
                                }
                                if (this.pTrailStop_On == 1)
                                {
                                    if (base.Position.MarketPosition == MarketPosition.Long)
                                    {
                                        if (this.LE_BestProfLossTicks >= this.pTrailStop_TrigTicks)
                                        {
                                            double num10 = base.Bars.Instrument.MasterInstrument.Round2TickSize(Math.Max(this.LX_PrevStopPrice, Math.Min((double) (base.GetCurrentBid() - (this.cTrailStopBufferTicks * base.TickSize)), (double) (base.High[0] - (this.pTrailStop_TrailTicks * base.TickSize)))));
                                            if (num10 > this.LX_PrevStopPrice)
                                            {
                                                this.LX_StopLossOrder_Modify = true;
                                                this.LX1_StopLossOrder_Modify = true;
                                                this.LX1_StopLossOrder_Price = num10;
                                                this.LX2_StopLossOrder_Modify = true;
                                                this.LX2_StopLossOrder_Price = num10;
                                                this.LX3_StopLossOrder_Modify = true;
                                                this.LX3_StopLossOrder_Price = num10;
                                                this.LX4_StopLossOrder_Modify = true;
                                                this.LX4_StopLossOrder_Price = num10;
                                                this.LX_PrevStopPrice = num10;
                                            }
                                        }
                                    }
                                    else if ((base.Position.MarketPosition == MarketPosition.Short) && (this.SE_BestProfLossTicks >= this.pTrailStop_TrigTicks))
                                    {
                                        double num11 = base.Bars.Instrument.MasterInstrument.Round2TickSize(Math.Min(this.SX_PrevStopPrice, Math.Max((double) (base.GetCurrentAsk() + (this.cTrailStopBufferTicks * base.TickSize)), (double) (base.Low[0] + (this.pTrailStop_TrailTicks * base.TickSize)))));
                                        if (num11 < this.SX_PrevStopPrice)
                                        {
                                            this.SX_StopLossOrder_Modify = true;
                                            this.SX1_StopLossOrder_Modify = true;
                                            this.SX1_StopLossOrder_Price = num11;
                                            this.SX2_StopLossOrder_Modify = true;
                                            this.SX2_StopLossOrder_Price = num11;
                                            this.SX3_StopLossOrder_Modify = true;
                                            this.SX3_StopLossOrder_Price = num11;
                                            this.SX4_StopLossOrder_Modify = true;
                                            this.SX4_StopLossOrder_Price = num11;
                                            this.SX_PrevStopPrice = num11;
                                        }
                                    }
                                }
                                if (!this.HaltStopLossModProcess)
                                {
                                    if ((base.Position.MarketPosition == MarketPosition.Long) && this.LX_StopLossOrder_Modify)
                                    {
                                        this.LX_StopLossOrder_Modify = false;
                                        if ((this.LX1_StopLossOrder_Modify && (this.LX1_StopLossOrder != null)) && (this.LX1_StopLossOrder_Price > this.LX1_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.LX1_StopLossOrder, this.LX1_StopLossOrder.Quantity, 0.0, this.LX1_StopLossOrder_Price);
                                        }
                                        if ((this.LX2_StopLossOrder_Modify && (this.LX2_StopLossOrder != null)) && (this.LX2_StopLossOrder_Price > this.LX2_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.LX2_StopLossOrder, this.LX2_StopLossOrder.Quantity, 0.0, this.LX2_StopLossOrder_Price);
                                        }
                                        if ((this.LX3_StopLossOrder_Modify && (this.LX3_StopLossOrder != null)) && (this.LX3_StopLossOrder_Price > this.LX3_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.LX3_StopLossOrder, this.LX3_StopLossOrder.Quantity, 0.0, this.LX3_StopLossOrder_Price);
                                        }
                                        if ((this.LX4_StopLossOrder_Modify && (this.LX4_StopLossOrder != null)) && (this.LX4_StopLossOrder_Price > this.LX4_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.LX4_StopLossOrder, this.LX4_StopLossOrder.Quantity, 0.0, this.LX4_StopLossOrder_Price);
                                        }
                                    }
                                    else if ((base.Position.MarketPosition == MarketPosition.Short) && this.SX_StopLossOrder_Modify)
                                    {
                                        this.SX_StopLossOrder_Modify = false;
                                        if ((this.SX1_StopLossOrder_Modify && (this.SX1_StopLossOrder != null)) && (this.SX1_StopLossOrder_Price < this.SX1_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.SX1_StopLossOrder, this.SX1_StopLossOrder.Quantity, 0.0, this.SX1_StopLossOrder_Price);
                                        }
                                        if ((this.SX2_StopLossOrder_Modify && (this.SX2_StopLossOrder != null)) && (this.SX2_StopLossOrder_Price < this.SX2_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.SX2_StopLossOrder, this.SX2_StopLossOrder.Quantity, 0.0, this.SX2_StopLossOrder_Price);
                                        }
                                        if ((this.SX3_StopLossOrder_Modify && (this.SX3_StopLossOrder != null)) && (this.SX3_StopLossOrder_Price < this.SX3_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.SX3_StopLossOrder, this.SX3_StopLossOrder.Quantity, 0.0, this.SX3_StopLossOrder_Price);
                                        }
                                        if ((this.SX4_StopLossOrder_Modify && (this.SX4_StopLossOrder != null)) && (this.SX4_StopLossOrder_Price < this.SX4_StopLossOrder.StopPrice))
                                        {
                                            base.ChangeOrder(this.SX4_StopLossOrder, this.SX4_StopLossOrder.Quantity, 0.0, this.SX4_StopLossOrder_Price);
                                        }
                                    }
                                }
                            }
                            this.LastBIP1BarsNum = base.CurrentBar;
                            this.Prev_LongBestProfLossTicks = this.LE_BestProfLossTicks;
                            this.Prev_ShortBestProfLossTicks = this.SE_BestProfLossTicks;
                        }
                        else if ((this.pT4_Filter_On == 1) && (base.BarsInProgress == (this.pOrderBIP + 1)))
                        {
                            bftatBFTiTG4A itga = base.bftatBFTiTG4A(this.pT4_Filter_Period, this.pT4_Filter_Factor);
                            this.mTG4A_Value1 = itga.Value1[0];
                            this.mTG4A_Value2 = itga.Value2[0];
                            if (itga != null)
                            {
                                this.filterTG4A_SignalDir = (int) Math.Round(itga.SignalDir[0]);
                            }
                            else
                            {
                                this.filterTG4A_SignalDir = 0;
                            }
                        }
                        TimeSpan span5 = (TimeSpan) (base.Time[0] - this.LastExit_DateTime);
                        if (span5.TotalSeconds > this.pBetweenTradeSeconds)
                        {
                            if (flag && (base.Position.MarketPosition == MarketPosition.Long))
                            {
                                this.LastExit_DateTime = base.Time[0];
                                if ((((this.LX1_ProfTrgtOrder == null) && (this.LX2_ProfTrgtOrder == null)) && ((this.LX3_ProfTrgtOrder == null) && (this.LX4_ProfTrgtOrder == null))) && (((this.LX1_StopLossOrder == null) && (this.LX2_StopLossOrder == null)) && ((this.LX3_StopLossOrder == null) && (this.LX4_StopLossOrder == null))))
                                {
                                    this.LX1_DynExitOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", this.ConfirmCancelThenExitLabel);
                                }
                                else
                                {
                                    base.CancelAllOrders(false, true);
                                    this.LX_ConfirmCancelThenExit = true;
                                }
                            }
                            else if (flag2 && (base.Position.MarketPosition == MarketPosition.Short))
                            {
                                this.LastExit_DateTime = base.Time[0];
                                if ((((this.SX1_ProfTrgtOrder == null) && (this.SX2_ProfTrgtOrder == null)) && ((this.SX3_ProfTrgtOrder == null) && (this.SX4_ProfTrgtOrder == null))) && (((this.SX1_StopLossOrder == null) && (this.SX2_StopLossOrder == null)) && ((this.SX3_StopLossOrder == null) && (this.SX4_StopLossOrder == null))))
                                {
                                    this.SX1_DynExitOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", this.ConfirmCancelThenExitLabel);
                                }
                                else
                                {
                                    base.CancelAllOrders(false, true);
                                    this.SX_ConfirmCancelThenExit = true;
                                }
                            }
                        }
                    }
                }
                catch (Exception exception2)
                {
                    base.Log(string.Concat(new object[] { "TryCatch Error: Please check your indicator for errors:", base.Time[0], " ", exception2.ToString() }), NinjaTrader.Cbi.LogLevel.Error);
                    base.Print(base.Time[0] + " " + exception2.ToString());
                    string[] strArray2 = exception2.StackTrace.Split(new char[] { '\n' });
                    int index = 0;
                    while (true)
                    {
                        if (index > (strArray2.Length - 1))
                        {
                            break;
                        }
                        string str4 = strArray2[index];
                        base.Log("TraceStack: " + str4, NinjaTrader.Cbi.LogLevel.Error);
                        base.Print("TraceStack: " + str4);
                        index++;
                    }
                    this.TryCatchExceptionCounter++;
                    if (this.TryCatchExceptionCounter >= this.pMaxExceptionsAllowed)
                    {
                        base.Log("OnExecution Max Exceptions Reached:  Strategy Disabled.", NinjaTrader.Cbi.LogLevel.Error);
                        base.Print("OnExecution Max Exceptions Reached:  Strategy Disabled.");
                        base.Disable();
                    }
                }
        }

        protected override void OnExecution(IExecution execution)
        {
            try
            {
                if ((this.LE1_EntryOrder != null) && (this.LE1_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot1_PosQty += execution.Quantity;
                        this.BreakEvenStopStatus = 1;
                        this.gProfTrgt1_Ticks = this.pProfTrgt1_LE_Ticks;
                        if (this.gProfTrgt1_Ticks > 0)
                        {
                            double num = execution.Order.AvgFillPrice + (this.gProfTrgt1_Ticks * base.TickSize);
                            if (this.LX1_ProfTrgtOrder == null)
                            {
                                this.LX1_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Limit, execution.Order.Filled, num, 0.0, this.LX1_OCO_GUID, "LX1P");
                            }
                            else
                            {
                                base.ChangeOrder(this.LX1_ProfTrgtOrder, execution.Order.Filled, num, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double stopPrice = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice - (this.gStopLoss_Ticks * base.TickSize));
                        double limitPrice = stopPrice - (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.LX_StopPrice = stopPrice;
                            this.LX1_LastStopPrice = stopPrice;
                            this.LX_PrevStopPrice = stopPrice;
                            if (this.LX1_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.LX1_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Stop, execution.Order.Filled, 0.0, stopPrice, this.LX1_OCO_GUID, "LX1S");
                                }
                                else
                                {
                                    this.LX1_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.StopLimit, execution.Order.Filled, limitPrice, stopPrice, this.LX1_OCO_GUID, "LX1S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.LX1_StopLossOrder, execution.Order.Filled, 0.0, stopPrice);
                            }
                            else
                            {
                                base.ChangeOrder(this.LX1_StopLossOrder, execution.Order.Filled, limitPrice, stopPrice);
                            }
                        }
                        else
                        {
                            this.LX_PrevStopPrice = double.MinValue;
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LE1_EntryOrder = null;
                        this.LE_EntriesPerDirCount++;
                    }
                }
                else if ((this.LE2_EntryOrder != null) && (this.LE2_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot2_PosQty += execution.Quantity;
                        this.gProfTrgt2_Ticks = this.pProfTrgt2_LE_Ticks;
                        if (this.gProfTrgt2_Ticks > 0)
                        {
                            double num4 = execution.Order.AvgFillPrice + (this.gProfTrgt2_Ticks * base.TickSize);
                            if (this.LX2_ProfTrgtOrder == null)
                            {
                                this.LX2_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Limit, execution.Order.Filled, num4, 0.0, this.LX2_OCO_GUID, "LX2P");
                            }
                            else
                            {
                                base.ChangeOrder(this.LX2_ProfTrgtOrder, execution.Order.Filled, num4, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double num5 = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice - (this.gStopLoss_Ticks * base.TickSize));
                        double num6 = num5 - (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.LX_StopPrice = num5;
                            this.LX2_LastStopPrice = num5;
                            this.LX_PrevStopPrice = num5;
                            if (this.LX2_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.LX2_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Stop, execution.Order.Filled, 0.0, num5, this.LX2_OCO_GUID, "LX2S");
                                }
                                else
                                {
                                    this.LX2_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.StopLimit, execution.Order.Filled, num6, num5, this.LX2_OCO_GUID, "LX2S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.LX2_StopLossOrder, execution.Order.Filled, 0.0, num5);
                            }
                            else
                            {
                                base.ChangeOrder(this.LX2_StopLossOrder, execution.Order.Filled, num6, num5);
                            }
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LE2_EntryOrder = null;
                    }
                }
                else if ((this.LE3_EntryOrder != null) && (this.LE3_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot3_PosQty += execution.Quantity;
                        this.gProfTrgt3_Ticks = this.pProfTrgt3_LE_Ticks;
                        if (this.gProfTrgt3_Ticks > 0)
                        {
                            double num7 = execution.Order.AvgFillPrice + (this.gProfTrgt3_Ticks * base.TickSize);
                            if (this.LX3_ProfTrgtOrder == null)
                            {
                                this.LX3_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Limit, execution.Order.Filled, num7, 0.0, this.LX3_OCO_GUID, "LX3P");
                            }
                            else
                            {
                                base.ChangeOrder(this.LX3_ProfTrgtOrder, execution.Order.Filled, num7, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double num8 = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice - (this.gStopLoss_Ticks * base.TickSize));
                        double num9 = num8 - (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.LX_StopPrice = num8;
                            this.LX3_LastStopPrice = num8;
                            this.LX_PrevStopPrice = num8;
                            if (this.LX3_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.LX3_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Stop, execution.Order.Filled, 0.0, num8, this.LX3_OCO_GUID, "LX3S");
                                }
                                else
                                {
                                    this.LX3_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.StopLimit, execution.Order.Filled, num9, num8, this.LX3_OCO_GUID, "LX3S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.LX3_StopLossOrder, execution.Order.Filled, 0.0, num8);
                            }
                            else
                            {
                                base.ChangeOrder(this.LX3_StopLossOrder, execution.Order.Filled, num9, num8);
                            }
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LE3_EntryOrder = null;
                    }
                }
                else if ((this.LE4_EntryOrder != null) && (this.LE4_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot4_PosQty += execution.Quantity;
                        this.gProfTrgt4_Ticks = this.pProfTrgt4_LE_Ticks;
                        if (this.gProfTrgt4_Ticks > 0)
                        {
                            double num10 = execution.Order.AvgFillPrice + (this.gProfTrgt4_Ticks * base.TickSize);
                            if (this.LX4_ProfTrgtOrder == null)
                            {
                                this.LX4_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Limit, execution.Order.Filled, num10, 0.0, this.LX4_OCO_GUID, "LX4P");
                            }
                            else
                            {
                                base.ChangeOrder(this.LX4_ProfTrgtOrder, execution.Order.Filled, num10, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double num11 = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice - (this.gStopLoss_Ticks * base.TickSize));
                        double num12 = num11 - (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.LX_StopPrice = num11;
                            this.LX4_LastStopPrice = num11;
                            this.LX_PrevStopPrice = num11;
                            if (this.LX4_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.LX4_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Stop, execution.Order.Filled, 0.0, num11, this.LX4_OCO_GUID, "LX4S");
                                }
                                else
                                {
                                    this.LX4_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.StopLimit, execution.Order.Filled, num12, num11, this.LX4_OCO_GUID, "LX4S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.LX4_StopLossOrder, execution.Order.Filled, 0.0, num11);
                            }
                            else
                            {
                                base.ChangeOrder(this.LX4_StopLossOrder, execution.Order.Filled, num12, num11);
                            }
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LE4_EntryOrder = null;
                    }
                }
                else if ((this.SE1_EntryOrder != null) && (this.SE1_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot1_PosQty -= execution.Quantity;
                        this.BreakEvenStopStatus = 1;
                        this.gProfTrgt1_Ticks = this.pProfTrgt1_SE_Ticks;
                        if (this.gProfTrgt1_Ticks > 0)
                        {
                            double num13 = execution.Order.AvgFillPrice - (this.gProfTrgt1_Ticks * base.TickSize);
                            if (this.SX1_ProfTrgtOrder == null)
                            {
                                this.SX1_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Limit, execution.Order.Filled, num13, 0.0, this.SX1_OCO_GUID, "SX1P");
                            }
                            else
                            {
                                base.ChangeOrder(this.SX1_ProfTrgtOrder, execution.Order.Filled, num13, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double num14 = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice + (this.gStopLoss_Ticks * base.TickSize));
                        double num15 = num14 + (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.SX_StopPrice = num14;
                            this.SX1_LastStopPrice = num14;
                            this.SX_PrevStopPrice = num14;
                            if (this.SX1_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.SX1_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Stop, execution.Order.Filled, 0.0, num14, this.SX1_OCO_GUID, "SX1S");
                                }
                                else
                                {
                                    this.SX1_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.StopLimit, execution.Order.Filled, num15, num14, this.SX1_OCO_GUID, "SX1S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.SX1_StopLossOrder, execution.Order.Filled, 0.0, num14);
                            }
                            else
                            {
                                base.ChangeOrder(this.SX1_StopLossOrder, execution.Order.Filled, num15, num14);
                            }
                        }
                        else
                        {
                            this.SX_PrevStopPrice = double.MaxValue;
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SE1_EntryOrder = null;
                        this.SE_EntriesPerDirCount++;
                    }
                }
                else if ((this.SE2_EntryOrder != null) && (this.SE2_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot2_PosQty -= execution.Quantity;
                        this.gProfTrgt2_Ticks = this.pProfTrgt2_SE_Ticks;
                        if (this.gProfTrgt2_Ticks > 0)
                        {
                            double num16 = execution.Order.AvgFillPrice - (this.gProfTrgt2_Ticks * base.TickSize);
                            if (this.SX2_ProfTrgtOrder == null)
                            {
                                this.SX2_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Limit, execution.Order.Filled, num16, 0.0, this.SX2_OCO_GUID, "SX2P");
                            }
                            else
                            {
                                base.ChangeOrder(this.SX2_ProfTrgtOrder, execution.Order.Filled, num16, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double num17 = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice + (this.gStopLoss_Ticks * base.TickSize));
                        double num18 = num17 + (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.SX_StopPrice = num17;
                            this.SX2_LastStopPrice = num17;
                            this.SX_PrevStopPrice = num17;
                            if (this.SX2_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.SX2_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Stop, execution.Order.Filled, 0.0, num17, this.SX2_OCO_GUID, "SX2S");
                                }
                                else
                                {
                                    this.SX2_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.StopLimit, execution.Order.Filled, num18, num17, this.SX2_OCO_GUID, "SX2S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.SX2_StopLossOrder, execution.Order.Filled, 0.0, num17);
                            }
                            else
                            {
                                base.ChangeOrder(this.SX2_StopLossOrder, execution.Order.Filled, num18, num17);
                            }
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SE2_EntryOrder = null;
                    }
                }
                else if ((this.SE3_EntryOrder != null) && (this.SE3_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot4_PosQty -= execution.Quantity;
                        this.gProfTrgt3_Ticks = this.pProfTrgt3_SE_Ticks;
                        if (this.gProfTrgt3_Ticks > 0)
                        {
                            double num19 = execution.Order.AvgFillPrice - (this.gProfTrgt3_Ticks * base.TickSize);
                            if (this.SX3_ProfTrgtOrder == null)
                            {
                                this.SX3_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Limit, execution.Order.Filled, num19, 0.0, this.SX3_OCO_GUID, "SX3P");
                            }
                            else
                            {
                                base.ChangeOrder(this.SX3_ProfTrgtOrder, execution.Order.Filled, num19, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double num20 = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice + (this.gStopLoss_Ticks * base.TickSize));
                        double num21 = num20 + (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.SX_StopPrice = num20;
                            this.SX3_LastStopPrice = num20;
                            this.SX_PrevStopPrice = num20;
                            if (this.SX3_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.SX3_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Stop, execution.Order.Filled, 0.0, num20, this.SX3_OCO_GUID, "SX3S");
                                }
                                else
                                {
                                    this.SX3_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.StopLimit, execution.Order.Filled, num21, num20, this.SX3_OCO_GUID, "SX3S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.SX3_StopLossOrder, execution.Order.Filled, 0.0, num20);
                            }
                            else
                            {
                                base.ChangeOrder(this.SX3_StopLossOrder, execution.Order.Filled, num21, num20);
                            }
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SE3_EntryOrder = null;
                    }
                }
                else if ((this.SE4_EntryOrder != null) && (this.SE4_EntryOrder.Token == execution.Order.Token))
                {
                    if (((execution.Order.OrderState == OrderState.Filled) || (execution.Order.OrderState == OrderState.PartFilled)) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.Lot4_PosQty -= execution.Quantity;
                        this.gProfTrgt4_Ticks = this.pProfTrgt4_SE_Ticks;
                        if (this.gProfTrgt4_Ticks > 0)
                        {
                            double num22 = execution.Order.AvgFillPrice - (this.gProfTrgt4_Ticks * base.TickSize);
                            if (this.SX4_ProfTrgtOrder == null)
                            {
                                this.SX4_ProfTrgtOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Limit, execution.Order.Filled, num22, 0.0, this.SX4_OCO_GUID, "SX4P");
                            }
                            else
                            {
                                base.ChangeOrder(this.SX4_ProfTrgtOrder, execution.Order.Filled, num22, 0.0);
                            }
                            if (!base.Historical)
                            {
                            }
                        }
                        double num23 = base.Bars.Instrument.MasterInstrument.Round2TickSize(execution.Order.AvgFillPrice + (this.gStopLoss_Ticks * base.TickSize));
                        double num24 = num23 + (this.pStopLoss_StopLmtTicks * base.TickSize);
                        if (this.gStopLoss_Ticks > 0)
                        {
                            this.SX_StopPrice = num23;
                            this.SX4_LastStopPrice = num23;
                            this.SX_PrevStopPrice = num23;
                            if (this.SX4_StopLossOrder == null)
                            {
                                if (this.pStopLoss_StopLmtOn == 0)
                                {
                                    this.SX4_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Stop, execution.Order.Filled, 0.0, num23, this.SX4_OCO_GUID, "SX4S");
                                }
                                else
                                {
                                    this.SX4_StopLossOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.StopLimit, execution.Order.Filled, num24, num23, this.SX4_OCO_GUID, "SX4S");
                                }
                            }
                            else if (this.pStopLoss_StopLmtOn == 0)
                            {
                                base.ChangeOrder(this.SX4_StopLossOrder, execution.Order.Filled, 0.0, num23);
                            }
                            else
                            {
                                base.ChangeOrder(this.SX4_StopLossOrder, execution.Order.Filled, num24, num23);
                            }
                        }
                    }
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SE4_EntryOrder = null;
                    }
                }
                else if ((this.LX_ReverseOrder != null) && (this.LX_ReverseOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty = 0;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX_ReverseOrder = null;
                    }
                }
                else if ((this.SX_ReverseOrder != null) && (this.SX_ReverseOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty = 0;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX_ReverseOrder = null;
                    }
                }
                else if ((this.LX1_DynExitOrder != null) && (this.LX1_DynExitOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX1_DynExitOrder = null;
                    }
                }
                else if ((this.SX1_DynExitOrder != null) && (this.SX1_DynExitOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX1_DynExitOrder = null;
                    }
                }
                else if ((this.LX1_ProfTrgtOrder != null) && (this.LX1_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX1_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX2_ProfTrgtOrder != null) && (this.LX2_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot2_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX2_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX3_ProfTrgtOrder != null) && (this.LX3_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot3_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX3_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX4_ProfTrgtOrder != null) && (this.LX4_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot4_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX4_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX1_StopLossOrder != null) && (this.LX1_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX1_StopLossOrder = null;
                    }
                }
                else if ((this.LX2_StopLossOrder != null) && (this.LX2_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot2_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX2_StopLossOrder = null;
                    }
                }
                else if ((this.LX3_StopLossOrder != null) && (this.LX3_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot3_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX3_StopLossOrder = null;
                    }
                }
                else if ((this.LX4_StopLossOrder != null) && (this.LX4_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot4_PosQty -= execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.LX4_StopLossOrder = null;
                    }
                }
                else if ((this.SX1_ProfTrgtOrder != null) && (this.SX1_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX1_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX2_ProfTrgtOrder != null) && (this.SX2_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot2_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX2_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX3_ProfTrgtOrder != null) && (this.SX3_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot4_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX3_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX4_ProfTrgtOrder != null) && (this.SX4_ProfTrgtOrder.Token == execution.Order.Token))
                {
                    this.Lot3_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX4_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX1_StopLossOrder != null) && (this.SX1_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot1_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX1_StopLossOrder = null;
                    }
                }
                else if ((this.SX2_StopLossOrder != null) && (this.SX2_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot2_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX2_StopLossOrder = null;
                    }
                }
                else if ((this.SX3_StopLossOrder != null) && (this.SX3_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot3_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX3_StopLossOrder = null;
                    }
                }
                else if ((this.SX4_StopLossOrder != null) && (this.SX4_StopLossOrder.Token == execution.Order.Token))
                {
                    this.Lot4_PosQty += execution.Quantity;
                    if ((execution.Order.OrderState == OrderState.Filled) || ((execution.Order.OrderState == OrderState.Cancelled) && (execution.Order.Filled > 0)))
                    {
                        this.SX4_StopLossOrder = null;
                    }
                }
            }
            catch (Exception exception)
            {
                base.Log(string.Concat(new object[] { "OnExecution TryCatch Error: Please check your indicator for errors:", base.Time[0], " ", exception.ToString() }), NinjaTrader.Cbi.LogLevel.Error);
                base.Print(base.Time[0] + " " + exception.ToString());
                string[] strArray = exception.StackTrace.Split(new char[] { '\n' });
                for (int i = 0; i <= (strArray.Length - 1); i++)
                {
                    string str = strArray[i];
                    base.Log("TraceStack: " + str, NinjaTrader.Cbi.LogLevel.Error);
                    base.Print("TraceStack: " + str);
                }
            }
        }

        protected override void OnOrderUpdate(IOrder order)
        {
            try
            {
                if ((this.LE1_EntryOrder != null) && (this.LE1_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string message = "LE1_EntryOrder REJECTED.";
                        base.Log(message, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LE1_EntryOrder = null;
                    }
                }
                else if ((this.LE2_EntryOrder != null) && (this.LE2_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str2 = "LE2_EntryOrder REJECTED.";
                        base.Log(str2, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LE2_EntryOrder = null;
                    }
                }
                else if ((this.LE3_EntryOrder != null) && (this.LE3_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str3 = "LE3_EntryOrder REJECTED.";
                        base.Log(str3, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LE3_EntryOrder = null;
                    }
                }
                else if ((this.LE4_EntryOrder != null) && (this.LE4_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str4 = "LE4_EntryOrder REJECTED.";
                        base.Log(str4, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LE4_EntryOrder = null;
                    }
                }
                else if ((this.LX1_ProfTrgtOrder != null) && (this.LX1_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str5 = "LX1 ProfTrgt Order REJECTED. Exit Long @ Market.";
                        base.Log(str5, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX1_ProfTrgtOrderCancelled = true;
                        this.LX1_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX2_ProfTrgtOrder != null) && (this.LX2_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str6 = "LX2 ProfTrgt Order REJECTED. Exit Long @ Market.";
                        base.Log(str6, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX2_ProfTrgtOrderCancelled = true;
                        this.LX2_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX3_ProfTrgtOrder != null) && (this.LX3_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str7 = "LX3 ProfTrgt Order REJECTED. Exit Long @ Market.";
                        base.Log(str7, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX3_ProfTrgtOrderCancelled = true;
                        this.LX3_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX4_ProfTrgtOrder != null) && (this.LX4_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str8 = "LX4 ProfTrgt Order REJECTED. Exit Long @ Market.";
                        base.Log(str8, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX4_ProfTrgtOrderCancelled = true;
                        this.LX4_ProfTrgtOrder = null;
                    }
                }
                else if ((this.LX1_StopLossOrder != null) && (this.LX1_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str9 = "LX1 StopLoss Order REJECTED. Exit Long @ Market.";
                        base.Log(str9, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX1_StopLossOrderCancelled = true;
                        this.LX1_StopLossOrder = null;
                    }
                }
                else if ((this.LX2_StopLossOrder != null) && (this.LX2_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str10 = "LX2 StopLoss Order REJECTED. Exit Long @ Market.";
                        base.Log(str10, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX2_StopLossOrderCancelled = true;
                        this.LX2_StopLossOrder = null;
                    }
                }
                else if ((this.LX3_StopLossOrder != null) && (this.LX3_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str11 = "LX3 StopLoss Order REJECTED. Exit Long @ Market.";
                        base.Log(str11, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX3_StopLossOrderCancelled = true;
                        this.LX3_StopLossOrder = null;
                    }
                }
                else if ((this.LX4_StopLossOrder != null) && (this.LX4_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str12 = "LX4 StopLoss Order REJECTED. Exit Long @ Market.";
                        base.Log(str12, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.LX4_StopLossOrderCancelled = true;
                        this.LX4_StopLossOrder = null;
                    }
                }
                else if ((this.SE1_EntryOrder != null) && (this.SE1_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str13 = "SE1_SellStopOrder REJECTED.";
                        base.Log(str13, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SE1_EntryOrder = null;
                    }
                }
                else if ((this.SE2_EntryOrder != null) && (this.SE2_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str14 = "SE2_SellStopOrder REJECTED.";
                        base.Log(str14, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SE2_EntryOrder = null;
                    }
                }
                else if ((this.SE3_EntryOrder != null) && (this.SE3_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str15 = "SE3_SellStopOrder REJECTED.";
                        base.Log(str15, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SE3_EntryOrder = null;
                    }
                }
                else if ((this.SE4_EntryOrder != null) && (this.SE4_EntryOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str16 = "SE4_SellStopOrder REJECTED.";
                        base.Log(str16, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SE4_EntryOrder = null;
                    }
                }
                else if ((this.SX1_ProfTrgtOrder != null) && (this.SX1_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str17 = "SX1 ProfTrgt Order REJECTED. ExitShort @ Market.";
                        base.Log(str17, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX1_ProfTrgtOrderCancelled = true;
                        this.SX1_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX2_ProfTrgtOrder != null) && (this.SX2_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str18 = "SX2 ProfTrgt Order REJECTED. ExitShort @ Market.";
                        base.Log(str18, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX2_ProfTrgtOrderCancelled = true;
                        this.SX2_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX3_ProfTrgtOrder != null) && (this.SX3_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str19 = "SX3 ProfTrgt Order REJECTED. ExitShort @ Market.";
                        base.Log(str19, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX3_ProfTrgtOrderCancelled = true;
                        this.SX3_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX4_ProfTrgtOrder != null) && (this.SX4_ProfTrgtOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str20 = "SX4 ProfTrgt Order REJECTED. ExitShort @ Market.";
                        base.Log(str20, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX4_ProfTrgtOrderCancelled = true;
                        this.SX4_ProfTrgtOrder = null;
                    }
                }
                else if ((this.SX1_StopLossOrder != null) && (this.SX1_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str21 = "SX_StopLossOrder REJECTED. Exit Short @ Market.";
                        base.Log(str21, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX1_StopLossOrderCancelled = true;
                        this.SX1_StopLossOrder = null;
                    }
                }
                else if ((this.SX2_StopLossOrder != null) && (this.SX2_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str22 = "SX_StopLossOrder REJECTED. Exit Short @ Market.";
                        base.Log(str22, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX2_StopLossOrderCancelled = true;
                        this.SX2_StopLossOrder = null;
                    }
                }
                else if ((this.SX3_StopLossOrder != null) && (this.SX3_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str23 = "SX_StopLossOrder REJECTED. Exit Short @ Market.";
                        base.Log(str23, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX3_StopLossOrderCancelled = true;
                        this.SX3_StopLossOrder = null;
                    }
                }
                else if ((this.SX4_StopLossOrder != null) && (this.SX4_StopLossOrder.Token == order.Token))
                {
                    if (order.OrderState == OrderState.Rejected)
                    {
                        string str24 = "SX_StopLossOrder REJECTED. Exit Short @ Market.";
                        base.Log(str24, NinjaTrader.Cbi.LogLevel.Warning);
                    }
                    if (order.OrderState == OrderState.Cancelled)
                    {
                        this.SX4_StopLossOrderCancelled = true;
                        this.SX4_StopLossOrder = null;
                    }
                }
                if (this.LX_ConfirmCancelThenExit)
                {
                    bool flag = (this.LX1_ProfTrgtOrder == null) || this.LX1_ProfTrgtOrderCancelled;
                    bool flag2 = (this.LX2_ProfTrgtOrder == null) || this.LX2_ProfTrgtOrderCancelled;
                    bool flag3 = (this.LX3_ProfTrgtOrder == null) || this.LX3_ProfTrgtOrderCancelled;
                    bool flag4 = (this.LX4_ProfTrgtOrder == null) || this.LX4_ProfTrgtOrderCancelled;
                    bool flag5 = (this.LX1_StopLossOrder == null) || this.LX1_StopLossOrderCancelled;
                    bool flag6 = (this.LX2_StopLossOrder == null) || this.LX2_StopLossOrderCancelled;
                    bool flag7 = (this.LX3_StopLossOrder == null) || this.LX3_StopLossOrderCancelled;
                    bool flag8 = (this.LX4_StopLossOrder == null) || this.LX4_StopLossOrderCancelled;
                    if (((flag && flag5) && (flag2 && flag6)) && ((flag3 && flag7) && (flag4 && flag8)))
                    {
                        this.LX_ConfirmCancelThenExit = false;
                        this.LX1_DynExitOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", this.ConfirmCancelThenExitLabel);
                        if (this.LX1_DynExitOrder != null)
                        {
                            this.LX1_ProfTrgtOrderCancelled = false;
                            this.LX2_ProfTrgtOrderCancelled = false;
                            this.LX3_ProfTrgtOrderCancelled = false;
                            this.LX4_ProfTrgtOrderCancelled = false;
                            this.LX1_StopLossOrderCancelled = false;
                            this.LX2_StopLossOrderCancelled = false;
                            this.LX3_StopLossOrderCancelled = false;
                            this.LX4_StopLossOrderCancelled = false;
                        }
                    }
                }
                if (this.SX_ConfirmCancelThenExit)
                {
                    bool flag9 = (this.SX1_ProfTrgtOrder == null) || this.SX1_ProfTrgtOrderCancelled;
                    bool flag10 = (this.SX2_ProfTrgtOrder == null) || this.SX2_ProfTrgtOrderCancelled;
                    bool flag11 = (this.SX3_ProfTrgtOrder == null) || this.SX3_ProfTrgtOrderCancelled;
                    bool flag12 = (this.SX4_ProfTrgtOrder == null) || this.SX4_ProfTrgtOrderCancelled;
                    bool flag13 = (this.SX1_StopLossOrder == null) || this.SX1_StopLossOrderCancelled;
                    bool flag14 = (this.SX2_StopLossOrder == null) || this.SX2_StopLossOrderCancelled;
                    bool flag15 = (this.SX3_StopLossOrder == null) || this.SX3_StopLossOrderCancelled;
                    bool flag16 = (this.SX4_StopLossOrder == null) || this.SX4_StopLossOrderCancelled;
                    if (((flag9 && flag13) && (flag10 && flag14)) && ((flag11 && flag15) && (flag12 && flag16)))
                    {
                        this.SX_ConfirmCancelThenExit = false;
                        this.SX1_DynExitOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", this.ConfirmCancelThenExitLabel);
                        if (this.SX1_DynExitOrder != null)
                        {
                            this.SX1_ProfTrgtOrderCancelled = false;
                            this.SX2_ProfTrgtOrderCancelled = false;
                            this.SX3_ProfTrgtOrderCancelled = false;
                            this.SX4_ProfTrgtOrderCancelled = false;
                            this.SX1_StopLossOrderCancelled = false;
                            this.SX2_StopLossOrderCancelled = false;
                            this.SX3_StopLossOrderCancelled = false;
                            this.SX4_StopLossOrderCancelled = false;
                        }
                    }
                }
                if ((((this.LE_ConfirmCancelThenPlaceReverseOrder && ((this.SX1_ProfTrgtOrder == null) || this.SX1_ProfTrgtOrderCancelled)) && ((this.SX2_ProfTrgtOrder == null) || this.SX2_ProfTrgtOrderCancelled)) && (((this.SX3_ProfTrgtOrder == null) || this.SX3_ProfTrgtOrderCancelled) && ((this.SX4_ProfTrgtOrder == null) || this.SX4_ProfTrgtOrderCancelled))) && ((((this.SX1_StopLossOrder == null) || this.SX1_StopLossOrderCancelled) && ((this.SX2_StopLossOrder == null) || this.SX2_StopLossOrderCancelled)) && (((this.SX3_StopLossOrder == null) || this.SX3_StopLossOrderCancelled) && ((this.SX4_StopLossOrder == null) || this.SX4_StopLossOrderCancelled))))
                {
                    this.SX1_ProfTrgtOrderCancelled = false;
                    this.SX2_ProfTrgtOrderCancelled = false;
                    this.SX3_ProfTrgtOrderCancelled = false;
                    this.SX4_ProfTrgtOrderCancelled = false;
                    this.SX1_StopLossOrderCancelled = false;
                    this.SX2_StopLossOrderCancelled = false;
                    this.SX3_StopLossOrderCancelled = false;
                    this.SX4_StopLossOrderCancelled = false;
                    if ((base.Position.MarketPosition == MarketPosition.Short) && (base.Position.Quantity > 0))
                    {
                        this.SX_ReverseOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.BuyToCover, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", "SX_Rev");
                    }
                    if ((this.pEntry_Order_Type == bftatBigfootV5bDev_OrderType.Limit) && (this.LE_EntrySetup_OrderPrice > 0.0))
                    {
                        this.PlaceEntryOrder(1, bftatBigfootV5bDev_OrderType.Limit, this.LE_EntrySetup_OrderPrice, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                    }
                    else
                    {
                        this.PlaceEntryOrder(1, bftatBigfootV5bDev_OrderType.Market, this.LE_EntrySetup_OrderPrice, this.gLE_StopMkt_StopPrice, this.gLE_StopLmt_StopPrice, this.gLE_StopLmt_LimitPrice, base.Closes[0][0], this.EntryOrderSuffix);
                    }
                    this.LE_ConfirmCancelThenPlaceReverseOrder = false;
                }
                if ((((this.SE_ConfirmCancelThenPlaceReverseOrder && ((this.LX1_ProfTrgtOrder == null) || this.LX1_ProfTrgtOrderCancelled)) && ((this.LX2_ProfTrgtOrder == null) || this.LX2_ProfTrgtOrderCancelled)) && (((this.LX3_ProfTrgtOrder == null) || this.LX3_ProfTrgtOrderCancelled) && ((this.LX4_ProfTrgtOrder == null) || this.LX4_ProfTrgtOrderCancelled))) && ((((this.LX1_StopLossOrder == null) || this.LX1_StopLossOrderCancelled) && ((this.LX2_StopLossOrder == null) || this.LX2_StopLossOrderCancelled)) && (((this.LX3_StopLossOrder == null) || this.LX3_StopLossOrderCancelled) && ((this.LX4_StopLossOrder == null) || this.LX4_StopLossOrderCancelled))))
                {
                    this.LX1_ProfTrgtOrderCancelled = false;
                    this.LX2_ProfTrgtOrderCancelled = false;
                    this.LX3_ProfTrgtOrderCancelled = false;
                    this.LX4_ProfTrgtOrderCancelled = false;
                    this.LX1_StopLossOrderCancelled = false;
                    this.LX2_StopLossOrderCancelled = false;
                    this.LX3_StopLossOrderCancelled = false;
                    this.LX4_StopLossOrderCancelled = false;
                    if ((base.Position.MarketPosition == MarketPosition.Long) && (base.Position.Quantity > 0))
                    {
                        this.LX_ReverseOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Sell, OrderType.Market, base.Position.Quantity, 0.0, 0.0, "", "LX_Rev");
                    }
                    if ((this.pEntry_Order_Type == bftatBigfootV5bDev_OrderType.Limit) && (this.SE_EntrySetup_OrderPrice > 0.0))
                    {
                        this.PlaceEntryOrder(-1, bftatBigfootV5bDev_OrderType.Limit, this.SE_EntrySetup_OrderPrice, 0.0, 0.0, 0.0, 0.0, this.EntryOrderSuffix);
                    }
                    else
                    {
                        this.PlaceEntryOrder(-1, bftatBigfootV5bDev_OrderType.Market, this.SE_EntrySetup_OrderPrice, this.gSE_StopMkt_StopPrice, this.gSE_StopLmt_StopPrice, this.gSE_StopLmt_LimitPrice, base.Closes[0][0], this.EntryOrderSuffix);
                    }
                    this.SE_ConfirmCancelThenPlaceReverseOrder = false;
                }
            }
            catch (Exception exception)
            {
                base.Log(string.Concat(new object[] { "OnExecution TryCatch Error: Please check your indicator for errors:", base.Time[0], " ", exception.ToString() }), NinjaTrader.Cbi.LogLevel.Error);
                base.Print(base.Time[0] + " " + exception.ToString());
                string[] strArray = exception.StackTrace.Split(new char[] { '\n' });
                for (int i = 0; i <= (strArray.Length - 1); i++)
                {
                    string str25 = strArray[i];
                    base.Log("TraceStack: " + str25, NinjaTrader.Cbi.LogLevel.Error);
                    base.Print("TraceStack: " + str25);
                }
            }
        }

        protected override void OnPositionUpdate(IPosition position)
        {
            base.DrawTextFixed("MyTag", position.ToString(), TextPosition.BottomLeft);
            if (base.Position.MarketPosition == MarketPosition.Flat)
            {
                this.LE_EntrySetup_Status = 0;
                this.SE_EntrySetup_Status = 0;
                this.HaltStopLossModProcess = false;
                this.OneEntryPerBarOkayToTrade = true;
                this.LE_EntriesPerDirCount = 0;
                this.SE_EntriesPerDirCount = 0;
                this.LE_BestProfLossTicks = 0.0;
                this.SE_BestProfLossTicks = 0.0;
            }
        }

        protected override void OnStartUp()
        {
            try
            {
                this.Backtest_OpMode = this.pOperatingMode == bftatBigfootV5bDev_OpMode.Backtest;
                this.Realtime_OpMode = this.pOperatingMode == bftatBigfootV5bDev_OpMode.Realtime;
                if (this.pBtn_Buttons_On && this.Realtime_OpMode)
                {
                    this.mySCB = base.bftatBFTiSCBV1a(this.pBtn_ButtonsXPixels, this.pBtn_ButtonsYPixels);
                    if (this.mySCB != null)
                    {
                        this.mySCB.CalculateOnBarClose = false;
                    }
                }
                if (this.mEntryTG2A_TR == null)
                {
                    this.mEntryTG2A_TR = base.bftatBFTiTG2A(this.pT2_TR_Entry_Period, this.pT2_TR_Entry_Factor);
                }
                if (this.mEntryTG2A_CT == null)
                {
                    this.mEntryTG2A_CT = base.bftatBFTiTG2A(this.pT2_CT_Entry_Period, this.pT2_CT_Entry_Factor);
                }
                if (this.mExitTG2A == null)
                {
                    this.mExitTG2A = base.bftatBFTiTG2A(this.pT2_Exit_Period, this.pT2_Exit_Factor);
                }
                if (this.mEntryEMA == null)
                {
                    this.mEntryEMA = base.EMA(this.pEMA_Entry_Period);
                }
                if (this.mDiverScout == null)
                {
                    this.mDiverScout = base.bftatBFTiDiverScout(this.pDiverScout_Period, this.pDiverScout_ScanWidth, this.pDiverScout_Smooth);
                }
                this.EntryOrderTypeIsWorkingOrder = this.pEntry_Order_Type != bftatBigfootV5bDev_OrderType.Market;
                this.gEntry1_Qty = this.pEntry1_Qty;
                this.gEntry2_Qty = this.pEntry2_Qty;
                this.gEntry3_Qty = this.pEntry3_Qty;
                this.gEntry4_Qty = this.pEntry4_Qty;
                this.gStopLoss_Ticks = this.pStopLoss_Ticks;
            }
            catch (Exception exception)
            {
                base.Log(string.Concat(new object[] { "TryCatch Error: Please check your indicator for errors:", base.Time[0], " ", exception.ToString() }), NinjaTrader.Cbi.LogLevel.Error);
                base.Print(base.Time[0] + " " + exception.ToString());
                string[] strArray = exception.StackTrace.Split(new char[] { '\n' });
                for (int i = 0; i <= (strArray.Length - 1); i++)
                {
                    string str = strArray[i];
                    base.Log("TraceStack: " + str, NinjaTrader.Cbi.LogLevel.Error);
                    base.Print("TraceStack: " + str);
                }
            }            
        }

        protected override void OnTermination()
        {
        }

        private void PlaceEntryOrder(int entryDirection, bftatBigfootV5bDev_OrderType entryOrderType, double entryLimitOrderPrice, double entryStopMktStopOrderPrice, double entryStopLmtStopOrderPrice, double entryStopLmtLimitOrderPrice, double slippageBasisPrice, string suffix)
        {
            try
            {
                this.LastEntry_DateTime = base.Time[0];
                if (entryDirection > 0)
                {
                    this.Prev_LongBestProfLossTicks = 0.0;
                    int quantity = this.gEntry1_Qty;
                    int num2 = this.gEntry2_Qty;
                    int num3 = this.gEntry3_Qty;
                    int num4 = this.gEntry4_Qty;
                    this.LX1_OCO_GUID = Guid.NewGuid().ToString();
                    this.LX2_OCO_GUID = Guid.NewGuid().ToString();
                    this.LX3_OCO_GUID = Guid.NewGuid().ToString();
                    this.LX4_OCO_GUID = Guid.NewGuid().ToString();
                    if (entryOrderType == bftatBigfootV5bDev_OrderType.Limit)
                    {
                        if (this.LE1_EntryOrder != null)
                        {
                            base.ChangeOrder(this.LE1_EntryOrder, this.LE1_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (quantity > 0)
                        {
                            this.LE1_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Limit, quantity, entryLimitOrderPrice, 0.0, "", "LE1" + suffix);
                        }
                        if (this.LE2_EntryOrder != null)
                        {
                            base.ChangeOrder(this.LE2_EntryOrder, this.LE2_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (num2 > 0)
                        {
                            this.LE2_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Limit, num2, entryLimitOrderPrice, 0.0, "", "LE2" + suffix);
                        }
                        if (this.LE3_EntryOrder != null)
                        {
                            base.ChangeOrder(this.LE3_EntryOrder, this.LE3_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (num3 > 0)
                        {
                            this.LE3_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Limit, num3, entryLimitOrderPrice, 0.0, "", "LE3" + suffix);
                        }
                        if (this.LE4_EntryOrder != null)
                        {
                            base.ChangeOrder(this.LE4_EntryOrder, this.LE4_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (num4 > 0)
                        {
                            this.LE4_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Limit, num4, entryLimitOrderPrice, 0.0, "", "LE4" + suffix);
                        }
                    }
                    else
                    {
                        if (quantity > 0)
                        {
                            this.LE1_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Market, quantity, 0.0, 0.0, "", "LE1" + suffix);
                        }
                        if (num2 > 0)
                        {
                            this.LE2_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Market, num2, 0.0, 0.0, "", "LE2" + suffix);
                        }
                        if (num3 > 0)
                        {
                            this.LE3_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Market, num3, 0.0, 0.0, "", "LE3" + suffix);
                        }
                        if (num4 > 0)
                        {
                            this.LE4_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.Buy, OrderType.Market, num4, 0.0, 0.0, "", "LE4" + suffix);
                        }
                    }
                    this.LX_ExitPositionNextReverse = false;
                    this.LE_EntryBarsNum = base.CurrentBars[0];
                }
                else if (entryDirection < 0)
                {
                    this.Prev_ShortBestProfLossTicks = 0.0;
                    int num5 = this.gEntry1_Qty;
                    int num6 = this.gEntry2_Qty;
                    int num7 = this.gEntry3_Qty;
                    int num8 = this.gEntry4_Qty;
                    this.SX1_OCO_GUID = Guid.NewGuid().ToString();
                    this.SX2_OCO_GUID = Guid.NewGuid().ToString();
                    this.SX3_OCO_GUID = Guid.NewGuid().ToString();
                    this.SX4_OCO_GUID = Guid.NewGuid().ToString();
                    if (entryOrderType == bftatBigfootV5bDev_OrderType.Limit)
                    {
                        if (this.SE1_EntryOrder != null)
                        {
                            base.ChangeOrder(this.SE1_EntryOrder, this.SE1_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (num5 > 0)
                        {
                            this.SE1_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Limit, num5, entryLimitOrderPrice, 0.0, "", "SE1" + suffix);
                        }
                        if (this.SE2_EntryOrder != null)
                        {
                            base.ChangeOrder(this.SE2_EntryOrder, this.SE2_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (num6 > 0)
                        {
                            this.SE2_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Limit, num6, entryLimitOrderPrice, 0.0, "", "SE2" + suffix);
                        }
                        if (this.SE3_EntryOrder != null)
                        {
                            base.ChangeOrder(this.SE3_EntryOrder, this.SE3_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (num7 > 0)
                        {
                            this.SE3_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Limit, num7, entryLimitOrderPrice, 0.0, "", "SE3" + suffix);
                        }
                        if (this.SE4_EntryOrder != null)
                        {
                            base.ChangeOrder(this.SE4_EntryOrder, this.SE4_EntryOrder.Quantity, entryLimitOrderPrice, 0.0);
                        }
                        else if (num8 > 0)
                        {
                            this.SE4_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Limit, num8, entryLimitOrderPrice, 0.0, "", "SE4" + suffix);
                        }
                    }
                    else
                    {
                        if (num5 > 0)
                        {
                            this.SE1_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Market, num5, 0.0, 0.0, "", "SE1" + suffix);
                        }
                        if (num6 > 0)
                        {
                            this.SE2_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Market, num6, 0.0, 0.0, "", "SE2" + suffix);
                        }
                        if (num7 > 0)
                        {
                            this.SE3_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Market, num7, 0.0, 0.0, "", "SE3" + suffix);
                        }
                        if (num8 > 0)
                        {
                            this.SE4_EntryOrder = base.SubmitOrder(this.pOrderBIP, OrderAction.SellShort, OrderType.Market, num8, 0.0, 0.0, "", "SE4" + suffix);
                        }
                    }
                    this.SX_ExitPositionNextReverse = false;
                    this.SE_EntryBarsNum = base.CurrentBars[0];
                }
            }
            catch (Exception exception)
            {
                base.Log(string.Concat(new object[] { "OnExecution TryCatch Error: Please check your indicator for errors:", base.Time[0], " ", exception.ToString() }), NinjaTrader.Cbi.LogLevel.Error);
                base.Print(base.Time[0] + " " + exception.ToString());
                string[] strArray = exception.StackTrace.Split(new char[] { '\n' });
                for (int i = 0; i <= (strArray.Length - 1); i++)
                {
                    string str = strArray[i];
                    base.Log("TraceStack: " + str, NinjaTrader.Cbi.LogLevel.Error);
                    base.Print("TraceStack: " + str);
                }
            }
        }

        private void PrintAuditLine(int Level, string AuditLineText)
        {
        }

        public override string ToString()
        {
            return this.pStrategyName;
        }

        [NinjaTrader.Gui.Design.DisplayName("p07_DisplayPnlTradeCount"), GridCategory("G15 - Utility"), Description("")]
        public bool DisplayProfitLoss
        {
            get
            {
                return this.displayProfitLoss;
            }
            set
            {
                this.displayProfitLoss = value;
            }
        }

        [Browsable(false)]
        public string EOW_Exit_TimeS
        {
            get
            {
                return this.ppEOW_Exit_Time.ToString();
            }
            set
            {
                this.ppEOW_Exit_Time = TimeSpan.Parse(value);
            }
        }

        [Description(""), NinjaTrader.Gui.Design.DisplayName("p08_Display Font Size"), GridCategory("G15 - Utility")]
        public int Fontsize
        {
            get
            {
                return this.fontsize;
            }
            set
            {
                this.fontsize = Math.Max(8, value);
            }
        }

        [Browsable(false), XmlIgnore]
        public bool LastBarOnChart
        {
            get
            {
                return ((!this.CalculateOnBarClose && (base.CurrentBar == (base.Bars.Count - 1))) || (this.CalculateOnBarClose && (base.CurrentBar == (base.Bars.Count - 2))));
            }
        }

        [Description("Alert_On"), NinjaTrader.Gui.Design.DisplayName("p02_Alert_Buy_Wav"), GridCategory("G13 - Alerts")]
        public string pAlert_Buy_Wav
        {
            get
            {
                return this.ppAlert_Buy_Wav;
            }
            set
            {
                this.ppAlert_Buy_Wav = value;
            }
        }

        [Description("Alert_On"), GridCategory("G13 - Alerts"), NinjaTrader.Gui.Design.DisplayName("p01_Alert_On")]
        public bool pAlert_On
        {
            get
            {
                return this.ppAlert_On;
            }
            set
            {
                this.ppAlert_On = value;
            }
        }

        [Description("Alert_On"), GridCategory("G13 - Alerts"), NinjaTrader.Gui.Design.DisplayName("p03_Alert_Sell_Wav")]
        public string pAlert_Sell_Wav
        {
            get
            {
                return this.ppAlert_Sell_Wav;
            }
            set
            {
                this.ppAlert_Sell_Wav = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p03_AuditMode_On\t"), GridCategory("G15 - Utility"), Description("AuditMode_On\t(1=On, 0=Off)")]
        public bool pAuditMode_On
        {
            get
            {
                return this.ppAuditMode_On;
            }
            set
            {
                this.ppAuditMode_On = value;
            }
        }

        [GridCategory("G15 - Utility"), NinjaTrader.Gui.Design.DisplayName("p04_AuditRpt_On"), Description("AuditRpt_On - used for debugging (1=On, 0=Off)")]
        public bool pAuditRpt_On
        {
            get
            {
                return this.ppAuditRpt_On;
            }
            set
            {
                this.ppAuditRpt_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p05_BetweenTradeSeconds"), Description("BetweenTradeSeconds."), GridCategory("G10 - Entry Quantity")]
        public int pBetweenTradeSeconds
        {
            get
            {
                return this.ppBetweenTradeSeconds;
            }
            set
            {
                this.ppBetweenTradeSeconds = Math.Max(10, value);
            }
        }

        [GridCategory("G11 - Targets & Stops"), NinjaTrader.Gui.Design.DisplayName("p10_BreakEven_On"), Description("BreakEven_On (1=On, 0=Off)")]
        public int pBreakEven_On
        {
            get
            {
                return this.ppBreakEven_On;
            }
            set
            {
                this.ppBreakEven_On = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p12_BreakEven_PlusTicks"), GridCategory("G11 - Targets & Stops"), Description("BreakEven_PlusTicks (+/- ticks from average fill) ")]
        public int pBreakEven_PlusTicks
        {
            get
            {
                return this.ppBreakEven_PlusTicks;
            }
            set
            {
                this.ppBreakEven_PlusTicks = value;
            }
        }

        [GridCategory("G11 - Targets & Stops"), Description("BreakEven_TrigTicks (from average fill)"), NinjaTrader.Gui.Design.DisplayName("p11_BreakEven_TrigTicks")]
        public int pBreakEven_TrigTicks
        {
            get
            {
                return this.ppBreakEven_TrigTicks;
            }
            set
            {
                this.ppBreakEven_TrigTicks = Math.Max(0, value);
            }
        }

        [Description("Btn_Buttons_On (Activates/deactivates button array)"), GridCategory("G14 - Button Presets"), NinjaTrader.Gui.Design.DisplayName("p01_Btn_Buttons_On")]
        public bool pBtn_Buttons_On
        {
            get
            {
                return this.ppBtn_Buttons_On;
            }
            set
            {
                this.ppBtn_Buttons_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p02_Btn_ButtonsXPixels"), Description("Btn_ButtonsXPixels"), GridCategory("G14 - Button Presets")]
        public int pBtn_ButtonsXPixels
        {
            get
            {
                return this.ppBtn_ButtonsXPixels;
            }
            set
            {
                this.ppBtn_ButtonsXPixels = Math.Max(0, value);
            }
        }

        [Description("Btn_ButtonsYPixels"), GridCategory("G14 - Button Presets"), NinjaTrader.Gui.Design.DisplayName("p03_Btn_ButtonsYPixels")]
        public int pBtn_ButtonsYPixels
        {
            get
            {
                return this.ppBtn_ButtonsYPixels;
            }
            set
            {
                this.ppBtn_ButtonsYPixels = Math.Max(0, value);
            }
        }

        [GridCategory("G14 - Button Presets"), Description("Btn_BuyMkt_On (Activates/deactivates button)"), NinjaTrader.Gui.Design.DisplayName("p08_Btn_BuyMkt_On")]
        public bool pBtn_BuyMkt_On
        {
            get
            {
                return this.ppBtn_BuyMkt_On;
            }
            set
            {
                this.ppBtn_BuyMkt_On = value;
            }
        }

        [GridCategory("G14 - Button Presets"), NinjaTrader.Gui.Design.DisplayName("p10_Btn_ClosePos_On"), Description("Btn_ClosePos_On (Activates/deactivates button)")]
        public bool pBtn_ClosePos_On
        {
            get
            {
                return this.ppBtn_ClosePos_On;
            }
            set
            {
                this.ppBtn_ClosePos_On = value;
            }
        }

        [Description("Btn_CT_On (Activates/deactivates button)"), NinjaTrader.Gui.Design.DisplayName("p07_Btn_CT_On"), GridCategory("G14 - Button Presets")]
        public bool pBtn_CT_On
        {
            get
            {
                return this.ppBtn_CT_On;
            }
            set
            {
                this.ppBtn_CT_On = value;
            }
        }

        [Description("Btn_Long_On (Activates/deactivates button)"), NinjaTrader.Gui.Design.DisplayName("p05_Btn_Long_On"), GridCategory("G14 - Button Presets")]
        public bool pBtn_Long_On
        {
            get
            {
                return this.ppBtn_Long_On;
            }
            set
            {
                this.ppBtn_Long_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p09_Btn_SellMkt_On"), GridCategory("G14 - Button Presets"), Description("Btn_SellMkt_On (Activates/deactivates button)")]
        public bool pBtn_SellMkt_On
        {
            get
            {
                return this.ppBtn_SellMkt_On;
            }
            set
            {
                this.ppBtn_SellMkt_On = value;
            }
        }

        [Description("Btn_Short_On (Activates/deactivates button)"), GridCategory("G14 - Button Presets"), NinjaTrader.Gui.Design.DisplayName("p06_Btn_Short_On")]
        public bool pBtn_Short_On
        {
            get
            {
                return this.ppBtn_Short_On;
            }
            set
            {
                this.ppBtn_Short_On = value;
            }
        }

        [Description("Btn_Strategy_On (Activates/deactivates strategy)"), NinjaTrader.Gui.Design.DisplayName("p04_Btn_Strategy_On"), GridCategory("G14 - Button Presets")]
        public bool pBtn_Strategy_On
        {
            get
            {
                return this.ppBtn_Strategy_On;
            }
            set
            {
                this.ppBtn_Strategy_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p02_DailyMaxGain_Amt"), GridCategory("G12 - Equity Trading Halts"), Description("DailyMaxGain_Amt")]
        public int pDailyMaxGain_Amt
        {
            get
            {
                return this.ppDailyMaxGain_Amt;
            }
            set
            {
                this.ppDailyMaxGain_Amt = Math.Max(0, value);
            }
        }

        [GridCategory("G12 - Equity Trading Halts"), NinjaTrader.Gui.Design.DisplayName("p01_DailyMaxGain_On"), Description("DailyMaxGain_On")]
        public bool pDailyMaxGain_On
        {
            get
            {
                return this.ppDailyMaxGain_On;
            }
            set
            {
                this.ppDailyMaxGain_On = value;
            }
        }

        [GridCategory("G12 - Equity Trading Halts"), Description("DailyMaxLoss_Amt"), NinjaTrader.Gui.Design.DisplayName("p04_DailyMaxLoss_Amt")]
        public int pDailyMaxLoss_Amt
        {
            get
            {
                return this.ppDailyMaxLoss_Amt;
            }
            set
            {
                this.ppDailyMaxLoss_Amt = Math.Max(0, value);
            }
        }

        [GridCategory("G12 - Equity Trading Halts"), NinjaTrader.Gui.Design.DisplayName("p03_DailyMaxLoss_On"), Description("DailyMaxLoss_On")]
        public bool pDailyMaxLoss_On
        {
            get
            {
                return this.ppDailyMaxLoss_On;
            }
            set
            {
                this.ppDailyMaxLoss_On = value;
            }
        }

        [Description("DiverScout_Bars"), GridCategory("G01 - Entry Setup"), NinjaTrader.Gui.Design.DisplayName("p03_DiverScout_Bars")]
        public int pDiverScout_Bars
        {
            get
            {
                return this.ppDiverScout_Bars;
            }
            set
            {
                this.ppDiverScout_Bars = Math.Max(0, value);
            }
        }

        [Description("DiverScout_MCFilter_On"), GridCategory("G01 - Entry Setup"), NinjaTrader.Gui.Design.DisplayName("p02_DiverScout_MCFilter_On")]
        public int pDiverScout_MCFilter_On
        {
            get
            {
                return this.ppDiverScout_MCFilter_On;
            }
            set
            {
                this.ppDiverScout_MCFilter_On = Math.Max(0, value);
            }
        }

        [GridCategory("G01 - Entry Setup"), NinjaTrader.Gui.Design.DisplayName("p05_DiverScout_Period"), Description("DiverScout_Period")]
        public int pDiverScout_Period
        {
            get
            {
                return this.ppDiverScout_Period;
            }
            set
            {
                this.ppDiverScout_Period = Math.Max(0, value);
            }
        }

        [GridCategory("G01 - Entry Setup"), Description("DiverScout_ScanWidth"), NinjaTrader.Gui.Design.DisplayName("p04_DiverScout_ScanWidth")]
        public int pDiverScout_ScanWidth
        {
            get
            {
                return this.ppDiverScout_ScanWidth;
            }
            set
            {
                this.ppDiverScout_ScanWidth = Math.Max(0, value);
            }
        }

        [GridCategory("G01 - Entry Setup"), Description("DiverScout_Smooth"), NinjaTrader.Gui.Design.DisplayName("p06_DiverScout_Smooth")]
        public int pDiverScout_Smooth
        {
            get
            {
                return this.ppDiverScout_Smooth;
            }
            set
            {
                this.ppDiverScout_Smooth = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p01_EMA_Entry_Period"), Description("EMA_Entry_Period."), GridCategory("G01 - Entry Setup")]
        public int pEMA_Entry_Period
        {
            get
            {
                return this.ppEMA_Entry_Period;
            }
            set
            {
                this.ppEMA_Entry_Period = Math.Max(0, value);
            }
        }

        [Description("Entry_Limit_Bars"), NinjaTrader.Gui.Design.DisplayName("p04_Entry_Limit_Bars"), GridCategory("G06 - Entry Order Type")]
        public int pEntry_Limit_Bars
        {
            get
            {
                return this.ppEntry_Limit_Bars;
            }
            set
            {
                this.ppEntry_Limit_Bars = Math.Max(0, value);
            }
        }

        [Description("Entry_Limit_Offset_Type"), NinjaTrader.Gui.Design.DisplayName("p02_Entry_Limit_Offset_Type"), GridCategory("G06 - Entry Order Type")]
        public bftatBigfootV5bDev_Limit_Offset_Type pEntry_Limit_Offset_Type
        {
            get
            {
                return this.ppEntry_Limit_Offset_Type;
            }
            set
            {
                this.ppEntry_Limit_Offset_Type = value;
            }
        }

        [Description("Entry_Limit_Ticks"), NinjaTrader.Gui.Design.DisplayName("p03_Entry_Limit_Ticks"), GridCategory("G06 - Entry Order Type")]
        public int pEntry_Limit_Ticks
        {
            get
            {
                return this.ppEntry_Limit_Ticks;
            }
            set
            {
                this.ppEntry_Limit_Ticks = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p01_Entry_Longs_On"), Description("Entry_Longs_On."), GridCategory("G04 - Entry Directional Filters")]
        public bool pEntry_Longs_On
        {
            get
            {
                return this.ppEntry_Longs_On;
            }
            set
            {
                this.ppEntry_Longs_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p01_Entry_Order_Type"), GridCategory("G06 - Entry Order Type"), Description("Entry_Order_Type")]
        public bftatBigfootV5bDev_OrderType pEntry_Order_Type
        {
            get
            {
                return this.ppEntry_Order_Type;
            }
            set
            {
                this.ppEntry_Order_Type = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p02_Entry_Shorts_On"), GridCategory("G04 - Entry Directional Filters"), Description("Entry_Shorts_On.")]
        public bool pEntry_Shorts_On
        {
            get
            {
                return this.ppEntry_Shorts_On;
            }
            set
            {
                this.ppEntry_Shorts_On = value;
            }
        }

        [GridCategory("G10 - Entry Quantity"), ReadOnly(true), NinjaTrader.Gui.Design.DisplayName("p01_Entry1_Qty"), Description("Entry1_Qty")]
        public int pEntry1_Qty
        {
            get
            {
                return this.ppEntry1_Qty;
            }
            set
            {
                this.ppEntry1_Qty = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p02_Entry2_Qty"), Description("Entry2_Qty"), ReadOnly(true), GridCategory("G10 - Entry Quantity")]
        public int pEntry2_Qty
        {
            get
            {
                return this.ppEntry2_Qty;
            }
            set
            {
                this.ppEntry2_Qty = Math.Max(0, value);
            }
        }

        [GridCategory("G10 - Entry Quantity"), Description("Entry3_Qty"), ReadOnly(true), NinjaTrader.Gui.Design.DisplayName("p03_Entry3_Qty")]
        public int pEntry3_Qty
        {
            get
            {
                return this.ppEntry3_Qty;
            }
            set
            {
                this.ppEntry3_Qty = Math.Max(0, value);
            }
        }

        [GridCategory("G10 - Entry Quantity"), Description("Entry4_Qty"), ReadOnly(true), NinjaTrader.Gui.Design.DisplayName("p04_Entry4_Qty")]
        public int pEntry4_Qty
        {
            get
            {
                return this.ppEntry4_Qty;
            }
            set
            {
                this.ppEntry4_Qty = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p13_EOW_Exit_DOW"), GridCategory("G05 - Entry Time Filters"), Description("EOW_Exit_DOW (Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday)")]
        public DayOfWeek pEOW_Exit_DOW
        {
            get
            {
                return this.ppEOW_Exit_DOW;
            }
            set
            {
                this.ppEOW_Exit_DOW = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), NinjaTrader.Gui.Design.DisplayName("p14_EOW_Exit_Time"), Description("EOW_Exit_Time (HH:MM:SS)")]
        public TimeSpan pEOW_Exit_Time
        {
            get
            {
                return this.ppEOW_Exit_Time;
            }
            set
            {
                this.ppEOW_Exit_Time = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p02_EquityCurve_On\t"), GridCategory("G15 - Utility"), Description("EquityCurve_On\t(1=On, 0=Off)")]
        public bool pEquityCurve_On
        {
            get
            {
                return this.ppEquityCurve_On;
            }
            set
            {
                this.ppEquityCurve_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p05_EquityTrail_On"), GridCategory("G12 - Equity Trading Halts"), Description("EquityTrail_On")]
        public bool pEquityTrail_On
        {
            get
            {
                return this.ppEquityTrail_On;
            }
            set
            {
                this.ppEquityTrail_On = value;
            }
        }

        [GridCategory("G12 - Equity Trading Halts"), NinjaTrader.Gui.Design.DisplayName("p08_EquityTrail_Trail_Amt"), Description("EquityTrail_Trail_Amt")]
        public int pEquityTrail_Trail_Amt
        {
            get
            {
                return this.ppEquityTrail_Trail_Amt;
            }
            set
            {
                this.ppEquityTrail_Trail_Amt = Math.Max(0, value);
            }
        }

        [GridCategory("G12 - Equity Trading Halts"), Description("EquityTrail_Trail_Pct"), NinjaTrader.Gui.Design.DisplayName("p09_EquityTrail_Trail_Pct")]
        public int pEquityTrail_Trail_Pct
        {
            get
            {
                return this.ppEquityTrail_Trail_Pct;
            }
            set
            {
                this.ppEquityTrail_Trail_Pct = Math.Max(0, value);
            }
        }

        [GridCategory("G12 - Equity Trading Halts"), Description("EquityTrail_Trig_Amt"), NinjaTrader.Gui.Design.DisplayName("p06_EquityTrail_Trig_Amt")]
        public int pEquityTrail_Trig_Amt
        {
            get
            {
                return this.ppEquityTrail_Trig_Amt;
            }
            set
            {
                this.ppEquityTrail_Trig_Amt = Math.Max(0, value);
            }
        }

        [GridCategory("G12 - Equity Trading Halts"), NinjaTrader.Gui.Design.DisplayName("p07_EquityTrail_Trig_Pct"), Description("EquityTrail_Trig_Pct")]
        public int pEquityTrail_Trig_Pct
        {
            get
            {
                return this.ppEquityTrail_Trig_Pct;
            }
            set
            {
                this.ppEquityTrail_Trig_Pct = Math.Max(0, value);
            }
        }

        [GridCategory("G15 - Utility"), NinjaTrader.Gui.Design.DisplayName("p06_OperatingMode"), Description("OperatingMode (Backtest, Realtime)")]
        public bftatBigfootV5bDev_OpMode pOperatingMode
        {
            get
            {
                return this.ppOperatingMode;
            }
            set
            {
                this.ppOperatingMode = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p01_ProfTrgt1_LE_Ticks"), Description("ProfTrgt1_LE_Ticks"), GridCategory("G11 - Targets & Stops")]
        public int pProfTrgt1_LE_Ticks
        {
            get
            {
                return this.ppProfTrgt1_LE_Ticks;
            }
            set
            {
                this.ppProfTrgt1_LE_Ticks = Math.Max(0, value);
            }
        }

        [GridCategory("G11 - Targets & Stops"), Description("ProfTrgt1_SE_Ticks"), NinjaTrader.Gui.Design.DisplayName("p05_ProfTrgt1_SE_Ticks")]
        public int pProfTrgt1_SE_Ticks
        {
            get
            {
                return this.ppProfTrgt1_SE_Ticks;
            }
            set
            {
                this.ppProfTrgt1_SE_Ticks = Math.Max(0, value);
            }
        }

        [GridCategory("G11 - Targets & Stops"), Description("ProfTrgt2_LE_Ticks"), NinjaTrader.Gui.Design.DisplayName("p02_ProfTrgt2_LE_Ticks")]
        public int pProfTrgt2_LE_Ticks
        {
            get
            {
                return this.ppProfTrgt2_LE_Ticks;
            }
            set
            {
                this.ppProfTrgt2_LE_Ticks = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p06_ProfTrgt2_SE_Ticks"), GridCategory("G11 - Targets & Stops"), Description("ProfTrgt2_SE_Ticks")]
        public int pProfTrgt2_SE_Ticks
        {
            get
            {
                return this.ppProfTrgt2_SE_Ticks;
            }
            set
            {
                this.ppProfTrgt2_SE_Ticks = Math.Max(0, value);
            }
        }

        [GridCategory("G11 - Targets & Stops"), Description("ProfTrgt3_Ticks"), NinjaTrader.Gui.Design.DisplayName("p03_ProfTrgt3_LE_Ticks")]
        public int pProfTrgt3_LE_Ticks
        {
            get
            {
                return this.ppProfTrgt3_LE_Ticks;
            }
            set
            {
                this.ppProfTrgt3_LE_Ticks = Math.Max(0, value);
            }
        }

        [Description("ProfTrgt3_Ticks"), NinjaTrader.Gui.Design.DisplayName("p07_ProfTrgt3_SE_Ticks"), GridCategory("G11 - Targets & Stops")]
        public int pProfTrgt3_SE_Ticks
        {
            get
            {
                return this.ppProfTrgt3_SE_Ticks;
            }
            set
            {
                this.ppProfTrgt3_SE_Ticks = Math.Max(0, value);
            }
        }

        [GridCategory("G11 - Targets & Stops"), NinjaTrader.Gui.Design.DisplayName("p04_ProfTrgt4_LE_Ticks"), Description("ProfTrgt4_LE_Ticks")]
        public int pProfTrgt4_LE_Ticks
        {
            get
            {
                return this.ppProfTrgt4_LE_Ticks;
            }
            set
            {
                this.ppProfTrgt4_LE_Ticks = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p08_ProfTrgt4_SE_Ticks"), GridCategory("G11 - Targets & Stops"), Description("ProfTrgt4_SE_Ticks")]
        public int pProfTrgt4_SE_Ticks
        {
            get
            {
                return this.ppProfTrgt4_SE_Ticks;
            }
            set
            {
                this.ppProfTrgt4_SE_Ticks = Math.Max(0, value);
            }
        }

        [GridCategory("G11 - Targets & Stops"), NinjaTrader.Gui.Design.DisplayName("p09_StopLoss_Ticks"), Description("StopLoss_Ticks")]
        public int pStopLoss_Ticks
        {
            get
            {
                return this.ppStopLoss_Ticks;
            }
            set
            {
                this.ppStopLoss_Ticks = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p01_StrategyName"), Description("StrategyName"), GridCategory("G15 - Utility")]
        public string pStrategyName
        {
            get
            {
                return this.ppStrategyName;
            }
            set
            {
                this.ppStrategyName = value;
            }
        }

        [GridCategory("G01 - Entry Setup"), Description("T2_CounterTrend_On"), NinjaTrader.Gui.Design.DisplayName("p15_T2_CounterTrend_On")]
        public int pT2_CounterTrend_On
        {
            get
            {
                return this.ppT2_CounterTrend_On;
            }
            set
            {
                this.ppT2_CounterTrend_On = Math.Max(0, value);
            }
        }

        [Description("T2_CT_Entry_Factor"), NinjaTrader.Gui.Design.DisplayName("p10_T2_CT_Entry_Factor"), GridCategory("G01 - Entry Setup")]
        public int pT2_CT_Entry_Factor
        {
            get
            {
                return this.ppT2_CT_Entry_Factor;
            }
            set
            {
                this.ppT2_CT_Entry_Factor = Math.Max(1, value);
            }
        }

        [Description("T2_CT_Entry_Period"), NinjaTrader.Gui.Design.DisplayName("p09_T2_CT_Entry_Period"), GridCategory("G01 - Entry Setup")]
        public int pT2_CT_Entry_Period
        {
            get
            {
                return this.ppT2_CT_Entry_Period;
            }
            set
            {
                this.ppT2_CT_Entry_Period = Math.Max(1, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p04_T2_Exit_Factor"), Description("T2_Exit_Factor"), GridCategory("G03 - Exit Setup")]
        public int pT2_Exit_Factor
        {
            get
            {
                return this.ppT2_Exit_Factor;
            }
            set
            {
                this.ppT2_Exit_Factor = Math.Max(1, value);
            }
        }

        [GridCategory("G03 - Exit Setup"), Description("T2_Exit_Hook_On"), NinjaTrader.Gui.Design.DisplayName("p01_T2_Exit_Hook_On")]
        public int pT2_Exit_Hook_On
        {
            get
            {
                return this.ppT2_Exit_Hook_On;
            }
            set
            {
                this.ppT2_Exit_Hook_On = Math.Max(0, value);
            }
        }

        [GridCategory("G03 - Exit Setup"), NinjaTrader.Gui.Design.DisplayName("p03_T2_Exit_Period"), Description("T2_Exit_Period")]
        public int pT2_Exit_Period
        {
            get
            {
                return this.ppT2_Exit_Period;
            }
            set
            {
                this.ppT2_Exit_Period = Math.Max(1, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p02_T2_Exit_Recross_On"), GridCategory("G03 - Exit Setup"), Description("T2_Exit_Recross_On")]
        public int pT2_Exit_Recross_On
        {
            get
            {
                return this.ppT2_Exit_Recross_On;
            }
            set
            {
                this.ppT2_Exit_Recross_On = Math.Max(0, value);
            }
        }

        [Description("T2_MidlineCross_On"), NinjaTrader.Gui.Design.DisplayName("p12_T2_MidlineCross_On"), GridCategory("G01 - Entry Setup")]
        public int pT2_MidlineCross_On
        {
            get
            {
                return this.ppT2_MidlineCross_On;
            }
            set
            {
                this.ppT2_MidlineCross_On = Math.Max(0, value);
            }
        }

        [Description("T2_MidlineOffset"), NinjaTrader.Gui.Design.DisplayName("p11_T2_MidlineOffset"), GridCategory("G01 - Entry Setup")]
        public int pT2_MidlineOffset
        {
            get
            {
                return this.ppT2_MidlineOffset;
            }
            set
            {
                this.ppT2_MidlineOffset = Math.Max(0, value);
            }
        }

        [Description("T2_TR_Entry_Factor"), GridCategory("G01 - Entry Setup"), NinjaTrader.Gui.Design.DisplayName("p08_T2_TR_Entry_Factor")]
        public int pT2_TR_Entry_Factor
        {
            get
            {
                return this.ppT2_TR_Entry_Factor;
            }
            set
            {
                this.ppT2_TR_Entry_Factor = Math.Max(1, value);
            }
        }

        [GridCategory("G01 - Entry Setup"), Description("T2_TR_Entry_Period"), NinjaTrader.Gui.Design.DisplayName("p07_T2_TR_Entry_Period")]
        public int pT2_TR_Entry_Period
        {
            get
            {
                return this.ppT2_TR_Entry_Period;
            }
            set
            {
                this.ppT2_TR_Entry_Period = Math.Max(1, value);
            }
        }

        [Description("T2_Trend_On"), GridCategory("G01 - Entry Setup"), NinjaTrader.Gui.Design.DisplayName("p14_T2_Trend_On")]
        public int pT2_Trend_On
        {
            get
            {
                return this.ppT2_Trend_On;
            }
            set
            {
                this.ppT2_Trend_On = Math.Max(0, value);
            }
        }

        [Description("T2_ValueCross_On"), GridCategory("G01 - Entry Setup"), NinjaTrader.Gui.Design.DisplayName("p13_T2_ValueCross_On")]
        public int pT2_ValueCross_On
        {
            get
            {
                return this.ppT2_ValueCross_On;
            }
            set
            {
                this.ppT2_ValueCross_On = Math.Max(0, value);
            }
        }

        [GridCategory("G02 - Entry Filter"), NinjaTrader.Gui.Design.DisplayName("p04_T4_Filter_BarSize"), Description("T4_Filter_BarSizer")]
        public int pT4_Filter_BarSize
        {
            get
            {
                return this.ppT4_Filter_BarSize;
            }
            set
            {
                this.ppT4_Filter_BarSize = Math.Max(1, value);
            }
        }

        [GridCategory("G02 - Entry Filter"), NinjaTrader.Gui.Design.DisplayName("p03_T4_Filter_Factor"), Description("T4_Filter_Factor")]
        public int pT4_Filter_Factor
        {
            get
            {
                return this.ppT4_Filter_Factor;
            }
            set
            {
                this.ppT4_Filter_Factor = Math.Max(1, value);
            }
        }

        [Description("T4_Filter_On"), NinjaTrader.Gui.Design.DisplayName("p01_T4_Filter_On"), GridCategory("G02 - Entry Filter")]
        public int pT4_Filter_On
        {
            get
            {
                return this.ppT4_Filter_On;
            }
            set
            {
                this.ppT4_Filter_On = Math.Max(0, value);
            }
        }

        [GridCategory("G02 - Entry Filter"), Description("T4_Filter_Period"), NinjaTrader.Gui.Design.DisplayName("p02_T4_Filter_Period")]
        public int pT4_Filter_Period
        {
            get
            {
                return this.ppT4_Filter_Period;
            }
            set
            {
                this.ppT4_Filter_Period = Math.Max(1, value);
            }
        }

        [GridCategory("G02 - Entry Filter"), Description("T4_Filter_PeriodType"), NinjaTrader.Gui.Design.DisplayName("p05_T4_Filter_PeriodType")]
        public PeriodType pT4_Filter_PeriodType
        {
            get
            {
                return this.ppT4_Filter_PeriodType;
            }
            set
            {
                this.ppT4_Filter_PeriodType = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), NinjaTrader.Gui.Design.DisplayName("p02_Time1_Beg"), Description("Time1_Beg (HH:MM:SS)")]
        public TimeSpan pTime1_Beg
        {
            get
            {
                return this.ppTime1_Beg;
            }
            set
            {
                this.ppTime1_Beg = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p03_Time1_End"), Description("Time1_End (HH:MM:SS)"), GridCategory("G05 - Entry Time Filters")]
        public TimeSpan pTime1_End
        {
            get
            {
                return this.ppTime1_End;
            }
            set
            {
                this.ppTime1_End = value;
            }
        }

        [Description("Time1_Exit (HH:MM:SS)"), GridCategory("G05 - Entry Time Filters"), NinjaTrader.Gui.Design.DisplayName("p04_Time1_Exit")]
        public TimeSpan pTime1_Exit
        {
            get
            {
                return this.ppTime1_Exit;
            }
            set
            {
                this.ppTime1_Exit = value;
            }
        }

        [Description("Time1_Filter_On"), NinjaTrader.Gui.Design.DisplayName("p01_Time1_Filter_On"), GridCategory("G05 - Entry Time Filters")]
        public bool pTime1_Filter_On
        {
            get
            {
                return this.ppTime1_Filter_On;
            }
            set
            {
                this.ppTime1_Filter_On = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), Description("Time2_Beg (HH:MM:SS)"), NinjaTrader.Gui.Design.DisplayName("p06_Time2_Beg")]
        public TimeSpan pTime2_Beg
        {
            get
            {
                return this.ppTime2_Beg;
            }
            set
            {
                this.ppTime2_Beg = value;
            }
        }

        [Description("Time2_End (HH:MM:SS)"), GridCategory("G05 - Entry Time Filters"), NinjaTrader.Gui.Design.DisplayName("p07_Time2_End")]
        public TimeSpan pTime2_End
        {
            get
            {
                return this.ppTime2_End;
            }
            set
            {
                this.ppTime2_End = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), Description("Time2_Exit (HH:MM:SS)"), NinjaTrader.Gui.Design.DisplayName("p08_Time2_Exit")]
        public TimeSpan pTime2_Exit
        {
            get
            {
                return this.ppTime2_Exit;
            }
            set
            {
                this.ppTime2_Exit = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), NinjaTrader.Gui.Design.DisplayName("p05_Time2_Filter_On"), Description("Time2_Filter_On")]
        public bool pTime2_Filter_On
        {
            get
            {
                return this.ppTime2_Filter_On;
            }
            set
            {
                this.ppTime2_Filter_On = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), Description("Time3_Beg (HH:MM:SS)"), NinjaTrader.Gui.Design.DisplayName("p10_Time3_Beg")]
        public TimeSpan pTime3_Beg
        {
            get
            {
                return this.ppTime3_Beg;
            }
            set
            {
                this.ppTime3_Beg = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), NinjaTrader.Gui.Design.DisplayName("p11_Time3_End"), Description("Time3_End (HH:MM:SS)")]
        public TimeSpan pTime3_End
        {
            get
            {
                return this.ppTime3_End;
            }
            set
            {
                this.ppTime3_End = value;
            }
        }

        [GridCategory("G05 - Entry Time Filters"), NinjaTrader.Gui.Design.DisplayName("p12_Time3_Exit"), Description("Time3_Exit (HH:MM:SS)")]
        public TimeSpan pTime3_Exit
        {
            get
            {
                return this.ppTime3_Exit;
            }
            set
            {
                this.ppTime3_Exit = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p09_Time3_Filter_On"), GridCategory("G05 - Entry Time Filters"), Description("Time3_Filter_On")]
        public bool pTime3_Filter_On
        {
            get
            {
                return this.ppTime3_Filter_On;
            }
            set
            {
                this.ppTime3_Filter_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p05_TraceOrders_On"), GridCategory("G15 - Utility"), Description("TraceOrders_On - used for debugging (1=On, 0=Off)")]
        public bool pTraceOrders_On
        {
            get
            {
                return this.ppTraceOrders_On;
            }
            set
            {
                this.ppTraceOrders_On = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p13_TrailStop_On"), GridCategory("G11 - Targets & Stops"), Description("TrailStop_On (1=On, 0=Off)")]
        public int pTrailStop_On
        {
            get
            {
                return this.ppTrailStop_On;
            }
            set
            {
                this.ppTrailStop_On = Math.Max(0, value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p15_TrailStop_TrailTicks"), GridCategory("G11 - Targets & Stops"), Description("TrailStop_TrailTicks (+/- ticks from leading price) ")]
        public int pTrailStop_TrailTicks
        {
            get
            {
                return this.ppTrailStop_TrailTicks;
            }
            set
            {
                this.ppTrailStop_TrailTicks = value;
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p14_TrailStop_TrigTicks"), GridCategory("G11 - Targets & Stops"), Description("TrailStop_TrigTicks (from average fill)")]
        public int pTrailStop_TrigTicks
        {
            get
            {
                return this.ppTrailStop_TrigTicks;
            }
            set
            {
                this.ppTrailStop_TrigTicks = Math.Max(0, value);
            }
        }

        [Browsable(false)]
        public string Time1_BegS
        {
            get
            {
                return this.ppTime1_Beg.ToString();
            }
            set
            {
                this.ppTime1_Beg = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time1_EndS
        {
            get
            {
                return this.ppTime1_End.ToString();
            }
            set
            {
                this.ppTime1_End = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time1_ExitS
        {
            get
            {
                return this.ppTime1_Exit.ToString();
            }
            set
            {
                this.ppTime1_Exit = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time2_BegS
        {
            get
            {
                return this.ppTime2_Beg.ToString();
            }
            set
            {
                this.ppTime2_Beg = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time2_EndS
        {
            get
            {
                return this.ppTime2_End.ToString();
            }
            set
            {
                this.ppTime2_End = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time2_ExitS
        {
            get
            {
                return this.ppTime2_Exit.ToString();
            }
            set
            {
                this.ppTime2_Exit = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time3_BegS
        {
            get
            {
                return this.ppTime3_Beg.ToString();
            }
            set
            {
                this.ppTime3_Beg = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time3_EndS
        {
            get
            {
                return this.ppTime3_End.ToString();
            }
            set
            {
                this.ppTime3_End = TimeSpan.Parse(value);
            }
        }

        [Browsable(false)]
        public string Time3_ExitS
        {
            get
            {
                return this.ppTime3_Exit.ToString();
            }
            set
            {
                this.ppTime3_Exit = TimeSpan.Parse(value);
            }
        }

        [NinjaTrader.Gui.Design.DisplayName("p09_Display Position"), GridCategory("G15 - Utility"), Description("")]
        public TextPosition TxtPosition
        {
            get
            {
                return this.txtPosition;
            }
            set
            {
                this.txtPosition = value;
            }
        }        
    }
}

