#region Using declarations
using System;
using System.Threading;
using System.IO;
using System.Media;
using System.Text;
using System.Reflection;
using System.Windows.Forms;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion
#region Global Enums
public enum buttonorhk {ChartButton, ToolbarButton, HotKey}
public enum saveoruploadscreenshot {Save, Upload, SaveAndUpload}
public enum returnurlformat {Plain, BBcode}
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    		/// <summary>
    /// 26.Oct.12 v1.7
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class vvScreenShot : Indicator
    {
        #region Variables
		//toolbarbutton
		ToolStripButton tsbtnBuy = null;
		ToolStripSeparator tsSeparator = null;
		//toolbarbutton
		
		private bool showmessage = false;
		private string message = "";
		private bool success = false;
		private bool playsound = true;
		private bool makered = false;
		private bool copytoclipboard = true;
		private returnurlformat returnformat = returnurlformat.Plain;
		private string filename = "";
		private string returnurl = "";
		private bool useprotection=true;
		private bool ctflag=false;
		private saveoruploadscreenshot savuplo =saveoruploadscreenshot.Save;
		private buttonorhk button =buttonorhk.ChartButton;
		private string savelocation = "C:\\NTScreenshots";
        // Wizard generated variables
         private StringFormat  			FormatCenter	= new StringFormat();
		private static SolidBrush 		Red    		= new SolidBrush(Color.Red);
		private static SolidBrush 		Black    		= new SolidBrush(Color.Black);
		private static SolidBrush 		Lime    		= new SolidBrush(Color.Lime);
		private static SolidBrush 		SkyBlue			= new SolidBrush(Color.SkyBlue);
		private System.Drawing.Font TextFont1 	= new Font("Arial Narpanel_top", 16,System.Drawing.FontStyle.Bold);

		private System.Drawing.Font smallFont 	= new Font("Arial Narpanel_top", 16,System.Drawing.FontStyle.Bold);
		 Pen redPen  = new Pen(Color.Red, 1); 
		 Pen grePen  = new Pen(Color.Lime, 1); 
		//Button struct
		public struct MY_BUTTON 
		{
		   public int X, Y, Width, Height;
		   public SolidBrush color;
		   public string text;
		   public string cmd;

		   public MY_BUTTON(string t, int x, int y, int w, int h, SolidBrush c, string s) {
		      text = t; X = x; Y = y; Width = w; Height = h; color = c; cmd = s; 
		   }
		}

		   //Window vars
		
		
		public int panel_left;			//Start X pixel (from right margin) of trade panel
		const  int TOP_MARGIN = 5;		//Top Window Margin
		const  int panel_top = 5;		//Y pixel Start of trade panel (from top of window)
		
		   //Mouse and Keyboard vars
		bool   button_press = false;	//Was user click on a user button
		bool   user_click   = false;	//Was moused button just clicked
		string user_click_modifiers="";	//Any Control keys pressed with mouse click

			//Panel Buttons array
		MY_BUTTON[] buttons = {
			   //Entry Buttons
		new MY_BUTTON("S", 55, 20,  20, 20, SkyBlue,"S")
		}	
		;

		private System.Windows.Forms.Timer	timer;	// System Timer
		
		int barNumber=0;
		
		
		
		
	
	
		
		
		//--- do not freeze on button click vars
		private bool buttonc1 = false;
		private bool buttonc2 = false;
		
		
		
		private int mouseclick = 0;
		
		private bool show = true;
		
	
			
		
	
		
		private int yMouse = 0;
	
		private int yMouseB = 0;
		private int xMouseB = 0;
		
			
		
	
		
		private StringFormat				stringFormat		= new StringFormat();
		private SolidBrush					textBrush			= new SolidBrush(Color.Green);
		private SolidBrush					textBrush2			= new SolidBrush(Color.Red);
		private SolidBrush					textBrush3			= new SolidBrush(Color.White);
		private Font						textFont			= new Font("Arial", 30);
		
		// Default setting for MyInput0
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void OnStartUp() 
		{
			textBrush.Color = ChartControl.AxisColor;
			//toolbarbutton
			if(button==buttonorhk.ToolbarButton) CreateButtons();
			
			if(button==buttonorhk.ChartButton) this.ChartControl.ChartPanel.MouseUp += new MouseEventHandler(chart_MouseClick);
			if(button==buttonorhk.HotKey) this.ChartControl.ChartPanel.KeyDown += new KeyEventHandler(chart_KeyDown);

			try
			{
				if(!Directory.Exists(savelocation))
				{
				Directory.CreateDirectory(savelocation);
					Print("created   "+savelocation);
				}
				if(Directory.Exists(savelocation))
				{
					Print("Directory exists"+savelocation);
				}
			}
			catch{Print("Error in OnStartUp()");}
		}
		
		protected override void Initialize()
        {
           // Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "Plot0"));
           
			CalculateOnBarClose = false;		//### Run on every Tick 
            Overlay				= true;	
			PaintPriceMarkers   = false;
			DisplayInDataBox    = false;
			
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
    	protected override void OnBarUpdate() {}
		
		private void chart_KeyDown (object sender, KeyEventArgs e)
		{
			
			if (e.Alt && e.KeyCode == Keys.P)
			{
				makered=true;
				ChartControl.Refresh();
				System.Threading.Thread t = new System.Threading.Thread(new System.Threading.ThreadStart(makescreenshot));
				t.SetApartmentState(ApartmentState.STA);
				
				Print("astate "+t.ApartmentState);// = Thread.ApartmentState.STA;
				t.IsBackground = true;
				t.Start();
//				makescreenshot();
				
			}
		}
		
		private void tsbtnBuy_Click(object sender,EventArgs e)
		{
			makered=true;
				ChartControl.Refresh();
				System.Threading.Thread t = new System.Threading.Thread(new System.Threading.ThreadStart(makescreenshot));
				t.SetApartmentState(ApartmentState.STA);
				
				
				t.IsBackground = true;
				t.Start();
//				makescreenshot();
		}
		
			//--------------------------------------------------------------------trap click	
		private void chart_MouseClick(object sender, MouseEventArgs e)
        {            
                                    
          //------------------------freeze	
			if (e.Clicks == 1 && (e.Button == MouseButtons.Left))
			{
				yMouseB=	e.Y;
				xMouseB=	e.X;
				//---------check click
				int x,y;	
				double d;
				x = xMouseB-panel_left;
				y = yMouseB-panel_top;	
				//### Check button
				for(int i=0; i < buttons.Length; i++) 
				{
					if ( x > buttons[i].X && x < buttons[i].X+buttons[i].Width && y > buttons[i].Y && y < buttons[i].Y+buttons[i].Height)
					{
						//capture
						makered=true;
						ChartControl.Refresh();
						System.Threading.Thread t = new System.Threading.Thread(new System.Threading.ThreadStart(makescreenshot));
						t.SetApartmentState(ApartmentState.STA);
						
						t.IsBackground = true;
						t.Start();
//						makescreenshot();
						
					}
				}
			}
		}
			
			
		private void makescreenshot()//############################################################# screenshot #################
		{
			DateTime now = DateTime.Now;
			
			
			try
			{
				if(useprotection)
				{
				   if ( ChartControl.ChartTraderEnabled && ChartControl.ChartTraderVisible )
					{
						ctflag= true;
						ChartControl.ChartTraderVisible=false;
					}
				}
				Rectangle bounds = this.ChartControl.FindForm().Bounds;
				using (Bitmap bitmap = new Bitmap(bounds.Width, bounds.Height))
				{
					using (Graphics g = Graphics.FromImage(bitmap))
					{
						g.CopyFromScreen(new Point(bounds.Left,bounds.Top), Point.Empty, bounds.Size);
					}
				
					if(useprotection)
				{
					if ( ChartControl.ChartTraderEnabled && ctflag== true )
					{
						ctflag= false;
						ChartControl.ChartTraderVisible=true;
					}
				}
					if(savuplo ==saveoruploadscreenshot.Save || savuplo ==saveoruploadscreenshot.SaveAndUpload)
					{
						filename=savelocation+"\\"+this.Instrument.FullName+"-"+this.BarsPeriod+"-"+now.Month+"."+now.Day+"."+now.Year+"-"+now.Hour+"."+now.Minute+"."+now.Second+".png";
						Print(this.BarsPeriod+"-");
						Print(now.Date+"-");
						Print(now.TimeOfDay+"-");
						Print(now.Millisecond+"-");
						Print(filename);
						bitmap.Save(filename, ImageFormat.Png);
						//Print("Path   "+savelocation+"\\"+this.Instrument.FullName+now+".png");
					}
					if(savuplo ==saveoruploadscreenshot.Upload || savuplo ==saveoruploadscreenshot.SaveAndUpload)
					{
						//upload the image and get url
						if(savuplo ==saveoruploadscreenshot.Upload)
						{
							
							filename = Path.GetTempPath()+this.Instrument.FullName+"-"+now.Ticks+".png";
						
							bitmap.Save(filename, ImageFormat.Png);
							
						}
						
						System.Net.WebClient client = new System.Net.WebClient ();
						{
							//bitmap
							
							byte[] responseArray = client.UploadFile("http://www.bmcharts.com/vvhgss.php?auth=1", "POST", filename);
							// Decode and display the response.
							
							
							//get the url out of the response array
							returnurl = Encoding.ASCII.GetString(responseArray);
							
							
							if(returnurl.StartsWith("http://")) success = true;
							else
							{
								success = false;
								Print("Response: "+Encoding.ASCII.GetString(responseArray));
							}
							
							//beep after finished
							
								if(playsound && success)
								{
									try
									{
									SoundPlayer simpleSound = new SoundPlayer(Application.StartupPath.Substring(0, Application.StartupPath.Length - 3)+"sounds\\CompiledSuccessfully.wav");
									simpleSound.Play();
									}
									catch{PlaySound("CompiledSuccessfully.wav");}
								}
								else if(playsound && !success)
								{
									try
									{
									SoundPlayer simpleSound = new SoundPlayer(Application.StartupPath.Substring(0, Application.StartupPath.Length - 3)+"sounds\\Alert3.wav");
									simpleSound.Play();
									}
									catch{PlaySound("Alert3.wav");}
								}
							
							

						}
						
						if(savuplo ==saveoruploadscreenshot.Upload)
						{
							try{File.Delete(filename);} catch{Print("error deleting temp file");}
						}
							
						if (returnformat == returnurlformat.BBcode && success)
						{
							returnurl = "[img]"+returnurl+"[/img]";
						}
							
						if(copytoclipboard && returnurl.Length != 0 && success)
						{
							Clipboard.SetText(returnurl);
							message = "Successfully uploaded, url copied to clipboard.";
							makered=false;
							ChartControl.Refresh();
							//wait
							System.Threading.Thread.Sleep(1500);
							message = "";
							ChartControl.Refresh();
						}
						else if(!copytoclipboard && returnurl.Length != 0 && success)
						{
							Print(returnurl);
							message = "Successfully uploaded, url printed to output window.";
							makered=false;
							ChartControl.Refresh();
							//wait
							System.Threading.Thread.Sleep(1500);
							message = "";
							ChartControl.Refresh();
						}
						
						
					}
					
					
					
				}
				
				
			}
			catch{Print("Error in makescreenshot()");}
			if(makered)
			{
				makered=false;
				ChartControl.Refresh();
			}
			if(useprotection)
				{
					if ( ChartControl.ChartTraderEnabled && ctflag== true )
					{
						ctflag= false;
						ChartControl.ChartTraderVisible=true;
					}
				}
			
		}
		
		private void CreateButtons()
		{
			if (ChartControl != null)
			{
				ToolStrip toolstrip = (ToolStrip)ChartControl.Controls["tsrTool"];
				
				
				if (toolstrip != null)
				{
					tsSeparator = new ToolStripSeparator();
					tsSeparator.Name = "tsSeparator";
					toolstrip.Items.Add(tsSeparator);
					
					
					
					//create the BUY button
					tsbtnBuy = new ToolStripButton();
					tsbtnBuy.Name = "tsbtnBuy";
					tsbtnBuy.Text = "Screenshot";
					tsbtnBuy.ForeColor = Color.Blue;
					tsbtnBuy.Click += new EventHandler(tsbtnBuy_Click);
					
					toolstrip.Items.Add(tsbtnBuy);
					tsbtnBuy.Enabled = true;
				}
			}
		}
		
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
        {
			//Print("Plot");
			if(button==buttonorhk.ChartButton && !makered)
			{
				//----------Button
				base.Plot(graphics, bounds, min, max);
				int i,x,y; double d,f,price;
				Rectangle rect = new Rectangle(); 
				Brush brush;
				//### Draw trade panel button
				panel_left = -40;
				for(i=0; i < buttons.Length; i++)
				{
					graphics.DrawString( "℗", smallFont, Lime, panel_left + buttons[i].X-4, buttons[i].Y+panel_top+2);
				}
			}
			if(makered)
			{
				//----------Button
				base.Plot(graphics, bounds, min, max);
				int i,x,y; double d,f,price;
				Rectangle rect = new Rectangle(); 
				Brush brush;
				//### Draw trade panel button
				panel_left = -40;
				for(i=0; i < buttons.Length; i++)
				{
					graphics.DrawString( "℗", smallFont, Red, panel_left + buttons[i].X-4, buttons[i].Y+panel_top+2);
				}
			}
			//if((button==buttonorhk.HotKey || button==buttonorhk.ToolbarButton) && !makered) ChartControl.ChartPanel.Invalidate();
			
			DrawTextFixed("errortag2", message, TextPosition.Center, textBrush.Color, TextFont1, Color.Transparent,Color.Transparent,0);
			
		}
	
		protected override void OnTermination() 
		{
 		if(button==buttonorhk.ChartButton) this.ChartControl.ChartPanel.MouseUp -= new MouseEventHandler(chart_MouseClick);
		if(button==buttonorhk.HotKey) this.ChartControl.ChartPanel.KeyDown -= new KeyEventHandler(chart_KeyDown);
		if (ChartControl != null && button==buttonorhk.ToolbarButton)
			{
				ToolStrip toolstrip = (ToolStrip)ChartControl.Controls["tsrTool"];
				if (toolstrip != null)
				{
					if (tsSeparator != null)
					{
						toolstrip.Items.Remove(tsSeparator);
					}
					if (tsbtnBuy != null)
					{
						tsbtnBuy.Click -= new EventHandler(tsbtnBuy_Click);
						toolstrip.Items.Remove(tsbtnBuy);
						
					}
				}
			}
		} 
		
		
		
		

        #region Properties
       
		
		[Description("Path to save screenshots to")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("3. Save Path")]
		public string Savelocation
		{
			get { return savelocation; }
			set { savelocation = value; }
		}
		
		[Description("Use Button or Hotkey Alt+P (the Hotkey can be changed in line 160")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("6. Use Button")]
		public buttonorhk Button
		{
			get { return button; }
			set { button = value; }
		}
		
		[Description("If set to true, this will temporarily disable the display of the chart trader fields for the screenshot. If this is set to false and the chart trader is visible the account number will be visible on the screenshot!")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("1. Protect My Account Number")]
		public bool Useprotection
		{
			get { return useprotection; }
			set { useprotection = value; }
		}
		
		[Description("Select to save locally, upload or both")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("2. Save/Upload")]
		public saveoruploadscreenshot Savuplo
		{
			get { return savuplo; }
			set { savuplo = value; }
		}
		
		[Description("Select the format of the picture url, either plain url or with bbcode wrappers")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("4. Format for picture url")]
		public returnurlformat Returnformat
		{
			get { return returnformat; }
			set { returnformat = value; }
		}
		
		[Description("Copy url to clipboard?")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("5. Copy url to clipboard?")]
		public bool Copytoclipboard
		{
			get { return copytoclipboard; }
			set { copytoclipboard = value; }
		}
		
		[Description("Play sound after upload? This is useful as an audio representation indicating the upload finished.")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("7. Play sound after upload?")]
		public bool Playsound
		{
			get { return playsound; }
			set { playsound = value; }
		}
		
		
        #endregion
	
	}
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private vvScreenShot[] cachevvScreenShot = null;

        private static vvScreenShot checkvvScreenShot = new vvScreenShot();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public vvScreenShot vvScreenShot(buttonorhk button, bool copytoclipboard, bool playsound, returnurlformat returnformat, string savelocation, saveoruploadscreenshot savuplo, bool useprotection)
        {
            return vvScreenShot(Input, button, copytoclipboard, playsound, returnformat, savelocation, savuplo, useprotection);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public vvScreenShot vvScreenShot(Data.IDataSeries input, buttonorhk button, bool copytoclipboard, bool playsound, returnurlformat returnformat, string savelocation, saveoruploadscreenshot savuplo, bool useprotection)
        {
            if (cachevvScreenShot != null)
                for (int idx = 0; idx < cachevvScreenShot.Length; idx++)
                    if (cachevvScreenShot[idx].Button == button && cachevvScreenShot[idx].Copytoclipboard == copytoclipboard && cachevvScreenShot[idx].Playsound == playsound && cachevvScreenShot[idx].Returnformat == returnformat && cachevvScreenShot[idx].Savelocation == savelocation && cachevvScreenShot[idx].Savuplo == savuplo && cachevvScreenShot[idx].Useprotection == useprotection && cachevvScreenShot[idx].EqualsInput(input))
                        return cachevvScreenShot[idx];

            lock (checkvvScreenShot)
            {
                checkvvScreenShot.Button = button;
                button = checkvvScreenShot.Button;
                checkvvScreenShot.Copytoclipboard = copytoclipboard;
                copytoclipboard = checkvvScreenShot.Copytoclipboard;
                checkvvScreenShot.Playsound = playsound;
                playsound = checkvvScreenShot.Playsound;
                checkvvScreenShot.Returnformat = returnformat;
                returnformat = checkvvScreenShot.Returnformat;
                checkvvScreenShot.Savelocation = savelocation;
                savelocation = checkvvScreenShot.Savelocation;
                checkvvScreenShot.Savuplo = savuplo;
                savuplo = checkvvScreenShot.Savuplo;
                checkvvScreenShot.Useprotection = useprotection;
                useprotection = checkvvScreenShot.Useprotection;

                if (cachevvScreenShot != null)
                    for (int idx = 0; idx < cachevvScreenShot.Length; idx++)
                        if (cachevvScreenShot[idx].Button == button && cachevvScreenShot[idx].Copytoclipboard == copytoclipboard && cachevvScreenShot[idx].Playsound == playsound && cachevvScreenShot[idx].Returnformat == returnformat && cachevvScreenShot[idx].Savelocation == savelocation && cachevvScreenShot[idx].Savuplo == savuplo && cachevvScreenShot[idx].Useprotection == useprotection && cachevvScreenShot[idx].EqualsInput(input))
                            return cachevvScreenShot[idx];

                vvScreenShot indicator = new vvScreenShot();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Button = button;
                indicator.Copytoclipboard = copytoclipboard;
                indicator.Playsound = playsound;
                indicator.Returnformat = returnformat;
                indicator.Savelocation = savelocation;
                indicator.Savuplo = savuplo;
                indicator.Useprotection = useprotection;
                Indicators.Add(indicator);
                indicator.SetUp();

                vvScreenShot[] tmp = new vvScreenShot[cachevvScreenShot == null ? 1 : cachevvScreenShot.Length + 1];
                if (cachevvScreenShot != null)
                    cachevvScreenShot.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachevvScreenShot = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvScreenShot vvScreenShot(buttonorhk button, bool copytoclipboard, bool playsound, returnurlformat returnformat, string savelocation, saveoruploadscreenshot savuplo, bool useprotection)
        {
            return _indicator.vvScreenShot(Input, button, copytoclipboard, playsound, returnformat, savelocation, savuplo, useprotection);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.vvScreenShot vvScreenShot(Data.IDataSeries input, buttonorhk button, bool copytoclipboard, bool playsound, returnurlformat returnformat, string savelocation, saveoruploadscreenshot savuplo, bool useprotection)
        {
            return _indicator.vvScreenShot(input, button, copytoclipboard, playsound, returnformat, savelocation, savuplo, useprotection);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvScreenShot vvScreenShot(buttonorhk button, bool copytoclipboard, bool playsound, returnurlformat returnformat, string savelocation, saveoruploadscreenshot savuplo, bool useprotection)
        {
            return _indicator.vvScreenShot(Input, button, copytoclipboard, playsound, returnformat, savelocation, savuplo, useprotection);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.vvScreenShot vvScreenShot(Data.IDataSeries input, buttonorhk button, bool copytoclipboard, bool playsound, returnurlformat returnformat, string savelocation, saveoruploadscreenshot savuplo, bool useprotection)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.vvScreenShot(input, button, copytoclipboard, playsound, returnformat, savelocation, savuplo, useprotection);
        }
    }
}
#endregion
