#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion



//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.fm
{
	

	
	public class fmLotsOLevels02 : Indicator
	{	
		//integer values for programmer readability. Allow reference by name to the array index values in their proper sequence.
		private const int H = 0;
		private const int PH = 1;
		private const int YH = 2;
		private const int L = 3;
		private const int PL = 4;
		private const int YL = 5;
		private const int O = 6;
		private const int PO = 7;
		private const int YO = 8;
		private const int PC = 9;
		private const int YC = 10;
		private const int M = 11;
		private const int PM = 12;
		private const int YM = 13;
		private const int VWAP = 14; 
 		private const int PVWAP = 15; 
		private const int YVWAP = 16; 
		private const int SessionVWAP = 17;
		private const int YSessionVWAP = 18;
		private const int WeekVWAP = 19;
		private const int YWeekVWAP = 20;
		
		
		private bool inWindow;
		private bool completedFirstSession = false;
		
		private DateTime WindowStartDateTime;
		private DateTime WindowEndDateTime; 
		
		private double	iCumVolume			= 0;
		private double	iCumTypicalVolume	= 0;
		
		private double	sessioniCumVolume			= 0;
		private double	sessioniCumTypicalVolume	= 0;
		
		private double	weekiCumVolume			= 0;
		private double	weekiCumTypicalVolume	= 0;
		
		private int dayOfWeek = 7;
		
		//plots need a few variables. current, last (set at the end of the window), persist (set whenever the active plot goes to N/A)
		
		private double currentHigh;
		private double lastWindowHigh;	
		private double currentLow;
		private double lastWindowLow;	
		private double currentOpen;
		private double lastWindowOpen;	
		private double lastWindowClose;	
		private double currentMid;
		private double lastWindowMid;	
		private double currentVWAP;
		private double lastWindowVWAP;
		private double currentSessionVWAP;
		private double lastSessionVWAP;
		private double currentWeekVWAP;
		private double lastWeekVWAP;
		private double persistH;
		private double persistPH;
		private double persistYH;
		private double persistL;
		private double persistPL;
		private double persistYL;
		private double persistO;
		private double persistPO;
		private double persistYO;
		private double persistPC;
		private double persistYC;
		private double persistM;
		private double persistPM;
		private double persistYM;
		private double persistVWAP;
		private double persistPVWAP;
		private double persistYVWAP;
		private double persistSessionVWAP;
		private double persistYSessionVWAP;
		private double persistWeekVWAP;
		private double persistYWeekVWAP;
		
		
		//a few arrays so I can use loops to set stuff up.
		
		private const int SERIESLENGTH = 21;
		
		private double[] allTheValues = new double[SERIESLENGTH];		
		private Brush[] brushSeries = new Brush[SERIESLENGTH];
		private String[] labelSeries = new String[SERIESLENGTH];
		private double[] persistSeries = new double[SERIESLENGTH];
		private bool[] showPlotSeries = new bool[SERIESLENGTH];
		private bool[] showLabelSeries = new bool[SERIESLENGTH];
		
		private int roundPlaces = 7;
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Indicator here.";
				Name										= "fmLotsOLevels02";
				Calculate									= Calculate.OnPriceChange;
				IsOverlay									= true;
				DisplayInDataBox							= false;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				ShowHLabel = true;
				ShowPHLabel = true;
				ShowYHLabel = true;
				ShowLLabel = true;
				ShowPLLabel = true;
				ShowYLLabel = true;
				ShowOLabel = true;
				ShowPOLabel = true;
				ShowYOLabel = true;
				ShowPCLabel = true;
				ShowYCLabel = true;
				ShowMLabel = true;
				ShowPMLabel = false;
				ShowYMLabel = false;
				ShowVWAPLabel = true;
				ShowPVWAPLabel = true;
				ShowYVWAPLabel = true;
				ShowSessionVWAPLabel = true;
				ShowYSessionVWAPLabel = true;
				ShowWeekVWAPLabel = true;
				ShowYWeekVWAPLabel = true;
				ShowPriceOnLabels = true;
				LabelH					= @"H";
				LabelPH					= @"PH";
				LabelYH					= @"YH";
				LabelL					= @"L";
				LabelPL					= @"PL";
				LabelYL					= @"YL";
				LabelO					= @"O";
				LabelPO					= @"PO";
				LabelYO					= @"YO";
				LabelPC					= @"PC";
				LabelYC					= @"YC";
				LabelM					= @"M";
				LabelPM					= @"PM";
				LabelYM					= @"YM";
				LabelVWAP					= @"VWAP";
				LabelPVWAP					= @"PVWAP";
				LabelYVWAP					= @"YVWAP";
				LabelSessionVWAP					= @"SeshVWAP";
				LabelYSessionVWAP					= @"YSeshVWAP";
				LabelWeekVWAP					= @"WeekVWAP";
				LabelYWeekVWAP					= @"YWeekVWAP";				
				FontSize					= 10;
				WindowStart						= DateTime.Parse("9:30 AM");
				WindowEnd						= DateTime.Parse("4:00 PM");
				ShowH					= true;
				ShowPH					= true;
				ShowYH					= true;
				ShowL					= true;
				ShowPL					= true;
				ShowYL					= true;
				ShowO					= true;
				ShowPO					= true;
				ShowYO					= true;
				ShowPC					= true;
				ShowYC					= true;
				ShowM					= true;
				ShowPM					= false;
				ShowYM					= false;
				ShowVWAP				= true;
				ShowPVWAP				= true;
				ShowYVWAP				= true;
				ShowSessionVWAP			= true;
				ShowYSessionVWAP		= true;
				ShowWeekVWAP			= true;
				ShowYWeekVWAP			= true;
				BrushH = Brushes.DeepSkyBlue;
				BrushPH = Brushes.DodgerBlue;
				BrushYH = Brushes.RoyalBlue;
				BrushL = Brushes.DeepSkyBlue;
				BrushPL = Brushes.DodgerBlue;
				BrushYL = Brushes.RoyalBlue;
				BrushO = Brushes.DeepSkyBlue;
				BrushPO = Brushes.DodgerBlue;
				BrushYO = Brushes.RoyalBlue;
				BrushPC = Brushes.DodgerBlue;
				BrushYC = Brushes.RoyalBlue;
				BrushM = Brushes.DeepSkyBlue;
				BrushPM = Brushes.DodgerBlue;
				BrushYM = Brushes.RoyalBlue;
				BrushVWAP = Brushes.OrangeRed;
				BrushPVWAP = Brushes.Tomato;
				BrushYVWAP = Brushes.DarkSalmon;
				BrushSessionVWAP = Brushes.Firebrick;
				BrushYSessionVWAP = Brushes.DarkRed;
				BrushWeekVWAP = Brushes.BlueViolet;
				BrushYWeekVWAP = Brushes.DarkViolet;
				
				AddPlot(new Stroke(BrushH, 2), PlotStyle.Hash, "WindowHigh");
				AddPlot(new Stroke(BrushPH, 2), PlotStyle.Hash, "PWindowHigh");
				AddPlot(new Stroke(BrushYH, 2), PlotStyle.Hash, "YWindowHigh");
				AddPlot(new Stroke(BrushL, 2), PlotStyle.Hash, "WindowLow");
				AddPlot(new Stroke(BrushPL, 2), PlotStyle.Hash, "PWindowLow");
				AddPlot(new Stroke(BrushYL, 2), PlotStyle.Hash, "YWindowLow");
				AddPlot(new Stroke(BrushO, 2), PlotStyle.Hash, "WindowOpen");
				AddPlot(new Stroke(BrushPO, 2), PlotStyle.Hash, "PWindowOpen");
				AddPlot(new Stroke(BrushYO, 2), PlotStyle.Hash, "YWindowOpen");
				AddPlot(new Stroke(BrushPC, 2), PlotStyle.Hash, "PWindowClose");
				AddPlot(new Stroke(BrushYC, 2), PlotStyle.Hash, "YWindowClose");
				AddPlot(new Stroke(BrushM, 1), PlotStyle.Dot, "WindowMid");
				AddPlot(new Stroke(BrushPM, 2), PlotStyle.Hash, "PWindowMid");
				AddPlot(new Stroke(BrushYM, 2), PlotStyle.Hash, "YWindowMid");
				AddPlot(new Stroke(BrushVWAP, DashStyleHelper.Dash,  2), PlotStyle.Line, "WindowVWAP");
				AddPlot(new Stroke(BrushPVWAP, 2), PlotStyle.Hash, "PWindowVWAP");
				AddPlot(new Stroke(BrushYVWAP, 2), PlotStyle.Hash, "YWindowVWAP");
				AddPlot(new Stroke(BrushSessionVWAP, DashStyleHelper.Dash,  2), PlotStyle.Line, "PlotSessionVWAP");
				AddPlot(new Stroke(BrushYSessionVWAP, 2), PlotStyle.Hash, "PlotPSessionVWAP");
				AddPlot(new Stroke(BrushWeekVWAP, DashStyleHelper.Dash,  2), PlotStyle.Line, "PlotWeekVWAP");
				AddPlot(new Stroke(BrushYWeekVWAP, 2), PlotStyle.Hash, "PlotYWeekVWAP");
			}
			else if (State == State.Configure)
			{
				//Lifted idea from FatTails ama.  No need for OnTick in this indicator. Force it.	
				if(Calculate == Calculate.OnEachTick)
					Calculate = Calculate.OnPriceChange; 
				
				//Unfortunately I gave up on figuring a way to make this indi work using only plot brushes.
				//The brush series holds all the brush and label colors, even when the plots themselves are set to transparent (deactivated).
				//The label series is what it says on the tin.
				for (int seriesCounter = 0; seriesCounter < brushSeries.Length; seriesCounter++)
				{
					switch (seriesCounter)
					{
						case H:
							brushSeries[seriesCounter] = BrushH;
							labelSeries[seriesCounter] = LabelH;
							showPlotSeries[seriesCounter] = ShowH;
							showLabelSeries[seriesCounter] = ShowHLabel;
							persistSeries[seriesCounter] = persistH;
							break;
						case PH:
							brushSeries[seriesCounter] = BrushPH;
							labelSeries[seriesCounter] = LabelPH;
							showPlotSeries[seriesCounter] = ShowPH;
							showLabelSeries[seriesCounter] = ShowPHLabel;
							persistSeries[seriesCounter] = persistPH;
							break;
						case YH:
							brushSeries[seriesCounter] = BrushYH;
							labelSeries[seriesCounter] = LabelYH;
							showPlotSeries[seriesCounter] = ShowYH;
							showLabelSeries[seriesCounter] = ShowYHLabel;
							persistSeries[seriesCounter] = persistYH;
							break;
						case L:
							brushSeries[seriesCounter] = BrushL;
							labelSeries[seriesCounter] = LabelL;
							showPlotSeries[seriesCounter] = ShowL;
							showLabelSeries[seriesCounter] = ShowLLabel;
							persistSeries[seriesCounter] = persistL;
							break;
						case PL:
							brushSeries[seriesCounter] = BrushPL;
							labelSeries[seriesCounter] = LabelPL;
							showPlotSeries[seriesCounter] = ShowPL;
							showLabelSeries[seriesCounter] = ShowPLLabel;
							persistSeries[seriesCounter] = persistPL;
							break;
						case YL:
							brushSeries[seriesCounter] = BrushYL;
							labelSeries[seriesCounter] = LabelYL;
							showPlotSeries[seriesCounter] = ShowYL;
							showLabelSeries[seriesCounter] = ShowYLLabel;
							persistSeries[seriesCounter] = persistYL;
							break;
						case O:
							brushSeries[seriesCounter] = BrushO;
							labelSeries[seriesCounter] = LabelO;
							showPlotSeries[seriesCounter] = ShowO;
							showLabelSeries[seriesCounter] = ShowOLabel;
							persistSeries[seriesCounter] = persistO;
							break;
						case PO:
							brushSeries[seriesCounter] = BrushPO;
							labelSeries[seriesCounter] = LabelPO;
							showPlotSeries[seriesCounter] = ShowPO;
							showLabelSeries[seriesCounter] = ShowPOLabel;
							persistSeries[seriesCounter] = persistPO;
							break;
						case YO:
							brushSeries[seriesCounter] = BrushYO;
							labelSeries[seriesCounter] = LabelYO;
							showPlotSeries[seriesCounter] = ShowYO;
							showLabelSeries[seriesCounter] = ShowYOLabel;
							persistSeries[seriesCounter] = persistYO;
							break;
						case PC:
							brushSeries[seriesCounter] = BrushPC;
							labelSeries[seriesCounter] = LabelPC;
							showPlotSeries[seriesCounter] = ShowPC;
							showLabelSeries[seriesCounter] = ShowPCLabel;
							persistSeries[seriesCounter] = persistPC;
							break;
						case YC:
							brushSeries[seriesCounter] = BrushYC;
							labelSeries[seriesCounter] = LabelYC;
							showPlotSeries[seriesCounter] = ShowYC;
							showLabelSeries[seriesCounter] = ShowYCLabel;
							persistSeries[seriesCounter] = persistYC;
							break;
						case M:
							brushSeries[seriesCounter] = BrushM;
							labelSeries[seriesCounter] = LabelM;
							showPlotSeries[seriesCounter] = ShowM;
							showLabelSeries[seriesCounter] = ShowMLabel;
							persistSeries[seriesCounter] = persistM;
							break;
						case PM:
							brushSeries[seriesCounter] = BrushPM;
							labelSeries[seriesCounter] = LabelPM;
							showPlotSeries[seriesCounter] = ShowPM;
							showLabelSeries[seriesCounter] = ShowPMLabel;
							persistSeries[seriesCounter] = persistPM;
							break;
						case YM:
							brushSeries[seriesCounter] = BrushYM;
							labelSeries[seriesCounter] = LabelYM;
							showPlotSeries[seriesCounter] = ShowYM;
							showLabelSeries[seriesCounter] = ShowYMLabel;
							persistSeries[seriesCounter] = persistYM;
							break;
						case VWAP:
							brushSeries[seriesCounter] = BrushVWAP;
							labelSeries[seriesCounter] = LabelVWAP;
							showPlotSeries[seriesCounter] = ShowVWAP;
							showLabelSeries[seriesCounter] = ShowVWAPLabel;
							persistSeries[seriesCounter] = persistVWAP;
							break;
						case PVWAP:
							brushSeries[seriesCounter] = BrushPVWAP;
							labelSeries[seriesCounter] = LabelPVWAP;
							showPlotSeries[seriesCounter] = ShowPVWAP;
							showLabelSeries[seriesCounter] = ShowPVWAPLabel;
							persistSeries[seriesCounter] = persistPVWAP;
							break;
						case YVWAP:
							brushSeries[seriesCounter] = BrushYVWAP;
							labelSeries[seriesCounter] = LabelYVWAP;
							showPlotSeries[seriesCounter] = ShowYVWAP;
							showLabelSeries[seriesCounter] = ShowYVWAPLabel;
							persistSeries[seriesCounter] = persistYVWAP;
							break;
						case SessionVWAP:
							brushSeries[seriesCounter] = BrushSessionVWAP;
							labelSeries[seriesCounter] = LabelSessionVWAP;
							showPlotSeries[seriesCounter] = ShowSessionVWAP;
							showLabelSeries[seriesCounter] = ShowSessionVWAPLabel;
							persistSeries[seriesCounter] = persistSessionVWAP;
							break;						
						case YSessionVWAP:
							brushSeries[seriesCounter] = BrushYSessionVWAP;
							labelSeries[seriesCounter] = LabelYSessionVWAP;
							showPlotSeries[seriesCounter] = ShowYSessionVWAP;
							showLabelSeries[seriesCounter] = ShowYSessionVWAPLabel;
							persistSeries[seriesCounter] = persistYSessionVWAP;
							break;
						case WeekVWAP:
							brushSeries[seriesCounter] = BrushWeekVWAP;
							labelSeries[seriesCounter] = LabelWeekVWAP;
							showPlotSeries[seriesCounter] = ShowWeekVWAP;
							showLabelSeries[seriesCounter] = ShowWeekVWAPLabel;
							persistSeries[seriesCounter] = persistWeekVWAP;
							break;						
						case YWeekVWAP:
							brushSeries[seriesCounter] = BrushYWeekVWAP;
							labelSeries[seriesCounter] = LabelYWeekVWAP;
							showPlotSeries[seriesCounter] = ShowYWeekVWAP;
							showLabelSeries[seriesCounter] = ShowYWeekVWAPLabel;
							persistSeries[seriesCounter] = persistYWeekVWAP;
							break;
					}
				}
				
				//if plots are not being shown, set the plot brushes to transparent.
				
				for (int seriesCounter = 0; seriesCounter < SERIESLENGTH; seriesCounter++)
				{
					if (showPlotSeries[seriesCounter]) Plots[seriesCounter].Brush = brushSeries[seriesCounter];
					else Plots[seriesCounter].Brush = Brushes.Transparent;
				}
				
				//determine number of decimal places to round, based on ticksize of instrument.
				double theTickSize = TickSize;
				roundPlaces = 0;
				theTickSize -= (int)theTickSize; //remove non-decimal portion of tick size
				while (theTickSize > 0)
				{
					roundPlaces++; //increment 1
					theTickSize *= 10; // move decimal to the right by 1
					theTickSize -= (int)theTickSize; //again remove non-decimal portion of running calc
				}
				
			}
		}

		protected override void OnBarUpdate()
		{
			
			if (CurrentBar == 0)
			{
				//setting the time values for the window start and end to absolute date-time values.
				//on the first bar of the chart, set the window start date to this historical day.
				//if the window crosses midnight, then window end is earlier than window day.  So add an extra day to window end.
					WindowStartDateTime = Time[0].Date.Add(WindowStart.TimeOfDay);
					if (WindowStart < WindowEnd) WindowEndDateTime = Time[0].Date.Add(WindowEnd.TimeOfDay);
					else WindowEndDateTime = Time[0].Date.AddDays(1.0).Add(WindowEnd.TimeOfDay);
					
					if (Time[0].CompareTo(WindowStartDateTime) > 0) 
					{
						WindowStartDateTime = WindowStartDateTime.AddDays(1.0);
						WindowEndDateTime = WindowEndDateTime.AddDays(1.0);
					}
					
				
			}
			
			if (CurrentBar > 0) 
			{
				//if the plot value was valid on the last bar, and invalid now, set persist variable
				//so we can use it to plot previous and yesterday plots.
				
				for (int seriesCounter = 0; seriesCounter < SERIESLENGTH; seriesCounter++)
				{
					if (Values[seriesCounter].IsValidDataPoint(1) &&
						!Values[seriesCounter].IsValidDataPoint(0)) 
						persistSeries[seriesCounter] = Values[seriesCounter][1];
				}
				
				//if inWindow.
				if (Time[0].CompareTo(WindowStartDateTime) >= 0
					&& Time[0].CompareTo(WindowEndDateTime) < 0) 
					inWindow = true;
				else inWindow = false;
				
				//at the end of the window, set the window-finishing variables. Will set plots later in update.
				if (Time[0].CompareTo(WindowEndDateTime) >= 0
					&& Time[1].CompareTo(WindowEndDateTime) < 0) 		//End Of Window
					{
						if (!completedFirstSession) completedFirstSession = true;
						lastWindowHigh = currentHigh;
						lastWindowLow = currentLow;
						lastWindowOpen = currentOpen;
						lastWindowClose = Close[1];
						lastWindowMid = currentMid;
						lastWindowVWAP = currentVWAP;
						
					}
					
				if (Bars.IsFirstBarOfSession) //Hand over to new session / new week.
				{
					lastSessionVWAP = currentSessionVWAP;
					sessioniCumVolume = Volume[0];
					sessioniCumTypicalVolume = Volume[0] * ((High[0] + Low[0] + Close[0]) / 3);
					
					int thisDayOfWeek = (int)Time[0].DayOfWeek;
					if (thisDayOfWeek < dayOfWeek)
					{
						lastWeekVWAP = currentWeekVWAP;
						weekiCumVolume = Volume[0];
						weekiCumTypicalVolume = Volume[0] * ((High[0] + Low[0] + Close[0]) / 3);
					}
					
					dayOfWeek = thisDayOfWeek;
					
				}
				
				//only if shown, always calculating session and week VWAPs
				
				if(ShowSessionVWAP || ShowSessionVWAPLabel) {
					sessioniCumVolume = sessioniCumVolume + Volume[0];
					sessioniCumTypicalVolume = sessioniCumTypicalVolume + (Volume[0] * ((High[0] + Low[0] + Close[0]) / 3));
					currentSessionVWAP = Math.Round((sessioniCumTypicalVolume / sessioniCumVolume), roundPlaces);
					PlotSessionVWAP[0] = currentSessionVWAP;
				}
				
				if (ShowWeekVWAP || ShowWeekVWAPLabel) {
					weekiCumVolume = weekiCumVolume + Volume[0];
					weekiCumTypicalVolume = weekiCumTypicalVolume + (Volume[0] * ((High[0] + Low[0] + Close[0]) / 3));
					currentWeekVWAP = Math.Round((weekiCumTypicalVolume / weekiCumVolume), roundPlaces);
					PlotWeekVWAP[0] = currentWeekVWAP;
				}
				
				PlotYSessionVWAP[0] = lastSessionVWAP;
				PlotYWeekVWAP[0] = lastWeekVWAP;
				
				
				if (inWindow)
				{
					//at the start of the window, reset the current value vars. Will set plots later in update.
					if (Time[0].CompareTo(WindowStartDateTime) >= 0
					&& Time[1].CompareTo(WindowStartDateTime) < 0) 		//Start Of Window
					{
						currentHigh = High[0];
						currentLow = Low[0];
						currentOpen = Open[0];
						currentMid = currentLow + Math.Round((currentHigh - currentLow)/2, roundPlaces);
						
						iCumVolume = Volume[0];
						iCumTypicalVolume = Volume[0] * ((High[0] + Low[0] + Close[0]) / 3);
					}
					
					//throughout the window, update all the changing values and set the plots.
					if (High[0] > currentHigh) currentHigh = High[0];
					WindowHigh[0] = currentHigh;
					if (Low[0] < currentLow) currentLow = Low[0];
					WindowLow[0] = currentLow;
					WindowOpen[0] = currentOpen;
					currentMid = currentLow + Math.Round((currentHigh - currentLow)/2, roundPlaces);
					WindowMid[0] = currentMid;
					
					iCumVolume = iCumVolume + Volume[0];
					iCumTypicalVolume = iCumTypicalVolume + (Volume[0] * ((High[0] + Low[0] + Close[0]) / 3));
					currentVWAP = Math.Round((iCumTypicalVolume / iCumVolume), roundPlaces);
					WindowVWAP[0] = currentVWAP;
					
					//as long as one window is complete (you have Y values), set the Y plots.
					if (completedFirstSession) 
					{
						YWindowHigh[0] = lastWindowHigh;
						YWindowLow[0] = lastWindowLow;
						YWindowOpen[0] = lastWindowOpen;
						YWindowClose[0] = lastWindowClose;
						YWindowMid[0] = lastWindowMid;
						YWindowVWAP[0] = lastWindowVWAP;
					}
				}
				
				//this trick should handle most cases of weekends and holidays?  If the window end is in the past, 
				//advance the window by 1 day until both are in the future.
				if (!inWindow) 
				{
					while (Time[0].CompareTo(WindowEndDateTime) > 0) 
					{
						WindowStartDateTime = WindowStartDateTime.AddDays(1.0);
						WindowEndDateTime = WindowEndDateTime.AddDays(1.0);
					}
					//Set the P plots.
					if (completedFirstSession) 
					{
						PWindowHigh[0] = lastWindowHigh;
						PWindowLow[0] = lastWindowLow;
						PWindowOpen[0] = lastWindowOpen;
						PWindowClose[0] = lastWindowClose;
						PWindowMid[0] = lastWindowMid;
						PWindowVWAP[0] = lastWindowVWAP;
					}
					
				}
				
				//if you don't have a value then set to the persist value.
				//this code feels a little sloppy. You shouldn't need to persist all of these... current H/L for example.
				//but, if it ain't broke?
				
				for (int seriesCount = 0; seriesCount < Values.Length; seriesCount++)
				{
					if (Values[seriesCount].IsValidDataPoint(0)) allTheValues[seriesCount] = Values[seriesCount][0];
					else allTheValues[seriesCount] = persistSeries[seriesCount];
				}
				
				//CleanUpSessionBreaks
				if (Bars.BarsSinceNewTradingDay == 0) {
					PlotBrushes[SessionVWAP][0] = Brushes.Transparent;
					PlotBrushes[YSessionVWAP][0] = Brushes.Transparent;
					PlotBrushes[WeekVWAP][0] = Brushes.Transparent;
					PlotBrushes[YWeekVWAP][0] = Brushes.Transparent;
				}
				
			
			}
			
		}
		
		protected override void OnRender(ChartControl chartControl, ChartScale chartScale)
		{
			base.OnRender(chartControl, chartScale);
					// get the ending bar from what is rendered on the chart
		  float endX = chartControl.GetXByBarIndex(ChartBars, ChartBars.ToIndex);
			
		  // Loop through each Plot Values on the chart
		  for (int seriesCount = 0; seriesCount < Values.Length; seriesCount++)
		  {
	//	     get the value at the last bar on the chart (if it has been set)
		    if (Values[seriesCount].IsValidDataPointAt(ChartBars.ToIndex) && showLabelSeries[seriesCount])
		    {
		        double plotValue = Values[seriesCount].GetValueAt(ChartBars.ToIndex);
		 		
		        // convert the plot value to the charts "Y" axis point
		        float chartScaleYValue = chartScale.GetYByValue(plotValue);
		 
		        // calculate the x and y values for the end
		        SharpDX.Vector2 endPoint = new SharpDX.Vector2(endX, chartScaleYValue);
		 
		 
				SharpDX.Direct2D1.Brush dxBrushToUse = brushSeries[seriesCount].ToDxBrush(RenderTarget);
						
		        // use a simplefront text form to draw plot values along the line
	 
				NinjaTrader.Gui.Tools.SimpleFont myFont = new NinjaTrader.Gui.Tools.SimpleFont("Arial", FontSize) { Size = FontSize, Bold = false };
				
				SharpDX.DirectWrite.TextFormat textFormat = myFont.ToDirectWriteTextFormat();
				
		        // calculate the label which will be rendered at each plot using it the label series and the plot price
		        string textToRender;
				if (ShowPriceOnLabels) textToRender = labelSeries[seriesCount] + ": " + plotValue;
				else textToRender = labelSeries[seriesCount];
		 
		        // calculate the layout of the text to be drawn
		        SharpDX.DirectWrite.TextLayout textLayout = new SharpDX.DirectWrite.TextLayout(Core.Globals.DirectWriteFactory,
		          textToRender, textFormat, 200, textFormat.FontSize);
		 		//adjust the position for the label by half the size of the textlayout object.  also push out by 3 pixels for spacing.
				SharpDX.Vector2 endPointAdjusted = new SharpDX.Vector2(endX+3, chartScaleYValue - Convert.ToInt32(Math.Round(textLayout.MaxHeight/2,roundPlaces)));
				
		        // draw the label at each plot using the brushseries SharpDX Brush color at the calculated start point	    
		 		RenderTarget.DrawTextLayout(endPointAdjusted, textLayout, dxBrushToUse);
		        // dipose of the unmanaged resources used
		        textLayout.Dispose();
		        textFormat.Dispose();
		
				
		    }
		  }		
		}
		
		#region Properties
		[NinjaScriptProperty]
		[Display(Name="ShowH", Order=10, GroupName="ShowOHLCPlots")]
		public bool ShowH
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowPH", Order=11, GroupName="ShowOHLCPlots")]
		public bool ShowPH
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYH", Order=12, GroupName="ShowOHLCPlots")]
		public bool ShowYH
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowL", Order=10, GroupName="ShowOHLCPlots")]
		public bool ShowL
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowPL", Order=11, GroupName="ShowOHLCPlots")]
		public bool ShowPL
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYL", Order=12, GroupName="ShowOHLCPlots")]
		public bool ShowYL
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowO", Order=10, GroupName="ShowOHLCPlots")]
		public bool ShowO
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowPO", Order=11, GroupName="ShowOHLCPlots")]
		public bool ShowPO
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYO", Order=12, GroupName="ShowOHLCPlots")]
		public bool ShowYO
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowPC", Order=11, GroupName="ShowOHLCPlots")]
		public bool ShowPC
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYC", Order=12, GroupName="ShowOHLCPlots")]
		public bool ShowYC
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowM", Order=10, GroupName="ShowRangePlots")]
		public bool ShowM
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowPM", Order=11, GroupName="ShowRangePlots")]
		public bool ShowPM
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYM", Order=12, GroupName="ShowRangePlots")]
		public bool ShowYM
		{ get; set; }
		
	
		
		[NinjaScriptProperty]
		[Display(Name="ShowVWAP", Order=10, GroupName="ShowVWAPPlots")]
		public bool ShowVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowPVWAP", Order=11, GroupName="ShowVWAPPlots")]
		public bool ShowPVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYVWAP", Order=12, GroupName="ShowVWAPPlots")]
		public bool ShowYVWAP
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowSessionVWAP", Order=13, GroupName="ShowVWAPPlots")]
		public bool ShowSessionVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYSessionVWAP", Order=14, GroupName="ShowVWAPPlots")]
		public bool ShowYSessionVWAP
		{ get; set; }
		
		
		[NinjaScriptProperty]
		[Display(Name="ShowWeekVWAP", Order=15, GroupName="ShowVWAPPlots")]
		public bool ShowWeekVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowYWeekVWAP", Order=16, GroupName="ShowVWAPPlots")]
		public bool ShowYWeekVWAP
		{ get; set; }
		
		
		[NinjaScriptProperty]
		[Display(Name="LabelH", Order=40, GroupName="OHLCLabels")]
		public string LabelH
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelPH", Order=41, GroupName="OHLCLabels")]
		public string LabelPH
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYH", Order=42, GroupName="OHLCLabels")]
		public string LabelYH
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="LabelL", Order=40, GroupName="OHLCLabels")]
		public string LabelL
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelPL", Order=41, GroupName="OHLCLabels")]
		public string LabelPL
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYL", Order=42, GroupName="OHLCLabels")]
		public string LabelYL
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="LabelO", Order=40, GroupName="OHLCLabels")]
		public string LabelO
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelPO", Order=41, GroupName="OHLCLabels")]
		public string LabelPO
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYO", Order=42, GroupName="OHLCLabels")]
		public string LabelYO
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="LabelPC", Order=41, GroupName="OHLCLabels")]
		public string LabelPC
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYC", Order=42, GroupName="OHLCLabels")]
		public string LabelYC
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="LabelM", Order=40, GroupName="RangeLabels")]
		public string LabelM
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelPM", Order=41, GroupName="RangeLabels")]
		public string LabelPM
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYM", Order=42, GroupName="RangeLabels")]
		public string LabelYM
		{ get; set; }

		
		[NinjaScriptProperty]
		[Display(Name="LabelVWAP", Order=40, GroupName="VWAPLabels")]
		public string LabelVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelPVWAP", Order=41, GroupName="VWAPLabels")]
		public string LabelPVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYVWAP", Order=42, GroupName="VWAPLabels")]
		public string LabelYVWAP
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="LabelSessionVWAP", Order=43, GroupName="VWAPLabels")]
		public string LabelSessionVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYSessionVWAP", Order=44, GroupName="VWAPLabels")]
		public string LabelYSessionVWAP
		{ get; set; }
		
		
		[NinjaScriptProperty]
		[Display(Name="LabelWeekVWAP", Order=45, GroupName="VWAPLabels")]
		public string LabelWeekVWAP
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="LabelYWeekVWAP", Order=46, GroupName="VWAPLabels")]
		public string LabelYWeekVWAP
		{ get; set; }		
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="FontSize", Order=1, GroupName="Parameters")]
		public int FontSize
		{ get; set; }

		[NinjaScriptProperty]
		[PropertyEditor("NinjaTrader.Gui.Tools.TimeEditorKey")]
		[Display(Name="WindowStart", Order=2, GroupName="Parameters")]
		public DateTime WindowStart
		{ get; set; }

		[NinjaScriptProperty]
		[PropertyEditor("NinjaTrader.Gui.Tools.TimeEditorKey")]
		[Display(Name="WindowEnd", Order=3, GroupName="Parameters")]
		public DateTime WindowEnd
		{ get; set; }

		[NinjaScriptProperty]
		[Display(Name="ShowHLabel", Order=70, GroupName="ShowOHLCLabels")]
		public bool ShowHLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowPHLabel", Order=71, GroupName="ShowOHLCLabels")]
		public bool ShowPHLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYHLabel", Order=72, GroupName="ShowOHLCLabels")]
		public bool ShowYHLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowLLabel", Order=70, GroupName="ShowOHLCLabels")]
		public bool ShowLLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowPLLabel", Order=71, GroupName="ShowOHLCLabels")]
		public bool ShowPLLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYLLabel", Order=72, GroupName="ShowOHLCLabels")]
		public bool ShowYLLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowOLabel", Order=70, GroupName="ShowOHLCLabels")]
		public bool ShowOLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowPOLabel", Order=71, GroupName="ShowOHLCLabels")]
		public bool ShowPOLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYOLabel", Order=72, GroupName="ShowOHLCLabels")]
		public bool ShowYOLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowPCLabel", Order=71, GroupName="ShowOHLCLabels")]
		public bool ShowPCLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYCLabel", Order=72, GroupName="ShowOHLCLabels")]
		public bool ShowYCLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowMLabel", Order=70, GroupName="ShowRangeLabels")]
		public bool ShowMLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowPMLabel", Order=71, GroupName="ShowRangeLabels")]
		public bool ShowPMLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYMLabel", Order=72, GroupName="ShowRangeLabels")]
		public bool ShowYMLabel
		{ get; set; }
		
		
		
		[NinjaScriptProperty]
		[Display(Name="ShowVWAPLabel", Order=70, GroupName="ShowVWAPLabels")]
		public bool ShowVWAPLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowPVWAPLabel", Order=71, GroupName="ShowVWAPLabels")]
		public bool ShowPVWAPLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYVWAPLabel", Order=72, GroupName="ShowVWAPLabels")]
		public bool ShowYVWAPLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowSessionVWAPLabel", Order=73, GroupName="ShowVWAPLabels")]
		public bool ShowSessionVWAPLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYSessionVWAPLabel", Order=74, GroupName="ShowVWAPLabels")]
		public bool ShowYSessionVWAPLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowWeekVWAPLabel", Order=75, GroupName="ShowVWAPLabels")]
		public bool ShowWeekVWAPLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowYWeekVWAPLabel", Order=76, GroupName="ShowVWAPLabels")]
		public bool ShowYWeekVWAPLabel
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(Name="ShowPriceOnLabels", Order=69, GroupName="Parameters")]
		public bool ShowPriceOnLabels
		{ get; set; }

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> WindowHigh
		{
			get { return Values[H]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PWindowHigh
		{
			get { return Values[PH]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> YWindowHigh
		{
			get { return Values[YH]; }
		}
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> WindowLow
		{
			get { return Values[L]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PWindowLow
		{
			get { return Values[PL]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> YWindowLow
		{
			get { return Values[YL]; }
		}
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> WindowOpen
		{
			get { return Values[O]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PWindowOpen
		{
			get { return Values[PO]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> YWindowOpen
		{
			get { return Values[YO]; }
		}
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PWindowClose
		{
			get { return Values[PC]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> YWindowClose
		{
			get { return Values[YC]; }
		}
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> WindowMid
		{
			get { return Values[M]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PWindowMid
		{
			get { return Values[PM]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> YWindowMid
		{
			get { return Values[YM]; }
		}
		
		
		
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> WindowVWAP
		{
			get { return Values[VWAP]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PWindowVWAP
		{
			get { return Values[PVWAP]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> YWindowVWAP
		{
			get { return Values[YVWAP]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PlotSessionVWAP
		{
			get { return Values[SessionVWAP]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PlotYSessionVWAP
		{
			get { return Values[YSessionVWAP]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PlotWeekVWAP
		{
			get { return Values[WeekVWAP]; }
		}
		[Browsable(false)]
		[XmlIgnore]
		public Series<double> PlotYWeekVWAP
		{
			get { return Values[YWeekVWAP]; }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushH", GroupName = "OHLCColors", Order = 100)]
		public Brush BrushH
		{ get; set; }
		
		[Browsable(false)]
		public string BrushHSerialize
		{
			get { return Serialize.BrushToString(BrushH); }
   			set { BrushH = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushPH", GroupName = "OHLCColors", Order = 101)]
		public Brush BrushPH
		{ get; set; }
		
		[Browsable(false)]
		public string BrushPHSerialize
		{
			get { return Serialize.BrushToString(BrushPH); }
   			set { BrushPH = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushYH", GroupName = "OHLCColors", Order = 102)]
		public Brush BrushYH
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYHSerialize
		{
			get { return Serialize.BrushToString(BrushYH); }
   			set { BrushYH = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushL", GroupName = "OHLCColors", Order = 100)]
		public Brush BrushL
		{ get; set; }
		
		[Browsable(false)]
		public string BrushLSerialize
		{
			get { return Serialize.BrushToString(BrushL); }
   			set { BrushL = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushPL", GroupName = "OHLCColors", Order = 101)]
		public Brush BrushPL
		{ get; set; }
		
		[Browsable(false)]
		public string BrushPLSerialize
		{
			get { return Serialize.BrushToString(BrushPL); }
   			set { BrushPL = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushYL", GroupName = "OHLCColors", Order = 102)]
		public Brush BrushYL
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYLSerialize
		{
			get { return Serialize.BrushToString(BrushYL); }
   			set { BrushYL = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushO", GroupName = "OHLCColors", Order = 100)]
		public Brush BrushO
		{ get; set; }
		
		[Browsable(false)]
		public string BrushOSerialize
		{
			get { return Serialize.BrushToString(BrushO); }
   			set { BrushO = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushPO", GroupName = "OHLCColors", Order = 101)]
		public Brush BrushPO
		{ get; set; }
		
		[Browsable(false)]
		public string BrushPOSerialize
		{
			get { return Serialize.BrushToString(BrushPO); }
   			set { BrushPO = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushYO", GroupName = "OHLCColors", Order = 102)]
		public Brush BrushYO
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYOSerialize
		{
			get { return Serialize.BrushToString(BrushYO); }
   			set { BrushYO = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushPC", GroupName = "OHLCColors", Order = 101)]
		public Brush BrushPC
		{ get; set; }
		
		[Browsable(false)]
		public string BrushPCSerialize
		{
			get { return Serialize.BrushToString(BrushPC); }
   			set { BrushPC = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushYC", GroupName = "OHLCColors", Order = 102)]
		public Brush BrushYC
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYCSerialize
		{
			get { return Serialize.BrushToString(BrushYC); }
   			set { BrushYC = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushM", GroupName = "RangeColors", Order = 100)]
		public Brush BrushM
		{ get; set; }
		
		[Browsable(false)]
		public string BrushMSerialize
		{
			get { return Serialize.BrushToString(BrushM); }
   			set { BrushM = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushPM", GroupName = "RangeColors", Order = 101)]
		public Brush BrushPM
		{ get; set; }
		
		[Browsable(false)]
		public string BrushPMSerialize
		{
			get { return Serialize.BrushToString(BrushPM); }
   			set { BrushPM = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "BrushYM", GroupName = "RangeColors", Order = 102)]
		public Brush BrushYM
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYMSerialize
		{
			get { return Serialize.BrushToString(BrushYM); }
   			set { BrushYM = Serialize.StringToBrush(value); }
		}
		
	
		[XmlIgnore()]
		[Display(Name = "BrushVWAP", GroupName = "VWAPColors", Order = 102)]
		public Brush BrushVWAP
		{ get; set; }
		
		[Browsable(false)]
		public string BrushVWAPSerialize
		{
			get { return Serialize.BrushToString(BrushVWAP); }
   			set { BrushVWAP = Serialize.StringToBrush(value); }
		}
		
				[XmlIgnore()]
		[Display(Name = "BrushPVWAP", GroupName = "VWAPColors", Order = 103)]
		public Brush BrushPVWAP
		{ get; set; }
		
		[Browsable(false)]
		public string BrushPVWAPSerialize
		{
			get { return Serialize.BrushToString(BrushPVWAP); }
   			set { BrushPVWAP = Serialize.StringToBrush(value); }
		}
		
						[XmlIgnore()]
		[Display(Name = "BrushYVWAP", GroupName = "VWAPColors", Order = 104)]
		public Brush BrushYVWAP
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYVWAPSerialize
		{
			get { return Serialize.BrushToString(BrushYVWAP); }
   			set { BrushYVWAP = Serialize.StringToBrush(value); }
		}
		[XmlIgnore()]
		[Display(Name = "BrushSessionVWAP", GroupName = "VWAPColors", Order = 105)]
		public Brush BrushSessionVWAP
		{ get; set; }
		
		[Browsable(false)]
		public string BrushSessionVWAPSerialize
		{
			get { return Serialize.BrushToString(BrushSessionVWAP); }
   			set { BrushSessionVWAP = Serialize.StringToBrush(value); }
		}
		[XmlIgnore()]
		[Display(Name = "BrushYSessionVWAP", GroupName = "VWAPColors", Order = 106)]
		public Brush BrushYSessionVWAP
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYSessionVWAPSerialize
		{
			get { return Serialize.BrushToString(BrushYSessionVWAP); }
   			set { BrushYSessionVWAP = Serialize.StringToBrush(value); }
		}
		[XmlIgnore()]
		[Display(Name = "BrushWeekVWAP", GroupName = "VWAPColors", Order = 107)]
		public Brush BrushWeekVWAP
		{ get; set; }
		
		[Browsable(false)]
		public string BrushWeekVWAPSerialize
		{
			get { return Serialize.BrushToString(BrushWeekVWAP); }
   			set { BrushWeekVWAP = Serialize.StringToBrush(value); }
		}
		[XmlIgnore()]
		[Display(Name = "BrushYWeekVWAP", GroupName = "VWAPColors", Order = 108)]
		public Brush BrushYWeekVWAP
		{ get; set; }
		
		[Browsable(false)]
		public string BrushYWeekVWAPSerialize
		{
			get { return Serialize.BrushToString(BrushYWeekVWAP); }
   			set { BrushYWeekVWAP = Serialize.StringToBrush(value); }
		}
		

		
		#endregion

	}
	
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private fm.fmLotsOLevels02[] cachefmLotsOLevels02;
		public fm.fmLotsOLevels02 fmLotsOLevels02(bool showH, bool showPH, bool showYH, bool showL, bool showPL, bool showYL, bool showO, bool showPO, bool showYO, bool showPC, bool showYC, bool showM, bool showPM, bool showYM, bool showVWAP, bool showPVWAP, bool showYVWAP, bool showSessionVWAP, bool showYSessionVWAP, bool showWeekVWAP, bool showYWeekVWAP, string labelH, string labelPH, string labelYH, string labelL, string labelPL, string labelYL, string labelO, string labelPO, string labelYO, string labelPC, string labelYC, string labelM, string labelPM, string labelYM, string labelVWAP, string labelPVWAP, string labelYVWAP, string labelSessionVWAP, string labelYSessionVWAP, string labelWeekVWAP, string labelYWeekVWAP, int fontSize, DateTime windowStart, DateTime windowEnd, bool showHLabel, bool showPHLabel, bool showYHLabel, bool showLLabel, bool showPLLabel, bool showYLLabel, bool showOLabel, bool showPOLabel, bool showYOLabel, bool showPCLabel, bool showYCLabel, bool showMLabel, bool showPMLabel, bool showYMLabel, bool showVWAPLabel, bool showPVWAPLabel, bool showYVWAPLabel, bool showSessionVWAPLabel, bool showYSessionVWAPLabel, bool showWeekVWAPLabel, bool showYWeekVWAPLabel, bool showPriceOnLabels)
		{
			return fmLotsOLevels02(Input, showH, showPH, showYH, showL, showPL, showYL, showO, showPO, showYO, showPC, showYC, showM, showPM, showYM, showVWAP, showPVWAP, showYVWAP, showSessionVWAP, showYSessionVWAP, showWeekVWAP, showYWeekVWAP, labelH, labelPH, labelYH, labelL, labelPL, labelYL, labelO, labelPO, labelYO, labelPC, labelYC, labelM, labelPM, labelYM, labelVWAP, labelPVWAP, labelYVWAP, labelSessionVWAP, labelYSessionVWAP, labelWeekVWAP, labelYWeekVWAP, fontSize, windowStart, windowEnd, showHLabel, showPHLabel, showYHLabel, showLLabel, showPLLabel, showYLLabel, showOLabel, showPOLabel, showYOLabel, showPCLabel, showYCLabel, showMLabel, showPMLabel, showYMLabel, showVWAPLabel, showPVWAPLabel, showYVWAPLabel, showSessionVWAPLabel, showYSessionVWAPLabel, showWeekVWAPLabel, showYWeekVWAPLabel, showPriceOnLabels);
		}

		public fm.fmLotsOLevels02 fmLotsOLevels02(ISeries<double> input, bool showH, bool showPH, bool showYH, bool showL, bool showPL, bool showYL, bool showO, bool showPO, bool showYO, bool showPC, bool showYC, bool showM, bool showPM, bool showYM, bool showVWAP, bool showPVWAP, bool showYVWAP, bool showSessionVWAP, bool showYSessionVWAP, bool showWeekVWAP, bool showYWeekVWAP, string labelH, string labelPH, string labelYH, string labelL, string labelPL, string labelYL, string labelO, string labelPO, string labelYO, string labelPC, string labelYC, string labelM, string labelPM, string labelYM, string labelVWAP, string labelPVWAP, string labelYVWAP, string labelSessionVWAP, string labelYSessionVWAP, string labelWeekVWAP, string labelYWeekVWAP, int fontSize, DateTime windowStart, DateTime windowEnd, bool showHLabel, bool showPHLabel, bool showYHLabel, bool showLLabel, bool showPLLabel, bool showYLLabel, bool showOLabel, bool showPOLabel, bool showYOLabel, bool showPCLabel, bool showYCLabel, bool showMLabel, bool showPMLabel, bool showYMLabel, bool showVWAPLabel, bool showPVWAPLabel, bool showYVWAPLabel, bool showSessionVWAPLabel, bool showYSessionVWAPLabel, bool showWeekVWAPLabel, bool showYWeekVWAPLabel, bool showPriceOnLabels)
		{
			if (cachefmLotsOLevels02 != null)
				for (int idx = 0; idx < cachefmLotsOLevels02.Length; idx++)
					if (cachefmLotsOLevels02[idx] != null && cachefmLotsOLevels02[idx].ShowH == showH && cachefmLotsOLevels02[idx].ShowPH == showPH && cachefmLotsOLevels02[idx].ShowYH == showYH && cachefmLotsOLevels02[idx].ShowL == showL && cachefmLotsOLevels02[idx].ShowPL == showPL && cachefmLotsOLevels02[idx].ShowYL == showYL && cachefmLotsOLevels02[idx].ShowO == showO && cachefmLotsOLevels02[idx].ShowPO == showPO && cachefmLotsOLevels02[idx].ShowYO == showYO && cachefmLotsOLevels02[idx].ShowPC == showPC && cachefmLotsOLevels02[idx].ShowYC == showYC && cachefmLotsOLevels02[idx].ShowM == showM && cachefmLotsOLevels02[idx].ShowPM == showPM && cachefmLotsOLevels02[idx].ShowYM == showYM && cachefmLotsOLevels02[idx].ShowVWAP == showVWAP && cachefmLotsOLevels02[idx].ShowPVWAP == showPVWAP && cachefmLotsOLevels02[idx].ShowYVWAP == showYVWAP && cachefmLotsOLevels02[idx].ShowSessionVWAP == showSessionVWAP && cachefmLotsOLevels02[idx].ShowYSessionVWAP == showYSessionVWAP && cachefmLotsOLevels02[idx].ShowWeekVWAP == showWeekVWAP && cachefmLotsOLevels02[idx].ShowYWeekVWAP == showYWeekVWAP && cachefmLotsOLevels02[idx].LabelH == labelH && cachefmLotsOLevels02[idx].LabelPH == labelPH && cachefmLotsOLevels02[idx].LabelYH == labelYH && cachefmLotsOLevels02[idx].LabelL == labelL && cachefmLotsOLevels02[idx].LabelPL == labelPL && cachefmLotsOLevels02[idx].LabelYL == labelYL && cachefmLotsOLevels02[idx].LabelO == labelO && cachefmLotsOLevels02[idx].LabelPO == labelPO && cachefmLotsOLevels02[idx].LabelYO == labelYO && cachefmLotsOLevels02[idx].LabelPC == labelPC && cachefmLotsOLevels02[idx].LabelYC == labelYC && cachefmLotsOLevels02[idx].LabelM == labelM && cachefmLotsOLevels02[idx].LabelPM == labelPM && cachefmLotsOLevels02[idx].LabelYM == labelYM && cachefmLotsOLevels02[idx].LabelVWAP == labelVWAP && cachefmLotsOLevels02[idx].LabelPVWAP == labelPVWAP && cachefmLotsOLevels02[idx].LabelYVWAP == labelYVWAP && cachefmLotsOLevels02[idx].LabelSessionVWAP == labelSessionVWAP && cachefmLotsOLevels02[idx].LabelYSessionVWAP == labelYSessionVWAP && cachefmLotsOLevels02[idx].LabelWeekVWAP == labelWeekVWAP && cachefmLotsOLevels02[idx].LabelYWeekVWAP == labelYWeekVWAP && cachefmLotsOLevels02[idx].FontSize == fontSize && cachefmLotsOLevels02[idx].WindowStart == windowStart && cachefmLotsOLevels02[idx].WindowEnd == windowEnd && cachefmLotsOLevels02[idx].ShowHLabel == showHLabel && cachefmLotsOLevels02[idx].ShowPHLabel == showPHLabel && cachefmLotsOLevels02[idx].ShowYHLabel == showYHLabel && cachefmLotsOLevels02[idx].ShowLLabel == showLLabel && cachefmLotsOLevels02[idx].ShowPLLabel == showPLLabel && cachefmLotsOLevels02[idx].ShowYLLabel == showYLLabel && cachefmLotsOLevels02[idx].ShowOLabel == showOLabel && cachefmLotsOLevels02[idx].ShowPOLabel == showPOLabel && cachefmLotsOLevels02[idx].ShowYOLabel == showYOLabel && cachefmLotsOLevels02[idx].ShowPCLabel == showPCLabel && cachefmLotsOLevels02[idx].ShowYCLabel == showYCLabel && cachefmLotsOLevels02[idx].ShowMLabel == showMLabel && cachefmLotsOLevels02[idx].ShowPMLabel == showPMLabel && cachefmLotsOLevels02[idx].ShowYMLabel == showYMLabel && cachefmLotsOLevels02[idx].ShowVWAPLabel == showVWAPLabel && cachefmLotsOLevels02[idx].ShowPVWAPLabel == showPVWAPLabel && cachefmLotsOLevels02[idx].ShowYVWAPLabel == showYVWAPLabel && cachefmLotsOLevels02[idx].ShowSessionVWAPLabel == showSessionVWAPLabel && cachefmLotsOLevels02[idx].ShowYSessionVWAPLabel == showYSessionVWAPLabel && cachefmLotsOLevels02[idx].ShowWeekVWAPLabel == showWeekVWAPLabel && cachefmLotsOLevels02[idx].ShowYWeekVWAPLabel == showYWeekVWAPLabel && cachefmLotsOLevels02[idx].ShowPriceOnLabels == showPriceOnLabels && cachefmLotsOLevels02[idx].EqualsInput(input))
						return cachefmLotsOLevels02[idx];
			return CacheIndicator<fm.fmLotsOLevels02>(new fm.fmLotsOLevels02(){ ShowH = showH, ShowPH = showPH, ShowYH = showYH, ShowL = showL, ShowPL = showPL, ShowYL = showYL, ShowO = showO, ShowPO = showPO, ShowYO = showYO, ShowPC = showPC, ShowYC = showYC, ShowM = showM, ShowPM = showPM, ShowYM = showYM, ShowVWAP = showVWAP, ShowPVWAP = showPVWAP, ShowYVWAP = showYVWAP, ShowSessionVWAP = showSessionVWAP, ShowYSessionVWAP = showYSessionVWAP, ShowWeekVWAP = showWeekVWAP, ShowYWeekVWAP = showYWeekVWAP, LabelH = labelH, LabelPH = labelPH, LabelYH = labelYH, LabelL = labelL, LabelPL = labelPL, LabelYL = labelYL, LabelO = labelO, LabelPO = labelPO, LabelYO = labelYO, LabelPC = labelPC, LabelYC = labelYC, LabelM = labelM, LabelPM = labelPM, LabelYM = labelYM, LabelVWAP = labelVWAP, LabelPVWAP = labelPVWAP, LabelYVWAP = labelYVWAP, LabelSessionVWAP = labelSessionVWAP, LabelYSessionVWAP = labelYSessionVWAP, LabelWeekVWAP = labelWeekVWAP, LabelYWeekVWAP = labelYWeekVWAP, FontSize = fontSize, WindowStart = windowStart, WindowEnd = windowEnd, ShowHLabel = showHLabel, ShowPHLabel = showPHLabel, ShowYHLabel = showYHLabel, ShowLLabel = showLLabel, ShowPLLabel = showPLLabel, ShowYLLabel = showYLLabel, ShowOLabel = showOLabel, ShowPOLabel = showPOLabel, ShowYOLabel = showYOLabel, ShowPCLabel = showPCLabel, ShowYCLabel = showYCLabel, ShowMLabel = showMLabel, ShowPMLabel = showPMLabel, ShowYMLabel = showYMLabel, ShowVWAPLabel = showVWAPLabel, ShowPVWAPLabel = showPVWAPLabel, ShowYVWAPLabel = showYVWAPLabel, ShowSessionVWAPLabel = showSessionVWAPLabel, ShowYSessionVWAPLabel = showYSessionVWAPLabel, ShowWeekVWAPLabel = showWeekVWAPLabel, ShowYWeekVWAPLabel = showYWeekVWAPLabel, ShowPriceOnLabels = showPriceOnLabels }, input, ref cachefmLotsOLevels02);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.fm.fmLotsOLevels02 fmLotsOLevels02(bool showH, bool showPH, bool showYH, bool showL, bool showPL, bool showYL, bool showO, bool showPO, bool showYO, bool showPC, bool showYC, bool showM, bool showPM, bool showYM, bool showVWAP, bool showPVWAP, bool showYVWAP, bool showSessionVWAP, bool showYSessionVWAP, bool showWeekVWAP, bool showYWeekVWAP, string labelH, string labelPH, string labelYH, string labelL, string labelPL, string labelYL, string labelO, string labelPO, string labelYO, string labelPC, string labelYC, string labelM, string labelPM, string labelYM, string labelVWAP, string labelPVWAP, string labelYVWAP, string labelSessionVWAP, string labelYSessionVWAP, string labelWeekVWAP, string labelYWeekVWAP, int fontSize, DateTime windowStart, DateTime windowEnd, bool showHLabel, bool showPHLabel, bool showYHLabel, bool showLLabel, bool showPLLabel, bool showYLLabel, bool showOLabel, bool showPOLabel, bool showYOLabel, bool showPCLabel, bool showYCLabel, bool showMLabel, bool showPMLabel, bool showYMLabel, bool showVWAPLabel, bool showPVWAPLabel, bool showYVWAPLabel, bool showSessionVWAPLabel, bool showYSessionVWAPLabel, bool showWeekVWAPLabel, bool showYWeekVWAPLabel, bool showPriceOnLabels)
		{
			return indicator.fmLotsOLevels02(Input, showH, showPH, showYH, showL, showPL, showYL, showO, showPO, showYO, showPC, showYC, showM, showPM, showYM, showVWAP, showPVWAP, showYVWAP, showSessionVWAP, showYSessionVWAP, showWeekVWAP, showYWeekVWAP, labelH, labelPH, labelYH, labelL, labelPL, labelYL, labelO, labelPO, labelYO, labelPC, labelYC, labelM, labelPM, labelYM, labelVWAP, labelPVWAP, labelYVWAP, labelSessionVWAP, labelYSessionVWAP, labelWeekVWAP, labelYWeekVWAP, fontSize, windowStart, windowEnd, showHLabel, showPHLabel, showYHLabel, showLLabel, showPLLabel, showYLLabel, showOLabel, showPOLabel, showYOLabel, showPCLabel, showYCLabel, showMLabel, showPMLabel, showYMLabel, showVWAPLabel, showPVWAPLabel, showYVWAPLabel, showSessionVWAPLabel, showYSessionVWAPLabel, showWeekVWAPLabel, showYWeekVWAPLabel, showPriceOnLabels);
		}

		public Indicators.fm.fmLotsOLevels02 fmLotsOLevels02(ISeries<double> input , bool showH, bool showPH, bool showYH, bool showL, bool showPL, bool showYL, bool showO, bool showPO, bool showYO, bool showPC, bool showYC, bool showM, bool showPM, bool showYM, bool showVWAP, bool showPVWAP, bool showYVWAP, bool showSessionVWAP, bool showYSessionVWAP, bool showWeekVWAP, bool showYWeekVWAP, string labelH, string labelPH, string labelYH, string labelL, string labelPL, string labelYL, string labelO, string labelPO, string labelYO, string labelPC, string labelYC, string labelM, string labelPM, string labelYM, string labelVWAP, string labelPVWAP, string labelYVWAP, string labelSessionVWAP, string labelYSessionVWAP, string labelWeekVWAP, string labelYWeekVWAP, int fontSize, DateTime windowStart, DateTime windowEnd, bool showHLabel, bool showPHLabel, bool showYHLabel, bool showLLabel, bool showPLLabel, bool showYLLabel, bool showOLabel, bool showPOLabel, bool showYOLabel, bool showPCLabel, bool showYCLabel, bool showMLabel, bool showPMLabel, bool showYMLabel, bool showVWAPLabel, bool showPVWAPLabel, bool showYVWAPLabel, bool showSessionVWAPLabel, bool showYSessionVWAPLabel, bool showWeekVWAPLabel, bool showYWeekVWAPLabel, bool showPriceOnLabels)
		{
			return indicator.fmLotsOLevels02(input, showH, showPH, showYH, showL, showPL, showYL, showO, showPO, showYO, showPC, showYC, showM, showPM, showYM, showVWAP, showPVWAP, showYVWAP, showSessionVWAP, showYSessionVWAP, showWeekVWAP, showYWeekVWAP, labelH, labelPH, labelYH, labelL, labelPL, labelYL, labelO, labelPO, labelYO, labelPC, labelYC, labelM, labelPM, labelYM, labelVWAP, labelPVWAP, labelYVWAP, labelSessionVWAP, labelYSessionVWAP, labelWeekVWAP, labelYWeekVWAP, fontSize, windowStart, windowEnd, showHLabel, showPHLabel, showYHLabel, showLLabel, showPLLabel, showYLLabel, showOLabel, showPOLabel, showYOLabel, showPCLabel, showYCLabel, showMLabel, showPMLabel, showYMLabel, showVWAPLabel, showPVWAPLabel, showYVWAPLabel, showSessionVWAPLabel, showYSessionVWAPLabel, showWeekVWAPLabel, showYWeekVWAPLabel, showPriceOnLabels);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.fm.fmLotsOLevels02 fmLotsOLevels02(bool showH, bool showPH, bool showYH, bool showL, bool showPL, bool showYL, bool showO, bool showPO, bool showYO, bool showPC, bool showYC, bool showM, bool showPM, bool showYM, bool showVWAP, bool showPVWAP, bool showYVWAP, bool showSessionVWAP, bool showYSessionVWAP, bool showWeekVWAP, bool showYWeekVWAP, string labelH, string labelPH, string labelYH, string labelL, string labelPL, string labelYL, string labelO, string labelPO, string labelYO, string labelPC, string labelYC, string labelM, string labelPM, string labelYM, string labelVWAP, string labelPVWAP, string labelYVWAP, string labelSessionVWAP, string labelYSessionVWAP, string labelWeekVWAP, string labelYWeekVWAP, int fontSize, DateTime windowStart, DateTime windowEnd, bool showHLabel, bool showPHLabel, bool showYHLabel, bool showLLabel, bool showPLLabel, bool showYLLabel, bool showOLabel, bool showPOLabel, bool showYOLabel, bool showPCLabel, bool showYCLabel, bool showMLabel, bool showPMLabel, bool showYMLabel, bool showVWAPLabel, bool showPVWAPLabel, bool showYVWAPLabel, bool showSessionVWAPLabel, bool showYSessionVWAPLabel, bool showWeekVWAPLabel, bool showYWeekVWAPLabel, bool showPriceOnLabels)
		{
			return indicator.fmLotsOLevels02(Input, showH, showPH, showYH, showL, showPL, showYL, showO, showPO, showYO, showPC, showYC, showM, showPM, showYM, showVWAP, showPVWAP, showYVWAP, showSessionVWAP, showYSessionVWAP, showWeekVWAP, showYWeekVWAP, labelH, labelPH, labelYH, labelL, labelPL, labelYL, labelO, labelPO, labelYO, labelPC, labelYC, labelM, labelPM, labelYM, labelVWAP, labelPVWAP, labelYVWAP, labelSessionVWAP, labelYSessionVWAP, labelWeekVWAP, labelYWeekVWAP, fontSize, windowStart, windowEnd, showHLabel, showPHLabel, showYHLabel, showLLabel, showPLLabel, showYLLabel, showOLabel, showPOLabel, showYOLabel, showPCLabel, showYCLabel, showMLabel, showPMLabel, showYMLabel, showVWAPLabel, showPVWAPLabel, showYVWAPLabel, showSessionVWAPLabel, showYSessionVWAPLabel, showWeekVWAPLabel, showYWeekVWAPLabel, showPriceOnLabels);
		}

		public Indicators.fm.fmLotsOLevels02 fmLotsOLevels02(ISeries<double> input , bool showH, bool showPH, bool showYH, bool showL, bool showPL, bool showYL, bool showO, bool showPO, bool showYO, bool showPC, bool showYC, bool showM, bool showPM, bool showYM, bool showVWAP, bool showPVWAP, bool showYVWAP, bool showSessionVWAP, bool showYSessionVWAP, bool showWeekVWAP, bool showYWeekVWAP, string labelH, string labelPH, string labelYH, string labelL, string labelPL, string labelYL, string labelO, string labelPO, string labelYO, string labelPC, string labelYC, string labelM, string labelPM, string labelYM, string labelVWAP, string labelPVWAP, string labelYVWAP, string labelSessionVWAP, string labelYSessionVWAP, string labelWeekVWAP, string labelYWeekVWAP, int fontSize, DateTime windowStart, DateTime windowEnd, bool showHLabel, bool showPHLabel, bool showYHLabel, bool showLLabel, bool showPLLabel, bool showYLLabel, bool showOLabel, bool showPOLabel, bool showYOLabel, bool showPCLabel, bool showYCLabel, bool showMLabel, bool showPMLabel, bool showYMLabel, bool showVWAPLabel, bool showPVWAPLabel, bool showYVWAPLabel, bool showSessionVWAPLabel, bool showYSessionVWAPLabel, bool showWeekVWAPLabel, bool showYWeekVWAPLabel, bool showPriceOnLabels)
		{
			return indicator.fmLotsOLevels02(input, showH, showPH, showYH, showL, showPL, showYL, showO, showPO, showYO, showPC, showYC, showM, showPM, showYM, showVWAP, showPVWAP, showYVWAP, showSessionVWAP, showYSessionVWAP, showWeekVWAP, showYWeekVWAP, labelH, labelPH, labelYH, labelL, labelPL, labelYL, labelO, labelPO, labelYO, labelPC, labelYC, labelM, labelPM, labelYM, labelVWAP, labelPVWAP, labelYVWAP, labelSessionVWAP, labelYSessionVWAP, labelWeekVWAP, labelYWeekVWAP, fontSize, windowStart, windowEnd, showHLabel, showPHLabel, showYHLabel, showLLabel, showPLLabel, showYLLabel, showOLabel, showPOLabel, showYOLabel, showPCLabel, showYCLabel, showMLabel, showPMLabel, showYMLabel, showVWAPLabel, showPVWAPLabel, showYVWAPLabel, showSessionVWAPLabel, showYSessionVWAPLabel, showWeekVWAPLabel, showYWeekVWAPLabel, showPriceOnLabels);
		}
	}
}

#endregion
