//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private SmartBook[] cacheSmartBook = null;

        private static SmartBook checkSmartBook = new SmartBook();

        /// <summary>
        /// Limit Orders Map Community Edition Version: 1.0.0 Releaese: 20151209-1019 for beta testing
        /// </summary>
        /// <returns></returns>
        public SmartBook SmartBook(int bigOrdersOpacity, int histogramPosition, double histogramWidthFactor, double lOMapBrightness, int lOMaxVolume, int minPixSideForMinVolBigOrder, int minVolBigOrder, bool showAskBidLines)
        {
            return SmartBook(Input, bigOrdersOpacity, histogramPosition, histogramWidthFactor, lOMapBrightness, lOMaxVolume, minPixSideForMinVolBigOrder, minVolBigOrder, showAskBidLines);
        }

        /// <summary>
        /// Limit Orders Map Community Edition Version: 1.0.0 Releaese: 20151209-1019 for beta testing
        /// </summary>
        /// <returns></returns>
        public SmartBook SmartBook(Data.IDataSeries input, int bigOrdersOpacity, int histogramPosition, double histogramWidthFactor, double lOMapBrightness, int lOMaxVolume, int minPixSideForMinVolBigOrder, int minVolBigOrder, bool showAskBidLines)
        {
            if (cacheSmartBook != null)
                for (int idx = 0; idx < cacheSmartBook.Length; idx++)
                    if (cacheSmartBook[idx].BigOrdersOpacity == bigOrdersOpacity && cacheSmartBook[idx].HistogramPosition == histogramPosition && Math.Abs(cacheSmartBook[idx].HistogramWidthFactor - histogramWidthFactor) <= double.Epsilon && Math.Abs(cacheSmartBook[idx].LOMapBrightness - lOMapBrightness) <= double.Epsilon && cacheSmartBook[idx].LOMaxVolume == lOMaxVolume && cacheSmartBook[idx].MinPixSideForMinVolBigOrder == minPixSideForMinVolBigOrder && cacheSmartBook[idx].MinVolBigOrder == minVolBigOrder && cacheSmartBook[idx].ShowAskBidLines == showAskBidLines && cacheSmartBook[idx].EqualsInput(input))
                        return cacheSmartBook[idx];

            lock (checkSmartBook)
            {
                checkSmartBook.BigOrdersOpacity = bigOrdersOpacity;
                bigOrdersOpacity = checkSmartBook.BigOrdersOpacity;
                checkSmartBook.HistogramPosition = histogramPosition;
                histogramPosition = checkSmartBook.HistogramPosition;
                checkSmartBook.HistogramWidthFactor = histogramWidthFactor;
                histogramWidthFactor = checkSmartBook.HistogramWidthFactor;
                checkSmartBook.LOMapBrightness = lOMapBrightness;
                lOMapBrightness = checkSmartBook.LOMapBrightness;
                checkSmartBook.LOMaxVolume = lOMaxVolume;
                lOMaxVolume = checkSmartBook.LOMaxVolume;
                checkSmartBook.MinPixSideForMinVolBigOrder = minPixSideForMinVolBigOrder;
                minPixSideForMinVolBigOrder = checkSmartBook.MinPixSideForMinVolBigOrder;
                checkSmartBook.MinVolBigOrder = minVolBigOrder;
                minVolBigOrder = checkSmartBook.MinVolBigOrder;
                checkSmartBook.ShowAskBidLines = showAskBidLines;
                showAskBidLines = checkSmartBook.ShowAskBidLines;

                if (cacheSmartBook != null)
                    for (int idx = 0; idx < cacheSmartBook.Length; idx++)
                        if (cacheSmartBook[idx].BigOrdersOpacity == bigOrdersOpacity && cacheSmartBook[idx].HistogramPosition == histogramPosition && Math.Abs(cacheSmartBook[idx].HistogramWidthFactor - histogramWidthFactor) <= double.Epsilon && Math.Abs(cacheSmartBook[idx].LOMapBrightness - lOMapBrightness) <= double.Epsilon && cacheSmartBook[idx].LOMaxVolume == lOMaxVolume && cacheSmartBook[idx].MinPixSideForMinVolBigOrder == minPixSideForMinVolBigOrder && cacheSmartBook[idx].MinVolBigOrder == minVolBigOrder && cacheSmartBook[idx].ShowAskBidLines == showAskBidLines && cacheSmartBook[idx].EqualsInput(input))
                            return cacheSmartBook[idx];

                SmartBook indicator = new SmartBook();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BigOrdersOpacity = bigOrdersOpacity;
                indicator.HistogramPosition = histogramPosition;
                indicator.HistogramWidthFactor = histogramWidthFactor;
                indicator.LOMapBrightness = lOMapBrightness;
                indicator.LOMaxVolume = lOMaxVolume;
                indicator.MinPixSideForMinVolBigOrder = minPixSideForMinVolBigOrder;
                indicator.MinVolBigOrder = minVolBigOrder;
                indicator.ShowAskBidLines = showAskBidLines;
                Indicators.Add(indicator);
                indicator.SetUp();

                SmartBook[] tmp = new SmartBook[cacheSmartBook == null ? 1 : cacheSmartBook.Length + 1];
                if (cacheSmartBook != null)
                    cacheSmartBook.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheSmartBook = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Limit Orders Map Community Edition Version: 1.0.0 Releaese: 20151209-1019 for beta testing
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SmartBook SmartBook(int bigOrdersOpacity, int histogramPosition, double histogramWidthFactor, double lOMapBrightness, int lOMaxVolume, int minPixSideForMinVolBigOrder, int minVolBigOrder, bool showAskBidLines)
        {
            return _indicator.SmartBook(Input, bigOrdersOpacity, histogramPosition, histogramWidthFactor, lOMapBrightness, lOMaxVolume, minPixSideForMinVolBigOrder, minVolBigOrder, showAskBidLines);
        }

        /// <summary>
        /// Limit Orders Map Community Edition Version: 1.0.0 Releaese: 20151209-1019 for beta testing
        /// </summary>
        /// <returns></returns>
        public Indicator.SmartBook SmartBook(Data.IDataSeries input, int bigOrdersOpacity, int histogramPosition, double histogramWidthFactor, double lOMapBrightness, int lOMaxVolume, int minPixSideForMinVolBigOrder, int minVolBigOrder, bool showAskBidLines)
        {
            return _indicator.SmartBook(input, bigOrdersOpacity, histogramPosition, histogramWidthFactor, lOMapBrightness, lOMaxVolume, minPixSideForMinVolBigOrder, minVolBigOrder, showAskBidLines);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Limit Orders Map Community Edition Version: 1.0.0 Releaese: 20151209-1019 for beta testing
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SmartBook SmartBook(int bigOrdersOpacity, int histogramPosition, double histogramWidthFactor, double lOMapBrightness, int lOMaxVolume, int minPixSideForMinVolBigOrder, int minVolBigOrder, bool showAskBidLines)
        {
            return _indicator.SmartBook(Input, bigOrdersOpacity, histogramPosition, histogramWidthFactor, lOMapBrightness, lOMaxVolume, minPixSideForMinVolBigOrder, minVolBigOrder, showAskBidLines);
        }

        /// <summary>
        /// Limit Orders Map Community Edition Version: 1.0.0 Releaese: 20151209-1019 for beta testing
        /// </summary>
        /// <returns></returns>
        public Indicator.SmartBook SmartBook(Data.IDataSeries input, int bigOrdersOpacity, int histogramPosition, double histogramWidthFactor, double lOMapBrightness, int lOMaxVolume, int minPixSideForMinVolBigOrder, int minVolBigOrder, bool showAskBidLines)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.SmartBook(input, bigOrdersOpacity, histogramPosition, histogramWidthFactor, lOMapBrightness, lOMaxVolume, minPixSideForMinVolBigOrder, minVolBigOrder, showAskBidLines);
        }
    }
}
#endregion
