//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private MQTDIVERGENTE2V[] cacheMQTDIVERGENTE2V = null;

        private static MQTDIVERGENTE2V checkMQTDIVERGENTE2V = new MQTDIVERGENTE2V();

        /// <summary>
        /// www.masquetrading.com - Indicador divergente mas 2V
        /// </summary>
        /// <returns></returns>
        public MQTDIVERGENTE2V MQTDIVERGENTE2V(bool alarm, string alarmSoundFile2V, string alarmSoundFileDIV, string email, bool emailAlert, int periodo, int periodoMedia, string scheduleEndTime, string scheduleStartTime)
        {
            return MQTDIVERGENTE2V(Input, alarm, alarmSoundFile2V, alarmSoundFileDIV, email, emailAlert, periodo, periodoMedia, scheduleEndTime, scheduleStartTime);
        }

        /// <summary>
        /// www.masquetrading.com - Indicador divergente mas 2V
        /// </summary>
        /// <returns></returns>
        public MQTDIVERGENTE2V MQTDIVERGENTE2V(Data.IDataSeries input, bool alarm, string alarmSoundFile2V, string alarmSoundFileDIV, string email, bool emailAlert, int periodo, int periodoMedia, string scheduleEndTime, string scheduleStartTime)
        {
            if (cacheMQTDIVERGENTE2V != null)
                for (int idx = 0; idx < cacheMQTDIVERGENTE2V.Length; idx++)
                    if (cacheMQTDIVERGENTE2V[idx].Alarm == alarm && cacheMQTDIVERGENTE2V[idx].AlarmSoundFile2V == alarmSoundFile2V && cacheMQTDIVERGENTE2V[idx].AlarmSoundFileDIV == alarmSoundFileDIV && cacheMQTDIVERGENTE2V[idx].Email == email && cacheMQTDIVERGENTE2V[idx].EmailAlert == emailAlert && cacheMQTDIVERGENTE2V[idx].Periodo == periodo && cacheMQTDIVERGENTE2V[idx].PeriodoMedia == periodoMedia && cacheMQTDIVERGENTE2V[idx].ScheduleEndTime == scheduleEndTime && cacheMQTDIVERGENTE2V[idx].ScheduleStartTime == scheduleStartTime && cacheMQTDIVERGENTE2V[idx].EqualsInput(input))
                        return cacheMQTDIVERGENTE2V[idx];

            lock (checkMQTDIVERGENTE2V)
            {
                checkMQTDIVERGENTE2V.Alarm = alarm;
                alarm = checkMQTDIVERGENTE2V.Alarm;
                checkMQTDIVERGENTE2V.AlarmSoundFile2V = alarmSoundFile2V;
                alarmSoundFile2V = checkMQTDIVERGENTE2V.AlarmSoundFile2V;
                checkMQTDIVERGENTE2V.AlarmSoundFileDIV = alarmSoundFileDIV;
                alarmSoundFileDIV = checkMQTDIVERGENTE2V.AlarmSoundFileDIV;
                checkMQTDIVERGENTE2V.Email = email;
                email = checkMQTDIVERGENTE2V.Email;
                checkMQTDIVERGENTE2V.EmailAlert = emailAlert;
                emailAlert = checkMQTDIVERGENTE2V.EmailAlert;
                checkMQTDIVERGENTE2V.Periodo = periodo;
                periodo = checkMQTDIVERGENTE2V.Periodo;
                checkMQTDIVERGENTE2V.PeriodoMedia = periodoMedia;
                periodoMedia = checkMQTDIVERGENTE2V.PeriodoMedia;
                checkMQTDIVERGENTE2V.ScheduleEndTime = scheduleEndTime;
                scheduleEndTime = checkMQTDIVERGENTE2V.ScheduleEndTime;
                checkMQTDIVERGENTE2V.ScheduleStartTime = scheduleStartTime;
                scheduleStartTime = checkMQTDIVERGENTE2V.ScheduleStartTime;

                if (cacheMQTDIVERGENTE2V != null)
                    for (int idx = 0; idx < cacheMQTDIVERGENTE2V.Length; idx++)
                        if (cacheMQTDIVERGENTE2V[idx].Alarm == alarm && cacheMQTDIVERGENTE2V[idx].AlarmSoundFile2V == alarmSoundFile2V && cacheMQTDIVERGENTE2V[idx].AlarmSoundFileDIV == alarmSoundFileDIV && cacheMQTDIVERGENTE2V[idx].Email == email && cacheMQTDIVERGENTE2V[idx].EmailAlert == emailAlert && cacheMQTDIVERGENTE2V[idx].Periodo == periodo && cacheMQTDIVERGENTE2V[idx].PeriodoMedia == periodoMedia && cacheMQTDIVERGENTE2V[idx].ScheduleEndTime == scheduleEndTime && cacheMQTDIVERGENTE2V[idx].ScheduleStartTime == scheduleStartTime && cacheMQTDIVERGENTE2V[idx].EqualsInput(input))
                            return cacheMQTDIVERGENTE2V[idx];

                MQTDIVERGENTE2V indicator = new MQTDIVERGENTE2V();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Alarm = alarm;
                indicator.AlarmSoundFile2V = alarmSoundFile2V;
                indicator.AlarmSoundFileDIV = alarmSoundFileDIV;
                indicator.Email = email;
                indicator.EmailAlert = emailAlert;
                indicator.Periodo = periodo;
                indicator.PeriodoMedia = periodoMedia;
                indicator.ScheduleEndTime = scheduleEndTime;
                indicator.ScheduleStartTime = scheduleStartTime;
                Indicators.Add(indicator);
                indicator.SetUp();

                MQTDIVERGENTE2V[] tmp = new MQTDIVERGENTE2V[cacheMQTDIVERGENTE2V == null ? 1 : cacheMQTDIVERGENTE2V.Length + 1];
                if (cacheMQTDIVERGENTE2V != null)
                    cacheMQTDIVERGENTE2V.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheMQTDIVERGENTE2V = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// www.masquetrading.com - Indicador divergente mas 2V
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MQTDIVERGENTE2V MQTDIVERGENTE2V(bool alarm, string alarmSoundFile2V, string alarmSoundFileDIV, string email, bool emailAlert, int periodo, int periodoMedia, string scheduleEndTime, string scheduleStartTime)
        {
            return _indicator.MQTDIVERGENTE2V(Input, alarm, alarmSoundFile2V, alarmSoundFileDIV, email, emailAlert, periodo, periodoMedia, scheduleEndTime, scheduleStartTime);
        }

        /// <summary>
        /// www.masquetrading.com - Indicador divergente mas 2V
        /// </summary>
        /// <returns></returns>
        public Indicator.MQTDIVERGENTE2V MQTDIVERGENTE2V(Data.IDataSeries input, bool alarm, string alarmSoundFile2V, string alarmSoundFileDIV, string email, bool emailAlert, int periodo, int periodoMedia, string scheduleEndTime, string scheduleStartTime)
        {
            return _indicator.MQTDIVERGENTE2V(input, alarm, alarmSoundFile2V, alarmSoundFileDIV, email, emailAlert, periodo, periodoMedia, scheduleEndTime, scheduleStartTime);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// www.masquetrading.com - Indicador divergente mas 2V
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MQTDIVERGENTE2V MQTDIVERGENTE2V(bool alarm, string alarmSoundFile2V, string alarmSoundFileDIV, string email, bool emailAlert, int periodo, int periodoMedia, string scheduleEndTime, string scheduleStartTime)
        {
            return _indicator.MQTDIVERGENTE2V(Input, alarm, alarmSoundFile2V, alarmSoundFileDIV, email, emailAlert, periodo, periodoMedia, scheduleEndTime, scheduleStartTime);
        }

        /// <summary>
        /// www.masquetrading.com - Indicador divergente mas 2V
        /// </summary>
        /// <returns></returns>
        public Indicator.MQTDIVERGENTE2V MQTDIVERGENTE2V(Data.IDataSeries input, bool alarm, string alarmSoundFile2V, string alarmSoundFileDIV, string email, bool emailAlert, int periodo, int periodoMedia, string scheduleEndTime, string scheduleStartTime)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.MQTDIVERGENTE2V(input, alarm, alarmSoundFile2V, alarmSoundFileDIV, email, emailAlert, periodo, periodoMedia, scheduleEndTime, scheduleStartTime);
        }
    }
}
#endregion
