//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private MQTVOLUMEN[] cacheMQTVOLUMEN = null;

        private static MQTVOLUMEN checkMQTVOLUMEN = new MQTVOLUMEN();

        /// <summary>
        /// MQT Volumen - MasQueTrading - www.masquetrading.com
        /// </summary>
        /// <returns></returns>
        public MQTVOLUMEN MQTVOLUMEN(int periodo1, int periodo2)
        {
            return MQTVOLUMEN(Input, periodo1, periodo2);
        }

        /// <summary>
        /// MQT Volumen - MasQueTrading - www.masquetrading.com
        /// </summary>
        /// <returns></returns>
        public MQTVOLUMEN MQTVOLUMEN(Data.IDataSeries input, int periodo1, int periodo2)
        {
            if (cacheMQTVOLUMEN != null)
                for (int idx = 0; idx < cacheMQTVOLUMEN.Length; idx++)
                    if (cacheMQTVOLUMEN[idx].Periodo1 == periodo1 && cacheMQTVOLUMEN[idx].Periodo2 == periodo2 && cacheMQTVOLUMEN[idx].EqualsInput(input))
                        return cacheMQTVOLUMEN[idx];

            lock (checkMQTVOLUMEN)
            {
                checkMQTVOLUMEN.Periodo1 = periodo1;
                periodo1 = checkMQTVOLUMEN.Periodo1;
                checkMQTVOLUMEN.Periodo2 = periodo2;
                periodo2 = checkMQTVOLUMEN.Periodo2;

                if (cacheMQTVOLUMEN != null)
                    for (int idx = 0; idx < cacheMQTVOLUMEN.Length; idx++)
                        if (cacheMQTVOLUMEN[idx].Periodo1 == periodo1 && cacheMQTVOLUMEN[idx].Periodo2 == periodo2 && cacheMQTVOLUMEN[idx].EqualsInput(input))
                            return cacheMQTVOLUMEN[idx];

                MQTVOLUMEN indicator = new MQTVOLUMEN();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Periodo1 = periodo1;
                indicator.Periodo2 = periodo2;
                Indicators.Add(indicator);
                indicator.SetUp();

                MQTVOLUMEN[] tmp = new MQTVOLUMEN[cacheMQTVOLUMEN == null ? 1 : cacheMQTVOLUMEN.Length + 1];
                if (cacheMQTVOLUMEN != null)
                    cacheMQTVOLUMEN.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheMQTVOLUMEN = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// MQT Volumen - MasQueTrading - www.masquetrading.com
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MQTVOLUMEN MQTVOLUMEN(int periodo1, int periodo2)
        {
            return _indicator.MQTVOLUMEN(Input, periodo1, periodo2);
        }

        /// <summary>
        /// MQT Volumen - MasQueTrading - www.masquetrading.com
        /// </summary>
        /// <returns></returns>
        public Indicator.MQTVOLUMEN MQTVOLUMEN(Data.IDataSeries input, int periodo1, int periodo2)
        {
            return _indicator.MQTVOLUMEN(input, periodo1, periodo2);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// MQT Volumen - MasQueTrading - www.masquetrading.com
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MQTVOLUMEN MQTVOLUMEN(int periodo1, int periodo2)
        {
            return _indicator.MQTVOLUMEN(Input, periodo1, periodo2);
        }

        /// <summary>
        /// MQT Volumen - MasQueTrading - www.masquetrading.com
        /// </summary>
        /// <returns></returns>
        public Indicator.MQTVOLUMEN MQTVOLUMEN(Data.IDataSeries input, int periodo1, int periodo2)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.MQTVOLUMEN(input, periodo1, periodo2);
        }
    }
}
#endregion
