                                                                     
                                                                     
                                                                     
                                             

#region Using declarations
using System;
using System.IO;
using System.Linq;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using System.Windows.Forms;
using System.Collections.Specialized;
using System.Collections.ObjectModel;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Media;
using System.Runtime.InteropServices;
//using System.Speech.Synthesis;
#endregion

#region Global Enums

public enum AggregatedTS1aggregationmethod {DOM, BidAsk, Time}
public enum AggregatedTS1pricedisplay {Decimal, Sixteenths, Thirtytwoths, Sixtyfourths, Onehundredtwentyeighths, SixteenthsNT, ThirtytwothsNT, SixtyfourthsNT, OnehundredtwentyeighthsNT}
public enum AggregatedTS1digitstodisplay {Two, Three, Four, Five, Six, Seven, Eight, Auto}
public enum AggregatedTS1periodtypeforpressure {Ticks, Seconds}
public enum AggregatedTS1periodtypeforprice {Ticks, Seconds}
public enum AggregatedTS1Scrolltype {None, ScrollNoBar, Scrollbar}
public enum AggregatedTS1SellBuyDisplay {Both, Buy, Sell}

#endregion



// v5.9 Apr 16 2013
//// Special thanks go to (alphabetical order): Big Mike, ktrader, rounder8, Xav1029 and Zondor
namespace NinjaTrader.Indicator
{
//	[StructLayout(LayoutKind.Sequential)]
//	public struct Tuple
//	{
//        public DateTime time;
//        public int size;
//		public double price;
//    }
		
    [Description("Aggregated Time & Sales ")]
    public class vvAggregatedTS : Indicator
    {
		#region iconstring
			private string iconstring = @"iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABPklEQVR42tWSMauCYBSGLXGxfoBg
g4P9gEAcWi0DwaWkCHETWvoDruLikHODLo66uQYNQdQQ0R9wcIzGRsn30jfEjS5x4XKHhjN853vP
wznvORRFUfhjfAKgXq+jVqu9B7As+xCrqoooiqBpGsIwxOFwwGq1gizLrwCO48jn8XhEHMfYbDao
quoR4/EYPM8jyzJcLhf0+/1ngCiKOJ/Pj4KyLJEkCfI8x+12g2maRDibzbDb7bDf719HuLd9b3ex
WCBNUziOA0mSoCgK2u02EY5GIyyXS2y3WwiCgEaj8bOJtm2jKArM53N0u93vQqzXa+i6Ds/zEATB
+y00m00icl33KWdZFq7XK/GNpun3a+x0OjidTphMJuTNMAx6vR6B3s391R20Wi34vo/hcIjpdArD
MDAYDIhvH3TK/wr4Aq8/bbmEbh1fAAAAAElFTkSuQmCC";
			
			#endregion
		#region Variables
		//
		public StringFormat sf = new StringFormat() ;
				
		public List<float> printsizelist = new List<float>();
		public double histogramfactor = 0.5;
		public int profilewidth = 50;
		public bool showhist = true;
		public bool showhistinown = true;
		public Color historgamcolourpropertyb = Color.DarkTurquoise;
		public Color historgamcolourpropertys = Color.DarkTurquoise;
		public Color historgamcolourpropertybm = Color.DeepSkyBlue;
		public Color historgamcolourpropertysm = Color.DeepSkyBlue;
		public Color historgamcolourproperty = Color.DarkTurquoise;
		public double maxout = 0;
		public int col1wid = -1;
		public int compressedrows = 30;
		private AggregatedTS1SellBuyDisplay sellbuydisplay = AggregatedTS1SellBuyDisplay.Both;
		private System.Windows.Forms.Timer	timer2;
		public int backtotop =10;
		public AggregatedTS1Scrolltype scrolltype = AggregatedTS1Scrolltype.None;
		public bool compress = false;
		public int smallerthanfilter = 10000;
		public Icon myicon = null;
		private double prevprice = 0;
		private int resetloc = 0;
		public Color Blockback = Color.Black;
		public Color Blockfore = Color.White;
		public Color buyblockback = Color.Black;
		public Color buyblockfore = Color.White;
		public Color sellblockback = Color.Black;
		public Color sellblockfore = Color.White;
		public Color foregroundSpeedColor = Color.LightGray;
		public Color backgroundSpeedColor = Color.DodgerBlue;
		public int scalewidth = 150;
		private bool useticksnovol = false;
		private bool plotpressuredelta = false;
		private bool plotpricedelta = false;
		private int SumOfBuyVolumeshelper =0;
		private int SumOfSellVolumeshelper =0;
		private double ratiop =0;
		private double ratio =0;
		private bool usedelta = true;
		private double magnitudep = 3;
		private int periodprice = 300;
		private DateTime now;
		private double price;
		private TimeSpan onesecond = new TimeSpan(0, 0, 1);
		private AggregatedTS1periodtypeforprice ptype1 = AggregatedTS1periodtypeforprice.Ticks;
		private AggregatedTS1periodtypeforpressure ptype = AggregatedTS1periodtypeforpressure.Ticks;
		private double buysum =0;
		private double sellsum =0;
		private int countloop =0;
		private int selltimepressure =0;
		private int buytimepressure =0;
		private bool weightedpressure = false;
		private bool onlyfiltered = false;
		private bool onlyfilteredp = false;
		private double magnitude =3;
		private int periodud = 300;
		private bool alertfired = false;
		private bool setalert = false;
		private	TimeSpan alerttime;
		private	DateTime lastTimePlot = Cbi.Globals.MinDate;
		private int oldrs = 0;
		private int runningsum = 0;
		private int periodvol = 30;
		private LinkedList<int> list = new LinkedList<int>();
		private LinkedList<int> udlist = new LinkedList<int>();
		private LinkedList<double> pricelist = new LinkedList<double>();
		private List<double> pricelisthelper = new List<double>();
		private List<int> pricesforsecondaverageb = new List<int>();
		private List<int> pricesforsecondaverages = new List<int>();
		
		//private LinkedList<Tuple> udlist = new LinkedList<Tuple>();
		private List<int> list2 = new List<int>();
		private int volforspeed = 0;
		private System.Windows.Forms.Timer	timer;
		private AggregatedTS1pricedisplay	pricedisplay				= AggregatedTS1pricedisplay.Decimal;
		private bool firstsessbrk=true;
		private int runcount=0;
		public int pricedisplay1 = 0;
		
		public bool displaypricedelta = true;
		public bool displaypressuredelta = true;
		public bool displaytimer=true;
		public bool displayspeed=true;
		public bool displayinstrument=true;
		public bool displayhilo=true;
		public bool displayother=true;
		public bool hi=false;
		public bool lo=false;
		//private int startBar=0;
		public int userx = 100;
		public int usery = 100;
		private bool firstvis=true;
		private bool visflag=false;
		private bool ontop = false;
		private bool bringfront = true;
		public bool setloc = false;
		//public IntPtr savehandle;
		//public IntPtr rhandle;
		private AggregatedTS1aggregationmethod	aggregationmethod				= AggregatedTS1aggregationmethod.DOM;
		private TimeSpan AggregationInterval = TimeSpan.FromMilliseconds(10);
		private int volumefilter = 5;
		private int volumefilterblock = 20;
		private int blockalert = 50;
		public float fsize = 8.25F;
		private bool bidaskflag=false;
		private int aggregationint=0;
		public int displaydigits = 3;
		private AggregatedTS1digitstodisplay	digitstodisplay				= AggregatedTS1digitstodisplay.Auto;
		public int hipix = 0;
		public int wipix = 0;
		//public bool displayscrollbar=false;
		public bool displayhour=false;
		
		//private bool speech = true;
		public Color foregroundbuy = Color.Green;
		public Color backgroundbuy = Color.Honeydew;
		public Color foregroundsell = Color.Crimson;
		public Color backgroundsell = Color.MistyRose;
		
		public Color foregroundhigh = Color.Honeydew;
		public Color backgroundhigh = Color.Green;
		public Color foregroundlow = Color.MistyRose;
		public Color backgroundlow = Color.Crimson;
		
		public Color foregroundDH = Color.Honeydew;
		public Color backgroundDH = Color.Green;
		public Color foregroundDL = Color.MistyRose;
		public Color backgroundDL = Color.Crimson;
		
		public Color foregroundbuyblock = Color.Black;
		public Color backgroundbuyblock = Color.DarkSeaGreen;
		public Color foregroundsellblock = Color.Black;
		public Color backgroundsellblock = Color.LightCoral;
		public Color backgroundcolor = Color.Black;
		public int numberoflines = 85;
		
		//------new variables-----------------------------------
		private bool rowadded = false;
		private bool rowfinalized = false;
		
		public double sesslo = 0;
		public double sesshi = 0;
	
		private TimeSpan TimeoutForDom = TimeSpan.FromMilliseconds(200);
		private bool inversehilo = true;
		//-------grid input variables--------
		
		public Color Rainbow = Color.MistyRose;
		public Color Rainbow2 = Color.MistyRose;
//		public Color Rainbow3 = Color.MistyRose;
//		public Color Rainbow4 = Color.MistyRose;
		
		private bool OverflowB = false;
		private bool OverflowS = false;
		
		private int sizeB=0;
		private int sizeS=0;
		private int domlim2 = 0;
		private double counterB=0;
		private double counterS=0;
		private double max=0; //for domlimit calc returns the product
		private double? FirstBuyPrice;
		private double? FirstSellPrice;
		
		private double? LastBuyPrice;
		private double? LastSellPrice;
		
		private int CountOfBuy=0;
		private int CountOfSell=0;
		
		private int SumOfBuyVolumes=0;
		private int SumOfSellVolumes=0;
		
		
		//--cheap domlim-------
		private int CountB1=0;
		private int CountB2=0;
		private int CountB3=0;
		private int CountB4=0;
		private int CountB5=0;
		private int CountB6=0;
		private int CountB7=0;
		private int CountB8=0;
		private int CountB9=0;
		private int CountB10=0;
		private int CountB15=0;
		private int CountB20=0;
		
		private int CountS1=0;
		private int CountS2=0;
		private int CountS3=0;
		private int CountS4=0;
		private int CountS5=0;
		private int CountS6=0;
		private int CountS7=0;
		private int CountS8=0;
		private int CountS9=0;
		private int CountS10=0;
		private int CountS15=0;
		private int CountS20=0;
		//------new variables end-----------------------------------
			
		public int NumberOfDecimals;
		public double pforlength;
		//public string ND;
		private TSForm4 tsform;
		private double LastBid = 0;
		private double LastAsk = 0;
		private int LastTrade = 0;
		private DateTime LastBuyTime = new DateTime();
		private DateTime LastSellTime = new DateTime();
		private List<int> BuyVolumes = new List<int>(100);
		private List<int> SellVolumes = new List<int>(100);
		private bool DomUpdated = false;
		private DateTime sessionBegin;
		private DateTime sessionEnd;
		
		
//	public const int SWP_ASYNCWINDOWPOS = 0x4000;
//    public const int SWP_DEFERERASE = 0x2000;
//    public const int SWP_DRAWFRAME = 0x0020;
//    public const int SWP_FRAMECHANGED = 0x0020;
//    public const int SWP_HIDEWINDOW = 0x0080;
//    public const int SWP_NOACTIVATE = 0x0010;
//    public const int SWP_NOCOPYBITS = 0x0100;
//    public const int SWP_NOMOVE = 0x0002;
//    public const int SWP_NOOWNERZORDER = 0x0200;
//    public const int SWP_NOREDRAW = 0x0008;
//    public const int SWP_NOREPOSITION = 0x0200;
//    public const int SWP_NOSENDCHANGING = 0x0400;
//    public const int SWP_NOSIZE = 0x0001;
//    public const int SWP_NOZORDER = 0x0004;
//    public const int SWP_SHOWWINDOW = 0x0040;

#endregion

        protected override void Initialize()
        {
		
        Overlay	= true;//set this to false for plots
		CalculateOnBarClose = false;
		
        }
		#region updowndelta()
		private  void updowndelta(double price)//called before Clearvals or finalizerow,and in ontimertick
		{
			int buyv;// = SumOfBuyVolumes;
			int sellv;// = SumOfSellVolumes;
			
			if(ptype == AggregatedTS1periodtypeforpressure.Seconds)
			{
				buyv = buytimepressure;
			 	sellv = selltimepressure;
				buytimepressure = 0;
			 	selltimepressure = 0;
			}
			else
			{
				buyv = SumOfBuyVolumes;
				sellv = SumOfSellVolumes;
			}
			
			
			if(onlyfiltered)
			{
				if (buyv > sellv) sellv=0; else buyv=0;
			}
			if (buyv != 0)
			{
			if (useticksnovol) udlist.AddFirst(1); else udlist.AddFirst(buyv);
				if(udlist.Count > periodud)//tick based
					{
						udlist.RemoveLast();
					}
			}
			if (sellv != 0)
			{
				if (useticksnovol) udlist.AddFirst(-1); else udlist.AddFirst(-sellv);
				if(udlist.Count > periodud)//tick based
					{
						udlist.RemoveLast();
					}
			}
			sellsum = 0;
			buysum = 0;
			if(!weightedpressure)
			{
				sellsum = udlist.Where(p => p < 0).Sum();//get the sell vol
				sellsum = Math.Abs(sellsum);
				buysum = udlist.Where(p => p > 0).Sum();//get the sell vol
				//IEnumerable<int> query  = udlist.Where(p => p > 0);//get the sell vol
			}
			else
			{
				countloop = 0;
				foreach (var value in udlist)
				{
					countloop++;
					int weight = periodud+1-countloop;//linear weighting
					if(value<0)
					{
						sellsum += Math.Abs(value*weight);
					}
					else
					{
						buysum += value*weight;
					}
				}
				}
			if(buysum+sellsum == 0) return;
			ratio = buysum/(buysum+sellsum);
			ratio = (ratio-0.5)*magnitude+0.5;
			tsform.setPressureWidth(ratio);
		}
		#endregion
		
		#region pricedelta()
		private  void pricedelta( double price)
		{
			double buyprice;// = SumOfBuyVolumes;
			double sellprice;
			ratiop = 0;
			//if nodelta
			if(usedelta)
			{
				pricelist.AddFirst(price);
				if(pricelist.Count > periodprice)//tick based
				{
					pricelist.RemoveLast();
				}
				double delta = pricelist.Last.Value - pricelist.First.Value;
				if((magnitudep/2)-delta<0) delta= 0; else delta = (magnitudep/2)-delta;
				ratiop = delta/(magnitudep);
			}
			else if(ptype1 == AggregatedTS1periodtypeforprice.Seconds && !usedelta)
			{
				//	build an average here
				//use a list to collect by and one list to collect sell
				if (SumOfBuyVolumeshelper > SumOfSellVolumeshelper)
				{
					//get average of list instead of price
					
					pricelist.AddFirst( pricelisthelper.Average());
					pricelisthelper.Clear();
					SumOfBuyVolumeshelper=0;
					SumOfSellVolumeshelper=0;
					if(pricelist.Count > periodprice)//tick based
					{
						pricelist.RemoveLast();
					}
				}
				else if (SumOfSellVolumeshelper > SumOfBuyVolumeshelper)
				{
					pricelist.AddFirst(- pricelisthelper.Average());
					SumOfBuyVolumeshelper=0;
					SumOfSellVolumeshelper=0;
					if(pricelist.Count > periodprice)//tick based
					{
						pricelist.RemoveLast();
					}
				}
				else
				{
					SumOfBuyVolumeshelper=0;
					SumOfSellVolumeshelper=0;
				pricelist.AddFirst(0);
					if(pricelist.Count > periodprice)//tick based
					{
						pricelist.RemoveLast();
					}
				}
				//sumifs
				buyprice = pricelist.Where(p => p > 0).Sum();
				sellprice = pricelist.Where(p => p < 0).Sum();
				sellprice = Math.Abs(sellprice);
				if ((buyprice+sellprice)==0) return;
				ratiop = (double)buyprice/(double)(buyprice+sellprice);
				ratiop = (ratiop-0.5)*magnitudep+0.5;
			}
			//if ticks and delta
			else if(ptype1 == AggregatedTS1periodtypeforprice.Ticks && !usedelta)
			{
				if (SumOfBuyVolumes > SumOfSellVolumes)
				{
					
					pricelist.AddFirst(price);
					if(pricelist.Count > periodprice)//tick based
					{
						pricelist.RemoveLast();
					}
				}
				else if (SumOfSellVolumes > SumOfBuyVolumes)
				{
					
					pricelist.AddFirst(-price);
					if(pricelist.Count > periodprice)//tick based
					{
						pricelist.RemoveLast();
					}
				}
				else
				{
					pricelist.AddFirst(0);
					if(pricelist.Count > periodprice)//tick based
					{
						pricelist.RemoveLast();
					}
				}
				buyprice = pricelist.Where(p => p > 0).Sum();
				sellprice = pricelist.Where(p => p < 0).Sum();
				sellprice = Math.Abs(sellprice);
				if (buyprice+sellprice == 0) return;
				ratiop = (double)buyprice/(double)(buyprice+sellprice);
				ratiop = (ratiop-0.5)*magnitudep+0.5;
			}
			tsform.setPrriceDeltaWidth(ratiop);
		}
		#endregion
		
		#region OnStartUp()
		protected override void OnStartUp()//-----------------------------------------------------------OnStartUp-------------------------------
		{
		for (int i = 0; i < 40; i++) 
		{
			printsizelist.Add(0);
		}
		
		
			sf.Alignment  = StringAlignment.Far;
//		sf.LineAlignment = StringAlignment.Near;
//			histogramcolour =  new SolidBrush(historgamcolourproperty);
		this.ChartControl.FindForm().VisibleChanged += new EventHandler(chartVisibleChanged);
//				if(displayspeed || displaytimer)
//				{
			
					if (timer == null)
					{
//						if (DisplayTime())
//						{
							timer = new System.Windows.Forms.Timer();
							timer.Interval = 100;
							timer.Tick += new EventHandler(OnTimerTick);
							timer.Enabled = true;
//						}
					}
					if (timer2 == null)
					{
						timer2= new System.Windows.Forms.Timer();
						timer2.Interval = 1000*backtotop;
						timer2.Tick += new EventHandler(OnTimer2Tick);
					}
					
//				}
		     
			
			try
			{
				byte[] data = Convert.FromBase64String(iconstring);
				using(var stream = new MemoryStream(data, 0, data.Length))
				{
					Image image = Image.FromStream(stream);
					Bitmap bmp = (Bitmap) image;
					using (Graphics g = Graphics.FromImage(bmp))
					myicon = Icon.FromHandle(bmp.GetHicon());
				}
			}
			 catch{}

			
			if(digitstodisplay == AggregatedTS1digitstodisplay.Two) displaydigits=2;
			else if(digitstodisplay == AggregatedTS1digitstodisplay.Four || (digitstodisplay == AggregatedTS1digitstodisplay.Auto && (Instrument.MasterInstrument.Name == "ES" ||
				Instrument.MasterInstrument.Name == "FGBL" ||
				Instrument.MasterInstrument.Name == "FGBM" ||
				Instrument.MasterInstrument.Name == "FGBS" ||
				Instrument.MasterInstrument.Name == "FGBX" ||
				Instrument.MasterInstrument.Name == "GE" ||
				Instrument.MasterInstrument.Name == "I" ||
				Instrument.MasterInstrument.Name == "O" ||
				Instrument.MasterInstrument.Name == "P" ||
				Instrument.MasterInstrument.Name == "S" ||
				Instrument.MasterInstrument.Name == "SR" ||
				Instrument.MasterInstrument.Name == "TWS" ||
				Instrument.MasterInstrument.Name == "XT" ||
				Instrument.MasterInstrument.Name == "YT" ||
				Instrument.MasterInstrument.Name == "Z3N" ||
				Instrument.MasterInstrument.Name == "ZB" ||
				Instrument.MasterInstrument.Name == "ZF" ||
				Instrument.MasterInstrument.Name == "ZN" ||
				Instrument.MasterInstrument.Name == "ZQ" ||
				Instrument.MasterInstrument.Name == "ZT"))) 
				displaydigits=4;
			else if(digitstodisplay == AggregatedTS1digitstodisplay.Three || digitstodisplay == AggregatedTS1digitstodisplay.Auto) displaydigits=3;
			else if(digitstodisplay == AggregatedTS1digitstodisplay.Five) displaydigits=5;
			else if(digitstodisplay == AggregatedTS1digitstodisplay.Six) displaydigits=6;
			else if(digitstodisplay == AggregatedTS1digitstodisplay.Seven) displaydigits=7;
			else if(digitstodisplay == AggregatedTS1digitstodisplay.Eight) displaydigits=8;
			
			if(pricedisplay == AggregatedTS1pricedisplay.Decimal) pricedisplay1=0;
			else if(pricedisplay == AggregatedTS1pricedisplay.Sixteenths) pricedisplay1=1;
			else if(pricedisplay == AggregatedTS1pricedisplay.Thirtytwoths) pricedisplay1=2;
			else if(pricedisplay == AggregatedTS1pricedisplay.Sixtyfourths) pricedisplay1=3;
			else if(pricedisplay == AggregatedTS1pricedisplay.Onehundredtwentyeighths) pricedisplay1=4;
			else if(pricedisplay == AggregatedTS1pricedisplay.SixteenthsNT) pricedisplay1=5;
			else if(pricedisplay == AggregatedTS1pricedisplay.ThirtytwothsNT) pricedisplay1=6;
			else if(pricedisplay == AggregatedTS1pricedisplay.SixtyfourthsNT) pricedisplay1=7;
			else if(pricedisplay == AggregatedTS1pricedisplay.OnehundredtwentyeighthsNT) pricedisplay1=8;
			
			if(pricedisplay1 == 0) 
			{
//				Print("flag0");
				if(TickSize.ToString().Contains(","))
				{
//					Print("flag1");
					string[] splitted = TickSize.ToString().Replace(',','.').Split('.');
				NumberOfDecimals = splitted[1].Length;
				}
				else if(TickSize.ToString().Contains("."))
				{
//					Print("flag2");
					string[] splitted = TickSize.ToString().Split('.');
				NumberOfDecimals = splitted[1].Length;
				}
				else if (TickSize < 1) NumberOfDecimals=Getdigits();
				else NumberOfDecimals =0;
				//Print("dec " +NumberOfDecimals);
			}
			else if(pricedisplay1 == 4 || pricedisplay1 == 5 || pricedisplay1 == 6 || pricedisplay1 == 7 || pricedisplay1 == 8) NumberOfDecimals =3;
			else NumberOfDecimals =2;
//			Print("nd " +NumberOfDecimals);
			
			pforlength = Close[0];
			tsform = new TSForm4(this);
			tsform.Show();
			//hides the window after creation for invisible workspaces
			if (this.ChartControl.FindForm().Visible)
			{
				
				tsform.Visible = true;
				if(ontop) tsform.TopMost =true;
				visflag=true;
				//Print("set T&S visible on startup for "+ChartControl.FindForm().Text);
				firstvis=false;
			}
			else {tsform.Visible = false;}//Print("set T&S invisible on startup for "+ChartControl.FindForm().Text);}
			
			Bars.Session.GetNextBeginEnd(BarsArray[0], 0, out sessionBegin, out sessionEnd);
			//Print("SessionStart OnStartUp--------"+sessionBegin);
			//startBar=this.LastBarIndexPainted;
			
			//Print (NumberOfDecimals);
			if (aggregationmethod == AggregatedTS1aggregationmethod.DOM) aggregationint = 1;
			else if (aggregationmethod == AggregatedTS1aggregationmethod.BidAsk) aggregationint = 2;
			else if (aggregationmethod == AggregatedTS1aggregationmethod.Time) aggregationint = 3;
			
			if(showhist && showhistinown) maxout = profilewidth/histogramfactor;
			else if(showhist && col1wid>0) maxout = col1wid/histogramfactor;
			else if(showhist && col1wid==-1) maxout = tsform.grid.Columns[1].Width/histogramfactor;
//			Print("maxout " +maxout +" "+tsform.grid.Columns[1].Width);
		}
		#endregion
		private int Getdigits()
		{
			int numdgits = 0;
			double number = TickSize;
//			Print("tick"+TickSize);
			do
				{
					number = number * 10;
					numdgits++;
				} while (number < 1);
//				Print("digits"+numdgits);
				return numdgits;
				
			
		}
		public void Starttimer2()
		{
			if(!timer2.Enabled && scrolltype == AggregatedTS1Scrolltype.ScrollNoBar) timer2.Start();
			
		}
		public void Stoptimer2()
		{
			if(timer2.Enabled) timer2.Stop();
			
			
		}
		protected override void OnTermination()//----------------------------------------------------OnTermination-----------------------
		{
			try{tsform.Close();} catch(Exception ex){}
			try{tsform.Dispose();} catch(Exception ex){}

			this.ChartControl.FindForm().VisibleChanged -= chartVisibleChanged;
			if (timer != null)
            {
                timer.Enabled = false;
                timer = null;
            }
			if (timer2 != null)
            {
                timer2.Enabled = false;
                timer2 = null;
            }
			
			
		}
		private bool DisplayTime()//--------------------------------------------------------------------DisplayTime-----------------------
        {
			if (ChartControl != null
					&& Bars != null
					&& Bars.Count > 0
					&& Bars.MarketData != null
					&& Bars.MarketData.Connection.PriceStatus == Cbi.ConnectionStatus.Connected)
				return true;
			

            return false;
        }
		private DateTime Now()
		{
//			get 
//			{ 
				DateTime now = (Bars.MarketData.Connection.Options.Provider == Cbi.Provider.Replay ? Bars.MarketData.Connection.Now : DateTime.Now); 

//				if (now.Millisecond > 0)
//					now = Cbi.Globals.MinDate.AddSeconds((long) System.Math.Floor(now.Subtract(Cbi.Globals.MinDate).TotalSeconds));

				return now;
//			}
		}
		public void OnTimer2Tick(object sender, EventArgs e)//------------------------------------------OnTimerTick-----------------------
        {
			tsform.grid.FirstDisplayedScrollingRowIndex=0;
			timer2.Stop();
		}
		private void OnTimerTick(object sender, EventArgs e)//------------------------------------------OnTimerTick-----------------------
        {
			if (DateTime.Now.Subtract(lastTimePlot).Milliseconds >= 100)
			{
				if(resetloc == 2)
				{
					resetloc = 0;
					tsform.Left = Screen.FromControl(ChartControl.ChartPanel).Bounds.Left +userx;
					tsform.Top = Screen.FromControl(ChartControl.ChartPanel).Bounds.Top +usery;
//					Print("reset location after one second");
				}
				else if(resetloc == 1) resetloc = 2;
			
			
			if (DateTime.Now.Subtract(lastTimePlot).Seconds >= 1)
			{
				

				if (displaypressuredelta && ptype == AggregatedTS1periodtypeforpressure.Seconds) updowndelta(price);
				if ( displaypricedelta && ptype1 == AggregatedTS1periodtypeforprice.Seconds) pricedelta(  price);
				if(DisplayTime())
				{
				
					if(displaytimer)
					{
						TimeSpan timertime = sessionEnd-Now();
						tsform.showTimerTime(timertime);
						//Print("printed time"+DateTime.Now.Subtract(lastTimePlot).Seconds);
						if( timertime < alerttime && setalert && alertfired == false)
						{
							Alert("NSE", NinjaTrader.Cbi.Priority.High, "Session end is close", "Alert1.wav", 1, Color.Black, Color.Yellow);
							alertfired=true;
						}
					}
					
					if(displayspeed)
					{
						
						//add running sum to list
						list.AddFirst(volforspeed);
						oldrs = runningsum;
						runningsum += volforspeed;
						//delete last from list if count of list is bigger than n
						if(list.Count > periodvol)
						{
							runningsum -= list.Last.Value;
							list.RemoveLast();
							//sum of list /n send to grid
							tsform.showVolSpeed(runningsum, runningsum-oldrs);
							//Print("runningsum"+runningsum);
						}
						//set running sum to 0
						volforspeed = 0;
						//sum of list /n send to grid
						//lastTimePlot = lastTimePlot.Add(onesecond);// DateTime.Now;
					}
				}
			}
			lastTimePlot = lastTimePlot.Add(TimeSpan.FromMilliseconds(100));
			}
		}
		
		private void getNewsession()//-----------------------------------------------------------------getNewsession-----------------------
		{
			Bars.Session.GetNextBeginEnd(BarsArray[0], 0, out sessionBegin, out sessionEnd);
		}
		
		private void chartVisibleChanged (object sender, EventArgs e)//--------------------------------chartVisibleChanged-----------------------
		{
			
		
			if (this.ChartControl.FindForm().Visible)
			{
				
				if (firstvis)
				{
					
				tsform.Show();
				resetloc = 1;
				
				//Print("set T&S location "+ChartControl.FindForm().Text);
					
				}
				tsform.Visible = true;
				if(ontop) tsform.TopMost =true;
				visflag=true;
				//Print("set T&S visible for "+ChartControl.FindForm().Text);
				firstvis=false;
			}
			
			else
			{
				tsform.Visible = false;
				//Print("set T&S invisible for "+ChartControl.FindForm().Text);
			
			}
			
		}
		 

        protected override void OnBarUpdate()//---------------------------------------------------------OnBarUpdate-----------------------
        {
		//Print("CurrentDayOHL().Volume[0] "+MAX(Volume, 5));//GetBar(sessionBegin)));	
//			if (displaypressuredelta && plotpressuredelta) Value.Set(ratio);
//			if ( displaypricedelta && plotpricedelta) PriceDelta.Set(ratiop);
		}
		
		protected override void OnMarketDepth(MarketDepthEventArgs e)//---------------------------------OnMarketDepth-----------------------
		{
			DomUpdated = true;
			
		}
		
		protected override void OnMarketData(MarketDataEventArgs e)//------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
		{
			
			if (Historical)
				return;
			
			
			
			if(visflag)
			{
				visflag=false;
				if(!ontop) tsform.BringToFront();
			}
			
			now = Now();
			
			
			
			if (e.MarketDataType == MarketDataType.Bid)
			{
				
				LastBid = e.Price/TickSize;
				bidaskflag=true;
				return;
			}
			
			if (e.MarketDataType == MarketDataType.Ask)
			{
				
				LastAsk = e.Price/TickSize;
				bidaskflag=true;
				return;
			}
			
			if (e.MarketDataType != MarketDataType.Last)
				return;
			
			price = e.Price/TickSize;
//			Print("e.Price "+e.Price);
////			Print("e.Price/TickSize "+e.Price/TickSize);
//			Print("price "+price);
			if(prevprice ==0) prevprice = price;
			if(Time[0]>sessionEnd)//get the new session//now only works with live
			{
				getNewsession();
				alertfired=false;
				sesslo = 0;// Low[0]/TickSize;
			    sesshi = 0;// High[0]/TickSize;
				//insert Session Break
				if (rowadded ==true)
				{
					if (onlyfiltered && displaypressuredelta)
					{
						if(ptype == AggregatedTS1periodtypeforpressure.Ticks) updowndelta(  price); 
					else
					{
						if (SumOfSellVolumes >= SumOfBuyVolumes)
						{
							if (useticksnovol) selltimepressure++; else selltimepressure += SumOfSellVolumes;
						}
						else
						{
							if (useticksnovol) buytimepressure++; else buytimepressure += SumOfBuyVolumes;
						}
					}
					}
					if(displaypricedelta && onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					GetRowData(3);	
					rowadded = false;
					rowfinalized=true;
				}
				tsform.AddSessionBreak(firstsessbrk);
				if(!onlyfiltered && displaypressuredelta) updowndelta(  price);
				if(displaypricedelta && !onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					Clearvals();
				runcount=0;
				firstsessbrk=false;
				if(displayhilo) tsform.GetNewHiLo();
			   //	Print("Session start " + sessionBegin+"Session end " + sessionEnd+"Now:  "+Time[0]);
				
			}
			if(runcount == 1 || sesslo==0)//CurrentBar>0&&CurrentBar<startBar+2)
			{
				sesslo = (MIN(Low,GetBar(sessionBegin))[0])/TickSize;
			    sesshi =  MAX(High,GetBar(sessionBegin)+0)[0]/TickSize; 
				runcount++;
				if(displayhilo) tsform.GetNewHiLo();
			  //	 Print("vvAggregatedTS: Session started " + GetBar(sessionBegin)+"  "+sessionBegin+" bars ago."+"Now:  "+Time[0]+" Session High and Low are "+(double)sesshi*TickSize+" and "+(double)sesslo*TickSize);
			}
			
            else
			{
				if(displayhilo)
				{
					if(Low[0]/TickSize<sesslo)
					{
						sesslo = Low[0]/TickSize;
						tsform.GetNewHiLo();
					//	Print("Session Low " + Low[0]+" sesslo:  "+(double)sesslo*TickSize);
					}
					
					if(High[0]/TickSize>sesshi)
					{
						sesshi = High[0]/TickSize;
						tsform.GetNewHiLo();
					//	Print("Session High " + High[0]+" sesshi:  "+(double)sesshi*TickSize);
						
					}
//					Print("Session low " + (double)sesslo*TickSize+" sesshi:  "+(double)sesshi*TickSize);
//					Print("CurrentDayOHL().Volume[0] "+SUM(Volume,GetBar(sessionBegin)));
//					Print("CurrentDayOHL().CurrentLow[0] "+CurrentDayOHL().CurrentLow[0]);
					
				}
				else
				{
					sesslo=Math.Min(sesslo,Low[0]/TickSize); 
					sesshi=Math.Max(sesshi,High[0]/TickSize);
//					CurrentDayOHL().Volume[0];
//					CurrentDayOHL().CurrentLow[0];
//					Print("Session low " + (double)sesslo*TickSize+" sesshi:  "+(double)sesshi*TickSize);
//					//Print("CurrentDayOHL().Volume[0] "+CurrentDayOHL().Volume[0]);
//					Print("CurrentDayOHL().CurrentLow[0] "+CurrentDayOHL().CurrentLow[0]);
					
				}
				
			}
			if(displayspeed) volforspeed += (int)e.Volume;
			//here goes the collector for buy and sell vol for time based
			if(displaypressuredelta && !onlyfiltered && ptype == AggregatedTS1periodtypeforpressure.Seconds)
			{
				if (price >= LastAsk)
				{
					if (useticksnovol) buytimepressure++; else buytimepressure += (int)e.Volume;
				}
				
				else if (price <= LastBid)
				{
					if (useticksnovol) selltimepressure++; else selltimepressure += (int)e.Volume;
				}
			}
			if(displaypricedelta && !onlyfilteredp && !usedelta && ptype1== AggregatedTS1periodtypeforprice.Seconds)
			{
				if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
				if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
				pricelisthelper.Add(price);
			}
			
			
//			Print(GetBar(sessionBegin));
//			Print (sesslo+"--lo");
//			Print (sesshi+"--hi");
			
			switch (aggregationint)
			{
			//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx	
			//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  dom aggregation  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
			//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
				case 1: 
			{
				if (!DomUpdated 
					&& (now.Subtract(LastBuyTime) < TimeoutForDom || now.Subtract(LastSellTime) < TimeoutForDom)
					&&((SumOfSellVolumes>0 && price < LastAsk && price<=prevprice) || SumOfSellVolumes == 0)
					&& ((SumOfBuyVolumes>0 && price > LastBid && price>=prevprice) || SumOfBuyVolumes == 0)
					 || (FirstBuyPrice==null && FirstSellPrice==null))//not too long or no trade if((SumOfSellVolumes>0 && price <= LastBid || SumOfSellVolumes == 0) && (SumOfBuyVolumes>0 && price >= LastAsk || SumOfBuyVolumes == 0))
				{
//					Print("e.Volume "+e.Volume);
					GetPriceData(e.Volume, price);
					
					//logic for immediate row has to go here#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
					if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
						if(rowadded==false)
						{
							GetRowData(1);
//							rowfinalized = false;
//							rowadded = true;
							return;
						}
						if(rowadded==true && rowfinalized == false)
						{
							GetRowData(2);
							return;
						}
					}
				}
				else
				{
//				if (DomUpdated) Print("Agg break, DOM update");
//				else if	(now.Subtract(LastBuyTime) > TimeoutForDom && now.Subtract(LastSellTime) > TimeoutForDom) Print("Agg break, timeout");
//				else if	((SumOfSellVolumes>0 && price >= LastAsk )|| (SumOfBuyVolumes>0 && price <= LastBid )) Print("Agg break, Bid/Ask cross");
//				else if	((SumOfSellVolumes>0 && price>prevprice) ||  (SumOfBuyVolumes>0 && price<prevprice)) Print("Agg break, direction change");
//				else Print("Agg break, WHY? Bug?");

					//###################  Missmatch  ############## commented out
//					if ((CountOfSell > 0 && CountOfBuy != 0) ||	(CountOfBuy > 0 && CountOfSell != 0))
//						{
//						Print(DateTime.Now + " Missmatch (" + CountOfBuy + "/" + CountOfSell + ")");
//						}
					
					DomUpdated = false;
					
					if (rowadded ==true)
					{
					if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
						if (onlyfiltered && displaypressuredelta )
						{
							if(ptype == AggregatedTS1periodtypeforpressure.Ticks) updowndelta(  price); 
							else
							{
							if (SumOfSellVolumes >= SumOfBuyVolumes)
							{
								if (useticksnovol) selltimepressure++; else selltimepressure += SumOfSellVolumes;
							}
								else 
							{
								if (useticksnovol) buytimepressure++; else buytimepressure += SumOfBuyVolumes;
							}
							}
						}
						if(displaypricedelta && onlyfilteredp)
						{
							if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
							{
								if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
								if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
								pricelisthelper.Add(price);
							}
							else pricedelta(  price);
						}
						GetRowData(3);	
					}
					
//					rowadded = false;
//					rowfinalized=true;
					}
					if(!onlyfiltered && displaypressuredelta) updowndelta(  price);
					if(displaypricedelta && !onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					Clearvals();
					
					GetPriceData(e.Volume, price);
					if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					
						{
							GetRowData(1);
//							rowfinalized = false;
//							rowadded = true;
							return;
						}
				}
				
				return;
			}
			
			break;
	
		
	//#################################################################################################################################################################		
	//####################################################################################   bid/ask aggregation  ######################################################		
	//################################################################################################################################################################
				case 2: 
			{
			//	Print("aminmethod");
				if (!bidaskflag
					&& (now.Subtract(LastBuyTime) < TimeoutForDom || now.Subtract(LastSellTime) < TimeoutForDom)
					&&((SumOfSellVolumes>0  && price<=prevprice) || SumOfSellVolumes == 0)
					&& ((SumOfBuyVolumes>0  && price>=prevprice) || SumOfBuyVolumes == 0)
					 || (FirstBuyPrice==null && FirstSellPrice==null))//not too long or no trade 
				{
				//	Print("aggregating");
					
					GetPriceData(e.Volume, price);
					//logic for immediate row has to go here#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
					if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
						if(rowadded==false)
						{
							GetRowData(1);
//							rowfinalized = false;
//							rowadded = true;
							return;
						}
						if(rowadded==true && rowfinalized == false)
						{
							GetRowData(2);
							return;
						}
					}
				}
				else
				{
//					if (bidaskflag) Print("Agg break, bidask update");
//					else if	(now.Subtract(LastBuyTime) > TimeoutForDom && now.Subtract(LastSellTime) > TimeoutForDom) Print("Agg break, timeout");
//					else if	((SumOfSellVolumes>0 && price>prevprice) ||  (SumOfBuyVolumes>0 && price<prevprice)) Print("Agg break, direction change");
//					else Print("Agg break, WHY? Bug?");

					//###################  Missmatch  ############## commented out
//					if ((CountOfSell > 0 && CountOfBuy != 0) ||	(CountOfBuy > 0 && CountOfSell != 0))
//						{
//						Print(DateTime.Now + " Missmatch (" + CountOfBuy + "/" + CountOfSell + ")");
//						}
					
					
					bidaskflag=false;
					if (rowadded ==true)
					{
					
					if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
					if (onlyfiltered && displaypressuredelta )
					{
						if(ptype == AggregatedTS1periodtypeforpressure.Ticks) updowndelta(  price); 
						else
						{
						
						if (SumOfSellVolumes >= SumOfBuyVolumes)
						{
							if (useticksnovol) selltimepressure++; else selltimepressure += SumOfSellVolumes;
						}
						else 
						{
							if (useticksnovol) buytimepressure++; else buytimepressure += SumOfBuyVolumes;
						}
						}
						
					}
					if(displaypricedelta && onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					GetRowData(3);	
					}
//					rowadded = false;
//					rowfinalized=true;
					}
					if(!onlyfiltered && displaypressuredelta) updowndelta(  price);
					if(displaypricedelta && !onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					Clearvals();
					
					GetPriceData(e.Volume, price);
					if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
						GetRowData(1);
//						rowfinalized = false;
//						rowadded = true;
						return;
					}
				}
				return;
			}
			break;
			
			//##################################################################################################################################################
			//################################################################################### Time #########################################################
			//##################################################################################################################################################
				case 3:
			{
				if (price <= LastBid)
				{
					if (now.Subtract(LastSellTime) > AggregationInterval && CountOfSell > 0)
						{
						
					if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
					if (onlyfiltered && displaypressuredelta )
					{
						if(ptype == AggregatedTS1periodtypeforpressure.Ticks) updowndelta(  price); 
						else
						{
						if (SumOfSellVolumes >= SumOfBuyVolumes)
						{
							if (useticksnovol) selltimepressure++; else selltimepressure += SumOfSellVolumes;
						}
						else 
						{
							if (useticksnovol) buytimepressure++; else buytimepressure += SumOfBuyVolumes;
						}
						}
					}
					if(displaypricedelta && onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					GetRowData(3);	
					}
						if(!onlyfiltered && displaypressuredelta) updowndelta(  price);
						if(displaypricedelta && !onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					Clearvals();
					}
				}
				else if (price >= LastAsk)
				{
					if (now.Subtract(LastBuyTime) > AggregationInterval && CountOfBuy > 0)
					{
						if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
					if (onlyfiltered && displaypressuredelta )
					{
						if(ptype == AggregatedTS1periodtypeforpressure.Ticks) updowndelta(  price); 
						else
						{
						if (SumOfSellVolumes >= SumOfBuyVolumes)
						{
							if (useticksnovol) selltimepressure++; else selltimepressure += SumOfSellVolumes;
						}
							else 
						{
							if (useticksnovol) buytimepressure++; else buytimepressure += SumOfBuyVolumes;
						}
						}
					}
					if(displaypricedelta && onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					GetRowData(3);	
					}
						if(!onlyfiltered && displaypressuredelta) updowndelta(  price);
						if(displaypricedelta && !onlyfilteredp)
					{
						if(ptype1== AggregatedTS1periodtypeforprice.Seconds)
						{
							if (price >= LastAsk)SumOfBuyVolumeshelper += (int)e.Volume;
							if (price <= LastBid)SumOfSellVolumeshelper += (int)e.Volume;
							pricelisthelper.Add(price);
						}
						else pricedelta(  price);
					}
					Clearvals();
					}
				}
				GetPriceData(e.Volume, price);
				if ( SumOfSellVolumes>=volumefilter ||  SumOfBuyVolumes >= volumefilter)
					{
						if(rowadded==false)
						{
							GetRowData(1);
//							rowfinalized = false;
//							rowadded = true;
							return;
						}
						if(rowadded==true && rowfinalized == false)
						{
							GetRowData(2);
							return;
						}
					}
			}//end time aggregation
			break;
			}
			
		}
		
		private void Clearvals()
		{
//			Print("printstatementsflag 1");
//			if(SumOfBuyVolumes>0) Print("AggTS: "+"  Vol: "+SumOfBuyVolumes+"  Price first: "+FirstBuyPrice+"  Price last: "+LastBuyPrice+"  Buy");
//			else Print("AggTS: "+"  Vol: "+SumOfSellVolumes+"  Price first: "+FirstSellPrice+"  Price last: "+LastSellPrice+"  Sell");
//			Print("printstatementsflag 2");
			
			//:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::clear values
			if(OverflowB)//-------------------------------------------------------------overflow
			{
			BuyVolumes.Clear();
			OverflowB = false;
			}
			
			if(OverflowS)//-------------------------------------------------------------overflow
			{
			SellVolumes.Clear();
			OverflowS = false;
			}
				
			//---clear new------------
			rowadded = false;
			rowfinalized=true;
			
			FirstBuyPrice = null;
			FirstSellPrice = null;
			
			LastBuyPrice = null;
			LastSellPrice = null;
			
			CountOfBuy = 0;
			CountOfSell = 0;
			
			SumOfBuyVolumes = 0;
			SumOfSellVolumes = 0;
			
			CountB1=0;
			CountB2=0;
			CountB3=0;
			CountB4=0;
			CountB5=0;
			CountB6=0;
			CountB7=0;
			CountB8=0;
			CountB9=0;
			CountB10=0;
			CountB15=0;
			CountB20=0;
			
			
			CountS1=0;
			CountS2=0;
			CountS3=0;
			CountS4=0;
			CountS5=0;
			CountS6=0;
			CountS7=0;
			CountS8=0;
			CountS9=0;
			CountS10=0;
			CountS15=0;
			CountS20=0;
		
			
			//---clear new end------------
		}
	private void GetPriceData(long Vol, double price)
		{
			//Print(LastAsk+"  LastAsk   "+LastBid+" LastBid   "+price+" PRICE");
			DateTime now = Now();
//			Print("Vol "+ (int)Vol);
			if (price > LastBid)
			{
				
				if(FirstBuyPrice==null) {FirstBuyPrice=price;}
				LastBuyPrice=price;
				CountOfBuy=CountOfBuy+1;
				
				SumOfBuyVolumes=SumOfBuyVolumes+(int)Vol;
				//------
				//Print("buy"+SumOfBuyVolumes);
				switch(Vol)
				{
					case 1:	CountB1 ++; break;
					case 2:	CountB2 ++; break;
					case 3:	CountB3 ++; break;
					case 4:	CountB4 ++; break;
					case 5:	CountB5 ++; break;
					case 6:	CountB6 ++; break;
					case 7:	CountB7 ++; break;
					case 8:	CountB8 ++; break;
					case 9:	CountB9 ++; break;
					case 10:	CountB10 ++; break;
					case 15:	CountB15 ++; break;
					case 20:	CountB20 ++; break;
					//-------------------------------------------------------------overflow
					default:{BuyVolumes.Add((int)Vol);	OverflowB=true;} break;
				}
				LastBuyTime = now;
			}
			
			if (price < LastAsk)
			{
				
				if(FirstSellPrice==null) {FirstSellPrice=price;}
				LastSellPrice=price;
				CountOfSell=CountOfSell+1;
				SumOfSellVolumes=SumOfSellVolumes+(int)Vol;
				
				switch(Vol)
				{
					case 1:	CountS1 ++; break;
					case 2:	CountS2 ++; break;
					case 3:	CountS3 ++; break;
					case 4:	CountS4 ++; break;
					case 5:	CountS5 ++; break;
					case 6:	CountS6 ++; break;
					case 7:	CountS7 ++; break;
					case 8:	CountS8 ++; break;
					case 9:	CountS9 ++; break;
					case 10:	CountS10 ++; break;
					case 15:	CountS15 ++; break;
					case 20:	CountS20 ++; break;
					//-------------------------------------------------------------overflow
					default:{SellVolumes.Add((int)Vol);	OverflowS=true;} break;
				}
				LastSellTime = now;
			}
			prevprice = price;
		}
		
		private void GetRowData(int aou)
		{
			DateTime now = Now();
			DateTime col0;
			int col1 = -1;
			double col2 =0;
			int col3 =-1;
			int col4 =-1;	
			int col6 =-1;
			bool blokk=false;
			//bool hi=false;//switched to containing hi lo not finish on
			//bool lo=false;
			
			if(sesslo == LastSellPrice  || sesslo == LastBuyPrice ) lo=true;
			if(sesshi == LastSellPrice  || sesshi == LastBuyPrice ) hi=true;
			//Print(sesshi+ "hi  "+sesslo+"lo  "+LastBuyPrice+"lb  "+LastSellPrice+" ls");
			col0=now;
//			Print(SumOfSellVolumes+"   "+SumOfBuyVolumes);
			if( SumOfSellVolumes >= SumOfBuyVolumes)
			{
//				if(showhist && col1wid==-1) maxout = (int) (tsform.grid.Columns[2].Width/histogramfactor);
//				Print("maxout " +maxout);
				if( SumOfSellVolumes>= maxout) historgamcolourproperty = historgamcolourpropertysm; else historgamcolourproperty = historgamcolourpropertys; 
				
				col1= SumOfSellVolumes;
				
				double pricehelp = (double) LastSellPrice*TickSize;
				
				switch(pricedisplay1)
				{
				case 0: col2 = (double) LastSellPrice*TickSize; break;
				case 1: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.16); break;
				case 2: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.32); break;
				case 3: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.64); break;
				case 4: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.128); break;
				case 5: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.32*0.5); break;
				case 6: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.64*0.5); break;
				case 7: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.64*0.5); break;
				case 8: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.128/0.4); break;
				}
				
				col4=(int) CountOfSell;
				if ( SumOfSellVolumes >= volumefilterblock)
				{
					Rainbow = foregroundsellblock;
					Rainbow2 =  backgroundsellblock;
					
					
				}
				else {Rainbow = foregroundsell;	Rainbow2 = backgroundsell;}
				if(SumOfSellVolumes>= blockalert)
				{
					Blockback = sellblockback;
					Blockfore = sellblockfore;
					blokk = true;
				}
				
			}
			
			else 
			{
//				if(showhist && col1wid==-1) maxout = (int) (tsform.grid.Columns[2].Width/histogramfactor);
//				Print("maxout " +maxout);
				if( SumOfBuyVolumes>= maxout) historgamcolourproperty = historgamcolourpropertybm; else historgamcolourproperty = historgamcolourpropertyb; 
				col1= SumOfBuyVolumes;
				double pricehelp = (double) LastBuyPrice*TickSize;
				
				switch(pricedisplay1)
				{
				case 0: col2 = (double) LastBuyPrice*TickSize; break;
				case 1: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.16); break;
				case 2: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.32); break;
				case 3: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.64); break;
				case 4: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.128); break;
				case 5: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.32*0.5); break;
				case 6: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.64*0.5); break;
				case 7: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.64*0.5); break;
				case 8: col2 = (double) System.Math.Floor(pricehelp) +((pricehelp - System.Math.Floor(pricehelp))*0.128/0.4); break;
				}
				
				col4=(int) CountOfBuy;
				if (SumOfBuyVolumes >= volumefilterblock)
				{
					Rainbow = foregroundbuyblock;
					Rainbow2 = backgroundbuyblock;
				}
				else {Rainbow = foregroundbuy;	Rainbow2 = backgroundbuy;}
				
				if(SumOfBuyVolumes>= blockalert)
				{
					Blockback = buyblockback;
					Blockfore = buyblockfore;
					blokk = true;
				}
			}
			switch (aou)
			{
				case 1:
				{
					if( SumOfSellVolumes >= SumOfBuyVolumes && sellbuydisplay == AggregatedTS1SellBuyDisplay.Sell || SumOfBuyVolumes > SumOfSellVolumes && sellbuydisplay == AggregatedTS1SellBuyDisplay.Buy || sellbuydisplay == AggregatedTS1SellBuyDisplay.Both)
					{
						tsform.AddGridRow(col0,col1,col2,col3,col4,col6, blokk,inversehilo,hi,lo);
					rowfinalized = false;
					rowadded = true;
			//		Print("addrow ####################################################################################" +col1);
					return;
					}
				}
				break;
			case 2:
				{
					if( SumOfSellVolumes >= SumOfBuyVolumes && sellbuydisplay == AggregatedTS1SellBuyDisplay.Sell || SumOfBuyVolumes > SumOfSellVolumes && sellbuydisplay == AggregatedTS1SellBuyDisplay.Buy || sellbuydisplay == AggregatedTS1SellBuyDisplay.Both)
					{
						tsform.UpdateGridRow(col0,col1,col2,col3,col4,col6, blokk,inversehilo,hi,lo);
							//	Print("Updaterow ####################" +col1);
						return;
					}
				}
				break;
			case 3:
			{
				if( SumOfSellVolumes>= SumOfBuyVolumes)
				{
					col0=LastSellTime;
				//	Print("FirstSellPrice "+FirstSellPrice+"     LastSellPrice "+LastSellPrice);
					
					if (FirstSellPrice != LastSellPrice) { int difference = (int)Math.Abs((double)(FirstSellPrice - LastSellPrice)); col3= difference;}
					
					if (OverflowS)
					{
						int domlim = DominantLimit(SellVolumes.ToArray());//---------dominant limit----------------
						whatdomlimS ();
						if(counterS * sizeS > max) domlim2 = sizeS; else domlim2 = domlim;
						col6=domlim2;
					}
					else
					{
						whatdomlimS ();
						col6=sizeS;
					}
				}
				else
				{
					col0=LastBuyTime;
					
					if (FirstBuyPrice != LastBuyPrice) { int difference = (int)Math.Abs((double)(FirstBuyPrice - LastBuyPrice)); col3= difference;}
					
					if (OverflowB)
					{
						int domlim = DominantLimit(BuyVolumes.ToArray());//---------dominant limit----------------
						whatdomlimB ();
						if(counterB * sizeB > max) domlim2 = sizeB; else domlim2 = domlim;
						col6=domlim2;
					}
					
					else
					{
						whatdomlimB ();
						col6=sizeB;
					}
				}
					
					if( SumOfSellVolumes >= SumOfBuyVolumes && sellbuydisplay == AggregatedTS1SellBuyDisplay.Sell || SumOfBuyVolumes > SumOfSellVolumes && sellbuydisplay == AggregatedTS1SellBuyDisplay.Buy || sellbuydisplay == AggregatedTS1SellBuyDisplay.Both)
					{
						tsform.FinalizeGridRow(col0,col1,col2,col3,col4,col6, blokk,inversehilo,hi,lo);
					}
				rowadded = false;
				rowfinalized=true;
				hi=false;//switched to containing hi lo not finish on
				lo=false;//reset after row is finished
						//	Print("Updaterow ####################" +col1);
					return;
			}
			break;
		}
		}
	
		
		private int DominantLimit(int[] x)//-------------------------------------dominant Limit-------------------------------
		{
			double[] sorted = new double[x.Length];
			Array.Copy(x, sorted, x.Length);
			Array.Sort(sorted);
			
			max = 0;
			int idx = -1;
			double sum = 0;
			double prev = 0;
			
			for (int i = 0; i < sorted.Length; i++)
			{
				if (sorted[i] == prev)
					sum += sorted[i];
			
				if (sorted[i] != prev)
				{
					if (sum > max)
					{
						max = sum;
						idx = i - 1;
					}
					sum = sorted[i];
				}
				
				if (i == sorted.Length - 1)
				{
					if (sum > max)
					{
						max = sum;
						idx = i;
					}
				}
				
				prev = sorted[i];
			}
			
			return (int)sorted[idx];
		}
		

		private void whatdomlimB ()
		{
			counterB = 0;
			sizeB = 0;
			
			if (CountB1 * 1 > CountB2 * 2) { counterB=CountB1; sizeB = 1; } else {counterB=CountB2; sizeB = 2; }
			if (counterB * sizeB <= CountB3 * 3) {counterB=CountB3; sizeB = 3; }
			if (counterB * sizeB <= CountB4 * 4) {counterB=CountB4; sizeB = 4; }
			if (counterB * sizeB <= CountB5 * 5) {counterB=CountB5; sizeB = 5; }
			if (counterB * sizeB <= CountB6 * 6) {counterB=CountB6; sizeB = 6; }
			if (counterB * sizeB <= CountB7 * 7) {counterB=CountB7; sizeB = 7; }
			if (counterB * sizeB <= CountB8 * 8) {counterB=CountB8; sizeB = 8; }
			if (counterB * sizeB <= CountB9 * 9) {counterB=CountB9; sizeB = 9; }
			if (counterB * sizeB <= CountB10 * 10) {counterB=CountB10; sizeB = 10; }
			if (counterB * sizeB <= CountB15 * 15) {counterB=CountB15; sizeB = 15; }
			if (counterB * sizeB <= CountB20 * 20) {counterB=CountB20; sizeB = 20; }
		}
		private void whatdomlimS ()
		{
			counterS = 0;
			sizeS = 0;
			if (CountS1 * 1 > CountS2 * 2) { counterS=CountS1; sizeS = 1; } else {counterS=CountS2; sizeS = 2; }
			if (counterS * sizeS <= CountS3 * 3) {counterS=CountS3; sizeS = 3; }
			if (counterS * sizeS <= CountS4 * 4) {counterS=CountS4; sizeS = 4; }
			if (counterS * sizeS <= CountS5 * 5) {counterS=CountS5; sizeS = 5; }
			if (counterS * sizeS <= CountS6 * 6) {counterS=CountS6; sizeS = 6; }
			if (counterS * sizeS <= CountS7 * 7) {counterS=CountS7; sizeS = 7; }
			if (counterS * sizeS <= CountS8 * 8) {counterS=CountS8; sizeS = 8; }
			if (counterS * sizeS <= CountS9 * 9) {counterS=CountS9; sizeS = 9; }
			if (counterS * sizeS <= CountS10 * 10) {counterS=CountS10; sizeS = 10; }
			if (counterS * sizeS <= CountS15 * 15) {counterS=CountS15; sizeS = 15; }
			if (counterS * sizeS <= CountS20 * 20) {counterS=CountS20; sizeS = 20; }
			
		}
		
		private double Sum(List<double> x)
		{
			double sum = 0;
			
			for (int i = 0; i < x.Count; i++)
			{
				sum += x[i];
			}
			
			return sum;
		}
		
		#region Properties
		
//		[Browsable(false)]
//		[XmlIgnore()]
//		public DataSeries PriceDelta
//		{
//			get { return Values[1]; }
//		}
		//----------------------------------------------------------------------------------------1.Parameters
		[Description("Aggregation method for Prints")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 1 Aggregation Method")]
		public AggregatedTS1aggregationmethod AggregationMethod
		{
			get { return aggregationmethod; }
			set { aggregationmethod = value; }
		}
		
		[Description("Displays either Both, just Sell or just Buy Prints")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 2 Buy/Sell Display")]
		public AggregatedTS1SellBuyDisplay Sellbuydisplay
		{
			get { return sellbuydisplay; }
			set { sellbuydisplay = value; }
		}
		
		[Description("Aggregation Timeout for Time based Aggregation")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 3 Aggregation Timeout")]
		public int AggregationTime
		{
			get { return (int)AggregationInterval.TotalMilliseconds; }
			set { AggregationInterval = TimeSpan.FromMilliseconds(value); }
		}
		
		[Description("Minimum amount of aggregated volume to display")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 4 Lower Volume Filter")]
		public int VolumeFilter
		{
			get { return volumefilter; }
			set { volumefilter = Math.Max(1,value); }
		}
		
		[Description("Maximum amount of aggregated volume to display")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 5 Upper Volume Filter")]
		public int Smallerthanfilter
		{
			get { return smallerthanfilter; }
			set { smallerthanfilter = Math.Max(VolumeFilter,value); }
		}
		
		[Description("Minimum Size to mark a Trade as a Block")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 6 Block Size")]
		public int VolumeFilterBlock
		{
			get { return volumefilterblock; }
			set { volumefilterblock = value; }
		}
		
		[Description("Minimum Size to mark a Trade as a Lot, this should always be bigger than a Block")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 7 Lot Size")]
		public int BlockAlert
		{
			get { return blockalert; }
			set { blockalert = value; }
		}
		
		[Description("Compress rows further down.")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 8 Compress")]
		public bool Compress
		{
			get { return compress; }
			set { compress = value; }
		}
		
		[Description("If Compress is selected this determins how many compressed rows will be shown")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute(" 9 # of Compressed Rows")]
		public int Compressedrows
		{
			get { return compressedrows; }
			set { compressedrows = Math.Max(1,value); }
		}
		
		
		[Description("Show High and Low of Session")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute("10 Show High and Low")]
		public bool MarkHighAndLow
		{
			get { return inversehilo; }
			set { inversehilo = value; }
		}
		
		[Description("Sets the width of the print size column, -1 is default width")]
		[GridCategory("1.Parameters")]
		[Gui.Design.DisplayNameAttribute("11 Printsize Column Width")]
		public int Col1wid
		{
			get { return col1wid; }
			set { col1wid = value; }
		}
		//---------------------------------------------------------------------------------------------------2. Psize histogram
		[Description("Show Histogram Style Print Size")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("1 Show PrintSize Histogram")]
		public bool Showhist
		{
			get { return showhist; }
			set { showhist = value; }
		}
		
		[Description("Show Histogram in separate Column")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("2 Separate Histogram Column")]
		public bool Showhistinown
		{
			get { return showhistinown; }
			set { showhistinown = value; }
		}
		
		[Description("Separate Column Width")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("2.1 Histogram Column Width")]
		public int Profilewidth
		{
			get { return profilewidth; }
			set { profilewidth = Math.Max(0,value); }
		}
		
		[Description("Factor for increasing or reducing histogram plot width, not the column width")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("3 Histogram Plot Factor")]
		public double Histogramfactor
		{
			get { return histogramfactor; }
			set { histogramfactor = Math.Max(0,value); }
		}
		
		[XmlIgnore()]
		[Description("Histogram Buy Color")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("4 Histogram Buy Color")]
		public Color Historgamcolourpropertyb
		{
			get { return historgamcolourpropertyb; }
			set { historgamcolourpropertyb = value; }
		}
		
		[Browsable(false)]
		public string HistorgamcolourpropertybSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(historgamcolourpropertyb); }
			set { historgamcolourpropertyb = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Histogram Sell Color")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("6 Histogram Sell Color")]
		public Color Historgamcolourpropertys
		{
			get { return historgamcolourpropertys; }
			set { historgamcolourpropertys = value; }
		}
		
		[Browsable(false)]
		public string HistorgamcolourpropertysSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(historgamcolourpropertys); }
			set { historgamcolourpropertys = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		[XmlIgnore()]
		[Description("Histogram Buy Color when Histogram maxes out")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("5 Histogram Max Buy Color")]
		public Color Historgamcolourpropertybm
		{
			get { return historgamcolourpropertybm; }
			set { historgamcolourpropertybm = value; }
		}
		
		[Browsable(false)]
		public string HistorgamcolourpropertybmSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(historgamcolourpropertybm); }
			set { historgamcolourpropertybm = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Histogram Sell Color when Histogram maxes out")]
		[GridCategory("2. Print Size Histogram")]
		[Gui.Design.DisplayNameAttribute("7 Histogram Max Sell Color")]
		public Color Historgamcolourpropertysm
		{
			get { return historgamcolourpropertysm; }
			set { historgamcolourpropertysm = value; }
		}
		
		[Browsable(false)]
		public string HistorgamcolourpropertysmSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(historgamcolourpropertysm); }
			set { historgamcolourpropertysm = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		//----------------------------------------------------------------------------------------2.Format
		[Description("Price Format, chose between decimal and fractions for treasuries")]
		[GridCategory("3.Format")]
		[Gui.Design.DisplayNameAttribute("1 Price Format")]
		public AggregatedTS1pricedisplay Pricedisplay
		{
			get { return pricedisplay; }
			set { pricedisplay = value; }
		}
		
		[Description("Chose how many digits to display in Block Size column, Ticks column and Dominant Limit column, only change this if prints do not get displayed correctly. The following instruments are supported in Auto mode to display four digit prints: ES, FGBL, FGBM, FGBS, FGBX, GE, I, O, P, S, SR, TWS, XT, YT, Z3N, ZB, ZF, ZN, ZQ, ZT")]
		[GridCategory("3.Format")]
		[Gui.Design.DisplayNameAttribute("2 Digits to display")]
		public AggregatedTS1digitstodisplay Digitstodisplay
		{
			get { return digitstodisplay; }
			set { digitstodisplay = value; }
		}
		
		[Description("Font Size for the T&S window")]
		[GridCategory("3.Format")]
		[Gui.Design.DisplayNameAttribute("3 Font Size")]
		public float Fsize
		{
			get { return fsize; }
			set { fsize = value; }
		}
		
		[Description("Display hour in timestamps")]
		[GridCategory("3.Format")]
		[Gui.Design.DisplayNameAttribute("4 Display hour")]
		public bool Displayhour
		{
			get { return displayhour; }
			set { displayhour = value; }
		}
		
		//----------------------------------------------------------------------------------------5.Header
		[Description("Display the instrument in the header of the T&S?")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("1 Show Instrument in Header")]
		public bool Displayinstrument
		{
			get { return displayinstrument; }
			set { displayinstrument = value; }
		}
		[Description("Display the session high and low in the header of the T&S?")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("2 Show Hi/Lo in Header")]
		public bool Displayhilo
		{
			get { return displayhilo; }
			set { displayhilo = value; }
		}
		[Description("Display a count down to session end in the header of the T&S?")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("3 Show Timer in Header")]
		public bool Displaytimer
		{
			get { return displaytimer; }
			set { displaytimer = value; }
		}
		
		[Description("Activate Session End Alarm? !!! Only works when 3 is set to true!!!")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("3.1 Activate Session End Alarm")]
		public bool Setalert
		{
			get { return setalert; }
			set { setalert = value; }
		}
		
		[Description("How far in advance to the session end shall the alarm go off?")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("3.2 Alert Time Span")]
		public TimeSpan Alerttime
		{
			get { return alerttime; }
			set { alerttime = value; }
		}
		
		[Description("Display the tape speed in the header of the T&S?")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("4 Show Tape Speed in Header")]
		public bool Displayspeed
		{
			get { return displayspeed; }
			set { displayspeed = value; }
		}
		
		[Description("Preiod for the tape speed in seconds")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("4.1 Period for Speed")]
		public int Periodvol
		{
			get { return periodvol; }
			set { periodvol = value; }
		}
		[XmlIgnore()]
		[Description("Foreground Speed Color")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("4.2 Foreground Speed Color")]
		public Color ForegroundSpeedColor
		{
			get { return foregroundSpeedColor; }
			set { foregroundSpeedColor = value; }
		}
		
		[Browsable(false)]
		public string ForegroundSpeedColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundSpeedColor); }
			set { foregroundSpeedColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Speed Color")]
		[GridCategory("6. Header")]
		[Gui.Design.DisplayNameAttribute("4.3 Background Speed Color")]
		public Color BackgroundSpeedColor
		{
			get { return backgroundSpeedColor; }
			set { backgroundSpeedColor = value; }
		}
		
		[Browsable(false)]
		public string BackgroundSpeedColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundSpeedColor); }
			set { backgroundSpeedColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[Description("Display the ratio of ticks @Bid/@Ask in the header of the T&S?")]
		[GridCategory("6.1 Header-Pressure")]
		[Gui.Design.DisplayNameAttribute("1 Show Pressure in Header")]
		public bool Displaypressuredelta
		{
			get { return displaypressuredelta; }
			set { displaypressuredelta = value; }
		}
		
		[Description("Filtered prints are the ones appearing in the T&S window, if 'false' is chosen, all prints including the ones that got filtered out are used for calculation.")]
		[GridCategory("6.1 Header-Pressure")]
		[Gui.Design.DisplayNameAttribute("2 Use Filtered Prints")]
		public bool Onlyfiltered
		{
			get { return onlyfiltered; }
			set { onlyfiltered = value; }
		}
		[Description("use last x ticks or seconds")]
		[GridCategory("6.1 Header-Pressure")]
		[Gui.Design.DisplayNameAttribute("3 Period for Pressure")]
		public int Periodud
		{
			get { return periodud; }
			set { periodud = value; }
		}
		[Description("Ticks or Seconds")]
		[GridCategory("6.1 Header-Pressure")]
		[Gui.Design.DisplayNameAttribute("4 Period Type for Pressure")]
		public AggregatedTS1periodtypeforpressure Ptype
		{
			get { return ptype; }
			set { ptype = value; }
		}
		
		[Description("Use weighting where recent prints have more weight than the ones longer ago?")]
		[GridCategory("6.1 Header-Pressure")]
		[Gui.Design.DisplayNameAttribute("5 Use Weighting")]
		public bool Weightedpressure
		{
			get { return weightedpressure; }
			set { weightedpressure = value; }
		}
		[Description("Use ticks instead of volume?")]
		[GridCategory("6.1 Header-Pressure")]
		[Gui.Design.DisplayNameAttribute("6 Use Ticks")]
		public bool Useticksnovol
		{
			get { return useticksnovol; }
			set { useticksnovol = value; }
		}
		[Description("If the amplitude is too small, increase this factor.")]
		[GridCategory("6.1 Header-Pressure")]
		[Gui.Design.DisplayNameAttribute("7 Amplitude Factor")]
		public double Magnitude
		{
			get { return magnitude; }
			set { magnitude = value; }
		}
//		[Description("Plot pressure on chart?")]
//		[GridCategory("5.1 Header-Pressure")]
//		[Gui.Design.DisplayNameAttribute("7 Plot Pressure?")]
//		public bool Plotpressuredelta
//		{
//			get { return plotpressuredelta; }
//			set { plotpressuredelta = value; }
//		}
		
		
		
		[Description("Display the price delta in the header of the T&S?")]
		[GridCategory("6.2 Header-Price Delta")]
		[Gui.Design.DisplayNameAttribute("1 Show Price Delta in Header")]
		public bool Displaypricedelta
		{
			get { return displaypricedelta; }
			set { displaypricedelta = value; }
		}
		[Description("Display simple delta (last price- first price? Otherwise delta of prices @ask/@bid is used.")]
		[GridCategory("6.2 Header-Price Delta")]
		[Gui.Design.DisplayNameAttribute("2 Use Simple Delta?")]
		public bool Usedelta
		{
			get { return usedelta; }
			set { usedelta = value; }
		}
		[Description("Filtered prints are the ones appearing in the T&S window, if 'false' is chosen, all prints including the ones that got filtered out are used for calculation.")]
		[GridCategory("6.2 Header-Price Delta")]
		[Gui.Design.DisplayNameAttribute("3 Use Filtered Prints")]
		public bool Onlyfilteredp
		{
			get { return onlyfilteredp; }
			set { onlyfilteredp = value; }
		}
		[Description("use last x ticks or seconds")]
		[GridCategory("6.2 Header-Price Delta")]
		[Gui.Design.DisplayNameAttribute("4 Period for Price Delta")]
		public int Periodprice
		{
			get { return periodprice; }
			set { periodprice = value; }
		}
		[Description("Ticks or Seconds?")]
		[GridCategory("6.2 Header-Price Delta")]
		[Gui.Design.DisplayNameAttribute("5 Period Type for Price Delta")]
		public AggregatedTS1periodtypeforprice Ptype1 
		{
			get { return ptype1; }
			set { ptype1 = value; }
		}
		
//		[Description("Use weighting where recent prints have more weight than the ones longer ago?")]
//		[GridCategory("5.2 Header-Price Delta")]
//		[Gui.Design.DisplayNameAttribute("5 Use Weighting")]
//		public bool Weightedpressure
//		{
//			get { return weightedpressure; }
//			set { weightedpressure = value; }
//		}
		[Description("If the amplitude is too small, increase this factor, if simple delta is used, this will represent the total width of the row in priceticks.")]
		[GridCategory("6.2 Header-Price Delta")]
		[Gui.Design.DisplayNameAttribute("6 Amplitude Factor")]
		public double Magnitudep
		{
			get { return magnitudep; }
			set { magnitudep = value; }
		}
//		[Description("Plot price delta on chart?")]
//		[GridCategory("5.2 Header-Price Delta")]
//		[Gui.Design.DisplayNameAttribute("7 Plot Price Delta?")]
//		public bool Plotpricedelta
//		{
//			get { return plotpricedelta; }
//			set { plotpricedelta = value; }
//		}
		
		
		//----------------------------------------------------------------------------------------6.Window Display
		
		
		[Description("Height of window in pixels, leave at zero for default height (default is 1080px, which is HD screen height) minimum value is 45")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("4 Window height px, 0=default height")]
		public int Hipix
		{
			get { return hipix; }
			set { hipix = value; }
		}
		
		[Description("Width of window in pixels, leave at zero for auto width, minimum value is 20")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("5 Window width px, 0=auto width")]
		public int Wipix
		{
			get { return wipix; }
			set { wipix = value; }
		}
		
		
		[Description("Selects the possible scroll methods")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("1 Scrolling")]
		public AggregatedTS1Scrolltype Scrolltype
		{
			get { return scrolltype; }
			set { scrolltype = value; }
		}
		
		[Description("Sets the time in seconds starting with a new print for the scroll position to return to the top, only relevant for option 'ScrollNoBar'")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("2 Timer to return to top")]
		public int Backtotop
		{
			get { return backtotop; }
			set { backtotop = Math.Max(1,value); }
		}
		
		[Description("Always displays the window on top")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("3 Always on top")]
		public bool Ontop
		{
			get { return ontop; }
			set { ontop = value; }
		}
		
		
		
		[Description("Set custom position where the window will open x/y Coordinates")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("6 Set Position")]
		public bool Setloc
		{
			get { return setloc; }
			set { setloc = value; }
		}
		
		[Description("X Coordinate for user set window position, 0 is the left side of the screen holding the chart the indicator runs on, increasing values are further right, negative values can be set too")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("6.1 X Position")]
		public int Userx
		{
			get { return userx; }
			set { userx = value; }
		}
		
		[Description("Y Coordinate for user set window position, 0 is the top of the screen holding the chart the indicator runs on, increasing values are further down, negative values can be set too")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("6.2 Y Position")]
		public int Usery
		{
			get { return usery; }
			set { usery = value; }
		}
		
		[XmlIgnore()]
		[Description("Sets the Background Color of the Window")]
		[GridCategory("7.Window Display")]
		[Gui.Design.DisplayNameAttribute("7 Background Color")]
		public Color BackgroundColor
		{
			get { return backgroundcolor; }
			set { backgroundcolor = value; }
		}
		
		[Browsable(false)]
		public string BackgroundColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundcolor); }
			set { backgroundcolor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
//		[Description("Bring the T&S window to front afer changing workspaces")]
//		[GridCategory("Parameters")]
//		[Gui.Design.DisplayNameAttribute("2.5 Bring to Front")]
//		public bool Bringfront
//		{
//			get { return bringfront; }
//			set { bringfront = value; }
//		}
//		[Description("Speech Synthesizer ON/OFF")]
//		[GridCategory("Parameters")]
//		public bool Speech
//		{
//			get { return speech; }
//			set { speech = value; }
//		}
//		
//		[Description("Number of lines to display, this determins the win")]
//		[GridCategory("Parameters")]
//		public int NumberOfLines
//		{
//			get { return numberoflines; }
//			set { numberoflines = value; }
//		}
//		
		//----------------------------------------------------------------------------------------3.Foreground Colors
		[XmlIgnore()]
		[Description("Foreground Buy Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("1 Foreground Buy Color")]
		public Color ForegroundBuyColor
		{
			get { return foregroundbuy; }
			set { foregroundbuy = value; }
		}
		
		[Browsable(false)]
		public string ForegroundBuyColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundbuy); }
			set { foregroundbuy = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground Sell Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("2 Foreground Sell Color")]
		public Color ForegroundSellColor
		{
			get { return foregroundsell; }
			set { foregroundsell = value; }
		}
		
		[Browsable(false)]
		public string ForegroundSellColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundsell); }
			set { foregroundsell = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground Buy Block Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("3 Foreground Buy Block Color")]
		public Color ForegroundBuyColorBlock
		{
			get { return foregroundbuyblock; }
			set { foregroundbuyblock = value; }
		}
		
		[Browsable(false)]
		public string ForegroundBuyColorBlockSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundbuyblock); }
			set { foregroundbuyblock = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground Sell Block Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("4 Foreground Sell Block Color")]
		public Color ForegroundSellColorBlock
		{
			get { return foregroundsellblock; }
			set { foregroundsellblock = value; }
		}
		
		[Browsable(false)]
		public string ForegroundSellColorBlockSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundsellblock); }
			set { foregroundsellblock = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground Buy Lot Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("5 Foreground Buy Lot Color")]
		public Color Buyblockfore
		{
			get { return buyblockfore; }
			set { buyblockfore = value; }
		}
		
		[Browsable(false)]
		public string BuyblockforeSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(buyblockfore); }
			set { buyblockfore = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground Sell Lot Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("6 Foreground Sell Lot Color")]
		public Color Sellblockfore
		{
			get { return sellblockfore; }
			set { sellblockfore = value; }
		}
		
		[Browsable(false)]
		public string SellblockforeSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(sellblockfore); }
			set { sellblockfore = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground High Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("7 Foreground High Color")]
		public Color ForegroundHighColor
		{
			get { return foregroundhigh; }
			set { foregroundhigh = value; }
		}
		
		[Browsable(false)]
		public string ForegroundHighColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundhigh); }
			set { foregroundhigh = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground Low Color")]
		[GridCategory("4.Foreground Colors")]
		[Gui.Design.DisplayNameAttribute("8 Foreground Low Color")]
		public Color ForegroundLowColor
		{
			get { return foregroundlow; }
			set { foregroundlow = value; }
		}
		
		[Browsable(false)]
		public string ForegroundLowColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundlow); }
			set { foregroundlow = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		//----------------------------------------------------------------------------------------4.Background Colors
		[XmlIgnore()]
		[Description("Background Buy Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("1 Background Buy Color")]
		public Color BackgroundBuyColor
		{
			get { return backgroundbuy; }
			set { backgroundbuy = value; }
		}
		
		[Browsable(false)]
		public string BackgroundBuyColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundbuy); }
			set { backgroundbuy = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Sell Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("2 Background Sell Color")]
		public Color BackgroundSellColor
		{
			get { return backgroundsell; }
			set { backgroundsell = value; }
		}
		
		[Browsable(false)]
		public string BackgroundSellColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundsell); }
			set { backgroundsell = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Buy Block Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("3 Background Buy Block Color")]
		public Color BackgroundBuyColorBlock
		{
			get { return backgroundbuyblock; }
			set { backgroundbuyblock = value; }
		}
		
		[Browsable(false)]
		public string BackgroundBuyColorBlockSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundbuyblock); }
			set { backgroundbuyblock = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Sell Block Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("4 Background Sell Block Color")]
		public Color BackgroundSellColorBlock
		{
			get { return backgroundsellblock; }
			set { backgroundsellblock = value; }
		}
		
		[Browsable(false)]
		public string BackgroundSellColorBlockSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundsellblock); }
			set { backgroundsellblock = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Buy Lot Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("5 Background Buy Lot Color")]
		public Color Buyblockback
		{
			get { return buyblockback; }
			set { buyblockback = value; }
		}
		
		[Browsable(false)]
		public string BuyblockbackSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(buyblockback); }
			set { buyblockback = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		[XmlIgnore()]
		[Description("Background Sell Lot Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("6 Background Sell Lot Color")]
		public Color Sellblockback
		{
			get { return sellblockback; }
			set { sellblockback = value; }
		}
		
		[Browsable(false)]
		public string SellblockbackSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(sellblockback); }
			set { sellblockback = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background High Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("7 Background High Color")]
		public Color BackgroundHighColor
		{
			get { return backgroundhigh; }
			set { backgroundhigh = value; }
		}
		
		[Browsable(false)]
		public string BackgroundHighColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundhigh); }
			set { backgroundhigh = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Low Color")]
		[GridCategory("5.Background Colors")]
		[Gui.Design.DisplayNameAttribute("8 Background Low Color")]
		public Color BackgroundLowColor
		{
			get { return backgroundlow; }
			set { backgroundlow = value; }
		}
		
		[Browsable(false)]
		public string BackgroundLowColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundlow); }
			set { backgroundlow = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		
		
        #endregion


    }
	public class TSForm4 : Form
	{
		
		
//			System.Windows.Forms.Timer	timer;//= new System.Windows.Forms.Timer();
//		static System.Windows.Forms.Timer timer2 = new System.Windows.Forms.Timer();
		private bool firstrunpricewidth = true;
		private int lasttimevisrow = 0;
		private int numberoflines;
		private int NumberOfDecimals;
		private float fsize;
		
		vvAggregatedTS mainindy;
		public DataGridView grid = new DataGridView();
		DataGridView grid1 = new DataGridView();
		DataGridView grid2 = new DataGridView();
		DataGridView grid3 = new DataGridView();
		DataGridView grid4 = new DataGridView();
		DataGridView grid5 = new DataGridView();
		DataGridView grid6 = new DataGridView();
		DataGridView grid7 = new DataGridView();
		DataGridView grid8 = new DataGridView();
		//Control noscroll = new Control();
		
		
		
		public TSForm4(vvAggregatedTS indicator)
		{
			
//			if (timer == null)
//					{
////						if (DisplayTime())
////						{
//							timer = new System.Windows.Forms.Timer();
//							
//							timer.Enabled = true;
////						}
//					}
			mainindy = indicator;
			this.numberoflines = mainindy.numberoflines;
			this.fsize = (float) mainindy.fsize;
			this.NumberOfDecimals= mainindy.NumberOfDecimals;
			//mainindy.Print("before setloc flag "+mainindy.ChartControl.FindForm().Text);
			if(mainindy.setloc)
			{
				Screen.FromControl(mainindy.ChartControl.ChartPanel);
				//mainindy.Print("setting location for "+mainindy.Instrument.FullName);
				this.StartPosition = FormStartPosition.Manual;
				this.Left = Screen.FromControl(mainindy.ChartControl.ChartPanel).Bounds.Left +mainindy.userx;
				this.Top = Screen.FromControl(mainindy.ChartControl.ChartPanel).Bounds.Top +mainindy.usery;
				//mainindy.Print("set user position for "+mainindy.ChartControl.FindForm().Text);
				
			}
				
			if (mainindy.myicon != null) this.Icon = mainindy.myicon;
			
			Font fontuser = new Font (grid.DefaultCellStyle.Font.FontFamily,fsize,grid.DefaultCellStyle.Font.Style);
			Font fontuser1 = new Font (grid1.DefaultCellStyle.Font.FontFamily,fsize,FontStyle.Bold);
			grid.DefaultCellStyle.Font = fontuser;
		//	mainindy.Print("Font Size  "+grid.DefaultCellStyle.Font.Size);
				
			this.SuspendLayout();
			Graphics graphics = this.CreateGraphics();
			SizeF textSize= graphics.MeasureString(mainindy.pforlength.ToString("F"+NumberOfDecimals.ToString()), fontuser);
			 SizeF textSize0;
			if(mainindy.displayhour== false) textSize0 = graphics.MeasureString("50:58", fontuser);	else textSize0 = graphics.MeasureString(" 22:50:58", fontuser);
			SizeF textSize5 = graphics.MeasureString("T", fontuser);
			SizeF textSize7 = graphics.MeasureString("DL", fontuser);
			SizeF textSize146;
			textSize146 = graphics.MeasureString("888", fontuser);
			if(mainindy.displaydigits<=2)  textSize146 = graphics.MeasureString("88", fontuser);
			if(mainindy.displaydigits==3)  textSize146 = graphics.MeasureString("888", fontuser);
			if(mainindy.displaydigits==4)  textSize146 = graphics.MeasureString("8888", fontuser);
			if(mainindy.displaydigits==5)  textSize146 = graphics.MeasureString("88888", fontuser);
			if(mainindy.displaydigits==6)  textSize146 = graphics.MeasureString("888888", fontuser);
			if(mainindy.displaydigits==7)  textSize146 = graphics.MeasureString("8888888", fontuser);
			if(mainindy.displaydigits>=8)  textSize146 = graphics.MeasureString("88888888", fontuser);
			
			SizeF textSize3;
			textSize3 = graphics.MeasureString("(88)", fontuser);
			//mainindy.Print(graphics.MeasureString("8888", fontuser));
			//mainindy.Print(textSize+"price   "+textSize5+"T  "+textSize7+"DL  "+textSize146+"888  "+textSize3+"(888)");
		//	mainindy.Print("window width   "+((int)textSize.Width+(int)textSize0.Width+(int)textSize5.Width+(int)textSize7.Width+((int)textSize146.Width*3)+(int)textSize3.Width));
			
			if(mainindy.scrolltype == AggregatedTS1Scrolltype.None || mainindy.scrolltype == AggregatedTS1Scrolltype.ScrollNoBar)this.grid.ScrollBars = ScrollBars.None;
			else this.grid.ScrollBars = ScrollBars.Vertical;
			grid.MouseWheel += new MouseEventHandler(this.grid_Mescrolling);
			this.grid.Dock = DockStyle.Fill;
			this.grid.AllowUserToAddRows = false;
            this.grid.AllowUserToDeleteRows = false;
            this.grid.AllowUserToResizeColumns = false;
            this.grid.AllowUserToResizeRows = false;
			this.grid.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid.BackgroundColor = mainindy.backgroundcolor;
            this.grid.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.None;//None;
			this.grid.ColumnHeadersVisible = false;
			this.grid.RowHeadersVisible = false;
			this.grid.ReadOnly = true;
			this.grid.MultiSelect = false;
			this.grid.SelectionChanged += new System.EventHandler(this.grid_SelectionChanged);
			this.grid.Scroll += new ScrollEventHandler(this.grid_Scroll);
			
			if(mainindy.displayinstrument)  
			{
			
			//--------------------------------grid1--------------
			SizeF textSizegrid1 = graphics.MeasureString("Hrid1", fontuser1);
			this.grid1.ScrollBars = ScrollBars.None;
			this.grid1.Dock = DockStyle.Top;
			this.grid1.AllowUserToAddRows = false;
            this.grid1.AllowUserToDeleteRows = false;
            this.grid1.AllowUserToResizeColumns = false;
            this.grid1.AllowUserToResizeRows = false;
			this.grid1.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid1.BackgroundColor = Color.Green;
            this.grid1.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid1.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.Single;//None;
			this.grid1.GridColor = Color.Black;
			this.grid1.ColumnHeadersVisible = false;
			this.grid1.RowHeadersVisible = false;
			this.grid1.ReadOnly = true;
			this.grid1.MultiSelect = false;
			this.grid1.SelectionChanged += new System.EventHandler(this.grid1_SelectionChanged);
			grid1.DefaultCellStyle.Font = fontuser1;//
			
			}
			//--------------------------------grid1--------------
			if(mainindy.displayhilo)  
			{
			//--------------------------------grid2--------------
			
			this.grid2.ScrollBars = ScrollBars.None;
			this.grid2.Dock = DockStyle.Top;
			this.grid2.AllowUserToAddRows = false;
            this.grid2.AllowUserToDeleteRows = false;
            this.grid2.AllowUserToResizeColumns = false;
            this.grid2.AllowUserToResizeRows = false;
			this.grid2.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid2.BackgroundColor = Color.Green;
            this.grid2.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid2.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.Single;//None;
			this.grid2.GridColor = Color.Black;
			this.grid2.ColumnHeadersVisible = false;
			this.grid2.RowHeadersVisible = false;
			this.grid2.ReadOnly = true;
			this.grid2.MultiSelect = false;
			this.grid2.SelectionChanged += new System.EventHandler(this.grid2_SelectionChanged);
			grid2.DefaultCellStyle.Font = fontuser1;
			
			
			//--------------------------------grid2--------------
				}
			if(mainindy.displaytimer)  
			{
			//--------------------------------grid3--------------
			
			this.grid3.ScrollBars = ScrollBars.None;
			this.grid3.Dock = DockStyle.Top;
			this.grid3.AllowUserToAddRows = false;
            this.grid3.AllowUserToDeleteRows = false;
            this.grid3.AllowUserToResizeColumns = false;
            this.grid3.AllowUserToResizeRows = false;
			this.grid3.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid3.BackgroundColor = Color.Green;
            this.grid3.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid3.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.Single;//None;
			this.grid3.GridColor = Color.Black;
			this.grid3.ColumnHeadersVisible = false;
			this.grid3.RowHeadersVisible = false;
			this.grid3.ReadOnly = true;
			this.grid3.MultiSelect = false;
			this.grid3.SelectionChanged += new System.EventHandler(this.grid3_SelectionChanged);
			grid3.DefaultCellStyle.Font = fontuser1;
			
			
			//--------------------------------grid3--------------
				}
			if(mainindy.displayspeed)  
			{
			//--------------------------------grid4--------------
			
			this.grid4.ScrollBars = ScrollBars.None;
			this.grid4.Dock = DockStyle.Top;
			this.grid4.AllowUserToAddRows = false;
            this.grid4.AllowUserToDeleteRows = false;
            this.grid4.AllowUserToResizeColumns = false;
            this.grid4.AllowUserToResizeRows = false;
			this.grid4.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid4.BackgroundColor = Color.Green;
            this.grid4.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid4.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.Single;//None;
			this.grid4.GridColor = Color.Black;
			this.grid4.ColumnHeadersVisible = false;
			this.grid4.RowHeadersVisible = false;
			this.grid4.ReadOnly = true;
			this.grid4.MultiSelect = false;
			this.grid4.SelectionChanged += new System.EventHandler(this.grid4_SelectionChanged);
			grid4.DefaultCellStyle.Font = fontuser1;
			
			
			//--------------------------------grid4--------------
				}
		if(mainindy.displayinstrument || mainindy.displayhilo || mainindy.displaytimer || mainindy.displayspeed|| mainindy.displaypressuredelta|| mainindy.displaypricedelta)
			{
			//--------------------------------grid5--------------
			
			this.grid5.ScrollBars = ScrollBars.None;
			this.grid5.Dock = DockStyle.Top;
			this.grid5.AllowUserToAddRows = false;
            this.grid5.AllowUserToDeleteRows = false;
            this.grid5.AllowUserToResizeColumns = false;
            this.grid5.AllowUserToResizeRows = false;
			this.grid5.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid5.BackgroundColor = Color.Black;
            this.grid5.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid5.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.Single;//None;
			this.grid5.GridColor = Color.Black;
			this.grid5.ColumnHeadersVisible = false;
			this.grid5.RowHeadersVisible = false;
			this.grid5.ReadOnly = true;
			this.grid5.MultiSelect = false;
			this.grid5.SelectionChanged += new System.EventHandler(this.grid5_SelectionChanged);
			grid5.DefaultCellStyle.Font = fontuser1;
			
			
			//--------------------------------grid5--------------
			
			}
			
			if(mainindy.displaypricedelta)
			{
				//--------------------------------grid6--------------
			
			this.grid6.ScrollBars = ScrollBars.None;
			this.grid6.Dock = DockStyle.Top;
			this.grid6.AllowUserToAddRows = false;
            this.grid6.AllowUserToDeleteRows = false;
            this.grid6.AllowUserToResizeColumns = false;
            this.grid6.AllowUserToResizeRows = false;
			this.grid6.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid6.BackgroundColor = Color.Black;
            this.grid6.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid6.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.Single;//None;
			this.grid6.GridColor = Color.Black;
			this.grid6.ColumnHeadersVisible = false;
			this.grid6.RowHeadersVisible = false;
			this.grid6.ReadOnly = true;
			this.grid6.MultiSelect = false;
			this.grid6.SelectionChanged += new System.EventHandler(this.grid6_SelectionChanged);
			grid6.DefaultCellStyle.Font = fontuser1;
			
			
			//--------------------------------grid6--------------
			}
			if(mainindy.displaypressuredelta)
			{
				//--------------------------------grid7--------------
			
			this.grid7.ScrollBars = ScrollBars.None;
			this.grid7.Dock = DockStyle.Top;
			this.grid7.AllowUserToAddRows = false;
            this.grid7.AllowUserToDeleteRows = false;
            this.grid7.AllowUserToResizeColumns = false;
            this.grid7.AllowUserToResizeRows = false;
			this.grid7.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid7.BackgroundColor = Color.Black;
            this.grid7.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid7.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.Single;//None;
			this.grid7.GridColor = Color.Black;
			this.grid7.ColumnHeadersVisible = false;
			this.grid7.RowHeadersVisible = false;
			this.grid7.ReadOnly = true;
			this.grid7.MultiSelect = false;
			this.grid7.SelectionChanged += new System.EventHandler(this.grid7_SelectionChanged);
			grid7.DefaultCellStyle.Font = fontuser1;
			
			
			//--------------------------------grid7--------------
				
			//--------------------------------grid8-------------------------
			this.grid8.ScrollBars = ScrollBars.None;
			this.grid8.Dock = DockStyle.Bottom;
			this.grid8.AllowUserToAddRows = false;
            this.grid8.AllowUserToDeleteRows = false;
            this.grid8.AllowUserToResizeColumns = false;
            this.grid8.AllowUserToResizeRows = false;
			this.grid8.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid8.BackgroundColor = mainindy.backgroundcolor;
            this.grid8.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid8.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.None;//None;
			this.grid8.ColumnHeadersVisible = false;
			this.grid8.RowHeadersVisible = false;
			this.grid8.ReadOnly = true;
			this.grid8.MultiSelect = false;
			this.grid8.RowTemplate.DefaultCellStyle.BackColor = Color.Black;
			this.grid8.RowTemplate.Height = 1;
			this.grid8.Height = mainindy.compressedrows*3;
			this.grid8.SelectionChanged += new System.EventHandler(this.grid8_SelectionChanged);
				
			//-------------------------------grid8----------------------------
				}
			this.Controls.Add(grid);
			if(mainindy.displayinstrument || mainindy.displayhilo || mainindy.displaytimer || mainindy.displayspeed|| mainindy.displaypressuredelta|| mainindy.displaypricedelta) this.Controls.Add(grid5);
			if(mainindy.displaypricedelta) this.Controls.Add(grid6);
			if(mainindy.displaypressuredelta) this.Controls.Add(grid7);
			if(mainindy.displayspeed) this.Controls.Add(grid4);
			if(mainindy.displaytimer) this.Controls.Add(grid3);
			if(mainindy.displayhilo) this.Controls.Add(grid2);//##############################################
			if(mainindy.displayinstrument) this.Controls.Add(grid1);
			if(mainindy.compress) this.Controls.Add(grid8); 
			
			
			
			
			
			
			int highthelper;
			int widthhelper;
			
			if(mainindy.hipix<=44) highthelper=1080; else highthelper = mainindy.hipix;
			if(mainindy.wipix<=19)
			{
				int hiswid;
				if (mainindy.showhistinown) hiswid = mainindy.profilewidth; else hiswid = 0;
				if( mainindy.col1wid<0) hiswid += (int)textSize146.Width;
				else if(mainindy.col1wid !=0) hiswid += mainindy.col1wid;
				widthhelper=(int)textSize.Width+(int)textSize0.Width+(int)textSize5.Width+(int)textSize7.Width+((int)textSize146.Width*2)+(int)textSize3.Width+11+hiswid;
			}
			else widthhelper= mainindy.wipix;
			
			this.Size = new System.Drawing.Size(widthhelper, highthelper);//numberoflines*13+50);
			
			if (mainindy.AggregationMethod  == AggregatedTS1aggregationmethod.DOM)	this.Text = mainindy.Instrument.FullName+" | Aggregated T&S E-DOM";
			else if (mainindy.AggregationMethod  == AggregatedTS1aggregationmethod.BidAsk) this.Text = mainindy.Instrument.FullName+" | Aggregated T&S E-Bid/Ask";
			else this.Text = mainindy.Instrument.FullName+" | Aggregated T&S E-Time";
			
			this.ResumeLayout(false);
			grid.ColumnCount=9;
			grid.DefaultCellStyle.Padding=new Padding(0,0,0,0);
			if(mainindy.showhist && !mainindy.showhistinown) grid.Columns[1].CellTemplate = new DataGridViewBarGraphCellTS(mainindy);
			else if(mainindy.showhist && mainindy.showhistinown)grid.Columns[2].CellTemplate = new DataGridViewBarGraphCellTSC(mainindy);
			DataGridViewColumn tickesp = grid.Columns[3];
			tickesp.MinimumWidth= (int)textSize.Width+2;//set
			//mainindy.Print("Pricelength  "+((int)textSize.Width+2));
			
			grid.Columns[0].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid.Columns[1].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid.Columns[2].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid.Columns[4].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid.Columns[5].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid.Columns[6].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid.Columns[7].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid.Columns[8].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			
			if (mainindy.displayhour== false) grid.Columns[0].DefaultCellStyle.Format = "mm:ss";	else grid.Columns[0].DefaultCellStyle.Format = "hh:mm:ss";
			
			grid.Columns[0].ValueType = typeof(DateTime);
			grid.Columns[3].DefaultCellStyle.Format = ("F"+NumberOfDecimals.ToString());
			grid.Columns[4].DefaultCellStyle.Format = "(#)";
			//grid.Columns[6].DefaultCellStyle.Format = (0,3:#);
			grid.DefaultCellStyle.WrapMode=DataGridViewTriState.True;
			grid.RowTemplate.Height= (int)textSize.Height;
			
			grid.DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight;
//			grid.Columns[4].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleLeft; 
//			grid.Columns[6].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleLeft; 
			//grid.Columns[6].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter; 
			

			
			
			
			DataGridViewColumn tickes = grid.Columns[0]; tickes.Width = (int ) Math.Floor(textSize0.Width);//34;//set
			DataGridViewColumn tickes1 = grid.Columns[1]; 
			if(mainindy.col1wid<0) tickes1.Width = (int )Math.Floor(textSize146.Width)-1; else if(mainindy.col1wid == 0) tickes1.Visible = false; else tickes1.Width = mainindy.col1wid;//24;//set
			if(mainindy.showhist && mainindy.showhistinown) grid.Columns[2].Width = mainindy.profilewidth; else grid.Columns[2].Visible = false;
			DataGridViewColumn tickes3 = grid.Columns[4]; tickes3.Width = (int ) Math.Floor(textSize3.Width)-1;//22;//set
			if(textSize146.Width > graphics.MeasureString("8888", fontuser).Width)
			{
				DataGridViewColumn tickes4 = grid.Columns[5]; tickes4.Width = (int ) Math.Floor(graphics.MeasureString("8888", fontuser).Width)-1;//21;//set
			}
			else
			{
				DataGridViewColumn tickes4 = grid.Columns[5]; tickes4.Width = (int ) Math.Floor(textSize146.Width)-1;//21;//set
			}
			DataGridViewColumn tickes5 = grid.Columns[6]; tickes5.Width = (int ) Math.Floor(textSize5.Width);//10;//set
			DataGridViewColumn tickes6 = grid.Columns[7]; tickes6.Width = (int ) Math.Floor(textSize146.Width)-1;//21;//set20
			DataGridViewColumn tickes7 = grid.Columns[8]; tickes7.Width = (int ) Math.Floor(textSize7.Width);//17;//set17
			
			
			grid.Rows.Insert(0,40);
			foreach (DataGridViewRow i in grid.Rows)
			{
			i.DefaultCellStyle.BackColor = Color.Black;
			}
//			grid.Rows[0].Height= (int)(grid.RowTemplate.Height*1.4+0);
//			grid.Rows[1].Height= (int)(grid.RowTemplate.Height*1.4+0);
//			grid.Rows[2].Height= (int)(grid.RowTemplate.Height*1.4+0);
//			grid.Rows[3].Height= (int)(grid.RowTemplate.Height*1.4+0);
//			grid.Rows[4].Height= (int)(grid.RowTemplate.Height*1.4+0);
//			grid.Rows[5].Height= (int)(grid.RowTemplate.Height*1.4+0);
			
			
//			if(mainindy.displayinstrument==false) grid.Rows[0].Visible=false;
//			//mainindy.Print("if(mainindy.displayinstrument==false) grid.Rows[0].Visible "+grid.Rows[0].Visible);
//			if(mainindy.displayhilo==false) grid.Rows[1].Visible=false;
//			//mainindy.Print("if(mainindy.displayhilo==false) grid.Rows[1].Visible "+grid.Rows[1].Visible);
//			if(mainindy.displayspeed==false) grid.Rows[2].Visible=false;
//			//mainindy.Print("if(mainindy.displayspeed==false) grid.Rows[2].Visible "+grid.Rows[2].Visible);
//			if(mainindy.displaytimer==false) grid.Rows[3].Visible=false;
//			if(mainindy.displaypressuredelta==false) grid.Rows[4].Visible=false;
//			if(mainindy.displaypricedelta==false) grid.Rows[5].Visible=false;
//			//mainindy.Print("if(mainindy.displaytimer==false) grid.Rows[3].Visible "+grid.Rows[3].Visible);
//			//if(mainindy.displayother==false) grid.Rows[2].Visible=false;
			
			if(mainindy.displayinstrument) 
			{
			//--------------------------------grid1--------------
			grid1.ColumnCount=1;
			grid1.Rows.Insert(0,1);
			grid1.Rows[0].Height= (int)(grid.RowTemplate.Height*1.4)-0;//changed
			grid1.Rows[0].DefaultCellStyle.ForeColor = Color.Black;
			grid1.Rows[0].DefaultCellStyle.BackColor = Color.White;
			grid1.Rows[0].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
			
			//mainindy.Print("height "+grid1.Rows[0].Height);
			this.grid1.Height = (int)(grid.RowTemplate.Height*1.4);//changed
			grid1.Rows[0].Cells[0].Value = mainindy.Instrument.FullName;
			}
			else this.grid1.Height = (int)(0);
			//mainindy.Print("this.grid1.Height "+this.grid1.Height);
			
			if(mainindy.displayhilo) 
			{
			//--------------------------------grid2--------------
			grid2.ColumnCount=2;
			grid2.Rows.Insert(0,1);
			grid2.Rows[0].Height= (int)(grid.RowTemplate.Height*1.4)-0;
			//grid2.Rows[1].Height= (int)(grid.RowTemplate.Height*1.5);
			grid2.Rows[0].DefaultCellStyle.Format = ("F"+NumberOfDecimals.ToString());
			
			grid2.Rows[0].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
			
			//mainindy.Print("height "+grid2.Rows[0].Height);
			this.grid2.Height = (int)(grid.RowTemplate.Height*1.4)+0;
			
			grid2.Rows[0].Cells[0].Value = mainindy.sesshi*mainindy.TickSize;
			grid2.Columns[0].DefaultCellStyle.ForeColor = Color.Green;
			grid2.Columns[0].DefaultCellStyle.BackColor = Color.Honeydew;//mainindy.backgroundbuy;
			grid2.Rows[0].DefaultCellStyle.Format = ("F"+NumberOfDecimals.ToString());
			grid2.Rows[0].Cells[1].Value = mainindy.sesslo*mainindy.TickSize;
			grid2.Columns[1].DefaultCellStyle.ForeColor = Color.Red;
			grid2.Columns[1].DefaultCellStyle.BackColor = Color.MistyRose;//mainindy.backgroundsell;
			
			}
			else this.grid2.Height = (int)(0);
			//mainindy.Print("this.grid2.Height "+this.grid2.Height);
			
			
			if(mainindy.displaytimer) 
			{
			//--------------------------------grid3--------------
			grid3.ColumnCount=1;
			grid3.Rows.Insert(0,1);
			grid3.Rows[0].Height= (int)(grid.RowTemplate.Height*1.4)-0;
			//grid2.Rows[1].Height= (int)(grid.RowTemplate.Height*1.5);
			//grid3.Rows[0].DefaultCellStyle.Format = ("hh:mm:ss");
			
			grid3.Rows[0].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
			
			//mainindy.Print("height "+grid2.Rows[0].Height);
			this.grid3.Height = (int)(grid.RowTemplate.Height*1.4)+0;
			
			grid3.Rows[0].Cells[0].Value = 0;//fix this
			grid3.Columns[0].DefaultCellStyle.ForeColor = Color.Green;
			grid3.Columns[0].DefaultCellStyle.BackColor = Color.LightGray;
			
			
			}
			else this.grid3.Height = (int)(0);
			//mainindy.Print("this.grid3.Height "+this.grid3.Height);
			
			if(mainindy.displayspeed) 
			{
			//--------------------------------grid4--------------
			grid4.ColumnCount=2;
			grid4.Rows.Insert(0,1);
			grid4.Rows[0].Height= (int)(grid.RowTemplate.Height*1.4)-0;
			//grid2.Rows[1].Height= (int)(grid.RowTemplate.Height*1.5);
			//grid4.Rows[0].DefaultCellStyle.Format = ("F0");
			
			grid4.Rows[0].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
			
			//mainindy.Print("height "+grid2.Rows[0].Height);
			this.grid4.Height = (int)(grid.RowTemplate.Height*1.4)+0;
			
			grid4.Rows[0].Cells[0].Value = 0;
			//grid4.Rows[0].Cells[1].Value = 0;
			grid4.Rows[0].DefaultCellStyle.ForeColor = mainindy.ForegroundSpeedColor;
			grid4.Columns[0].DefaultCellStyle.BackColor = mainindy.BackgroundSpeedColor;
			grid4.Columns[1].DefaultCellStyle.BackColor = Color.LightGray;
			}
			else this.grid4.Height = (int)(0);
			//mainindy.Print("this.grid4.Height "+this.grid4.Height);
			
			if(mainindy.displayinstrument || mainindy.displayhilo || mainindy.displaytimer || mainindy.displayspeed)
			{
			//--------------------------------grid5--------------just line
			grid5.ColumnCount=1;
			grid5.Rows.Insert(0,1);
			grid5.Rows[0].DefaultCellStyle.BackColor = Color.Black;
			this.grid5.Height = (int)(2)+0;
			}
			else this.grid5.Height = (int)(0);
			//mainindy.Print("this.grid5.Height "+this.grid5.Height);
			
			if(mainindy.displaypricedelta) 
			{
			//--------------------------------grid6--------------
			grid6.ColumnCount=2;
			grid6.Rows.Insert(0,1);
			grid6.Rows[0].Height= (int)(grid.RowTemplate.Height*1.4)-0;//changed
			grid6.Columns[0].DefaultCellStyle.BackColor = Color.DarkGreen;
			grid6.Columns[1].DefaultCellStyle.BackColor = Color.DarkRed;
			DataGridViewColumn wid60 = grid6.Columns[0]; wid60.Width = (int ) Math.Floor((double) grid.Width/2);
			
			//mainindy.Print("height "+grid1.Rows[0].Height);
			this.grid6.Height = (int)(grid.RowTemplate.Height*1.4);//changed
			}
			else this.grid6.Height = (int)(0);
			
			if(mainindy.displaypressuredelta) 
			{
			//--------------------------------grid7--------------pressure
			grid7.ColumnCount=2;
			grid7.Rows.Insert(0,1);
			grid7.Rows[0].Height= (int)(grid.RowTemplate.Height*1.4)-0;//changed
			grid7.Columns[0].DefaultCellStyle.BackColor = Color.Green;
			grid7.Columns[1].DefaultCellStyle.BackColor = Color.Red;
			
			DataGridViewColumn wid70 = grid7.Columns[0]; wid70.Width = (int ) Math.Floor((double)grid.Width/2);
			//mainindy.Print("height "+grid1.Rows[0].Height);
			this.grid7.Height = (int)(grid.RowTemplate.Height*1.4);//changed
			}
			else this.grid7.Height = (int)(0);
			//--------------------------------grid8--------------compressed
			if(mainindy.compress)
			{
			grid8.ColumnCount=5;
				
				int rowstoadd = 2*mainindy.compressedrows;
			grid8.Rows.Insert(0,rowstoadd+120);
				if(mainindy.showhist && !mainindy.showhistinown) grid8.Columns[1].CellTemplate = new DataGridViewBarGraphCellTSC(mainindy);
			else if(mainindy.showhist && mainindy.showhistinown) grid8.Columns[2].CellTemplate = new DataGridViewBarGraphCellTSC(mainindy);
			
			grid8.Columns[0].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid8.Columns[1].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid8.Columns[2].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid8.Columns[3].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			grid8.Columns[4].AutoSizeMode=DataGridViewAutoSizeColumnMode.Fill;
			grid8.Columns[0].Width = grid.Columns[0].Width;
			grid8.Columns[1].Width = grid.Columns[1].Width;
			if(!grid.Columns[1].Visible) grid8.Columns[1].Visible = false;
			grid8.Columns[2].Width = grid.Columns[2].Width;
			if(!grid.Columns[2].Visible) grid8.Columns[2].Visible = false;
			grid8.Columns[3].Width = grid.Columns[3].Width;
			grid8.Columns[1].DefaultCellStyle.ForeColor = Color.Transparent;
			
				
			}
			
			
		}
		
		public void setPressureWidth(double width)
		{
//			mainindy.Print("totalwidth "+grid.Width);
//			mainindy.Print("ratio "+width);
			int wid = (int ) Math.Round((double)grid.Width*width);
			if (wid > grid.Width) wid = grid.Width;
			else if (wid < 0) wid = 0;
			DataGridViewColumn wid70 = grid7.Columns[0]; wid70.Width = wid;
		}
		
		public void setPrriceDeltaWidth(double width)
		{
			//mainindy.Print("setwidthflag ");
			int wid = (int ) Math.Round((double)grid.Width*width);
			if (wid > grid.Width) wid = grid.Width;
			else if (wid < 0) wid = 0;
			
			DataGridViewColumn wid60 = grid6.Columns[0]; wid60.Width = wid;
		}
		
		public void showTimerTime(TimeSpan timertime)
		{
			//mainindy.Print("timertime printed "+timertime);
			grid3.Rows[0].Cells[0].Value = timertime.Hours.ToString("00")+":"+timertime.Minutes.ToString("00")+":"+timertime.Seconds.ToString("00");
			
			
			
		}
		public void showVolSpeed(int volume, int chng)
		{
			grid4.Rows[0].Cells[0].Value = volume;
			//grid4.Rows[0].Cells[1].Value = volume;
			
			double width = (double) volume / mainindy.scalewidth;
			
			int wid = (int ) Math.Round((double)grid.Width*width);
			
			if (wid > grid.Width) wid = grid.Width;
			else if (wid < 0) wid = 0;
			
			DataGridViewColumn wid40 = grid4.Columns[0]; wid40.Width = wid;
			
			
//			grid4.Rows[0].Cells[1].Value = chng;
//			if(chng<0) grid4.Rows[0].DefaultCellStyle.ForeColor = Color.Red;
//			else grid4.Rows[0].DefaultCellStyle.ForeColor = Color.Green;
			
			
		}
		public void GetNewHiLo()
		{
			double pricehelpl = (double) mainindy.sesslo*mainindy.TickSize;
			double pricehelph = (double) mainindy.sesshi*mainindy.TickSize;
			switch(mainindy.pricedisplay1)
			{
				case 0: grid2.Rows[0].Cells[1].Value = pricehelpl;
						grid2.Rows[0].Cells[0].Value = pricehelph;
						break;
				case 1: 
						grid2.Rows[0].Cells[1].Value = System.Math.Floor(pricehelpl) +((pricehelpl - System.Math.Floor(pricehelpl))*0.16);
						grid2.Rows[0].Cells[0].Value = System.Math.Floor(pricehelph) +((pricehelph - System.Math.Floor(pricehelph))*0.16);
						break;
				case 2: grid2.Rows[0].Cells[1].Value = System.Math.Floor(pricehelpl) +((pricehelpl - System.Math.Floor(pricehelpl))*0.32);
						grid2.Rows[0].Cells[0].Value = System.Math.Floor(pricehelph) +((pricehelph - System.Math.Floor(pricehelph))*0.32);
						break;
				case 3: grid2.Rows[0].Cells[1].Value = System.Math.Floor(pricehelpl) +((pricehelpl - System.Math.Floor(pricehelpl))*0.64);
						grid2.Rows[0].Cells[0].Value = System.Math.Floor(pricehelph) +((pricehelph - System.Math.Floor(pricehelph))*0.64);
						break;
			}
		}
		
		
		private void grid_Mescrolling(object sender, MouseEventArgs e)
		{
			if(mainindy.scrolltype != AggregatedTS1Scrolltype.ScrollNoBar) return;
			if(e.Delta > 0 && grid.FirstDisplayedScrollingRowIndex > 0)
			{
				mainindy.Stoptimer2();
				grid.FirstDisplayedScrollingRowIndex--;
			}
			else if(e.Delta < 0)
			{
				mainindy.Stoptimer2();
				grid.FirstDisplayedScrollingRowIndex++;
			}
			grid8.FirstDisplayedScrollingRowIndex = grid.FirstDisplayedScrollingRowIndex + grid.DisplayedRowCount(false) + 0;
		}
		private void grid_Scroll(object sender, EventArgs e)
		{
			grid8.FirstDisplayedScrollingRowIndex = grid.FirstDisplayedScrollingRowIndex + grid.DisplayedRowCount(false) + 0;
		}
		
		public void AddGridRow(DateTime col0,int col1,double col2,int col3,int col4,int col6,  bool blokk,bool inversehilo,bool hi,bool lo)
		{
			if(mainindy.showhist) mainindy.printsizelist.Insert(0,0);
			if(grid.FirstDisplayedScrollingRowIndex > 0 ) mainindy.Starttimer2();
			grid.Rows.Insert(0,1);
			if(mainindy.compress)
			{
				grid8.Rows.Insert(0,1);
				grid8.FirstDisplayedScrollingRowIndex = grid.FirstDisplayedScrollingRowIndex + grid.DisplayedRowCount(true) + 0;
			}
		//	grid.Rows[0].Height = 13;
			if(firstrunpricewidth)
			{
			Graphics graphics = this.CreateGraphics();
			SizeF textSize = graphics.MeasureString(col2.ToString("F"+mainindy.NumberOfDecimals), this.Font);
			DataGridViewColumn tickesp = grid.Columns[3]; tickesp.MinimumWidth= (int)textSize.Width+2;//set
			if(mainindy.compress) grid8.Columns[3].MinimumWidth = grid.Columns[3].MinimumWidth;
				firstrunpricewidth=false;
			}
//			grid.FirstDisplayedCell.RowIndex;
			int countrows = grid.Rows.Count;
//			if(mainindy.compress && countrows > mainindy.compafter)
//			{
////				mainindy.Print("compressing");
//				grid.Rows[mainindy.compafter].Height = 1;
//				
//			}
			if (countrows > 100000)
			{
				grid.Rows.Remove(grid.Rows[countrows-1]);
				if(mainindy.compress) grid8.Rows.Remove(grid8.Rows[countrows-1]);
			}
			//grid.Rows[0].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight;
			UpdateGridRow(col0,col1,col2,col3,col4,col6, blokk,inversehilo,hi,lo);
			//if (countrows > 20) mainindy.Print("timeback "+ grid.Rows[20].Cells[0].Value);
			
			
			 
		}
		public void AddSessionBreak(bool first)
		{
			grid.Rows.Insert(0,1);
			if(mainindy.compress) grid8.Rows.Insert(0,1);
		
			int countrows = grid.Rows.Count;
			if (countrows > 100000)
			{
				grid.Rows.Remove(grid.Rows[countrows-1]);
				if(mainindy.compress) grid8.Rows.Remove(grid8.Rows[countrows-1]);
			}
			//grid.Rows[0].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight;
			if(first)grid.Rows[0].Cells[3].Value="Start"; else grid.Rows[0].Cells[3].Value="Sess";
			if(first)grid.Rows[0].Cells[4].Value="TS"; else grid.Rows[0].Cells[4].Value="Brk";
			grid.Rows[0].DefaultCellStyle.ForeColor =  Color.Black;
			grid.Rows[0].DefaultCellStyle.BackColor = Color.Yellow;
			
			if(mainindy.compress) grid8.Rows[0].DefaultCellStyle.BackColor = Color.Yellow;
			
			
			 
		}

		public void UpdateGridRow(DateTime col0,int col1,double col2,int col3,int col4,int col6, bool blokk,bool inversehilo,bool hi,bool lo)
		{
			
			if(mainindy.showhist) mainindy.printsizelist[0] = col1;
			grid.Rows[0].Cells[0].Value=col0;//.ToString("mm:ss");
			grid.Rows[0].Cells[1].Value=col1;//.ToString();
//			if(mainindy.compress && mainindy.showhist && mainindy.showhistinown) grid8.Rows[0].Cells[1].Value=col1;
			if( mainindy.smallerthanfilter < col1)
			{ 
				grid.Rows[0].Visible = false;
				return;
			}
			grid.Rows[0].Cells[3].Value=col2;//.ToString();//("#######.00");//price
//			mainindy.Print("price"+col2);
			
			if (col3>0) {
				grid.Rows[0].Cells[4].Value=col3;//.ToString("(#)");
			}
			if (col4>-1) {
				grid.Rows[0].Cells[6].Value="T";
				grid.Rows[0].Cells[5].Value=col4;//.ToString();
			}
			if (col6>-1) {
				grid.Rows[0].Cells[8].Value="DL";
				grid.Rows[0].Cells[7].Value=col6;//"{0,3:#}");
			}
			
			Color colorlof;// = Color.MistyRose;
			Color colorlob;// = Color.Crimson;
			Color colorhif;// = Color.Green;
			Color colorhib;// = Color.Honeydew;
			
			colorlof = mainindy.ForegroundLowColor;
			colorlob = mainindy.BackgroundLowColor;
			colorhif = mainindy.ForegroundHighColor;
			colorhib = mainindy.BackgroundHighColor;
			

			grid.Rows[0].DefaultCellStyle.ForeColor = mainindy.Rainbow;//color;
			grid.Rows[0].DefaultCellStyle.BackColor = mainindy.Rainbow2;//color2;
			grid.Rows[0].Cells[2].Style.ForeColor = mainindy.historgamcolourproperty;
			if(mainindy.compress && mainindy.showhist && mainindy.showhistinown) grid8.Rows[0].Cells[2].Style.ForeColor = mainindy.historgamcolourproperty;
			else if(mainindy.compress && mainindy.showhist && !mainindy.showhistinown) grid8.Rows[0].Cells[1].Style.ForeColor = mainindy.historgamcolourproperty;
			if(mainindy.compress) grid8.Rows[0].DefaultCellStyle.BackColor = mainindy.Rainbow2;//color2;
			if(blokk)
			{
				grid.Rows[0].Cells[1].Style.ForeColor = mainindy.Blockfore;//color4;
				grid.Rows[0].Cells[1].Style.BackColor = mainindy.Blockback;//color3;
				if(mainindy.compress) grid8.Rows[0].Cells[1].Style.BackColor = mainindy.Blockback;//color3;
			}
			
			if(inversehilo)
			{
				if(hi)
				{
					grid.Rows[0].Cells[3].Style.ForeColor = colorhif;
					grid.Rows[0].Cells[3].Style.BackColor = colorhib;
					if(mainindy.compress)
					{
						grid8.Rows[0].Cells[3].Style.BackColor = colorhib;
						grid8.Columns[3].Width = grid.Columns[3].Width;
						
					}
				}
				else if(lo)
				{
					grid.Rows[0].Cells[3].Style.ForeColor = colorlof;
					grid.Rows[0].Cells[3].Style.BackColor = colorlob;
					if(mainindy.compress)
					{
						grid8.Rows[0].Cells[3].Style.BackColor = colorlob;
						grid8.Columns[3].Width = grid.Columns[3].Width;
					}
				}
				
					
				
			}
			
			
		}
		public void FinalizeGridRow(DateTime col0,int col1,double col2,int col3,int col4,int col6,  bool blokk,bool inversehilo,bool hi,bool lo)
		{
			if(mainindy.showhist) mainindy.printsizelist[0] = col1;
			if( mainindy.smallerthanfilter < col1)
			{ 
				grid.Rows.Remove(grid.Rows[0]);
				if(mainindy.compress) grid8.Rows.Remove(grid.Rows[0]);
				return;
			}
//			mainindy.Print(col0+"	"+col1+"	"+col2+"	"+col3+"	"+col4+" T	"+col6+" DL	Block: "+blokk+"	High: "+hi+"	Low:"+lo);
			grid.Rows[0].Cells[0].Value=col0;//.ToString("mm:ss");
			grid.Rows[0].Cells[1].Value=col1;//.ToString();
			grid.Rows[0].Cells[3].Value=col2;//.ToString();//("#######.00");//price
			
			if (col3>0) {
				grid.Rows[0].Cells[4].Value=col3;//.ToString("(#)");
			}
			if (col4>-1) {
				grid.Rows[0].Cells[6].Value="T";
				grid.Rows[0].Cells[5].Value=col4;//.ToString();
			}
			
			if (col6>-1) {
				grid.Rows[0].Cells[8].Value="DL";
				grid.Rows[0].Cells[7].Value=col6;//.ToString().PadLeft(4);
			}
			Color colorlof;// = Color.MistyRose;
			Color colorlob;// = Color.Crimson;
			Color colorhif;// = Color.Green;
			Color colorhib;// = Color.Honeydew;
			
			colorlof = mainindy.ForegroundLowColor;
			colorlob = mainindy.BackgroundLowColor;
			colorhif = mainindy.ForegroundHighColor;
			colorhib = mainindy.BackgroundHighColor;
			

			grid.Rows[0].DefaultCellStyle.ForeColor = mainindy.Rainbow;//color;
			grid.Rows[0].DefaultCellStyle.BackColor = mainindy.Rainbow2;//color2;
			grid.Rows[0].Cells[2].Style.ForeColor = mainindy.historgamcolourproperty;
			if(mainindy.compress) grid8.Rows[0].DefaultCellStyle.BackColor = mainindy.Rainbow2;//color2;
			if(mainindy.compress && mainindy.showhist && mainindy.showhistinown) grid8.Rows[0].Cells[2].Style.ForeColor = mainindy.historgamcolourproperty;
			else if(mainindy.compress && mainindy.showhist && !mainindy.showhistinown) grid8.Rows[0].Cells[1].Style.ForeColor = mainindy.historgamcolourproperty;
			if(blokk)
			{
				grid.Rows[0].Cells[1].Style.ForeColor = mainindy.Blockfore;//color4;
				grid.Rows[0].Cells[1].Style.BackColor = mainindy.Blockback;//color3;
				if(mainindy.compress) grid8.Rows[0].Cells[1].Style.BackColor = mainindy.Blockback;//color3;
			}
			if(inversehilo)
			{
				if(hi)
				{
					grid.Rows[0].Cells[3].Style.ForeColor = colorhif;
					grid.Rows[0].Cells[3].Style.BackColor = colorhib;
					if(mainindy.compress)
					{
						grid8.Rows[0].Cells[3].Style.BackColor = colorhib;
						grid8.Columns[3].Width = grid.Columns[3].Width;
						
					}
				}
				else if(lo)
				{
					grid.Rows[0].Cells[3].Style.ForeColor = colorlof;
					grid.Rows[0].Cells[3].Style.BackColor = colorlob;
					if(mainindy.compress)
					{
						grid8.Rows[0].Cells[3].Style.BackColor = colorlob;
						grid8.Columns[3].Width = grid.Columns[3].Width;
						
					}
				}
			}
			
			
		}
		
		private void grid_SelectionChanged(object sender, EventArgs e)
        {
            if (this.grid.SelectedCells.Count > 0)
            {
                this.grid.SelectedCells[0].Selected = false;
            }
		}
		
			private void grid1_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid1.SelectedCells.Count > 0)
            {
                this.grid1.SelectedCells[0].Selected = false;
            }
		}
		
			private void grid2_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid2.SelectedCells.Count > 0)
            {
                this.grid2.SelectedCells[0].Selected = false;
            }
		}
		
			private void grid3_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid3.SelectedCells.Count > 0)
            {
                this.grid3.SelectedCells[0].Selected = false;
            }
		}
		
			private void grid4_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid4.SelectedCells.Count > 0)
            {
                this.grid4.SelectedCells[0].Selected = false;
            }
		}
		
			private void grid5_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid5.SelectedCells.Count > 0)
            {
                this.grid5.SelectedCells[0].Selected = false;
            }
		}
		
			private void grid6_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid6.SelectedCells.Count > 0)
            {
                this.grid6.SelectedCells[0].Selected = false;
            }
		}
		
			private void grid7_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid7.SelectedCells.Count > 0)
            {
                this.grid7.SelectedCells[0].Selected = false;
            }
		
        }
			private void grid8_SelectionChanged(object sender, EventArgs e)
        {
			if (this.grid8.SelectedCells.Count > 0)
            {
                this.grid8.SelectedCells[0].Selected = false;
            }
		
        }
		
//		protected   void grid_PostPaint(object sender,	EventArgs ev) 
//		{
//				
//			DataGridViewRowPostPaintEventArgs e = (DataGridViewRowPostPaintEventArgs) ev;
//
//			Brush b = SystemBrushes.ButtonFace;
//			e.Graphics.FillRectangle(b,0,0,e.RowBounds.Width,e.RowBounds.Height);
//		}

	}
	
	public class DataGridViewBarGraphCellTS : DataGridViewTextBoxCell 
		{
			vvAggregatedTS mainindy =null;
			public  DataGridViewBarGraphCellTS () : base() {
			}
			public  DataGridViewBarGraphCellTS (vvAggregatedTS indicator) : base() 
		{
			
			 mainindy = indicator;
		}
			
		public override object Clone() {
			DataGridViewBarGraphCellTS xx = base.Clone() as DataGridViewBarGraphCellTS;
			xx.mainindy = this.mainindy;
			return xx;
		}
			protected override void Paint(
			Graphics graphics, 
			Rectangle clipBounds, 
			Rectangle cellBounds, 
			int rowIndex, 
			DataGridViewElementStates cellState, 
			object value, object formattedValue, 
			string errorText, 
			DataGridViewCellStyle cellStyle, 
			DataGridViewAdvancedBorderStyle advancedBorderStyle, 
			DataGridViewPaintParts paintParts)
			{
				
			base.Paint(graphics, clipBounds, cellBounds,
				rowIndex, cellState,
				value, "", errorText, cellStyle,
				advancedBorderStyle, paintParts);

			//  Get the value of the cell:need to create list for faster access
			float cellValue = (float) (mainindy.printsizelist[rowIndex]*mainindy.histogramfactor);
			float startpoint = (float)(cellBounds.X+(cellBounds.Width - cellValue)/2);
			startpoint = Math.Max(cellBounds.X, startpoint);
			float widt = Math.Min(cellBounds.Width, cellValue);
			

			using (SolidBrush brush = new SolidBrush(this.OwningRow.Cells[2].Style.ForeColor))//cellStyle.ForeColor))//mainindy.historgamcolourproperty))
			{
				RectangleF newRect = new RectangleF(
				startpoint,// + HORIZONTALOFFSET,
				cellBounds.Y,// + VERTOFFSET,
				widt,//Convert.ToSingle(cellValue),//now has 0 instead of empty
				cellBounds.Height);// - (VERTOFFSET * 2));
			graphics.FillRectangle(brush, newRect);//-----------------------------------------colo for bar
			}

			
			string cellText;
//			if(cellValue == 0) cellText = ""; else 
			cellText = formattedValue.ToString();

			using (SolidBrush brush = new SolidBrush(cellStyle.ForeColor))
			{
				graphics.DrawString(cellText ,cellStyle.Font, brush,
				cellBounds.Right ,//+ cellBounds.Width-textSize,//textStart.X,
				cellBounds.Y+1,mainindy.sf);//textStart.Y);

			}

		}
		
	
	}
	public class DataGridViewBarGraphCellTSC : DataGridViewTextBoxCell 
		{
			vvAggregatedTS mainindy =null;
			public  DataGridViewBarGraphCellTSC () : base() {
			}
			public  DataGridViewBarGraphCellTSC (vvAggregatedTS indicator) : base() 
		{
			
			 mainindy = indicator;
		}
			
		public override object Clone() {
			DataGridViewBarGraphCellTSC xx = base.Clone() as DataGridViewBarGraphCellTSC;
			xx.mainindy = this.mainindy;
			return xx;
		}
			protected override void Paint(
			Graphics graphics, 
			Rectangle clipBounds, 
			Rectangle cellBounds, 
			int rowIndex, 
			DataGridViewElementStates cellState, 
			object value, object formattedValue, 
			string errorText, 
			DataGridViewCellStyle cellStyle, 
			DataGridViewAdvancedBorderStyle advancedBorderStyle, 
			DataGridViewPaintParts paintParts)
			{
				
			base.Paint(graphics, clipBounds, cellBounds,
				rowIndex, cellState,
				value, "", errorText, cellStyle,
				advancedBorderStyle, paintParts);
			float cellValue = (float) (mainindy.printsizelist[rowIndex]*mainindy.histogramfactor);
			float startpoint = (float)(cellBounds.X+(cellBounds.Width - cellValue)/2);
			startpoint = Math.Max(cellBounds.X, startpoint);
			float widt = Math.Min(cellBounds.Width, cellValue);

				using (SolidBrush brush = new SolidBrush(cellStyle.ForeColor))//mainindy.historgamcolourproperty))
				{
					RectangleF newRect = new RectangleF(
					startpoint,// + HORIZONTALOFFSET,
					cellBounds.Y,// + VERTOFFSET,
					widt,//Convert.ToSingle(cellValue),//now has 0 instead of empty
					cellBounds.Height);// - (VERTOFFSET * 2));
					graphics.FillRectangle(brush, newRect);//-----------------------------------------colo for bar
				}

		}
		
	
	}
	

}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private vvAggregatedTS[] cachevvAggregatedTS = null;

        private static vvAggregatedTS checkvvAggregatedTS = new vvAggregatedTS();

        /// <summary>
        /// Aggregated Time & Sales 
        /// </summary>
        /// <returns></returns>
        public vvAggregatedTS vvAggregatedTS(AggregatedTS1aggregationmethod aggregationMethod, int aggregationTime, TimeSpan alerttime, Color backgroundBuyColor, Color backgroundBuyColorBlock, Color backgroundColor, Color backgroundHighColor, Color backgroundLowColor, Color backgroundSellColor, Color backgroundSellColorBlock, Color backgroundSpeedColor, int backtotop, int blockAlert, Color buyblockback, Color buyblockfore, int col1wid, bool compress, int compressedrows, AggregatedTS1digitstodisplay digitstodisplay, bool displayhilo, bool displayhour, bool displayinstrument, bool displaypressuredelta, bool displaypricedelta, bool displayspeed, bool displaytimer, Color foregroundBuyColor, Color foregroundBuyColorBlock, Color foregroundHighColor, Color foregroundLowColor, Color foregroundSellColor, Color foregroundSellColorBlock, Color foregroundSpeedColor, float fsize, int hipix, double histogramfactor, Color historgamcolourpropertyb, Color historgamcolourpropertybm, Color historgamcolourpropertys, Color historgamcolourpropertysm, double magnitude, double magnitudep, bool markHighAndLow, bool onlyfiltered, bool onlyfilteredp, bool ontop, int periodprice, int periodud, int periodvol, AggregatedTS1pricedisplay pricedisplay, int profilewidth, AggregatedTS1periodtypeforpressure ptype, AggregatedTS1periodtypeforprice ptype1, AggregatedTS1Scrolltype scrolltype, Color sellblockback, Color sellblockfore, AggregatedTS1SellBuyDisplay sellbuydisplay, bool setalert, bool setloc, bool showhist, bool showhistinown, int smallerthanfilter, bool usedelta, int userx, int usery, bool useticksnovol, int volumeFilter, int volumeFilterBlock, bool weightedpressure, int wipix)
        {
            return vvAggregatedTS(Input, aggregationMethod, aggregationTime, alerttime, backgroundBuyColor, backgroundBuyColorBlock, backgroundColor, backgroundHighColor, backgroundLowColor, backgroundSellColor, backgroundSellColorBlock, backgroundSpeedColor, backtotop, blockAlert, buyblockback, buyblockfore, col1wid, compress, compressedrows, digitstodisplay, displayhilo, displayhour, displayinstrument, displaypressuredelta, displaypricedelta, displayspeed, displaytimer, foregroundBuyColor, foregroundBuyColorBlock, foregroundHighColor, foregroundLowColor, foregroundSellColor, foregroundSellColorBlock, foregroundSpeedColor, fsize, hipix, histogramfactor, historgamcolourpropertyb, historgamcolourpropertybm, historgamcolourpropertys, historgamcolourpropertysm, magnitude, magnitudep, markHighAndLow, onlyfiltered, onlyfilteredp, ontop, periodprice, periodud, periodvol, pricedisplay, profilewidth, ptype, ptype1, scrolltype, sellblockback, sellblockfore, sellbuydisplay, setalert, setloc, showhist, showhistinown, smallerthanfilter, usedelta, userx, usery, useticksnovol, volumeFilter, volumeFilterBlock, weightedpressure, wipix);
        }

        /// <summary>
        /// Aggregated Time & Sales 
        /// </summary>
        /// <returns></returns>
        public vvAggregatedTS vvAggregatedTS(Data.IDataSeries input, AggregatedTS1aggregationmethod aggregationMethod, int aggregationTime, TimeSpan alerttime, Color backgroundBuyColor, Color backgroundBuyColorBlock, Color backgroundColor, Color backgroundHighColor, Color backgroundLowColor, Color backgroundSellColor, Color backgroundSellColorBlock, Color backgroundSpeedColor, int backtotop, int blockAlert, Color buyblockback, Color buyblockfore, int col1wid, bool compress, int compressedrows, AggregatedTS1digitstodisplay digitstodisplay, bool displayhilo, bool displayhour, bool displayinstrument, bool displaypressuredelta, bool displaypricedelta, bool displayspeed, bool displaytimer, Color foregroundBuyColor, Color foregroundBuyColorBlock, Color foregroundHighColor, Color foregroundLowColor, Color foregroundSellColor, Color foregroundSellColorBlock, Color foregroundSpeedColor, float fsize, int hipix, double histogramfactor, Color historgamcolourpropertyb, Color historgamcolourpropertybm, Color historgamcolourpropertys, Color historgamcolourpropertysm, double magnitude, double magnitudep, bool markHighAndLow, bool onlyfiltered, bool onlyfilteredp, bool ontop, int periodprice, int periodud, int periodvol, AggregatedTS1pricedisplay pricedisplay, int profilewidth, AggregatedTS1periodtypeforpressure ptype, AggregatedTS1periodtypeforprice ptype1, AggregatedTS1Scrolltype scrolltype, Color sellblockback, Color sellblockfore, AggregatedTS1SellBuyDisplay sellbuydisplay, bool setalert, bool setloc, bool showhist, bool showhistinown, int smallerthanfilter, bool usedelta, int userx, int usery, bool useticksnovol, int volumeFilter, int volumeFilterBlock, bool weightedpressure, int wipix)
        {
            if (cachevvAggregatedTS != null)
                for (int idx = 0; idx < cachevvAggregatedTS.Length; idx++)
                    if (cachevvAggregatedTS[idx].AggregationMethod == aggregationMethod && cachevvAggregatedTS[idx].AggregationTime == aggregationTime && cachevvAggregatedTS[idx].Alerttime == alerttime && cachevvAggregatedTS[idx].BackgroundBuyColor == backgroundBuyColor && cachevvAggregatedTS[idx].BackgroundBuyColorBlock == backgroundBuyColorBlock && cachevvAggregatedTS[idx].BackgroundColor == backgroundColor && cachevvAggregatedTS[idx].BackgroundHighColor == backgroundHighColor && cachevvAggregatedTS[idx].BackgroundLowColor == backgroundLowColor && cachevvAggregatedTS[idx].BackgroundSellColor == backgroundSellColor && cachevvAggregatedTS[idx].BackgroundSellColorBlock == backgroundSellColorBlock && cachevvAggregatedTS[idx].BackgroundSpeedColor == backgroundSpeedColor && cachevvAggregatedTS[idx].Backtotop == backtotop && cachevvAggregatedTS[idx].BlockAlert == blockAlert && cachevvAggregatedTS[idx].Buyblockback == buyblockback && cachevvAggregatedTS[idx].Buyblockfore == buyblockfore && cachevvAggregatedTS[idx].Col1wid == col1wid && cachevvAggregatedTS[idx].Compress == compress && cachevvAggregatedTS[idx].Compressedrows == compressedrows && cachevvAggregatedTS[idx].Digitstodisplay == digitstodisplay && cachevvAggregatedTS[idx].Displayhilo == displayhilo && cachevvAggregatedTS[idx].Displayhour == displayhour && cachevvAggregatedTS[idx].Displayinstrument == displayinstrument && cachevvAggregatedTS[idx].Displaypressuredelta == displaypressuredelta && cachevvAggregatedTS[idx].Displaypricedelta == displaypricedelta && cachevvAggregatedTS[idx].Displayspeed == displayspeed && cachevvAggregatedTS[idx].Displaytimer == displaytimer && cachevvAggregatedTS[idx].ForegroundBuyColor == foregroundBuyColor && cachevvAggregatedTS[idx].ForegroundBuyColorBlock == foregroundBuyColorBlock && cachevvAggregatedTS[idx].ForegroundHighColor == foregroundHighColor && cachevvAggregatedTS[idx].ForegroundLowColor == foregroundLowColor && cachevvAggregatedTS[idx].ForegroundSellColor == foregroundSellColor && cachevvAggregatedTS[idx].ForegroundSellColorBlock == foregroundSellColorBlock && cachevvAggregatedTS[idx].ForegroundSpeedColor == foregroundSpeedColor && cachevvAggregatedTS[idx].Fsize == fsize && cachevvAggregatedTS[idx].Hipix == hipix && Math.Abs(cachevvAggregatedTS[idx].Histogramfactor - histogramfactor) <= double.Epsilon && cachevvAggregatedTS[idx].Historgamcolourpropertyb == historgamcolourpropertyb && cachevvAggregatedTS[idx].Historgamcolourpropertybm == historgamcolourpropertybm && cachevvAggregatedTS[idx].Historgamcolourpropertys == historgamcolourpropertys && cachevvAggregatedTS[idx].Historgamcolourpropertysm == historgamcolourpropertysm && Math.Abs(cachevvAggregatedTS[idx].Magnitude - magnitude) <= double.Epsilon && Math.Abs(cachevvAggregatedTS[idx].Magnitudep - magnitudep) <= double.Epsilon && cachevvAggregatedTS[idx].MarkHighAndLow == markHighAndLow && cachevvAggregatedTS[idx].Onlyfiltered == onlyfiltered && cachevvAggregatedTS[idx].Onlyfilteredp == onlyfilteredp && cachevvAggregatedTS[idx].Ontop == ontop && cachevvAggregatedTS[idx].Periodprice == periodprice && cachevvAggregatedTS[idx].Periodud == periodud && cachevvAggregatedTS[idx].Periodvol == periodvol && cachevvAggregatedTS[idx].Pricedisplay == pricedisplay && cachevvAggregatedTS[idx].Profilewidth == profilewidth && cachevvAggregatedTS[idx].Ptype == ptype && cachevvAggregatedTS[idx].Ptype1 == ptype1 && cachevvAggregatedTS[idx].Scrolltype == scrolltype && cachevvAggregatedTS[idx].Sellblockback == sellblockback && cachevvAggregatedTS[idx].Sellblockfore == sellblockfore && cachevvAggregatedTS[idx].Sellbuydisplay == sellbuydisplay && cachevvAggregatedTS[idx].Setalert == setalert && cachevvAggregatedTS[idx].Setloc == setloc && cachevvAggregatedTS[idx].Showhist == showhist && cachevvAggregatedTS[idx].Showhistinown == showhistinown && cachevvAggregatedTS[idx].Smallerthanfilter == smallerthanfilter && cachevvAggregatedTS[idx].Usedelta == usedelta && cachevvAggregatedTS[idx].Userx == userx && cachevvAggregatedTS[idx].Usery == usery && cachevvAggregatedTS[idx].Useticksnovol == useticksnovol && cachevvAggregatedTS[idx].VolumeFilter == volumeFilter && cachevvAggregatedTS[idx].VolumeFilterBlock == volumeFilterBlock && cachevvAggregatedTS[idx].Weightedpressure == weightedpressure && cachevvAggregatedTS[idx].Wipix == wipix && cachevvAggregatedTS[idx].EqualsInput(input))
                        return cachevvAggregatedTS[idx];

            lock (checkvvAggregatedTS)
            {
                checkvvAggregatedTS.AggregationMethod = aggregationMethod;
                aggregationMethod = checkvvAggregatedTS.AggregationMethod;
                checkvvAggregatedTS.AggregationTime = aggregationTime;
                aggregationTime = checkvvAggregatedTS.AggregationTime;
                checkvvAggregatedTS.Alerttime = alerttime;
                alerttime = checkvvAggregatedTS.Alerttime;
                checkvvAggregatedTS.BackgroundBuyColor = backgroundBuyColor;
                backgroundBuyColor = checkvvAggregatedTS.BackgroundBuyColor;
                checkvvAggregatedTS.BackgroundBuyColorBlock = backgroundBuyColorBlock;
                backgroundBuyColorBlock = checkvvAggregatedTS.BackgroundBuyColorBlock;
                checkvvAggregatedTS.BackgroundColor = backgroundColor;
                backgroundColor = checkvvAggregatedTS.BackgroundColor;
                checkvvAggregatedTS.BackgroundHighColor = backgroundHighColor;
                backgroundHighColor = checkvvAggregatedTS.BackgroundHighColor;
                checkvvAggregatedTS.BackgroundLowColor = backgroundLowColor;
                backgroundLowColor = checkvvAggregatedTS.BackgroundLowColor;
                checkvvAggregatedTS.BackgroundSellColor = backgroundSellColor;
                backgroundSellColor = checkvvAggregatedTS.BackgroundSellColor;
                checkvvAggregatedTS.BackgroundSellColorBlock = backgroundSellColorBlock;
                backgroundSellColorBlock = checkvvAggregatedTS.BackgroundSellColorBlock;
                checkvvAggregatedTS.BackgroundSpeedColor = backgroundSpeedColor;
                backgroundSpeedColor = checkvvAggregatedTS.BackgroundSpeedColor;
                checkvvAggregatedTS.Backtotop = backtotop;
                backtotop = checkvvAggregatedTS.Backtotop;
                checkvvAggregatedTS.BlockAlert = blockAlert;
                blockAlert = checkvvAggregatedTS.BlockAlert;
                checkvvAggregatedTS.Buyblockback = buyblockback;
                buyblockback = checkvvAggregatedTS.Buyblockback;
                checkvvAggregatedTS.Buyblockfore = buyblockfore;
                buyblockfore = checkvvAggregatedTS.Buyblockfore;
                checkvvAggregatedTS.Col1wid = col1wid;
                col1wid = checkvvAggregatedTS.Col1wid;
                checkvvAggregatedTS.Compress = compress;
                compress = checkvvAggregatedTS.Compress;
                checkvvAggregatedTS.Compressedrows = compressedrows;
                compressedrows = checkvvAggregatedTS.Compressedrows;
                checkvvAggregatedTS.Digitstodisplay = digitstodisplay;
                digitstodisplay = checkvvAggregatedTS.Digitstodisplay;
                checkvvAggregatedTS.Displayhilo = displayhilo;
                displayhilo = checkvvAggregatedTS.Displayhilo;
                checkvvAggregatedTS.Displayhour = displayhour;
                displayhour = checkvvAggregatedTS.Displayhour;
                checkvvAggregatedTS.Displayinstrument = displayinstrument;
                displayinstrument = checkvvAggregatedTS.Displayinstrument;
                checkvvAggregatedTS.Displaypressuredelta = displaypressuredelta;
                displaypressuredelta = checkvvAggregatedTS.Displaypressuredelta;
                checkvvAggregatedTS.Displaypricedelta = displaypricedelta;
                displaypricedelta = checkvvAggregatedTS.Displaypricedelta;
                checkvvAggregatedTS.Displayspeed = displayspeed;
                displayspeed = checkvvAggregatedTS.Displayspeed;
                checkvvAggregatedTS.Displaytimer = displaytimer;
                displaytimer = checkvvAggregatedTS.Displaytimer;
                checkvvAggregatedTS.ForegroundBuyColor = foregroundBuyColor;
                foregroundBuyColor = checkvvAggregatedTS.ForegroundBuyColor;
                checkvvAggregatedTS.ForegroundBuyColorBlock = foregroundBuyColorBlock;
                foregroundBuyColorBlock = checkvvAggregatedTS.ForegroundBuyColorBlock;
                checkvvAggregatedTS.ForegroundHighColor = foregroundHighColor;
                foregroundHighColor = checkvvAggregatedTS.ForegroundHighColor;
                checkvvAggregatedTS.ForegroundLowColor = foregroundLowColor;
                foregroundLowColor = checkvvAggregatedTS.ForegroundLowColor;
                checkvvAggregatedTS.ForegroundSellColor = foregroundSellColor;
                foregroundSellColor = checkvvAggregatedTS.ForegroundSellColor;
                checkvvAggregatedTS.ForegroundSellColorBlock = foregroundSellColorBlock;
                foregroundSellColorBlock = checkvvAggregatedTS.ForegroundSellColorBlock;
                checkvvAggregatedTS.ForegroundSpeedColor = foregroundSpeedColor;
                foregroundSpeedColor = checkvvAggregatedTS.ForegroundSpeedColor;
                checkvvAggregatedTS.Fsize = fsize;
                fsize = checkvvAggregatedTS.Fsize;
                checkvvAggregatedTS.Hipix = hipix;
                hipix = checkvvAggregatedTS.Hipix;
                checkvvAggregatedTS.Histogramfactor = histogramfactor;
                histogramfactor = checkvvAggregatedTS.Histogramfactor;
                checkvvAggregatedTS.Historgamcolourpropertyb = historgamcolourpropertyb;
                historgamcolourpropertyb = checkvvAggregatedTS.Historgamcolourpropertyb;
                checkvvAggregatedTS.Historgamcolourpropertybm = historgamcolourpropertybm;
                historgamcolourpropertybm = checkvvAggregatedTS.Historgamcolourpropertybm;
                checkvvAggregatedTS.Historgamcolourpropertys = historgamcolourpropertys;
                historgamcolourpropertys = checkvvAggregatedTS.Historgamcolourpropertys;
                checkvvAggregatedTS.Historgamcolourpropertysm = historgamcolourpropertysm;
                historgamcolourpropertysm = checkvvAggregatedTS.Historgamcolourpropertysm;
                checkvvAggregatedTS.Magnitude = magnitude;
                magnitude = checkvvAggregatedTS.Magnitude;
                checkvvAggregatedTS.Magnitudep = magnitudep;
                magnitudep = checkvvAggregatedTS.Magnitudep;
                checkvvAggregatedTS.MarkHighAndLow = markHighAndLow;
                markHighAndLow = checkvvAggregatedTS.MarkHighAndLow;
                checkvvAggregatedTS.Onlyfiltered = onlyfiltered;
                onlyfiltered = checkvvAggregatedTS.Onlyfiltered;
                checkvvAggregatedTS.Onlyfilteredp = onlyfilteredp;
                onlyfilteredp = checkvvAggregatedTS.Onlyfilteredp;
                checkvvAggregatedTS.Ontop = ontop;
                ontop = checkvvAggregatedTS.Ontop;
                checkvvAggregatedTS.Periodprice = periodprice;
                periodprice = checkvvAggregatedTS.Periodprice;
                checkvvAggregatedTS.Periodud = periodud;
                periodud = checkvvAggregatedTS.Periodud;
                checkvvAggregatedTS.Periodvol = periodvol;
                periodvol = checkvvAggregatedTS.Periodvol;
                checkvvAggregatedTS.Pricedisplay = pricedisplay;
                pricedisplay = checkvvAggregatedTS.Pricedisplay;
                checkvvAggregatedTS.Profilewidth = profilewidth;
                profilewidth = checkvvAggregatedTS.Profilewidth;
                checkvvAggregatedTS.Ptype = ptype;
                ptype = checkvvAggregatedTS.Ptype;
                checkvvAggregatedTS.Ptype1 = ptype1;
                ptype1 = checkvvAggregatedTS.Ptype1;
                checkvvAggregatedTS.Scrolltype = scrolltype;
                scrolltype = checkvvAggregatedTS.Scrolltype;
                checkvvAggregatedTS.Sellblockback = sellblockback;
                sellblockback = checkvvAggregatedTS.Sellblockback;
                checkvvAggregatedTS.Sellblockfore = sellblockfore;
                sellblockfore = checkvvAggregatedTS.Sellblockfore;
                checkvvAggregatedTS.Sellbuydisplay = sellbuydisplay;
                sellbuydisplay = checkvvAggregatedTS.Sellbuydisplay;
                checkvvAggregatedTS.Setalert = setalert;
                setalert = checkvvAggregatedTS.Setalert;
                checkvvAggregatedTS.Setloc = setloc;
                setloc = checkvvAggregatedTS.Setloc;
                checkvvAggregatedTS.Showhist = showhist;
                showhist = checkvvAggregatedTS.Showhist;
                checkvvAggregatedTS.Showhistinown = showhistinown;
                showhistinown = checkvvAggregatedTS.Showhistinown;
                checkvvAggregatedTS.Smallerthanfilter = smallerthanfilter;
                smallerthanfilter = checkvvAggregatedTS.Smallerthanfilter;
                checkvvAggregatedTS.Usedelta = usedelta;
                usedelta = checkvvAggregatedTS.Usedelta;
                checkvvAggregatedTS.Userx = userx;
                userx = checkvvAggregatedTS.Userx;
                checkvvAggregatedTS.Usery = usery;
                usery = checkvvAggregatedTS.Usery;
                checkvvAggregatedTS.Useticksnovol = useticksnovol;
                useticksnovol = checkvvAggregatedTS.Useticksnovol;
                checkvvAggregatedTS.VolumeFilter = volumeFilter;
                volumeFilter = checkvvAggregatedTS.VolumeFilter;
                checkvvAggregatedTS.VolumeFilterBlock = volumeFilterBlock;
                volumeFilterBlock = checkvvAggregatedTS.VolumeFilterBlock;
                checkvvAggregatedTS.Weightedpressure = weightedpressure;
                weightedpressure = checkvvAggregatedTS.Weightedpressure;
                checkvvAggregatedTS.Wipix = wipix;
                wipix = checkvvAggregatedTS.Wipix;

                if (cachevvAggregatedTS != null)
                    for (int idx = 0; idx < cachevvAggregatedTS.Length; idx++)
                        if (cachevvAggregatedTS[idx].AggregationMethod == aggregationMethod && cachevvAggregatedTS[idx].AggregationTime == aggregationTime && cachevvAggregatedTS[idx].Alerttime == alerttime && cachevvAggregatedTS[idx].BackgroundBuyColor == backgroundBuyColor && cachevvAggregatedTS[idx].BackgroundBuyColorBlock == backgroundBuyColorBlock && cachevvAggregatedTS[idx].BackgroundColor == backgroundColor && cachevvAggregatedTS[idx].BackgroundHighColor == backgroundHighColor && cachevvAggregatedTS[idx].BackgroundLowColor == backgroundLowColor && cachevvAggregatedTS[idx].BackgroundSellColor == backgroundSellColor && cachevvAggregatedTS[idx].BackgroundSellColorBlock == backgroundSellColorBlock && cachevvAggregatedTS[idx].BackgroundSpeedColor == backgroundSpeedColor && cachevvAggregatedTS[idx].Backtotop == backtotop && cachevvAggregatedTS[idx].BlockAlert == blockAlert && cachevvAggregatedTS[idx].Buyblockback == buyblockback && cachevvAggregatedTS[idx].Buyblockfore == buyblockfore && cachevvAggregatedTS[idx].Col1wid == col1wid && cachevvAggregatedTS[idx].Compress == compress && cachevvAggregatedTS[idx].Compressedrows == compressedrows && cachevvAggregatedTS[idx].Digitstodisplay == digitstodisplay && cachevvAggregatedTS[idx].Displayhilo == displayhilo && cachevvAggregatedTS[idx].Displayhour == displayhour && cachevvAggregatedTS[idx].Displayinstrument == displayinstrument && cachevvAggregatedTS[idx].Displaypressuredelta == displaypressuredelta && cachevvAggregatedTS[idx].Displaypricedelta == displaypricedelta && cachevvAggregatedTS[idx].Displayspeed == displayspeed && cachevvAggregatedTS[idx].Displaytimer == displaytimer && cachevvAggregatedTS[idx].ForegroundBuyColor == foregroundBuyColor && cachevvAggregatedTS[idx].ForegroundBuyColorBlock == foregroundBuyColorBlock && cachevvAggregatedTS[idx].ForegroundHighColor == foregroundHighColor && cachevvAggregatedTS[idx].ForegroundLowColor == foregroundLowColor && cachevvAggregatedTS[idx].ForegroundSellColor == foregroundSellColor && cachevvAggregatedTS[idx].ForegroundSellColorBlock == foregroundSellColorBlock && cachevvAggregatedTS[idx].ForegroundSpeedColor == foregroundSpeedColor && cachevvAggregatedTS[idx].Fsize == fsize && cachevvAggregatedTS[idx].Hipix == hipix && Math.Abs(cachevvAggregatedTS[idx].Histogramfactor - histogramfactor) <= double.Epsilon && cachevvAggregatedTS[idx].Historgamcolourpropertyb == historgamcolourpropertyb && cachevvAggregatedTS[idx].Historgamcolourpropertybm == historgamcolourpropertybm && cachevvAggregatedTS[idx].Historgamcolourpropertys == historgamcolourpropertys && cachevvAggregatedTS[idx].Historgamcolourpropertysm == historgamcolourpropertysm && Math.Abs(cachevvAggregatedTS[idx].Magnitude - magnitude) <= double.Epsilon && Math.Abs(cachevvAggregatedTS[idx].Magnitudep - magnitudep) <= double.Epsilon && cachevvAggregatedTS[idx].MarkHighAndLow == markHighAndLow && cachevvAggregatedTS[idx].Onlyfiltered == onlyfiltered && cachevvAggregatedTS[idx].Onlyfilteredp == onlyfilteredp && cachevvAggregatedTS[idx].Ontop == ontop && cachevvAggregatedTS[idx].Periodprice == periodprice && cachevvAggregatedTS[idx].Periodud == periodud && cachevvAggregatedTS[idx].Periodvol == periodvol && cachevvAggregatedTS[idx].Pricedisplay == pricedisplay && cachevvAggregatedTS[idx].Profilewidth == profilewidth && cachevvAggregatedTS[idx].Ptype == ptype && cachevvAggregatedTS[idx].Ptype1 == ptype1 && cachevvAggregatedTS[idx].Scrolltype == scrolltype && cachevvAggregatedTS[idx].Sellblockback == sellblockback && cachevvAggregatedTS[idx].Sellblockfore == sellblockfore && cachevvAggregatedTS[idx].Sellbuydisplay == sellbuydisplay && cachevvAggregatedTS[idx].Setalert == setalert && cachevvAggregatedTS[idx].Setloc == setloc && cachevvAggregatedTS[idx].Showhist == showhist && cachevvAggregatedTS[idx].Showhistinown == showhistinown && cachevvAggregatedTS[idx].Smallerthanfilter == smallerthanfilter && cachevvAggregatedTS[idx].Usedelta == usedelta && cachevvAggregatedTS[idx].Userx == userx && cachevvAggregatedTS[idx].Usery == usery && cachevvAggregatedTS[idx].Useticksnovol == useticksnovol && cachevvAggregatedTS[idx].VolumeFilter == volumeFilter && cachevvAggregatedTS[idx].VolumeFilterBlock == volumeFilterBlock && cachevvAggregatedTS[idx].Weightedpressure == weightedpressure && cachevvAggregatedTS[idx].Wipix == wipix && cachevvAggregatedTS[idx].EqualsInput(input))
                            return cachevvAggregatedTS[idx];

                vvAggregatedTS indicator = new vvAggregatedTS();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AggregationMethod = aggregationMethod;
                indicator.AggregationTime = aggregationTime;
                indicator.Alerttime = alerttime;
                indicator.BackgroundBuyColor = backgroundBuyColor;
                indicator.BackgroundBuyColorBlock = backgroundBuyColorBlock;
                indicator.BackgroundColor = backgroundColor;
                indicator.BackgroundHighColor = backgroundHighColor;
                indicator.BackgroundLowColor = backgroundLowColor;
                indicator.BackgroundSellColor = backgroundSellColor;
                indicator.BackgroundSellColorBlock = backgroundSellColorBlock;
                indicator.BackgroundSpeedColor = backgroundSpeedColor;
                indicator.Backtotop = backtotop;
                indicator.BlockAlert = blockAlert;
                indicator.Buyblockback = buyblockback;
                indicator.Buyblockfore = buyblockfore;
                indicator.Col1wid = col1wid;
                indicator.Compress = compress;
                indicator.Compressedrows = compressedrows;
                indicator.Digitstodisplay = digitstodisplay;
                indicator.Displayhilo = displayhilo;
                indicator.Displayhour = displayhour;
                indicator.Displayinstrument = displayinstrument;
                indicator.Displaypressuredelta = displaypressuredelta;
                indicator.Displaypricedelta = displaypricedelta;
                indicator.Displayspeed = displayspeed;
                indicator.Displaytimer = displaytimer;
                indicator.ForegroundBuyColor = foregroundBuyColor;
                indicator.ForegroundBuyColorBlock = foregroundBuyColorBlock;
                indicator.ForegroundHighColor = foregroundHighColor;
                indicator.ForegroundLowColor = foregroundLowColor;
                indicator.ForegroundSellColor = foregroundSellColor;
                indicator.ForegroundSellColorBlock = foregroundSellColorBlock;
                indicator.ForegroundSpeedColor = foregroundSpeedColor;
                indicator.Fsize = fsize;
                indicator.Hipix = hipix;
                indicator.Histogramfactor = histogramfactor;
                indicator.Historgamcolourpropertyb = historgamcolourpropertyb;
                indicator.Historgamcolourpropertybm = historgamcolourpropertybm;
                indicator.Historgamcolourpropertys = historgamcolourpropertys;
                indicator.Historgamcolourpropertysm = historgamcolourpropertysm;
                indicator.Magnitude = magnitude;
                indicator.Magnitudep = magnitudep;
                indicator.MarkHighAndLow = markHighAndLow;
                indicator.Onlyfiltered = onlyfiltered;
                indicator.Onlyfilteredp = onlyfilteredp;
                indicator.Ontop = ontop;
                indicator.Periodprice = periodprice;
                indicator.Periodud = periodud;
                indicator.Periodvol = periodvol;
                indicator.Pricedisplay = pricedisplay;
                indicator.Profilewidth = profilewidth;
                indicator.Ptype = ptype;
                indicator.Ptype1 = ptype1;
                indicator.Scrolltype = scrolltype;
                indicator.Sellblockback = sellblockback;
                indicator.Sellblockfore = sellblockfore;
                indicator.Sellbuydisplay = sellbuydisplay;
                indicator.Setalert = setalert;
                indicator.Setloc = setloc;
                indicator.Showhist = showhist;
                indicator.Showhistinown = showhistinown;
                indicator.Smallerthanfilter = smallerthanfilter;
                indicator.Usedelta = usedelta;
                indicator.Userx = userx;
                indicator.Usery = usery;
                indicator.Useticksnovol = useticksnovol;
                indicator.VolumeFilter = volumeFilter;
                indicator.VolumeFilterBlock = volumeFilterBlock;
                indicator.Weightedpressure = weightedpressure;
                indicator.Wipix = wipix;
                Indicators.Add(indicator);
                indicator.SetUp();

                vvAggregatedTS[] tmp = new vvAggregatedTS[cachevvAggregatedTS == null ? 1 : cachevvAggregatedTS.Length + 1];
                if (cachevvAggregatedTS != null)
                    cachevvAggregatedTS.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachevvAggregatedTS = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Aggregated Time & Sales 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvAggregatedTS vvAggregatedTS(AggregatedTS1aggregationmethod aggregationMethod, int aggregationTime, TimeSpan alerttime, Color backgroundBuyColor, Color backgroundBuyColorBlock, Color backgroundColor, Color backgroundHighColor, Color backgroundLowColor, Color backgroundSellColor, Color backgroundSellColorBlock, Color backgroundSpeedColor, int backtotop, int blockAlert, Color buyblockback, Color buyblockfore, int col1wid, bool compress, int compressedrows, AggregatedTS1digitstodisplay digitstodisplay, bool displayhilo, bool displayhour, bool displayinstrument, bool displaypressuredelta, bool displaypricedelta, bool displayspeed, bool displaytimer, Color foregroundBuyColor, Color foregroundBuyColorBlock, Color foregroundHighColor, Color foregroundLowColor, Color foregroundSellColor, Color foregroundSellColorBlock, Color foregroundSpeedColor, float fsize, int hipix, double histogramfactor, Color historgamcolourpropertyb, Color historgamcolourpropertybm, Color historgamcolourpropertys, Color historgamcolourpropertysm, double magnitude, double magnitudep, bool markHighAndLow, bool onlyfiltered, bool onlyfilteredp, bool ontop, int periodprice, int periodud, int periodvol, AggregatedTS1pricedisplay pricedisplay, int profilewidth, AggregatedTS1periodtypeforpressure ptype, AggregatedTS1periodtypeforprice ptype1, AggregatedTS1Scrolltype scrolltype, Color sellblockback, Color sellblockfore, AggregatedTS1SellBuyDisplay sellbuydisplay, bool setalert, bool setloc, bool showhist, bool showhistinown, int smallerthanfilter, bool usedelta, int userx, int usery, bool useticksnovol, int volumeFilter, int volumeFilterBlock, bool weightedpressure, int wipix)
        {
            return _indicator.vvAggregatedTS(Input, aggregationMethod, aggregationTime, alerttime, backgroundBuyColor, backgroundBuyColorBlock, backgroundColor, backgroundHighColor, backgroundLowColor, backgroundSellColor, backgroundSellColorBlock, backgroundSpeedColor, backtotop, blockAlert, buyblockback, buyblockfore, col1wid, compress, compressedrows, digitstodisplay, displayhilo, displayhour, displayinstrument, displaypressuredelta, displaypricedelta, displayspeed, displaytimer, foregroundBuyColor, foregroundBuyColorBlock, foregroundHighColor, foregroundLowColor, foregroundSellColor, foregroundSellColorBlock, foregroundSpeedColor, fsize, hipix, histogramfactor, historgamcolourpropertyb, historgamcolourpropertybm, historgamcolourpropertys, historgamcolourpropertysm, magnitude, magnitudep, markHighAndLow, onlyfiltered, onlyfilteredp, ontop, periodprice, periodud, periodvol, pricedisplay, profilewidth, ptype, ptype1, scrolltype, sellblockback, sellblockfore, sellbuydisplay, setalert, setloc, showhist, showhistinown, smallerthanfilter, usedelta, userx, usery, useticksnovol, volumeFilter, volumeFilterBlock, weightedpressure, wipix);
        }

        /// <summary>
        /// Aggregated Time & Sales 
        /// </summary>
        /// <returns></returns>
        public Indicator.vvAggregatedTS vvAggregatedTS(Data.IDataSeries input, AggregatedTS1aggregationmethod aggregationMethod, int aggregationTime, TimeSpan alerttime, Color backgroundBuyColor, Color backgroundBuyColorBlock, Color backgroundColor, Color backgroundHighColor, Color backgroundLowColor, Color backgroundSellColor, Color backgroundSellColorBlock, Color backgroundSpeedColor, int backtotop, int blockAlert, Color buyblockback, Color buyblockfore, int col1wid, bool compress, int compressedrows, AggregatedTS1digitstodisplay digitstodisplay, bool displayhilo, bool displayhour, bool displayinstrument, bool displaypressuredelta, bool displaypricedelta, bool displayspeed, bool displaytimer, Color foregroundBuyColor, Color foregroundBuyColorBlock, Color foregroundHighColor, Color foregroundLowColor, Color foregroundSellColor, Color foregroundSellColorBlock, Color foregroundSpeedColor, float fsize, int hipix, double histogramfactor, Color historgamcolourpropertyb, Color historgamcolourpropertybm, Color historgamcolourpropertys, Color historgamcolourpropertysm, double magnitude, double magnitudep, bool markHighAndLow, bool onlyfiltered, bool onlyfilteredp, bool ontop, int periodprice, int periodud, int periodvol, AggregatedTS1pricedisplay pricedisplay, int profilewidth, AggregatedTS1periodtypeforpressure ptype, AggregatedTS1periodtypeforprice ptype1, AggregatedTS1Scrolltype scrolltype, Color sellblockback, Color sellblockfore, AggregatedTS1SellBuyDisplay sellbuydisplay, bool setalert, bool setloc, bool showhist, bool showhistinown, int smallerthanfilter, bool usedelta, int userx, int usery, bool useticksnovol, int volumeFilter, int volumeFilterBlock, bool weightedpressure, int wipix)
        {
            return _indicator.vvAggregatedTS(input, aggregationMethod, aggregationTime, alerttime, backgroundBuyColor, backgroundBuyColorBlock, backgroundColor, backgroundHighColor, backgroundLowColor, backgroundSellColor, backgroundSellColorBlock, backgroundSpeedColor, backtotop, blockAlert, buyblockback, buyblockfore, col1wid, compress, compressedrows, digitstodisplay, displayhilo, displayhour, displayinstrument, displaypressuredelta, displaypricedelta, displayspeed, displaytimer, foregroundBuyColor, foregroundBuyColorBlock, foregroundHighColor, foregroundLowColor, foregroundSellColor, foregroundSellColorBlock, foregroundSpeedColor, fsize, hipix, histogramfactor, historgamcolourpropertyb, historgamcolourpropertybm, historgamcolourpropertys, historgamcolourpropertysm, magnitude, magnitudep, markHighAndLow, onlyfiltered, onlyfilteredp, ontop, periodprice, periodud, periodvol, pricedisplay, profilewidth, ptype, ptype1, scrolltype, sellblockback, sellblockfore, sellbuydisplay, setalert, setloc, showhist, showhistinown, smallerthanfilter, usedelta, userx, usery, useticksnovol, volumeFilter, volumeFilterBlock, weightedpressure, wipix);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Aggregated Time & Sales 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvAggregatedTS vvAggregatedTS(AggregatedTS1aggregationmethod aggregationMethod, int aggregationTime, TimeSpan alerttime, Color backgroundBuyColor, Color backgroundBuyColorBlock, Color backgroundColor, Color backgroundHighColor, Color backgroundLowColor, Color backgroundSellColor, Color backgroundSellColorBlock, Color backgroundSpeedColor, int backtotop, int blockAlert, Color buyblockback, Color buyblockfore, int col1wid, bool compress, int compressedrows, AggregatedTS1digitstodisplay digitstodisplay, bool displayhilo, bool displayhour, bool displayinstrument, bool displaypressuredelta, bool displaypricedelta, bool displayspeed, bool displaytimer, Color foregroundBuyColor, Color foregroundBuyColorBlock, Color foregroundHighColor, Color foregroundLowColor, Color foregroundSellColor, Color foregroundSellColorBlock, Color foregroundSpeedColor, float fsize, int hipix, double histogramfactor, Color historgamcolourpropertyb, Color historgamcolourpropertybm, Color historgamcolourpropertys, Color historgamcolourpropertysm, double magnitude, double magnitudep, bool markHighAndLow, bool onlyfiltered, bool onlyfilteredp, bool ontop, int periodprice, int periodud, int periodvol, AggregatedTS1pricedisplay pricedisplay, int profilewidth, AggregatedTS1periodtypeforpressure ptype, AggregatedTS1periodtypeforprice ptype1, AggregatedTS1Scrolltype scrolltype, Color sellblockback, Color sellblockfore, AggregatedTS1SellBuyDisplay sellbuydisplay, bool setalert, bool setloc, bool showhist, bool showhistinown, int smallerthanfilter, bool usedelta, int userx, int usery, bool useticksnovol, int volumeFilter, int volumeFilterBlock, bool weightedpressure, int wipix)
        {
            return _indicator.vvAggregatedTS(Input, aggregationMethod, aggregationTime, alerttime, backgroundBuyColor, backgroundBuyColorBlock, backgroundColor, backgroundHighColor, backgroundLowColor, backgroundSellColor, backgroundSellColorBlock, backgroundSpeedColor, backtotop, blockAlert, buyblockback, buyblockfore, col1wid, compress, compressedrows, digitstodisplay, displayhilo, displayhour, displayinstrument, displaypressuredelta, displaypricedelta, displayspeed, displaytimer, foregroundBuyColor, foregroundBuyColorBlock, foregroundHighColor, foregroundLowColor, foregroundSellColor, foregroundSellColorBlock, foregroundSpeedColor, fsize, hipix, histogramfactor, historgamcolourpropertyb, historgamcolourpropertybm, historgamcolourpropertys, historgamcolourpropertysm, magnitude, magnitudep, markHighAndLow, onlyfiltered, onlyfilteredp, ontop, periodprice, periodud, periodvol, pricedisplay, profilewidth, ptype, ptype1, scrolltype, sellblockback, sellblockfore, sellbuydisplay, setalert, setloc, showhist, showhistinown, smallerthanfilter, usedelta, userx, usery, useticksnovol, volumeFilter, volumeFilterBlock, weightedpressure, wipix);
        }

        /// <summary>
        /// Aggregated Time & Sales 
        /// </summary>
        /// <returns></returns>
        public Indicator.vvAggregatedTS vvAggregatedTS(Data.IDataSeries input, AggregatedTS1aggregationmethod aggregationMethod, int aggregationTime, TimeSpan alerttime, Color backgroundBuyColor, Color backgroundBuyColorBlock, Color backgroundColor, Color backgroundHighColor, Color backgroundLowColor, Color backgroundSellColor, Color backgroundSellColorBlock, Color backgroundSpeedColor, int backtotop, int blockAlert, Color buyblockback, Color buyblockfore, int col1wid, bool compress, int compressedrows, AggregatedTS1digitstodisplay digitstodisplay, bool displayhilo, bool displayhour, bool displayinstrument, bool displaypressuredelta, bool displaypricedelta, bool displayspeed, bool displaytimer, Color foregroundBuyColor, Color foregroundBuyColorBlock, Color foregroundHighColor, Color foregroundLowColor, Color foregroundSellColor, Color foregroundSellColorBlock, Color foregroundSpeedColor, float fsize, int hipix, double histogramfactor, Color historgamcolourpropertyb, Color historgamcolourpropertybm, Color historgamcolourpropertys, Color historgamcolourpropertysm, double magnitude, double magnitudep, bool markHighAndLow, bool onlyfiltered, bool onlyfilteredp, bool ontop, int periodprice, int periodud, int periodvol, AggregatedTS1pricedisplay pricedisplay, int profilewidth, AggregatedTS1periodtypeforpressure ptype, AggregatedTS1periodtypeforprice ptype1, AggregatedTS1Scrolltype scrolltype, Color sellblockback, Color sellblockfore, AggregatedTS1SellBuyDisplay sellbuydisplay, bool setalert, bool setloc, bool showhist, bool showhistinown, int smallerthanfilter, bool usedelta, int userx, int usery, bool useticksnovol, int volumeFilter, int volumeFilterBlock, bool weightedpressure, int wipix)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.vvAggregatedTS(input, aggregationMethod, aggregationTime, alerttime, backgroundBuyColor, backgroundBuyColorBlock, backgroundColor, backgroundHighColor, backgroundLowColor, backgroundSellColor, backgroundSellColorBlock, backgroundSpeedColor, backtotop, blockAlert, buyblockback, buyblockfore, col1wid, compress, compressedrows, digitstodisplay, displayhilo, displayhour, displayinstrument, displaypressuredelta, displaypricedelta, displayspeed, displaytimer, foregroundBuyColor, foregroundBuyColorBlock, foregroundHighColor, foregroundLowColor, foregroundSellColor, foregroundSellColorBlock, foregroundSpeedColor, fsize, hipix, histogramfactor, historgamcolourpropertyb, historgamcolourpropertybm, historgamcolourpropertys, historgamcolourpropertysm, magnitude, magnitudep, markHighAndLow, onlyfiltered, onlyfilteredp, ontop, periodprice, periodud, periodvol, pricedisplay, profilewidth, ptype, ptype1, scrolltype, sellblockback, sellblockfore, sellbuydisplay, setalert, setloc, showhist, showhistinown, smallerthanfilter, usedelta, userx, usery, useticksnovol, volumeFilter, volumeFilterBlock, weightedpressure, wipix);
        }
    }
}
#endregion
