#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using System.Windows.Forms;
using System.Collections.Specialized;
using System.Collections.ObjectModel;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Media;
//using System.Speech.Synthesis;
#endregion

#region Global Enums
public enum vvTitanic1pricedisplay {Decimal, Sixteenths, Thirtytwoths, Sixtyfourths}
//public enum CustomTSexpensive1aggregationmethod {DOM, Time}
//public enum anaPivotStylesPD38 {Floor, Wide, Fibonacci, Jackson, Camarilla, Woodie}
//public enum anaSessionTypePD38 {ETH, RTH, Auto}
//public enum anaSessionCountPD38 {First, Second, Third}

#endregion

// v1.3
namespace NinjaTrader.Indicator
{
	
	 
	
   [Description("Enter the description of your new custom indicator here")]
    public class vvTitanic : Indicator
    {
        #region Variables
        // ---grid variables
		private vvTitanic1pricedisplay	pricedisplay				= vvTitanic1pricedisplay.Decimal;
		public int pricedisplay1 = 0;

		private IceForm iceform;
		public int NumberOfDecimals;
		public double pforlength;
		public Color foregroundbuy = Color.MediumBlue;
		public Color backgroundbuy = Color.LightCyan;
		public Color foregroundsell = Color.Crimson;
		public Color backgroundsell = Color.Snow;
		public Color backgroundcolor = Color.Black;
		//---------------
		private TimeSpan timeout = TimeSpan.FromMilliseconds(1000);//user settings
           
			private double currenticeprice = 0;
			private double currenticeprice2 = 0;
			private double previceprice = 0;
			private int currenticevol = 0;
			private int previcevol = 0;
			private int currenticesell = 0;
			private int previcesell = 0;
		
		private int Minimumhidden = 20;
			private int Minimumbook = 5;
			private double bid0p = 0;
			private double bid1p = 0;
			private double bid2p = 0;
			private double ask0p = 0;
			private double ask1p = 0;
			private double ask2p = 0;
			private double bid0v = 0;
			private double bid1v = 0;
			private double bid2v = 0;
			private double ask0v = 0;
			private double ask1v = 0;
			private double ask2v = 0;
		private double LastAsk = 0;
			private double LastBid = 0;
			private int bbookvol = 0;
		private int sbookvol = 0;
			private double lastprice = 0;
			private double currentprice = 0;
			private int blastvol = 0;
			private int bcurrentvol = 0;
			private int blastbookvol = 0;
			private int bcurrentbookvol = 0;
		private int slastvol = 0;
			private int scurrentvol = 0;
			private int slastbookvol = 0;
			private int scurrentbookvol = 0;
		private DateTime LastBuyTime = new DateTime();
		private DateTime CurrentBuyTime = new DateTime();
//			private double ask0v = 0;
//			private double ask1v = 0;
//			private double ask2v = 0;
		
		// Default setting for MyInput0
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
           
            Overlay				= true;
			CalculateOnBarClose = false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
           
        }
		protected override void OnStartUp()
        {
          
			
			if(pricedisplay == vvTitanic1pricedisplay.Decimal) pricedisplay1=0;
			else if(pricedisplay == vvTitanic1pricedisplay.Sixteenths) pricedisplay1=1;
			else if(pricedisplay == vvTitanic1pricedisplay.Thirtytwoths) pricedisplay1=2;
			else if(pricedisplay == vvTitanic1pricedisplay.Sixtyfourths) pricedisplay1=3;
			
			if(pricedisplay1 == 0) 
			{
				if(TickSize.ToString().Contains(","))
				{
					string[] splitted = TickSize.ToString().Replace(',','.').Split('.');
				NumberOfDecimals = splitted[1].Length;
				}
				else if(TickSize.ToString().Contains("."))
				{
					string[] splitted = TickSize.ToString().Split('.');
				NumberOfDecimals = splitted[1].Length;
				}
				else NumberOfDecimals =0;
				//Print("dec " +NumberOfDecimals);
			}
			else NumberOfDecimals =2;
			//ND=NumberOfDecimals.ToString;
			pforlength = Close[0];
			iceform = new IceForm(this);
			iceform.Show();
			
			
			//Print (pforlength);
        }
		protected override void OnTermination()
        {
           if (iceform.Visible)
				iceform.Close();
        }
		
		protected override void OnMarketDepth(MarketDepthEventArgs e)
		{
			//DomUpdated = true;
			if (e.Position == 0 && e.MarketDataType == MarketDataType.Bid)
			{
				bid0p = e.Price;
				bid0v = e.Volume;
//				Print (bid0p+"-------bid0p");
//				Print (bid0v+"-------bid0v");
			}
			if (e.Position ==1 && e.MarketDataType == MarketDataType.Bid)
			{
				bid1p = e.Price;
				bid1v = e.Volume;
			}
			if (e.Position ==2 && e.MarketDataType == MarketDataType.Bid)
			{
				bid2p = e.Price;
				bid2v = e.Volume;
			}
			
			if (e.Position == 0 && e.MarketDataType == MarketDataType.Ask)
			{
				ask0p = e.Price;
				ask0v = e.Volume;
//				Print (bid0p+"-------ask0p");
//				Print (bid0v+"-------ask0v");
			}
			if (e.Position ==1 && e.MarketDataType == MarketDataType.Ask)
			{
				ask1p = e.Price;
				ask1v = e.Volume;
			}
			if (e.Position ==2 && e.MarketDataType == MarketDataType.Ask)
			{
				ask2p = e.Price;
				ask2v = e.Volume;
			}
			
			//if lastvol collection and order book collection line up on price compare

		}
		
		protected override void OnMarketData(MarketDataEventArgs e)//------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
			//-------------------------------------------------------------------------------------------------------------------------------
		{
			DateTime now = DateTime.Now;
			double price = (double)(e.Price/TickSize);
			
			if (e.MarketDataType == MarketDataType.Bid)
			{
				LastBid = price;
				return;
			}
			
			if (e.MarketDataType == MarketDataType.Ask)
			{
				LastAsk = price;
				return;
			}
			int buyberg =0;
			if (e.MarketDataType != MarketDataType.Last)
				return;
			if (price == bid0p/TickSize) bbookvol = (int)bid0v;
			if (price == bid1p/TickSize) bbookvol = (int)bid1v;
			if (price == bid2p/TickSize) bbookvol = (int)bid2v;
			
			if (price == ask0p/TickSize) sbookvol = (int)ask0v;
			if (price == ask1p/TickSize) sbookvol = (int)ask1v;
			if (price == ask2p/TickSize) sbookvol = (int)ask2v;
			
			if (price == bid0p/TickSize || price == bid1p/TickSize || price == bid2p/TickSize) buyberg = 1;
			if (price == ask0p/TickSize || price == ask1p/TickSize || price == ask2p/TickSize) buyberg = 2;
			
			if(((price == currentprice+1 || price == currentprice-1) && price != lastprice) || ((price == lastprice && now.Subtract(LastBuyTime) > timeout)&&(price == currentprice+1 || price == currentprice-1)))
			{//if price ticks to new level no jump or old level after timeout-----always makes new row

				
				lastprice = currentprice;
				currentprice = price;
				LastBuyTime = CurrentBuyTime;
				CurrentBuyTime = now;
				previceprice = 0;
				previcesell = 0;
				
				if(buyberg ==1)
				{
				blastvol = bcurrentvol;				
				bcurrentvol = (int) e.Volume;
				bcurrentbookvol = bbookvol;
				blastbookvol = bcurrentbookvol;
				
					
					if (bcurrentvol >= Minimumhidden+bcurrentbookvol && Minimumbook <= bcurrentbookvol)
					{
						
						
						currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
						currenticesell = 2;
						currenticevol = bcurrentvol;
						//make new row	
						iceform.AddGridRow(now, bcurrentbookvol,  bcurrentvol,currenticeprice2, false);
//						Print ("############################################################################################");
//						Print (now+"   "+bcurrentbookvol+" -- "+bcurrentvol+"ticks to new level no jump or old level after timeout-------------------BUY------iceberg ahead"+currentprice);
					}
				
				}
				if(buyberg ==2)
				{
				slastvol = scurrentvol;				
				scurrentvol = (int)e.Volume;
				scurrentbookvol = sbookvol;
				slastbookvol = scurrentbookvol;
					if (scurrentvol >= Minimumhidden+scurrentbookvol && Minimumbook <= scurrentbookvol)
					{
						
						currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
						currenticesell = 1;
						currenticevol = scurrentvol;
						//make new row	
						iceform.AddGridRow(now, scurrentbookvol,  scurrentvol,currenticeprice2, true);
//						Print ("############################################################################################");
//						Print (now+"   "+scurrentbookvol+" -- "+scurrentvol+"ticks to new level no jump or old level after timeout----------------------SELL---iceberg ahead"+currentprice);
				
					}
				}
	
				
			}
			else if(price != currentprice && price != currentprice+1 && price != currentprice-1) 
			{//if price ticks to new level and jumps one or more levels, last data is deleted-----always makes new row
			 	
				
				lastprice = 0;
				blastvol = 0;
				slastvol = 0;
				currentprice = price;
				CurrentBuyTime = now;
				if(currentprice != currenticeprice+1 && currentprice != currenticeprice-1)
					{ currenticeprice=0; previceprice =0; currenticesell =0; previcesell =0;}else {previceprice =0;previcesell =0;}
				
				if(buyberg ==1)
				{
				blastvol = bcurrentvol;				
				bcurrentvol =(int) e.Volume;
				bcurrentbookvol = bbookvol;
					
				if (bcurrentvol >= Minimumhidden+bcurrentbookvol && Minimumbook <= bcurrentbookvol)
				{
					
						
					currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
					currenticevol = bcurrentvol;
					currenticesell = 2;
					//make new row
					iceform.AddGridRow(now, bcurrentbookvol,  bcurrentvol,currenticeprice2, false);
//					Print ("############################################################################################");
//					Print (now+"   "+bcurrentbookvol+" -- "+bcurrentvol+"price ticks to new level and jumps one or more levels, last data is deleted----BUY---iceberg ahead "+currentprice);
				}
				}
				if(buyberg ==2)
				{
				slastvol = scurrentvol;				
				scurrentvol = (int)e.Volume;
				scurrentbookvol = sbookvol;
				if (scurrentvol >= Minimumhidden+scurrentbookvol && Minimumbook <= scurrentbookvol){
					
				
					currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
					currenticevol = scurrentvol;
					currenticesell = 1;
					//make new row
					iceform.AddGridRow(now, scurrentbookvol,  scurrentvol,currenticeprice2, true);
//					Print ("############################################################################################");
//					Print (now+"   "+scurrentbookvol+" -- "+scurrentvol+"price ticks to new level and jumps one or more levels, last data is deleted----SELL--iceberg ahead "+currentprice);
				
				}
				}
				
				

				
			}
			else if((price != currentprice && price == lastprice) && now.Subtract(LastBuyTime) < timeout)
			{//if price ticks right back-----can make new row--most is update //for update buy sell must match and price must match and current vol must be higher else new row
				
				
			 	lastprice = currentprice;
				currentprice = price;
				
				LastBuyTime = CurrentBuyTime;
				CurrentBuyTime = now;
				
				
				if(buyberg ==1)
				{
				int helpervol = bcurrentvol;				
				bcurrentvol = blastvol+(int)e.Volume;
				blastvol = helpervol;
					
				int helperbookvol = bcurrentbookvol;
				bcurrentbookvol = blastbookvol;
				blastbookvol = helperbookvol;
				if (bcurrentvol >= Minimumhidden+bcurrentbookvol && Minimumbook <= bcurrentbookvol && currentprice == currenticeprice && bcurrentvol > currenticevol && currenticesell == 2)
					{
						//update row 0
						iceform.UpdateGridRow(bcurrentvol,0);
//						Print (now+"   "+bcurrentbookvol+" -- "+bcurrentvol+"---------------------------price ticks right back--------------------------BUY-----iceberg ahead"+currentprice);
						currenticevol = bcurrentvol;
					}
				else if(currentprice == previceprice && bcurrentvol > previcevol && previcesell == 2)
					{
						//update row 1
						iceform.UpdateGridRow(bcurrentvol,1);
//						Print (now+"   "+bcurrentbookvol+" -- "+bcurrentvol+"---------------------------price ticks right back--------------------------BUY-----iceberg ahead"+currentprice);
						previcevol = bcurrentvol;
					}
				else if (bcurrentvol >= Minimumhidden+bcurrentbookvol && Minimumbook <= bcurrentbookvol)
					{
						//create row
						previceprice = currenticeprice;
						currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
					
						previcevol = currenticevol;
						previcesell = currenticesell;
						
						currenticevol = bcurrentvol;
						currenticesell = 2;
						
						iceform.AddGridRow(now, bcurrentbookvol,  bcurrentvol,currenticeprice2, false);
//						Print ("############################################################################################");
//						Print (now+"   "+bcurrentbookvol+" -- "+bcurrentvol+"---------------------------price ticks right back--------------------------BUY-----iceberg ahead"+currentprice);
						
					}
				}
				
				if(buyberg ==2)
				{
				int helpervol = scurrentvol;				
				scurrentvol = slastvol+(int)e.Volume;
				slastvol = helpervol;
					
				int helperbookvol = scurrentbookvol;
				scurrentbookvol = slastbookvol;
				slastbookvol = helperbookvol;
				if (scurrentvol >= Minimumhidden+scurrentbookvol && Minimumbook <= scurrentbookvol && currentprice == currenticeprice && bcurrentvol > currenticevol && currenticesell == 1)
					{
						//update row 0
						iceform.UpdateGridRow(scurrentvol,0);
//						Print (now+"   "+scurrentbookvol+" -- "+scurrentvol+"---------------------------price ticks right back---------------------------SELL---iceberg ahead"+currentprice);
						currenticevol = scurrentvol;
					}
				else if(currentprice == previceprice && scurrentvol > previcevol && previcesell == 1)
					{
						//update row 1
						iceform.UpdateGridRow(scurrentvol,1);
//						Print (now+"   "+scurrentbookvol+" -- "+scurrentvol+"---------------------------price ticks right back---------------------------SELL---iceberg ahead"+currentprice);
						previcevol = bcurrentvol;
					}
				else if(scurrentvol >= Minimumhidden+scurrentbookvol && Minimumbook <= scurrentbookvol)
					{
						previceprice = currenticeprice;
						currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
					
						previcevol = currenticevol;
						previcesell = currenticesell;
						
						currenticevol = scurrentvol;
						currenticesell = 1;
						
						//create row
						iceform.AddGridRow(now, scurrentbookvol,  scurrentvol,currenticeprice2, true);
//						Print ("############################################################################################");
//						Print (now+"   "+scurrentbookvol+" -- "+scurrentvol+"---------------------------price ticks right back---------------------------SELL---iceberg ahead"+currentprice);
						
					}
				
				}
				
				
			}
			else if(price == currentprice)
			{//if price stays put-----can make new row--most is update //for new row buy sell must be different
				
				if(buyberg ==1)
				{
				bcurrentvol = (int)e.Volume+bcurrentvol;
					if (bcurrentvol >= Minimumhidden+bcurrentbookvol && Minimumbook <= bcurrentbookvol && currentprice == currenticeprice && currenticesell == 2 && bcurrentvol > currenticevol)
					{
						//update row 0
						iceform.UpdateGridRow(bcurrentvol,0);
//						Print (now+"   "+bcurrentbookvol+" -- "+bcurrentvol+"-----price stays put--------------------------------------------------------BUY------iceberg ahead"+currentprice);
						currenticevol = bcurrentvol;
					}
					else if(currentprice == previceprice && bcurrentvol > previcevol && previcesell == 2)
					{
						//update row 1
						iceform.UpdateGridRow(bcurrentvol,1);
						previcevol = bcurrentvol;	
					}
					else if(bcurrentvol >= Minimumhidden+bcurrentbookvol && Minimumbook <= bcurrentbookvol)
					{
						
						previceprice = currenticeprice;
						currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
					
						previcevol = currenticevol;
						previcesell = currenticesell;
						
						currenticevol = bcurrentvol;
						currenticesell = 2;
						//create row
						iceform.AddGridRow(now, bcurrentbookvol,  bcurrentvol,currenticeprice2, false);
//						Print ("############################################################################################");
//						Print (now+"   "+bcurrentbookvol+" -- "+bcurrentvol+"-----price stays put--------------------------------------------------------BUY------iceberg ahead"+currentprice);
						
					}
					
						
					
					
				}
				
				if(buyberg ==2)
				{
					scurrentvol = (int)e.Volume+scurrentvol;
					if (scurrentvol >= Minimumhidden+scurrentbookvol && Minimumbook <= scurrentbookvol && currentprice == currenticeprice && currenticesell == 1 && scurrentvol > currenticevol)
					{
						//update row 0
						iceform.UpdateGridRow(scurrentvol,0);
//						Print (now+"   "+scurrentbookvol+" -- "+scurrentvol+"-----price stays put---------------------------------------------------------SELL----iceberg ahead"+currentprice);
						currenticevol = scurrentvol;
					}
					
					else if(currentprice == previceprice && scurrentvol > previcevol && previcesell == 1)
					{
						//update row 1
						iceform.UpdateGridRow(scurrentvol,1);
						previcevol = bcurrentvol;	
					}
					
					else if (scurrentvol >= Minimumhidden+scurrentbookvol && Minimumbook <= scurrentbookvol)
					{
						previceprice = currenticeprice;
						currenticeprice = currentprice;
						switch(pricedisplay1)
				{
				case 0: currenticeprice2 = (double) currenticeprice*TickSize; break;
				case 1: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.16); break;
				case 2: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.32); break;
				case 3: currenticeprice2 = (double) System.Math.Floor(currenticeprice*TickSize) +(((currenticeprice*TickSize) - System.Math.Floor(currenticeprice*TickSize))*0.64); break;
				}
					
						previcevol = currenticevol;
						previcesell = currenticesell;
						
						currenticevol = scurrentvol;
						currenticesell = 1;
						
						//create row
						iceform.AddGridRow(now, scurrentbookvol,  scurrentvol,currenticeprice2, true);
//						Print ("############################################################################################");
//						Print (now+"   "+scurrentbookvol+" -- "+scurrentvol+"-----price stays put---------------------------------------------------------SELL----iceberg ahead"+currentprice);
					
					}
					
				}

			}
		}
		

        #region Properties
		[Description("Price Format, chose between decimal and fractions for treasuries")]
		[GridCategory("Parameters")]
		[Gui.Design.DisplayNameAttribute("Price Format")]
		public vvTitanic1pricedisplay Pricedisplay
		{
			get { return pricedisplay; }
			set { pricedisplay = value; }
		}
		
		[Description("Minimum Visible Size of Iceberg, this is the initial size of the book")]
		[GridCategory("Parameters")]
		public int MinimumBook
		{
			get { return Minimumbook; }
			set { Minimumbook = value; }
		}
		[Description("Minimum Hidden Size of Iceberg")]
		[GridCategory("Parameters")]
		public int MinimumHidden
		{
			get { return Minimumhidden; }
			set { Minimumhidden = value; }
		}
		
		[XmlIgnore()]
		[Description("Foreground Sell Color")]
		[GridCategory("Colors")]
		public Color ForegroundSellColor
		{
			get { return foregroundsell; }
			set { foregroundsell = value; }
		}
		
		[Browsable(false)]
		public string ForegroundSellColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundsell); }
			set { foregroundsell = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Foreground Buy Color")]
		[GridCategory("Colors")]
		public Color ForegroundBuyColor
		{
			get { return foregroundbuy; }
			set { foregroundbuy = value; }
		}
		
		[Browsable(false)]
		public string ForegroundBuyColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(foregroundbuy); }
			set { foregroundbuy = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Sell Color")]
		[GridCategory("Colors")]
		public Color BackgroundSellColor
		{
			get { return backgroundsell; }
			set { backgroundsell = value; }
		}
		
		[Browsable(false)]
		public string BackgroundSellColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundsell); }
			set { backgroundsell = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
		[Description("Background Buy Color")]
		[GridCategory("Colors")]
		public Color BackgroundBuyColor
		{
			get { return backgroundbuy; }
			set { backgroundbuy = value; }
		}
		
		[Browsable(false)]
		public string BackgroundBuyColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(backgroundbuy); }
			set { backgroundbuy = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
        #endregion
    }
	
	public class IceForm : Form
	{
		private int NumberOfDecimals;
		
		vvTitanic mainindy;
		DataGridView grid = new DataGridView();
		//Control noscroll = new Control();
		
		
		
		public IceForm(vvTitanic indicator)
		{
			mainindy = indicator;

			this.NumberOfDecimals= mainindy.NumberOfDecimals;

			
				
			this.SuspendLayout();
			Graphics graphics = this.CreateGraphics();
			SizeF textSize = graphics.MeasureString(mainindy.pforlength.ToString(), this.Font);
			this.grid.ScrollBars = ScrollBars.None;
			
			this.grid.Dock = DockStyle.Fill;
 			this.grid.AllowUserToAddRows = false;
            this.grid.AllowUserToDeleteRows = false;
            this.grid.AllowUserToResizeColumns = false;
            this.grid.AllowUserToResizeRows = false;
			this.grid.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.grid.BackgroundColor = mainindy.backgroundcolor;
            this.grid.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.grid.CellBorderStyle = System.Windows.Forms.DataGridViewCellBorderStyle.None;//None;
			this.grid.ColumnHeadersVisible = false;
			this.grid.RowHeadersVisible = false;
			this.grid.ReadOnly = true;
			this.grid.MultiSelect = false;
			this.grid.SelectionChanged += new System.EventHandler(this.grid_SelectionChanged);
			
			this.Controls.Add(grid);
			this.Size = new System.Drawing.Size((int)textSize.Width+195, 300);//numberoflines*13+50);
			this.Text = mainindy.Instrument.FullName+" | vvTitanic";
			
			
			this.ResumeLayout(false);
			grid.ColumnCount=4;
			grid.DefaultCellStyle.Padding=new Padding(0,0,0,0);
			
			DataGridViewColumn tickesp = grid.Columns[3]; tickesp.MinimumWidth= (int)textSize.Width+2;//set
			
			grid.Columns[0].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			//grid.Columns[1].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			//grid.Columns[3].AutoSizeMode=DataGridViewAutoSizeColumnMode.None;
			
			
			grid.Columns[0].DefaultCellStyle.Format = "hh:mm:ss";
			grid.Columns[0].ValueType = typeof(DateTime);
			grid.Columns[3].DefaultCellStyle.Format = ("F"+NumberOfDecimals.ToString());
			grid.Columns[1].DefaultCellStyle.Format = "(#)";
			grid.DefaultCellStyle.WrapMode=DataGridViewTriState.True;
			
			
			grid.DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight;
//			grid.Columns[4].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleLeft; 

			DataGridViewColumn tickes = grid.Columns[0]; tickes.Width = 50;//set
//			DataGridViewColumn tickes1 = grid.Columns[1]; tickes1.Width = 24;//set
//			DataGridViewColumn tickes5 = grid.Columns[2]; tickes5.Width = 24;//set
		}
		//######################################################################################  add #################################
		public void AddGridRow(DateTime col0,int col1,int col2,double col3, bool issell)
		{
			grid.Rows.Insert(0,1);
			grid.Rows[0].Height = 13;
			
//			Graphics graphics = this.CreateGraphics();
//			SizeF textSize = graphics.MeasureString(col2.ToString("F"+mainindy.NumberOfDecimals), this.Font);
//			DataGridViewColumn tickesp = grid.Columns[3]; tickesp.MinimumWidth= (int)textSize.Width+2;//set
			
			int countrows = grid.Rows.Count;
			if (countrows > 1000) grid.Rows.Remove(grid.Rows[countrows-1]);
			//grid.Rows[0].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight;
			
					Color colorSB;// = Color.MistyRose;
			Color colorSF;// = Color.Crimson;
			Color colorBB;// = Color.Green;
			Color colorBF;// = Color.Honeydew;
			
			colorSB = mainindy.BackgroundSellColor;
			colorSF = mainindy.ForegroundSellColor;
			colorBB = mainindy.BackgroundBuyColor;
			colorBF = mainindy.ForegroundBuyColor;
			
			
			grid.Rows[0].Cells[0].Value=col0;//.ToString("hh:mm:ss");
			grid.Rows[0].Cells[1].Value=col1;//this is the original order book
			grid.Rows[0].Cells[2].Value=col2;//this is the traded vol
			grid.Rows[0].Cells[3].Value=col3;//.ToString();//("#######.00");//price
			
			if(issell)
			{
				grid.Rows[0].DefaultCellStyle.ForeColor = colorSF;
				grid.Rows[0].DefaultCellStyle.BackColor = colorSB;
			}
			else
			{
				grid.Rows[0].DefaultCellStyle.ForeColor = colorBF;
				grid.Rows[0].DefaultCellStyle.BackColor = colorBB;
			}
			
			 
		}

		public void UpdateGridRow(int col2, int row)
		{
			
			if (row==0)
			{
				//grid.Rows[0].Cells[0].Value=col0;//.ToString("mm:ss");
			//	grid.Rows[0].Cells[1].Value=col1;//.ToString();
				grid.Rows[0].Cells[2].Value=col2;
				//grid.Rows[0].Cells[3].Value=col2;//.ToString();//("#######.00");//price
			}
			else if (row==1)
			{
				//grid.Rows[1].Cells[0].Value=col0;//.ToString("mm:ss");
			//	grid.Rows[1].Cells[1].Value=col1;//.ToString();
				grid.Rows[1].Cells[2].Value=col2;
				//grid.Rows[1].Cells[3].Value=col2;//.ToString();//("#######.00");//price
			}
			
		}
		
		
		private void grid_SelectionChanged(object sender, EventArgs e)
        {
            if (this.grid.SelectedCells.Count > 0)
            {
                this.grid.SelectedCells[0].Selected = false;
            }
        }

	}
	

	

}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private vvTitanic[] cachevvTitanic = null;

        private static vvTitanic checkvvTitanic = new vvTitanic();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public vvTitanic vvTitanic(Color backgroundBuyColor, Color backgroundSellColor, Color foregroundBuyColor, Color foregroundSellColor, int minimumBook, int minimumHidden, vvTitanic1pricedisplay pricedisplay)
        {
            return vvTitanic(Input, backgroundBuyColor, backgroundSellColor, foregroundBuyColor, foregroundSellColor, minimumBook, minimumHidden, pricedisplay);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public vvTitanic vvTitanic(Data.IDataSeries input, Color backgroundBuyColor, Color backgroundSellColor, Color foregroundBuyColor, Color foregroundSellColor, int minimumBook, int minimumHidden, vvTitanic1pricedisplay pricedisplay)
        {
            if (cachevvTitanic != null)
                for (int idx = 0; idx < cachevvTitanic.Length; idx++)
                    if (cachevvTitanic[idx].BackgroundBuyColor == backgroundBuyColor && cachevvTitanic[idx].BackgroundSellColor == backgroundSellColor && cachevvTitanic[idx].ForegroundBuyColor == foregroundBuyColor && cachevvTitanic[idx].ForegroundSellColor == foregroundSellColor && cachevvTitanic[idx].MinimumBook == minimumBook && cachevvTitanic[idx].MinimumHidden == minimumHidden && cachevvTitanic[idx].Pricedisplay == pricedisplay && cachevvTitanic[idx].EqualsInput(input))
                        return cachevvTitanic[idx];

            lock (checkvvTitanic)
            {
                checkvvTitanic.BackgroundBuyColor = backgroundBuyColor;
                backgroundBuyColor = checkvvTitanic.BackgroundBuyColor;
                checkvvTitanic.BackgroundSellColor = backgroundSellColor;
                backgroundSellColor = checkvvTitanic.BackgroundSellColor;
                checkvvTitanic.ForegroundBuyColor = foregroundBuyColor;
                foregroundBuyColor = checkvvTitanic.ForegroundBuyColor;
                checkvvTitanic.ForegroundSellColor = foregroundSellColor;
                foregroundSellColor = checkvvTitanic.ForegroundSellColor;
                checkvvTitanic.MinimumBook = minimumBook;
                minimumBook = checkvvTitanic.MinimumBook;
                checkvvTitanic.MinimumHidden = minimumHidden;
                minimumHidden = checkvvTitanic.MinimumHidden;
                checkvvTitanic.Pricedisplay = pricedisplay;
                pricedisplay = checkvvTitanic.Pricedisplay;

                if (cachevvTitanic != null)
                    for (int idx = 0; idx < cachevvTitanic.Length; idx++)
                        if (cachevvTitanic[idx].BackgroundBuyColor == backgroundBuyColor && cachevvTitanic[idx].BackgroundSellColor == backgroundSellColor && cachevvTitanic[idx].ForegroundBuyColor == foregroundBuyColor && cachevvTitanic[idx].ForegroundSellColor == foregroundSellColor && cachevvTitanic[idx].MinimumBook == minimumBook && cachevvTitanic[idx].MinimumHidden == minimumHidden && cachevvTitanic[idx].Pricedisplay == pricedisplay && cachevvTitanic[idx].EqualsInput(input))
                            return cachevvTitanic[idx];

                vvTitanic indicator = new vvTitanic();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BackgroundBuyColor = backgroundBuyColor;
                indicator.BackgroundSellColor = backgroundSellColor;
                indicator.ForegroundBuyColor = foregroundBuyColor;
                indicator.ForegroundSellColor = foregroundSellColor;
                indicator.MinimumBook = minimumBook;
                indicator.MinimumHidden = minimumHidden;
                indicator.Pricedisplay = pricedisplay;
                Indicators.Add(indicator);
                indicator.SetUp();

                vvTitanic[] tmp = new vvTitanic[cachevvTitanic == null ? 1 : cachevvTitanic.Length + 1];
                if (cachevvTitanic != null)
                    cachevvTitanic.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachevvTitanic = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvTitanic vvTitanic(Color backgroundBuyColor, Color backgroundSellColor, Color foregroundBuyColor, Color foregroundSellColor, int minimumBook, int minimumHidden, vvTitanic1pricedisplay pricedisplay)
        {
            return _indicator.vvTitanic(Input, backgroundBuyColor, backgroundSellColor, foregroundBuyColor, foregroundSellColor, minimumBook, minimumHidden, pricedisplay);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.vvTitanic vvTitanic(Data.IDataSeries input, Color backgroundBuyColor, Color backgroundSellColor, Color foregroundBuyColor, Color foregroundSellColor, int minimumBook, int minimumHidden, vvTitanic1pricedisplay pricedisplay)
        {
            return _indicator.vvTitanic(input, backgroundBuyColor, backgroundSellColor, foregroundBuyColor, foregroundSellColor, minimumBook, minimumHidden, pricedisplay);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.vvTitanic vvTitanic(Color backgroundBuyColor, Color backgroundSellColor, Color foregroundBuyColor, Color foregroundSellColor, int minimumBook, int minimumHidden, vvTitanic1pricedisplay pricedisplay)
        {
            return _indicator.vvTitanic(Input, backgroundBuyColor, backgroundSellColor, foregroundBuyColor, foregroundSellColor, minimumBook, minimumHidden, pricedisplay);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.vvTitanic vvTitanic(Data.IDataSeries input, Color backgroundBuyColor, Color backgroundSellColor, Color foregroundBuyColor, Color foregroundSellColor, int minimumBook, int minimumHidden, vvTitanic1pricedisplay pricedisplay)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.vvTitanic(input, backgroundBuyColor, backgroundSellColor, foregroundBuyColor, foregroundSellColor, minimumBook, minimumHidden, pricedisplay);
        }
    }
}
#endregion
